/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import org.bukkit.entity.ChestedHorse;

public class EntityChestCarrier
implements Property {
    public static final String[] handledMechs = new String[]{"carries_chest"};
    EntityTag entity;

    public static boolean describes(ObjectTag entity) {
        return entity instanceof EntityTag && ((EntityTag)entity).getBukkitEntity() instanceof ChestedHorse;
    }

    public static EntityChestCarrier getFrom(ObjectTag entity) {
        if (!EntityChestCarrier.describes(entity)) {
            return null;
        }
        return new EntityChestCarrier((EntityTag)entity);
    }

    private EntityChestCarrier(EntityTag entity) {
        this.entity = entity;
    }

    @Override
    public String getPropertyString() {
        return String.valueOf(this.getChestedHorse().isCarryingChest());
    }

    @Override
    public String getPropertyId() {
        return "carries_chest";
    }

    public ChestedHorse getChestedHorse() {
        return (ChestedHorse)this.entity.getBukkitEntity();
    }

    public static void register() {
        PropertyParser.registerTag(EntityChestCarrier.class, ElementTag.class, "carries_chest", (attribute, object) -> new ElementTag(object.getChestedHorse().isCarryingChest()), new String[0]);
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("carries_chest") && mechanism.requireBoolean()) {
            this.getChestedHorse().setCarryingChest(mechanism.getValue().asBoolean());
        }
    }
}

