/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.tags;

import com.denizenscript.denizencore.exceptions.TagProcessingException;
import com.denizenscript.denizencore.objects.ObjectFetcher;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.ObjectType;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.JavaReflectedObjectTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.commands.Comparable;
import com.denizenscript.denizencore.scripts.containers.core.ProcedureScriptContainer;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.ReflectionRefuse;
import com.denizenscript.denizencore.utilities.ScriptUtilities;

public class CoreObjectTags {
    public static void generateCoreTags(ObjectTagProcessor<?> tagProcessor) {
        tagProcessor.registerStaticTag(ElementTag.class, "prefix", (attribute, object) -> new ElementTag(object.getPrefix()), new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, "object_type", (attribute, object) -> new ElementTag(object.getDenizenObjectType().shortName), "type");
        tagProcessor.registerTag(ObjectTag.class, "proc", (attribute, object) -> {
            ScriptQueue queue;
            ScriptTag script;
            if (!attribute.hasParam()) {
                return null;
            }
            String path = null;
            if (attribute.getParam().indexOf(46) > 0) {
                String[] split = attribute.getParam().split("\\.", 2);
                path = split[1];
                script = ScriptTag.valueOf(split[0], attribute.context);
            } else {
                script = attribute.paramAsType(ScriptTag.class);
            }
            if (script == null) {
                attribute.echoError("Missing script for procedure script tag '" + attribute.getParam() + "'!");
                return null;
            }
            if (!(script.getContainer() instanceof ProcedureScriptContainer)) {
                attribute.echoError("Chosen script is not a procedure script!");
                return null;
            }
            ListTag definitions = new ListTag();
            definitions.addObject(object);
            if (attribute.startsWith("context", 2) && attribute.hasContext(2)) {
                definitions.objectForms.addAll(attribute.contextAsType((int)2, ListTag.class).objectForms);
                attribute.fulfill(1);
            }
            if ((queue = ScriptUtilities.createAndStartQueue(script.getContainer(), path, attribute.context.getScriptEntryData(), null, q -> {
                q.procedural = true;
            }, null, null, definitions, script.getContainer())) == null) {
                attribute.echoError("Procedure queue start failed.");
                return null;
            }
            if (queue.determinations != null && queue.determinations.size() > 0) {
                return queue.determinations.getObject(0);
            }
            return null;
        }, new String[0]);
        tagProcessor.registerStaticTag(ObjectTag.class, "if_null", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            return object;
        }, new String[0]);
        tagProcessor.registerStaticTag(ElementTag.class, "exists", (attribute, object) -> new ElementTag(true), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "is_truthy", (attribute, object) -> new ElementTag(object.isTruthy()), new String[0]);
        tagProcessor.registerTag(ObjectTag.class, "null_if", (attribute, object) -> {
            Attribute subAttribute;
            if (!attribute.hasParam()) {
                return null;
            }
            String tag = attribute.getParam();
            boolean defaultValue = tag.endsWith("||true");
            if (defaultValue) {
                tag = tag.substring(0, tag.length() - "||true".length());
            }
            try {
                subAttribute = new Attribute(tag, attribute.getScriptEntry(), attribute.context);
            }
            catch (TagProcessingException ex) {
                attribute.echoError("Tag processing failed: " + ex.getMessage());
                return null;
            }
            Attribute tempAttrib = new Attribute(subAttribute, attribute.getScriptEntry(), attribute.context);
            tempAttrib.setHadAlternative(true);
            ObjectTag objs = CoreUtilities.autoAttribTyped(object, tempAttrib);
            if (objs == null ? defaultValue : CoreUtilities.equalsIgnoreCase(objs.toString(), "true")) {
                return null;
            }
            return object;
        }, new String[0]);
        tagProcessor.registerTag(ObjectTag.class, "null_if_tag", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            Attribute.OverridingDefinitionProvider provider = new Attribute.OverridingDefinitionProvider(attribute.context.definitionProvider);
            provider.altDefs.putObject("null_if_value", object);
            if (CoreUtilities.equalsIgnoreCase(attribute.parseDynamicParam(provider).toString(), "true")) {
                return null;
            }
            return object;
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "is", (attribute, object) -> {
            if (attribute.hasParam() && (attribute.startsWith("to", 2) || attribute.startsWith("than", 2)) && attribute.hasContext(2)) {
                String operator;
                boolean negative = false;
                if (attribute.getParam().startsWith("!")) {
                    operator = attribute.getParam().substring(1);
                    negative = true;
                } else {
                    operator = attribute.getParam();
                }
                attribute = attribute.fulfill(1);
                Comparable.Operator comparableOperator = Comparable.getOperatorFor(operator);
                if (comparableOperator == null) {
                    attribute.echoError("Unknown operator '" + operator + "'.");
                    return null;
                }
                return new ElementTag(Comparable.compare(object, attribute.getParamObject(), comparableOperator, negative, attribute.context));
            }
            return null;
        }, new String[0]);
        tagProcessor.registerStaticTag(ListTag.class, "repeat_as_list", (attribute, object) -> {
            if (!attribute.hasParam()) {
                attribute.echoError("The tag ObjectTag.repeat_as_list[...] must have a value.");
                return null;
            }
            int repeatTimes = attribute.getIntParam();
            ListTag result = new ListTag(repeatTimes);
            for (int i = 0; i < repeatTimes; ++i) {
                result.addObject(object.duplicate());
            }
            return result;
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "advanced_matches", (attribute, object) -> {
            if (!attribute.hasParam()) {
                return null;
            }
            return new ElementTag(object.tryAdvancedMatcher(attribute.getParam()));
        }, "advanced_matches_text");
        tagProcessor.registerTag(JavaReflectedObjectTag.class, "reflected_internal_object", (attribute, object) -> {
            Object obj = object.getJavaObject();
            if (!CoreConfiguration.allowReflectionFieldReads) {
                return null;
            }
            if (obj == null) {
                return null;
            }
            if (obj.getClass().isAnnotationPresent(ReflectionRefuse.class)) {
                attribute.echoError("Cannot reflect object " + object + " as its type '" + obj.getClass().getName() + "' is marked as refused for reflection.");
                return null;
            }
            return new JavaReflectedObjectTag(obj);
        }, new String[0]);
        tagProcessor.registerTag(ObjectTag.class, ElementTag.class, "as", (attribute, object, asType) -> {
            ObjectType<? extends ObjectTag> type = ObjectFetcher.objectsByName.get(asType.asLowerString());
            if (type == null) {
                attribute.echoError("Invalid object type '" + asType + "'. Cannot convert.");
                return null;
            }
            ObjectTag result = object.asType(type, attribute.context);
            if (result == null) {
                attribute.echoError("Cannot convert object '" + object + "' to type '" + type.longName + "'.");
            }
            return result;
        }, new String[0]);
    }
}

