/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.queues;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.queues.ContextSource;
import com.denizenscript.denizencore.scripts.queues.DeterminationTarget;
import com.denizenscript.denizencore.scripts.queues.ScriptEngine;
import com.denizenscript.denizencore.scripts.queues.core.TimedQueue;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.DefinitionProvider;
import com.denizenscript.denizencore.utilities.ListQueue;
import com.denizenscript.denizencore.utilities.QueueWordList;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import com.denizenscript.denizencore.utilities.scheduling.OneTimeSchedulable;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public abstract class ScriptQueue
implements Debuggable,
DefinitionProvider {
    protected static long total_queues = 0L;
    protected static LinkedHashMap<String, ScriptQueue> allQueues = new LinkedHashMap();
    public String id;
    public String debugId;
    public boolean procedural = false;
    public Consumer<String> debugOutput = null;
    public final ListQueue script_entries = new ListQueue(4);
    private ScriptEntry lastEntryExecuted = null;
    private long delay_time = 0L;
    public MapTag definitions = new MapTag();
    public ListTag determinations = null;
    public ScriptTag script;
    public ContextSource contextSource = null;
    public DeterminationTarget determinationTarget = null;
    public ScriptQueue replacementQueue = null;
    public boolean is_stopping = false;
    public boolean isStopped = false;
    public volatile ScriptEntry holdingOn = null;
    public boolean waitWhenEmpty = false;
    public boolean is_started;
    public long startTime = 0L;
    public long startTimeMilli = 0L;
    private Runnable callback = null;
    public long numericId = total_queues++;

    public static String getStats() {
        String c1 = DenizenCore.implementation.applyDebugColors("<W>");
        String c2 = DenizenCore.implementation.applyDebugColors("<A>");
        StringBuilder stats = new StringBuilder();
        TreeSet<Map.Entry> statsSet = new TreeSet<Map.Entry>(Comparator.comparingLong(Map.Entry::getKey));
        for (ScriptEvent event : ScriptEvent.events) {
            if (event.eventData.stats_fires <= 0L) continue;
            stats.setLength(0);
            stats.append(c1).append("Event '").append(event.getName()).append(c1).append("' ran ").append(c2).append(event.eventData.stats_fires).append(c1).append(" times (").append(c2).append(event.eventData.stats_scriptFires).append(c1).append(" script fires)").append(c1).append(", totalling ").append(c2).append((float)event.eventData.stats_nanoTimes / 1000000.0f).append(c1).append("ms, averaging ").append(c2).append((float)event.eventData.stats_nanoTimes / 1000000.0f / (float)event.eventData.stats_fires).append(c1).append("ms per event or ").append(c2).append((float)event.eventData.stats_nanoTimes / 1000000.0f / (float)event.eventData.stats_scriptFires).append(c1).append("ms per script.\n");
            statsSet.add(new AbstractMap.SimpleEntry<Long, String>(event.eventData.stats_nanoTimes, stats.toString()));
        }
        return "Total number of queues created: " + total_queues + ", currently active queues: " + allQueues.size() + ",\n" + String.join((CharSequence)"", statsSet.stream().map(Map.Entry::getValue).collect(Collectors.joining()));
    }

    public static ListTag getStatsRawData() {
        return new ListTag(ScriptEvent.events, event -> event.eventData.stats_fires > 0L, event -> {
            MapTag map = new MapTag();
            map.putObject("name", new ElementTag(event.getName(), true));
            map.putObject("total_fires", new ElementTag(event.eventData.stats_fires));
            map.putObject("script_fires", new ElementTag(event.eventData.stats_scriptFires));
            map.putObject("total_time", new DurationTag((double)event.eventData.stats_nanoTimes / 1000000.0));
            return map;
        });
    }

    public static ScriptQueue getExistingQueue(String id) {
        return allQueues.get(id);
    }

    public static Collection<ScriptQueue> getQueues() {
        return allQueues.values();
    }

    public static boolean queueExists(String id) {
        return allQueues.containsKey(id);
    }

    protected ScriptQueue(String id) {
        this.id = id;
        this.generateId(id, this.numericId, 0);
    }

    public final void setContextSource(ContextSource source) {
        this.contextSource = source;
    }

    @Override
    public ObjectTag getDefinitionObject(String definition) {
        ObjectTag value;
        if (definition == null) {
            return null;
        }
        if (definition.startsWith("__") && (value = DenizenCore.implementation.getSpecialDef(definition, this)) != null) {
            return value;
        }
        return this.definitions.getDeepObject(definition);
    }

    @Override
    public void addDefinition(String definition, ObjectTag value) {
        if (definition.startsWith("__") && DenizenCore.implementation.setSpecialDef(definition, this, value)) {
            return;
        }
        this.definitions.putDeepObject(definition, value);
    }

    @Override
    public String getDefinition(String definition) {
        if (definition == null) {
            return null;
        }
        return CoreUtilities.stringifyNullPass(this.getDefinitionObject(definition));
    }

    @Override
    public boolean hasDefinition(String definition) {
        return this.getDefinitionObject(definition) != null;
    }

    @Override
    public void addDefinition(String definition, String value) {
        this.addDefinition(definition, new ElementTag(value));
    }

    @Override
    public void removeDefinition(String definition) {
        this.addDefinition(definition, (ObjectTag)null);
    }

    @Override
    public MapTag getAllDefinitions() {
        return this.definitions;
    }

    public final ScriptEntry getLastEntryExecuted() {
        return this.lastEntryExecuted;
    }

    public final void clear() {
        this.script_entries.clear();
    }

    public void delayUntil(long delayTime) {
        this.delay_time = delayTime;
    }

    public final void generateId(String prefix, long numericId, int depth) {
        if (prefix.startsWith("FORCE:")) {
            this.debugId = this.id = prefix.substring("FORCE:".length());
            return;
        }
        int size = QueueWordList.FinalWordList.size();
        Random random = CoreUtilities.getRandom();
        Object wordsRaw = "";
        Object wordsColor = "";
        if (CoreConfiguration.queueIdWords) {
            String wordOne = QueueWordList.FinalWordList.get(random.nextInt(size));
            String wordTwo = QueueWordList.FinalWordList.get(random.nextInt(size));
            String colorOne = DenizenCore.implementation.getRandomColor();
            String colorTwo = DenizenCore.implementation.getRandomColor();
            wordsRaw = wordOne + wordTwo;
            wordsColor = colorOne + wordOne + colorTwo + wordTwo;
            for (int i = 0; i < depth; ++i) {
                String wordThree = QueueWordList.FinalWordList.get(random.nextInt(size));
                String colorThree = DenizenCore.implementation.getRandomColor();
                wordsRaw = (String)wordsRaw + wordThree;
                wordsColor = (String)wordsColor + colorThree + wordThree;
            }
        }
        this.id = (String)(CoreConfiguration.queueIdPrefix ? prefix + "_" : "") + (String)(CoreConfiguration.queueIdNumeric ? numericId + (CoreConfiguration.queueIdWords ? "_" : "") : "") + (String)(CoreConfiguration.queueIdWords ? wordsRaw : "");
        this.debugId = (String)(CoreConfiguration.queueIdPrefix ? "<LG>" + prefix + "_" : "") + (String)(CoreConfiguration.queueIdNumeric ? "<GR>" + numericId + (CoreConfiguration.queueIdWords ? "<LG>_" : "") : "") + (String)(CoreConfiguration.queueIdWords ? wordsColor : "");
        if (!CoreConfiguration.queueIdNumeric && ScriptQueue.queueExists(this.id)) {
            if (!CoreConfiguration.queueIdWords) {
                Debug.echoError("WARNING: Configuration invalid! Trying to generate queue IDs with neither numbers nor words! Resetting to both enabled.");
                CoreConfiguration.queueIdNumeric = true;
                CoreConfiguration.queueIdWords = true;
            }
            this.generateId(prefix, numericId, depth + 1);
        }
    }

    public final TimedQueue forceToTimed(TimedQueue.DelayTracker delay) {
        this.queueDebug("Forcing queue '<QUEUE>' into a timed queue...");
        Runnable r = this.callback;
        this.callback = null;
        TimedQueue newQueue = new TimedQueue("FORCE:" + this.id, 0L);
        this.replacementQueue = newQueue;
        this.stopSilent();
        newQueue.id = this.id;
        newQueue.debugId = this.debugId;
        newQueue.debugOutput = this.debugOutput;
        for (ScriptEntry entry : this.getEntries()) {
            entry.entryData.scriptEntry = entry = entry.clone();
            entry.setInstant(true);
            entry.setSendingQueue(newQueue);
            entry.updateContext();
            newQueue.script_entries.add(entry);
        }
        newQueue.determinations = this.determinations;
        newQueue.definitions = this.definitions.duplicate();
        newQueue.setContextSource(this.contextSource);
        newQueue.determinationTarget = this.determinationTarget;
        newQueue.setLastEntryExecuted(this.getLastEntryExecuted());
        this.clear();
        newQueue.delay = delay;
        newQueue.startTime = this.startTime;
        newQueue.startTimeMilli = this.startTimeMilli;
        newQueue.script = this.script;
        newQueue.holdingOn = this.holdingOn;
        newQueue.callBack(r);
        if (newQueue.script_entries.isEmpty() && newQueue.holdingOn == null) {
            newQueue.stop();
        } else {
            newQueue.start(false);
        }
        return newQueue;
    }

    public abstract void onStart();

    public String getName() {
        return "UnidentifiedQueueType";
    }

    public final void queueDebug(String message) {
        Debug.echoDebug((Debuggable)this, "<O>" + message.replace("<QUEUE>", this.debugId + "<O>"));
    }

    public final void start() {
        this.start(true);
    }

    public final void start(boolean doBasicConfig) {
        boolean is_delayed;
        if (this.is_started) {
            return;
        }
        if (this.script_entries.isEmpty() && this.holdingOn == null) {
            return;
        }
        if (CoreConfiguration.verifyThreadMatches && !DenizenCore.isMainThread()) {
            try {
                throw new RuntimeException("Invalid thread access - starting queue from thread " + Thread.currentThread());
            }
            catch (Throwable ex) {
                Debug.echoError(ex);
            }
        }
        allQueues.put(this.id, this);
        this.is_started = true;
        long delay = this.delay_time - DenizenCore.serverTimeMillis;
        boolean bl = is_delayed = delay > 0L;
        if (doBasicConfig) {
            this.script = this.script_entries.get(0).getScript();
            this.startTime = System.nanoTime();
            this.startTimeMilli = CoreUtilities.monotonicMillis();
            String name = this.getName();
            if (this.queueNeedsToDebug()) {
                if (is_delayed) {
                    this.queueDebug("Delaying " + name + " '<QUEUE>' for '" + new DurationTag((double)delay / 1000.0).identify() + "'...");
                } else {
                    this.queueDebug("Starting " + name + " '<QUEUE>'" + DenizenCore.implementation.queueHeaderInfo(this.script_entries.get(0)) + "...");
                }
            }
        }
        if (is_delayed) {
            OneTimeSchedulable schedulable = new OneTimeSchedulable(this::onStart, (float)delay / 1000.0f);
            DenizenCore.schedule(schedulable);
        } else {
            this.onStart();
        }
    }

    public final void runNow(List<ScriptEntry> entries) {
        ScriptEntry nextup = this.getQueueSize() > 0 ? this.getEntry(0) : null;
        this.injectEntriesAtStart(entries);
        while (this.getQueueSize() > 0 && this.getEntry(0) != nextup) {
            this.getEntry(0).setInstant(true);
            this.holdingOn = null;
            ScriptEngine.revolveOnceForce(this);
        }
    }

    public final void callBack(Runnable r) {
        this.callback = r;
    }

    private void stopSilent() {
        this.is_stopping = true;
        allQueues.remove(this.id);
        this.is_started = false;
        this.isStopped = true;
    }

    public final void stop() {
        if (this.is_stopping) {
            return;
        }
        if (CoreConfiguration.verifyThreadMatches && !DenizenCore.isMainThread()) {
            try {
                throw new RuntimeException("Invalid thread access - stopping queue from thread " + Thread.currentThread());
            }
            catch (Throwable ex) {
                Debug.echoError(ex);
            }
        }
        if (this.queueNeedsToDebug()) {
            this.queueDebug("Completing queue '<QUEUE>' in <A>" + (System.nanoTime() - this.startTime) / 1000000L + "<O>ms.");
        }
        if (this.callback != null) {
            this.callback.run();
        }
        this.stopSilent();
    }

    public final void setLastEntryExecuted(ScriptEntry entry) {
        this.lastEntryExecuted = entry;
        if (entry != null) {
            entry.queue = this;
        }
    }

    public final ScriptEntry getNext() {
        if (!this.script_entries.isEmpty()) {
            return this.script_entries.removeFirst();
        }
        return null;
    }

    public final void addEntries(List<ScriptEntry> entries) {
        this.script_entries.addAll(entries);
    }

    public final ListQueue getEntries() {
        return this.script_entries;
    }

    public final void injectEntriesAtStart(List<ScriptEntry> entries) {
        this.script_entries.addAllToStart(entries);
    }

    public final boolean removeFirst() {
        if (this.script_entries.isEmpty()) {
            return false;
        }
        this.script_entries.removeFirst();
        return true;
    }

    public final ScriptEntry getEntry(int position) {
        if (this.script_entries.size() < position) {
            return null;
        }
        return this.script_entries.get(position);
    }

    public final void injectEntryAtStart(ScriptEntry entry) {
        this.script_entries.injectAtStart(entry);
    }

    public final int getQueueSize() {
        return this.script_entries.size();
    }

    public final boolean queueNeedsToDebug() {
        return Debug.shouldDebug(this);
    }

    @Override
    public boolean shouldDebug() {
        return this.lastEntryExecuted != null ? this.lastEntryExecuted.shouldDebug() : this.script_entries.get(0).shouldDebug();
    }

    public String toString() {
        return this.id;
    }
}

