/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.events;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import io.papermc.paper.event.player.PlayerLecternPageChangeEvent;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class PlayerLecternPageChangeScriptEvent
extends BukkitScriptEvent
implements Listener {
    public PlayerLecternPageChangeEvent event;

    public PlayerLecternPageChangeScriptEvent() {
        this.registerCouldMatcher("player flips lectern page");
        this.registerSwitches("book");
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.event.getLectern().getLocation())) {
            return false;
        }
        if (!path.tryObjectSwitch("book", new ItemTag(this.event.getBook()))) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData((Entity)this.event.getPlayer());
    }

    @Override
    public ObjectTag getContext(String name) {
        return switch (name) {
            case "book" -> new ItemTag(this.event.getBook());
            case "lectern" -> new LocationTag(this.event.getLectern().getLocation());
            case "old_page" -> new ElementTag(this.event.getOldPage() + 1);
            case "new_page" -> new ElementTag(this.event.getNewPage() + 1);
            case "flip_direction" -> new ElementTag((Enum<?>)this.event.getPageChangeDirection());
            default -> super.getContext(name);
        };
    }

    @Override
    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        ElementTag value;
        String lower;
        if (determinationObj instanceof ElementTag && (lower = CoreUtilities.toLowerCase(determinationObj.toString())).startsWith("page:") && (value = new ElementTag(lower.substring("page:".length()))).isInt()) {
            this.event.setNewPage(value.asInt() - 1);
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @EventHandler
    public void onPlayerFlipsLecternPage(PlayerLecternPageChangeEvent event) {
        this.event = event;
        this.fire((Event)event);
    }
}

