/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.entity.DenizenEntityType;
import com.denizenscript.denizen.utilities.entity.FakeEntity;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.List;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;

public class RemoveCommand
extends AbstractCommand {
    public static boolean alwaysWarnOnMassRemove = false;

    public RemoveCommand() {
        this.setName("remove");
        this.setSyntax("remove [<entity>|...] (world:<world>)");
        this.setRequiredArguments(1, 2);
        this.isProcedural = false;
    }

    @Override
    public void addCustomTabCompletions(AbstractCommand.TabCompletionsBuilder tab) {
        tab.add((Enum<?>[])EntityType.values());
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("entities") && arg.matchesArgumentList(EntityTag.class)) {
                EntityTag.allowDespawnedNpcs = true;
                scriptEntry.addObject("entities", arg.asType(ListTag.class).filter(EntityTag.class, scriptEntry));
                EntityTag.allowDespawnedNpcs = false;
                continue;
            }
            if (!scriptEntry.hasObject("world") && arg.matchesArgumentType(WorldTag.class)) {
                scriptEntry.addObject("world", arg.asType(WorldTag.class));
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("entities")) {
            throw new InvalidArgumentsException("Must specify entity/entities!");
        }
        scriptEntry.defaultObject("world", Utilities.entryDefaultWorld(scriptEntry, false));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        List entities = (List)scriptEntry.getObject("entities");
        WorldTag world = (WorldTag)scriptEntry.getObjectTag("world");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), world, RemoveCommand.db("entities", entities));
        }
        for (EntityTag entity : entities) {
            if (entity.isUnique()) {
                if (entity.isFake) {
                    FakeEntity fakeEnt = FakeEntity.idsToEntities.get(entity.getUUID());
                    if (fakeEnt == null) continue;
                    fakeEnt.cancelEntity();
                    continue;
                }
                if (entity.isCitizensNPC()) {
                    entity.getDenizenNPC().getCitizen().destroy();
                    continue;
                }
                if (!entity.isSpawned()) {
                    Debug.echoError("Tried to remove already-removed entity.");
                }
                if (entity.entity == null) continue;
                entity.remove();
                continue;
            }
            int removed = 0;
            for (Entity worldEntity : world.getEntities()) {
                if (!entity.getEntityType().equals(DenizenEntityType.getByEntity(worldEntity))) continue;
                worldEntity.remove();
                ++removed;
            }
            Debug.echoDebug((Debuggable)scriptEntry, "Removed " + removed + " entities from the world.");
            if (!alwaysWarnOnMassRemove) continue;
            Debug.echoError("Remove command 'Always warn on mass delete' in Denizen config is enabled - mass removal of '" + entity.getEntityType() + "' performed, removing " + removed + " entities.");
        }
    }
}

