/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.utilities.debugging;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.events.core.ConsoleOutputScriptEvent;
import java.io.PrintStream;

public class LogInterceptor
extends PrintStream {
    public boolean redirected = false;
    public PrintStream standardOut;
    public boolean antiLoop = false;

    public LogInterceptor() {
        super(System.out, true);
    }

    @Override
    public void print(String s) {
        if (this.antiLoop) {
            super.print(s);
            return;
        }
        this.antiLoop = true;
        try {
            ConsoleOutputScriptEvent event = ConsoleOutputScriptEvent.instance;
            event.message = DenizenCore.implementation.cleanseLogString(s);
            event = (ConsoleOutputScriptEvent)event.fire();
            if (!event.cancelled) {
                super.print(s);
            }
        }
        finally {
            this.antiLoop = false;
        }
    }

    @Override
    public void print(Object obj) {
        this.print(String.valueOf(obj));
    }

    @Override
    public void print(char[] buf) {
        this.print(new String(buf));
    }

    public void redirectOutput() {
        if (this.redirected) {
            return;
        }
        this.redirected = true;
        if (System.out != this) {
            this.standardOut = System.out;
        }
        System.setOut(this);
    }

    public void standardOutput() {
        if (!this.redirected) {
            return;
        }
        this.redirected = false;
        System.setOut(this.standardOut);
    }
}

