/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.material;

import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.properties.material.MaterialProperty;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.core.ElementTag;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.FaceAttachable;
import org.bukkit.block.data.type.Bell;

public class MaterialAttachmentFace
extends MaterialProperty<ElementTag> {
    public static boolean describes(MaterialTag material) {
        return material.getModernData() instanceof FaceAttachable || material.getModernData() instanceof Bell;
    }

    public MaterialAttachmentFace(MaterialTag material) {
        super(material);
    }

    @Override
    public ElementTag getPropertyValue() {
        BlockData blockData = this.getBlockData();
        if (blockData instanceof FaceAttachable) {
            FaceAttachable attachable = (FaceAttachable)blockData;
            return new ElementTag((Enum<?>)attachable.getAttachedFace());
        }
        blockData = this.getBlockData();
        if (blockData instanceof Bell) {
            Bell bell = (Bell)blockData;
            return new ElementTag((Enum<?>)bell.getAttachment());
        }
        return null;
    }

    @Override
    public String getPropertyId() {
        return "attachment_face";
    }

    @Override
    public void setPropertyValue(ElementTag value, Mechanism mechanism) {
        BlockData blockData = this.getBlockData();
        if (blockData instanceof FaceAttachable) {
            FaceAttachable attachable = (FaceAttachable)blockData;
            if (mechanism.requireEnum(FaceAttachable.AttachedFace.class)) {
                attachable.setAttachedFace(value.asEnum(FaceAttachable.AttachedFace.class));
            }
        } else {
            blockData = this.getBlockData();
            if (blockData instanceof Bell) {
                Bell bell = (Bell)blockData;
                if (mechanism.requireEnum(Bell.Attachment.class)) {
                    bell.setAttachment(value.asEnum(Bell.Attachment.class));
                }
            }
        }
    }

    public BlockFace getAttachedTo() {
        BlockData blockData = this.getBlockData();
        if (blockData instanceof FaceAttachable) {
            FaceAttachable attachable = (FaceAttachable)blockData;
            return switch (attachable.getAttachedFace()) {
                default -> throw new IncompatibleClassChangeError();
                case FaceAttachable.AttachedFace.WALL -> {
                    BlockData var4_3 = this.getBlockData();
                    if (var4_3 instanceof Directional) {
                        Directional directional = (Directional)var4_3;
                        yield directional.getFacing().getOppositeFace();
                    }
                    yield BlockFace.SELF;
                }
                case FaceAttachable.AttachedFace.FLOOR -> BlockFace.DOWN;
                case FaceAttachable.AttachedFace.CEILING -> BlockFace.UP;
            };
        }
        blockData = this.getBlockData();
        if (blockData instanceof Bell) {
            Bell bell = (Bell)blockData;
            return switch (bell.getAttachment()) {
                default -> throw new IncompatibleClassChangeError();
                case Bell.Attachment.SINGLE_WALL, Bell.Attachment.DOUBLE_WALL -> ((Directional)this.getBlockData()).getFacing();
                case Bell.Attachment.FLOOR -> BlockFace.DOWN;
                case Bell.Attachment.CEILING -> BlockFace.UP;
            };
        }
        return null;
    }

    public static void register() {
        MaterialAttachmentFace.autoRegister("attachment_face", MaterialAttachmentFace.class, ElementTag.class, false, "switch_face");
    }
}

