/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.item;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.util.jnbt.ByteTag;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.util.jnbt.Tag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bukkit.Material;

public class ItemFrameInvisible
implements Property {
    public static final String[] handledTags = new String[]{"invisible"};
    public static final String[] handledMechs = new String[]{"invisible"};
    ItemTag item;

    public static boolean describes(ObjectTag object) {
        return object instanceof ItemTag && (((ItemTag)object).getBukkitMaterial() == Material.ITEM_FRAME || ((ItemTag)object).getBukkitMaterial() == Material.GLOW_ITEM_FRAME);
    }

    public static ItemFrameInvisible getFrom(ObjectTag object) {
        if (!ItemFrameInvisible.describes(object)) {
            return null;
        }
        return new ItemFrameInvisible((ItemTag)object);
    }

    public ItemFrameInvisible(ItemTag item) {
        this.item = item;
    }

    public boolean isInvisible() {
        CompoundTag compoundTag = NMSHandler.itemHelper.getNbtData(this.item.getItemStack());
        if (compoundTag == null) {
            return false;
        }
        CompoundTag entTag = (CompoundTag)compoundTag.getValue().get("EntityTag");
        if (entTag == null) {
            return false;
        }
        byte b = entTag.getByte("Invisible");
        return b == 1;
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("invisible")) {
            return new ElementTag(this.isInvisible()).getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    @Override
    public String getPropertyString() {
        if (this.isInvisible()) {
            return "true";
        }
        return null;
    }

    @Override
    public String getPropertyId() {
        return "invisible";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("invisible") && mechanism.requireBoolean()) {
            CompoundTag compoundTag = NMSHandler.itemHelper.getNbtData(this.item.getItemStack());
            LinkedHashMap<String, Tag> result = new LinkedHashMap<String, Tag>((Map<String, Tag>)compoundTag.getValue());
            CompoundTag entityTag = (CompoundTag)result.get("EntityTag");
            LinkedHashMap<String, Tag> entMap = entityTag != null ? new LinkedHashMap(entityTag.getValue()) : new LinkedHashMap<String, Tag>();
            if (mechanism.getValue().asBoolean()) {
                entMap.put("Invisible", new ByteTag(1));
            } else {
                entMap.remove("Invisible");
            }
            if (entMap.isEmpty()) {
                result.remove("EntityTag");
            } else {
                result.put("EntityTag", NMSHandler.instance.createCompoundTag(entMap));
            }
            compoundTag = NMSHandler.instance.createCompoundTag(result);
            this.item.setItemStack(NMSHandler.itemHelper.setNbtData(this.item.getItemStack(), compoundTag));
        }
    }
}

