/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.scripts.commands.core;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.core.SecretTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.Holdable;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultNull;
import com.denizenscript.denizencore.scripts.commands.generator.ArgName;
import com.denizenscript.denizencore.scripts.commands.generator.ArgPrefixed;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import com.denizenscript.denizencore.utilities.scheduling.AsyncSchedulable;
import com.denizenscript.denizencore.utilities.scheduling.OneTimeSchedulable;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.result.InsertOneResult;
import com.mongodb.client.result.UpdateResult;
import java.util.HashMap;
import java.util.Map;
import org.bson.BsonObjectId;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;

public class MongoCommand
extends AbstractCommand
implements Holdable {
    public static Map<String, Connection> mongoConnections = new HashMap<String, Connection>();

    public MongoCommand() {
        this.setName("mongo");
        this.setSyntax("mongo [id:<ID>] [connect:<uri> database:<database> collection:<collection>/disconnect/command:<map>/find:<map> (by_id:<id>)/insert:<map>/update:<update> new:<new> (upsert:true/{false})/use_database:<database>/use_collection:<collection>]");
        this.setRequiredArguments(2, 4);
        this.isProcedural = false;
        this.autoCompile();
    }

    @Override
    public void onDisable() {
        for (Connection entry : mongoConnections.values()) {
            try {
                entry.connection.close();
            }
            catch (Exception e) {
                Debug.echoError(e);
            }
        }
        mongoConnections.clear();
    }

    @Override
    public void addCustomTabCompletions(AbstractCommand.TabCompletionsBuilder tab) {
        tab.addWithPrefix("id:", mongoConnections.keySet());
    }

    public static void autoExecute(ScriptEntry scriptEntry, @ArgPrefixed @ArgName(value="id") String id, @ArgPrefixed @ArgDefaultNull @ArgName(value="connect") SecretTag uri, @ArgPrefixed @ArgDefaultNull @ArgName(value="database") String database, @ArgPrefixed @ArgDefaultNull @ArgName(value="collection") String collection, @ArgName(value="disconnect") boolean disconnect, @ArgPrefixed @ArgDefaultNull @ArgName(value="command") MapTag command, @ArgPrefixed @ArgDefaultNull @ArgName(value="find") MapTag findQuery, @ArgPrefixed @ArgDefaultNull @ArgName(value="by_id") String findByID, @ArgPrefixed @ArgDefaultNull @ArgName(value="insert") MapTag insert, @ArgPrefixed @ArgDefaultNull @ArgName(value="update") MapTag oldData, @ArgPrefixed @ArgDefaultNull @ArgName(value="new") MapTag newData, @ArgName(value="upsert") boolean upsert, @ArgPrefixed @ArgDefaultNull @ArgName(value="use_database") String newDatabase, @ArgPrefixed @ArgDefaultNull @ArgName(value="use_collection") String newCollection) {
        if (!CoreConfiguration.allowMongo) {
            Debug.echoError(scriptEntry, "Mongo disabled by config!");
            return;
        }
        String connectionId = CoreUtilities.toLowerCase(id);
        Connection connection = mongoConnections.get(connectionId);
        Runnable runnable = () -> {
            block43: {
                try {
                    if (uri != null) {
                        if (connection != null) {
                            Debug.echoError(scriptEntry, "Already connected to a server with ID '" + id + "'!");
                            scriptEntry.setFinished(true);
                            return;
                        }
                        if (database == null) {
                            Debug.echoError(scriptEntry, "You must specify a Database!");
                            scriptEntry.setFinished(true);
                            return;
                        }
                        if (collection == null) {
                            Debug.echoError(scriptEntry, "You must specify a Collection!");
                            scriptEntry.setFinished(true);
                            return;
                        }
                        DenizenCore.schedule(new AsyncSchedulable(new OneTimeSchedulable(() -> {
                            MongoCollection col;
                            MongoDatabase db;
                            MongoClient con;
                            Object conStr = uri.getValue();
                            if (!((String)conStr).startsWith("mongodb://") && !((String)conStr).startsWith("mongodb+srv://")) {
                                conStr = "mongodb://" + (String)conStr;
                            }
                            Debug.echoDebug((Debuggable)scriptEntry, "Connecting to Mongo server...");
                            try {
                                con = MongoClients.create((String)conStr);
                                db = con.getDatabase(database);
                                col = db.getCollection(collection);
                            }
                            catch (Exception e) {
                                DenizenCore.runOnMainThread(() -> {
                                    Debug.echoError(scriptEntry, "Mongo Exception: " + e.getMessage());
                                    if (CoreConfiguration.debugVerbose) {
                                        Debug.echoError(scriptEntry, e);
                                    }
                                    scriptEntry.setFinished(true);
                                });
                                return;
                            }
                            MongoClient conn = con;
                            MongoDatabase connDB = db;
                            MongoCollection coll = col;
                            DenizenCore.runOnMainThread(() -> {
                                Connection mongoConnection = new Connection();
                                mongoConnection.connection = conn;
                                mongoConnection.database = connDB;
                                mongoConnection.collection = coll;
                                mongoConnections.put(connectionId, mongoConnection);
                                Debug.echoDebug((Debuggable)scriptEntry, "Successfully connected to Mongo server.");
                                scriptEntry.setFinished(true);
                            });
                        }, 0.0f)));
                        return;
                    }
                    if (connection == null) {
                        Debug.echoError(scriptEntry, "There is no open connection with ID: '" + id + "'! Has it been disconnected?");
                        scriptEntry.setFinished(true);
                        return;
                    }
                    if (disconnect) {
                        mongoConnections.remove(connectionId);
                        try {
                            connection.connection.close();
                        }
                        catch (Exception e) {
                            Debug.echoError(e);
                        }
                        Debug.echoDebug((Debuggable)scriptEntry, "Disconnected from '" + id + "'.");
                        return;
                    }
                    if (connection.database == null) {
                        Debug.echoError(scriptEntry, "Not connected to database! Was it dropped?");
                        scriptEntry.setFinished(true);
                        return;
                    }
                    if (command != null) {
                        try {
                            Debug.echoDebug((Debuggable)scriptEntry, "Running commands: " + command);
                            HashMap finalCommand = (HashMap)CoreUtilities.objectTagToJavaForm(command, false, true);
                            Document commandResult = connection.database.runCommand((Bson)new Document((Map)finalCommand));
                            ElementTag okResult = new ElementTag(commandResult.get((Object)"ok").toString());
                            ElementTag resultRaw = new ElementTag(commandResult.toJson());
                            scriptEntry.saveObject("result", resultRaw);
                            scriptEntry.saveObject("ok", okResult);
                            DenizenCore.runOnMainThread(() -> scriptEntry.setFinished(true));
                        }
                        catch (Exception e) {
                            DenizenCore.runOnMainThread(() -> {
                                Debug.echoError(scriptEntry, "Mongo Exception: " + e.getMessage());
                                if (CoreConfiguration.debugVerbose) {
                                    Debug.echoError(scriptEntry, e);
                                }
                                scriptEntry.setFinished(true);
                            });
                        }
                        return;
                    }
                    if (newDatabase != null) {
                        try {
                            MongoDatabase newDB = connection.connection.getDatabase(newDatabase);
                            Debug.echoDebug((Debuggable)scriptEntry, "Using new Database: '" + newDatabase + "'.");
                            connection.database = newDB;
                            DenizenCore.runOnMainThread(() -> scriptEntry.setFinished(true));
                        }
                        catch (Exception e) {
                            DenizenCore.runOnMainThread(() -> {
                                Debug.echoError(scriptEntry, "Mongo Exception: " + e.getMessage());
                                if (CoreConfiguration.debugVerbose) {
                                    Debug.echoError(scriptEntry, e);
                                }
                                scriptEntry.setFinished(true);
                            });
                        }
                        return;
                    }
                    if (connection.collection == null) {
                        Debug.echoError(scriptEntry, "Not connected to Collection! Was it dropped?");
                        scriptEntry.setFinished(true);
                        return;
                    }
                    if (findQuery != null) {
                        try {
                            HashMap query = (HashMap)CoreUtilities.objectTagToJavaForm(findQuery, false, true);
                            if (findByID != null) {
                                query.put("_id", new BsonObjectId(new ObjectId(findByID)));
                            }
                            Debug.echoDebug((Debuggable)scriptEntry, "Finding data in Collection: '" + connection.collection.getNamespace() + "'...");
                            FindIterable findResult = connection.collection.find((Bson)new Document((Map)query));
                            ListTag result = new ListTag();
                            for (Document doc : findResult) {
                                result.addObject(new ElementTag(doc.toJson()));
                            }
                            scriptEntry.saveObject("result", result);
                            DenizenCore.runOnMainThread(() -> scriptEntry.setFinished(true));
                        }
                        catch (Exception e) {
                            DenizenCore.runOnMainThread(() -> {
                                Debug.echoError(scriptEntry, "Mongo Exception: " + e.getMessage());
                                if (CoreConfiguration.debugVerbose) {
                                    Debug.echoError(scriptEntry, e);
                                }
                                scriptEntry.setFinished(true);
                            });
                        }
                    } else if (insert != null) {
                        try {
                            HashMap insertData = (HashMap)CoreUtilities.objectTagToJavaForm(insert, false, true);
                            Debug.echoDebug((Debuggable)scriptEntry, "Inserting data into Collection: '" + connection.collection.getNamespace() + "'...");
                            InsertOneResult result = connection.collection.insertOne((Object)new Document((Map)insertData));
                            if (result.getInsertedId() != null) {
                                scriptEntry.saveObject("inserted_id", new ElementTag(result.getInsertedId().asObjectId().getValue().toString()));
                            } else {
                                scriptEntry.saveObject("inserted_id", null);
                            }
                            DenizenCore.runOnMainThread(() -> scriptEntry.setFinished(true));
                        }
                        catch (Exception e) {
                            DenizenCore.runOnMainThread(() -> {
                                Debug.echoError(scriptEntry, "Mongo Exception: " + e.getMessage());
                                if (CoreConfiguration.debugVerbose) {
                                    Debug.echoError(scriptEntry, e);
                                }
                                scriptEntry.setFinished(true);
                            });
                        }
                    } else if (oldData != null) {
                        if (newData == null) {
                            Debug.echoError(scriptEntry, "You must specify the new data to be updated!");
                            scriptEntry.setFinished(true);
                            return;
                        }
                        try {
                            UpdateResult result;
                            HashMap updateMap = (HashMap)CoreUtilities.objectTagToJavaForm(oldData, false, true);
                            HashMap newMap = (HashMap)CoreUtilities.objectTagToJavaForm(newData, false, true);
                            Debug.echoDebug((Debuggable)scriptEntry, "Updating data...");
                            if (upsert) {
                                result = connection.collection.updateMany((Bson)new Document((Map)updateMap), (Bson)new Document((Map)newMap), new UpdateOptions().upsert(true));
                                if (result.getUpsertedId() != null) {
                                    scriptEntry.saveObject("upserted_id", new ElementTag(result.getUpsertedId().asObjectId().getValue().toString()));
                                } else {
                                    scriptEntry.saveObject("upserted_id", null);
                                }
                            } else {
                                result = connection.collection.updateMany((Bson)new Document((Map)updateMap), (Bson)new Document((Map)newMap));
                            }
                            scriptEntry.saveObject("updated_count", new ElementTag(result.getModifiedCount()));
                            DenizenCore.runOnMainThread(() -> scriptEntry.setFinished(true));
                        }
                        catch (Exception e) {
                            DenizenCore.runOnMainThread(() -> {
                                Debug.echoError(scriptEntry, "Mongo Exception: " + e.getMessage());
                                if (CoreConfiguration.debugVerbose) {
                                    Debug.echoError(scriptEntry, e);
                                }
                                scriptEntry.setFinished(true);
                            });
                        }
                    } else if (newCollection != null) {
                        try {
                            MongoCollection newCol = connection.database.getCollection(newCollection);
                            Debug.echoDebug((Debuggable)scriptEntry, "Using new Collection: '" + newCollection + "'.");
                            connection.collection = newCol;
                            DenizenCore.runOnMainThread(() -> scriptEntry.setFinished(true));
                        }
                        catch (Exception e) {
                            DenizenCore.runOnMainThread(() -> {
                                Debug.echoError(scriptEntry, "Mongo Exception: " + e.getMessage());
                                if (CoreConfiguration.debugVerbose) {
                                    Debug.echoError(scriptEntry, e);
                                }
                                scriptEntry.setFinished(true);
                            });
                        }
                    } else {
                        Debug.echoError(scriptEntry, "Invalid mongo action!");
                        scriptEntry.setFinished(true);
                    }
                }
                catch (Exception e) {
                    Debug.echoError("Mongo Exception: " + e.getMessage());
                    if (!CoreConfiguration.debugVerbose) break block43;
                    Debug.echoError(scriptEntry, e);
                }
            }
        };
        if (!scriptEntry.shouldWaitFor()) {
            DenizenCore.schedule(new AsyncSchedulable(new OneTimeSchedulable(runnable, 0.0f)));
        } else {
            runnable.run();
        }
    }

    public static class Connection {
        public MongoClient connection;
        public MongoDatabase database;
        public MongoCollection<Document> collection;
    }
}

