/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.npc.traits.AssignmentTrait;
import com.denizenscript.denizen.objects.AreaContainmentObject;
import com.denizenscript.denizen.objects.ChunkTag;
import com.denizenscript.denizen.objects.CuboidTag;
import com.denizenscript.denizen.objects.EllipsoidTag;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.InventoryTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.objects.PolygonTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizen.scripts.containers.core.EntityScriptHelper;
import com.denizenscript.denizen.scripts.containers.core.InventoryScriptHelper;
import com.denizenscript.denizen.scripts.containers.core.ItemScriptHelper;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizen.utilities.NotedAreaTracker;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizen.utilities.inventory.SlotHelper;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.flags.AbstractFlagTracker;
import com.denizenscript.denizencore.flags.FlaggableObject;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.JavaReflectedObjectTag;
import com.denizenscript.denizencore.objects.notable.Notable;
import com.denizenscript.denizencore.objects.notable.NoteManager;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.IllegalPluginAccessException;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredListener;
import org.bukkit.scheduler.BukkitRunnable;

public abstract class BukkitScriptEvent
extends ScriptEvent {
    public static HashSet<String> areaCouldMatchableText = new HashSet<String>(List.of("area", "cuboid", "polygon", "ellipsoid"));
    public static HashSet<String> areaCouldMatchPrefixes = new HashSet<String>(List.of("area_flagged", "biome"));
    public static HashSet<String> inventoryCouldMatchableText = new HashSet<String>(List.of("inventory", "notable", "note", "gui"));
    public static HashSet<String> inventoryCouldMatchPrefixes = new HashSet<String>(List.of("inventory_flagged"));
    public static HashSet<String> entityCouldMatchPrefixes = new HashSet<String>(List.of("entity_flagged", "player_flagged", "npc_flagged"));
    public static HashSet<String> vehicleCouldMatchPrefixes = new HashSet<String>(List.of("entity_flagged"));
    public static HashSet<String> materialCouldMatchableText = new HashSet<String>(List.of("block", "material"));
    public static HashSet<String> materialCouldMatchPrefixes = new HashSet<String>(List.of("vanilla_tagged", "material_flagged"));
    public static HashSet<String> itemCouldMatchableText = new HashSet<String>(List.of("item", "potion"));
    public static HashSet<String> itemCouldMatchPrefixes = new HashSet<String>(List.of("item_flagged", "vanilla_tagged", "item_enchanted", "material_flagged", "raw_exact"));
    private static Field REGISTERED_LISTENER_EXECUTOR_FIELD;
    public HashMap<EventPriority, BukkitScriptEvent> priorityHandlers;
    public List<Map.Entry<RegisteredListener, HandlerList>> registeredHandlers;
    public Event currentEvent = null;

    public static boolean couldMatchLegacyInArea(String lower) {
        String next;
        int index = CoreUtilities.split(lower, ' ').indexOf("in");
        if (index == -1) {
            return true;
        }
        String in = CoreUtilities.getXthArg(index + 1, lower);
        if (BukkitScriptEvent.couldMatchInventory(in)) {
            return false;
        }
        return !in.equals("notable") && !in.equals("noted") || (next = CoreUtilities.getXthArg(index + 2, lower)).equals("cuboid") || next.equals("ellipsoid");
    }

    public static boolean couldMatchArea(String text) {
        if (areaCouldMatchableText.contains(text)) {
            return true;
        }
        int colon = text.indexOf(58);
        if (colon != -1 && areaCouldMatchPrefixes.contains(text.substring(0, colon))) {
            return true;
        }
        if (NoteManager.getSavedObject(text) instanceof AreaContainmentObject) {
            return true;
        }
        if (BukkitScriptEvent.isAdvancedMatchable(text)) {
            ScriptEvent.MatchHelper matcher = BukkitScriptEvent.createMatcher(text);
            for (Notable obj : NoteManager.nameToObject.values()) {
                if (!(obj instanceof AreaContainmentObject) || !matcher.doesMatch(((AreaContainmentObject)((Object)obj)).getNoteName())) continue;
                return true;
            }
            BukkitScriptEvent.addPossibleCouldMatchFailReason("Imperfect area label (allowed due to advanced-matcher usage)", text);
            return true;
        }
        BukkitScriptEvent.addPossibleCouldMatchFailReason("Not a valid area label", text);
        return false;
    }

    public static boolean exactMatchesEnum(String text, Enum<?>[] enumVals) {
        for (Enum<?> val : enumVals) {
            if (!CoreUtilities.equalsIgnoreCase(val.name(), text)) continue;
            return true;
        }
        BukkitScriptEvent.addPossibleCouldMatchFailReason("Does not match required enumeration", text);
        return false;
    }

    public static boolean couldMatchEnum(String text, Enum<?>[] enumVals) {
        if (BukkitScriptEvent.exactMatchesEnum(text, enumVals)) {
            return true;
        }
        if (BukkitScriptEvent.isAdvancedMatchable(text)) {
            ScriptEvent.MatchHelper matcher = BukkitScriptEvent.createMatcher(text);
            for (Enum<?> val : enumVals) {
                if (!matcher.doesMatch(val.name())) continue;
                return true;
            }
        }
        BukkitScriptEvent.addPossibleCouldMatchFailReason("Does not match required enumeration", text);
        return false;
    }

    public static boolean couldMatchInventory(String text) {
        if (inventoryCouldMatchableText.contains(text)) {
            return true;
        }
        int colon = text.indexOf(58);
        if (colon != -1 && inventoryCouldMatchPrefixes.contains(text.substring(0, colon))) {
            return true;
        }
        if (InventoryTag.matches(text)) {
            return true;
        }
        if (BukkitScriptEvent.isAdvancedMatchable(text)) {
            ScriptEvent.MatchHelper matcher = BukkitScriptEvent.createMatcher(text);
            for (InventoryType inventoryType : InventoryType.values()) {
                if (!matcher.doesMatch(inventoryType.name())) continue;
                return true;
            }
            for (InventoryType inventoryType : InventoryTag.idTypes) {
                if (!matcher.doesMatch((String)inventoryType)) continue;
                return true;
            }
            for (String type : InventoryScriptHelper.inventoryScripts.keySet()) {
                if (!matcher.doesMatch(type)) continue;
                return true;
            }
            for (InventoryTag note : InventoryScriptHelper.notedInventories.values()) {
                if (!matcher.doesMatch(note.noteName)) continue;
                return true;
            }
        }
        BukkitScriptEvent.addPossibleCouldMatchFailReason("Not a valid inventory label", text);
        return false;
    }

    public static boolean couldMatchEntity(String text) {
        if (BukkitScriptEvent.exactMatchEntity(text)) {
            return true;
        }
        if (BukkitScriptEvent.isAdvancedMatchable(text)) {
            ScriptEvent.MatchHelper matcher = BukkitScriptEvent.createMatcher(text);
            for (EntityType entity : EntityType.values()) {
                if (!matcher.doesMatch(entity.name())) continue;
                return true;
            }
            for (String script : EntityScriptHelper.scripts.keySet()) {
                if (!matcher.doesMatch(script)) continue;
                return true;
            }
        }
        BukkitScriptEvent.addPossibleCouldMatchFailReason("Not a valid entity label", text);
        return false;
    }

    public static boolean exactMatchEntity(String text) {
        if (EntityTag.specialEntityMatchables.contains(text)) {
            return true;
        }
        int colon = text.indexOf(58);
        if (colon != -1 && entityCouldMatchPrefixes.contains(text.substring(0, colon))) {
            return true;
        }
        if (EntityTag.matches(text)) {
            return true;
        }
        BukkitScriptEvent.addPossibleCouldMatchFailReason("Not a valid entity label", text);
        return false;
    }

    public static boolean exactMatchesVehicle(String text) {
        if (text.equals("vehicle")) {
            return true;
        }
        if (EntityTag.specialEntityMatchables.contains(text)) {
            return false;
        }
        int colon = text.indexOf(58);
        if (colon != -1 && vehicleCouldMatchPrefixes.contains(text.substring(0, colon))) {
            return true;
        }
        if (text.startsWith("player_flagged:") || text.startsWith("npc_flagged:")) {
            return false;
        }
        if (EntityTag.matches(text)) {
            EntityTag entity = EntityTag.valueOf(text, CoreUtilities.noDebugContext);
            if (entity == null) {
                BukkitScriptEvent.addPossibleCouldMatchFailReason("Broken entity/vehicle reference", text);
                return false;
            }
            if (!Vehicle.class.isAssignableFrom(entity.getEntityType().getBukkitEntityType().getEntityClass())) {
                BukkitScriptEvent.addPossibleCouldMatchFailReason("Entity type is not a vehicle", text);
                return false;
            }
            return true;
        }
        BukkitScriptEvent.addPossibleCouldMatchFailReason("Not a valid vehicle label", text);
        return false;
    }

    public static boolean couldMatchVehicle(String text) {
        if (BukkitScriptEvent.exactMatchesVehicle(text)) {
            return true;
        }
        if (BukkitScriptEvent.isAdvancedMatchable(text)) {
            ScriptEvent.MatchHelper matcher = BukkitScriptEvent.createMatcher(text);
            for (EntityType entity : EntityType.values()) {
                if (!matcher.doesMatch(entity.name())) continue;
                return true;
            }
            for (String script : EntityScriptHelper.scripts.keySet()) {
                if (!matcher.doesMatch(script)) continue;
                return true;
            }
        }
        BukkitScriptEvent.addPossibleCouldMatchFailReason("Not a valid vehicle label", text);
        return false;
    }

    public static boolean couldMatchBlockOrItem(String text) {
        if (itemCouldMatchableText.contains(text) || materialCouldMatchableText.contains(text)) {
            return true;
        }
        int colon = text.indexOf(58);
        if (colon != -1) {
            if (itemCouldMatchPrefixes.contains(text.substring(0, colon))) {
                return true;
            }
            if (materialCouldMatchPrefixes.contains(text.substring(0, colon))) {
                return true;
            }
        }
        if (MaterialTag.matches(text)) {
            MaterialTag mat = MaterialTag.valueOf(text, CoreUtilities.noDebugContext);
            return mat != null;
        }
        if (ItemTag.matches(text)) {
            return true;
        }
        if (BukkitScriptEvent.isAdvancedMatchable(text)) {
            ScriptEvent.MatchHelper matcher = BukkitScriptEvent.createMatcher(text);
            for (Material material : Material.values()) {
                if (!matcher.doesMatch(material.name())) continue;
                return true;
            }
            for (String item : ItemScriptHelper.item_scripts.keySet()) {
                if (!matcher.doesMatch(item)) continue;
                return true;
            }
        }
        BukkitScriptEvent.addPossibleCouldMatchFailReason("Not a valid block or item label", text);
        return false;
    }

    public static boolean couldMatchBlock(String text) {
        return BukkitScriptEvent.couldMatchBlock(text, null);
    }

    public static boolean couldMatchBlock(String text, Function<Material, Boolean> requirement) {
        if (materialCouldMatchableText.contains(text)) {
            return true;
        }
        if (text.equals("item")) {
            return false;
        }
        int colon = text.indexOf(58);
        if (colon != -1 && materialCouldMatchPrefixes.contains(text.substring(0, colon))) {
            return true;
        }
        if (MaterialTag.matches(text)) {
            MaterialTag mat = MaterialTag.valueOf(text, CoreUtilities.noDebugContext);
            if (mat == null || !mat.getMaterial().isBlock()) {
                return false;
            }
            if (mat.getMaterial().isBlock() && (requirement == null || requirement.apply(mat.getMaterial()).booleanValue())) {
                return true;
            }
            BukkitScriptEvent.addPossibleCouldMatchFailReason("Material is an item not a block", text);
            return false;
        }
        if (BukkitScriptEvent.isAdvancedMatchable(text)) {
            ScriptEvent.MatchHelper matcher = BukkitScriptEvent.createMatcher(text);
            for (Material material : Material.values()) {
                if (!material.isBlock() || !matcher.doesMatch(material.name()) || requirement != null && !requirement.apply(material).booleanValue()) continue;
                return true;
            }
        }
        BukkitScriptEvent.addPossibleCouldMatchFailReason("Not a valid block label", text);
        return false;
    }

    public static boolean couldMatchItem(String text) {
        if (itemCouldMatchableText.contains(text)) {
            return true;
        }
        int colon = text.indexOf(58);
        if (colon != -1 && itemCouldMatchPrefixes.contains(text.substring(0, colon))) {
            return true;
        }
        int bracketIndex = text.indexOf(91);
        if (bracketIndex != -1) {
            return ItemTag.matches(text);
        }
        if (MaterialTag.matches(text)) {
            MaterialTag mat = MaterialTag.valueOf(text, CoreUtilities.noDebugContext);
            if (mat == null || !mat.getMaterial().isItem()) {
                BukkitScriptEvent.addPossibleCouldMatchFailReason("Material is not an item", text);
                return false;
            }
            return true;
        }
        if (ItemTag.matches(text)) {
            return true;
        }
        if (BukkitScriptEvent.isAdvancedMatchable(text)) {
            ScriptEvent.MatchHelper matcher = BukkitScriptEvent.createMatcher(text);
            for (Material material : Material.values()) {
                if (!material.isItem() || !matcher.doesMatch(material.name())) continue;
                return true;
            }
            for (String item : ItemScriptHelper.item_scripts.keySet()) {
                if (!matcher.doesMatch(item)) continue;
                return true;
            }
        }
        BukkitScriptEvent.addPossibleCouldMatchFailReason("Not a valid item label", text);
        return false;
    }

    public static boolean nonSwitchWithCheck(ScriptEvent.ScriptPath path, ItemTag held) {
        int index;
        for (index = 0; index < path.eventArgsLower.length && !path.eventArgsLower[index].equals("with"); ++index) {
        }
        if (index >= path.eventArgsLower.length) {
            return true;
        }
        String with = path.eventArgLowerAt(index + 1);
        return with == null || held != null && held.tryAdvancedMatcher(with, path.context);
    }

    @Override
    public BukkitTagContext getTagContext(ScriptEvent.ScriptPath path) {
        return (BukkitTagContext)super.getTagContext(path);
    }

    public static Class<? extends Event> getRegistrationClass(Class<? extends Event> clazz) {
        try {
            clazz.getDeclaredMethod("getHandlerList", new Class[0]);
            return clazz;
        }
        catch (NoSuchMethodException var3) {
            if (clazz.getSuperclass() != null && !clazz.getSuperclass().equals(Event.class) && Event.class.isAssignableFrom(clazz.getSuperclass())) {
                return BukkitScriptEvent.getRegistrationClass(clazz.getSuperclass().asSubclass(Event.class));
            }
            throw new IllegalPluginAccessException("Unable to find handler list for event " + clazz.getName() + ". Static getHandlerList method required!");
        }
    }

    public static HandlerList getEventListeners(Class<? extends Event> type) {
        try {
            Method method = BukkitScriptEvent.getRegistrationClass(type).getDeclaredMethod("getHandlerList", new Class[0]);
            method.setAccessible(true);
            return (HandlerList)method.invoke(null, new Object[0]);
        }
        catch (Exception var3) {
            throw new IllegalPluginAccessException(var3.toString());
        }
    }

    public static EventExecutor getExecutor(RegisteredListener listener) {
        try {
            return (EventExecutor)REGISTERED_LISTENER_EXECUTOR_FIELD.get(listener);
        }
        catch (IllegalAccessException ex) {
            Debug.echoError(ex);
            return null;
        }
    }

    @Override
    public ScriptEvent fire() {
        if (!Bukkit.isPrimaryThread()) {
            if (CoreConfiguration.debugVerbose) {
                Debug.log("Event is firing async: " + this.getName());
            }
            final BukkitScriptEvent altEvent = (BukkitScriptEvent)this.clone();
            new BukkitRunnable(){

                public void run() {
                    altEvent.fire();
                }
            }.runTask((Plugin)Denizen.getInstance());
            return altEvent;
        }
        return super.fire();
    }

    @Override
    public void cancellationChanged() {
        if (this.currentEvent instanceof Cancellable) {
            ((Cancellable)this.currentEvent).setCancelled(this.cancelled);
        }
        super.cancellationChanged();
    }

    public void fire(Event event) {
        this.currentEvent = event;
        this.cancelled = event instanceof Cancellable ? ((Cancellable)event).isCancelled() : false;
        this.fire();
    }

    @Override
    public ObjectTag getContext(String name) {
        return switch (name) {
            case "reflect_event" -> {
                if (this.currentEvent == null) {
                    yield null;
                }
                yield new JavaReflectedObjectTag(this.currentEvent);
            }
            default -> super.getContext(name);
        };
    }

    @Override
    public void destroy() {
        if (this.priorityHandlers != null) {
            for (BukkitScriptEvent bukkitScriptEvent : this.priorityHandlers.values()) {
                bukkitScriptEvent.destroy();
            }
            this.priorityHandlers = null;
        }
        if (this.registeredHandlers != null) {
            for (Map.Entry entry : this.registeredHandlers) {
                ((HandlerList)entry.getValue()).unregister((RegisteredListener)entry.getKey());
            }
            this.registeredHandlers = null;
        }
    }

    @Override
    public void init() {
        if (this instanceof Listener) {
            this.initListener((Listener)this);
        }
    }

    public void initListener(Listener listener) {
        if (this.priorityHandlers == null) {
            this.priorityHandlers = new HashMap();
        }
        for (ScriptEvent.ScriptPath path : new ArrayList(this.eventPaths)) {
            String bukkitPriority = path.switches.get("bukkit_priority");
            if (bukkitPriority == null) continue;
            try {
                EventPriority priority = EventPriority.valueOf((String)CoreUtilities.toUpperCase(bukkitPriority));
                BukkitScriptEvent handler = this.priorityHandlers.get(priority);
                if (handler == null) {
                    handler = (BukkitScriptEvent)this.clone();
                    handler.eventPaths = new ArrayList();
                    handler.priorityHandlers = null;
                    handler.registeredHandlers = null;
                    this.priorityHandlers.put(priority, handler);
                    handler.initForPriority(priority, (Listener)handler);
                }
                handler.eventPaths.add(path);
                this.eventPaths.remove(path);
            }
            catch (IllegalArgumentException ex) {
                Debug.echoError("Invalid 'bukkit_priority' switch for event '" + path.event + "' in script '" + path.container.getName() + "'.");
                Debug.echoError(ex);
            }
        }
        if (!this.eventPaths.isEmpty()) {
            this.initForPriority(EventPriority.NORMAL, listener);
        }
    }

    public void initForPriority(EventPriority priority, Listener listener) {
        if (this.registeredHandlers == null) {
            this.registeredHandlers = new ArrayList<Map.Entry<RegisteredListener, HandlerList>>();
        }
        Denizen plugin = Denizen.getInstance();
        for (Map.Entry entry : plugin.getPluginLoader().createRegisteredListeners(listener, (Plugin)plugin).entrySet()) {
            for (RegisteredListener registeredListener : (Set)entry.getValue()) {
                RegisteredListener newListener = new RegisteredListener(listener, BukkitScriptEvent.getExecutor(registeredListener), priority, (Plugin)plugin, false);
                HandlerList handlers = BukkitScriptEvent.getEventListeners(BukkitScriptEvent.getRegistrationClass((Class)entry.getKey()));
                handlers.register(newListener);
                this.registeredHandlers.add(new AbstractMap.SimpleEntry<RegisteredListener, HandlerList>(newListener, handlers));
            }
        }
    }

    public boolean runInCheck(ScriptEvent.ScriptPath path, Location location) {
        return this.runInCheck(path, location, "in");
    }

    public static boolean runFlaggedCheck(ScriptEvent.ScriptPath path, String switchName, AbstractFlagTracker tracker) {
        String flagged = path.switches.get(switchName);
        return BukkitScriptEvent.coreFlaggedCheck(flagged, tracker);
    }

    public boolean runLocationFlaggedCheck(ScriptEvent.ScriptPath path, String switchName, Location location) {
        if (!path.switches.containsKey(switchName)) {
            return true;
        }
        return BukkitScriptEvent.runFlaggedCheck(path, switchName, location == null ? null : new LocationTag(location).getFlagTracker());
    }

    public boolean runInCheck(ScriptEvent.ScriptPath path, Location location, String innote) {
        if (!this.runLocationFlaggedCheck(path, "location_flagged", location)) {
            return false;
        }
        String inputText = path.switches.get(innote);
        if (inputText == null) {
            int index;
            for (index = 0; index < path.eventArgsLower.length && !path.eventArgsLower[index].equals(innote); ++index) {
            }
            if (index >= path.eventArgsLower.length) {
                return true;
            }
            if (location == null) {
                return false;
            }
            Deprecations.inAreaSwitchFormat.warn();
            inputText = path.eventArgLowerAt(index + 1);
            if (inputText.equals("notable") || inputText.equals("noted")) {
                String subit = path.eventArgLowerAt(index + 2);
                if (subit.equals("cuboid")) {
                    BoolHolder bool = new BoolHolder();
                    NotedAreaTracker.forEachAreaThatContains(new LocationTag(location), a -> {
                        if (a instanceof CuboidTag) {
                            bool.bool = true;
                        }
                    });
                    return bool.bool;
                }
                if (subit.equals("ellipsoid")) {
                    BoolHolder bool = new BoolHolder();
                    NotedAreaTracker.forEachAreaThatContains(new LocationTag(location), a -> {
                        if (a instanceof EllipsoidTag) {
                            bool.bool = true;
                        }
                    });
                    return bool.bool;
                }
                Debug.echoError("Invalid event 'IN ...' check [" + this.getName() + "] ('in notable ???'): '" + path.event + "' for " + path.container.getName());
                return false;
            }
        }
        if (location == null) {
            return false;
        }
        if (inputText.startsWith("!")) {
            return !BukkitScriptEvent.inCheckInternal(path.context, this.getName(), location, inputText.substring(1), path.event, path.container.getName());
        }
        return BukkitScriptEvent.inCheckInternal(path.context, this.getName(), location, inputText, path.event, path.container.getName());
    }

    public static boolean inCheckInternal(TagContext context, String name, Location location, String inputText, String evtLine, String containerName) {
        String lower = CoreUtilities.toLowerCase(inputText);
        if (lower.contains(":")) {
            if (lower.startsWith("world_flagged:")) {
                return BukkitScriptEvent.coreFlaggedCheck(inputText.substring("world_flagged:".length()), new WorldTag(location.getWorld()).getFlagTracker());
            }
            if (lower.startsWith("chunk_flagged:")) {
                return BukkitScriptEvent.coreFlaggedCheck(inputText.substring("chunk_flagged:".length()), new ChunkTag(location).getFlagTracker());
            }
            if (lower.startsWith("area_flagged:")) {
                String flagName = inputText.substring("area_flagged:".length());
                BoolHolder bool = new BoolHolder();
                NotedAreaTracker.forEachAreaThatContains(new LocationTag(location), a -> {
                    if (a instanceof FlaggableObject && BukkitScriptEvent.coreFlaggedCheck(flagName, ((FlaggableObject)((Object)a)).getFlagTracker())) {
                        bool.bool = true;
                    }
                });
                return bool.bool;
            }
            if (lower.startsWith("biome:")) {
                String biome = inputText.substring("biome:".length());
                return BukkitScriptEvent.runGenericCheck(biome, Utilities.namespacedKeyToString(new LocationTag(location).getBiome().getKey()));
            }
        }
        if (lower.equals("cuboid")) {
            BoolHolder bool = new BoolHolder();
            NotedAreaTracker.forEachAreaThatContains(new LocationTag(location), a -> {
                if (a instanceof CuboidTag) {
                    bool.bool = true;
                }
            });
            return bool.bool;
        }
        if (lower.equals("ellipsoid")) {
            BoolHolder bool = new BoolHolder();
            NotedAreaTracker.forEachAreaThatContains(new LocationTag(location), a -> {
                if (a instanceof EllipsoidTag) {
                    bool.bool = true;
                }
            });
            return bool.bool;
        }
        if (lower.equals("polygon")) {
            BoolHolder bool = new BoolHolder();
            NotedAreaTracker.forEachAreaThatContains(new LocationTag(location), a -> {
                if (a instanceof PolygonTag) {
                    bool.bool = true;
                }
            });
            return bool.bool;
        }
        if (WorldTag.matches(inputText)) {
            return CoreUtilities.equalsIgnoreCase(location.getWorld().getName(), lower);
        }
        if (CuboidTag.matches(inputText)) {
            CuboidTag cuboid = CuboidTag.valueOf(inputText, context);
            if (cuboid == null || !cuboid.isUnique()) {
                if (context.showErrors()) {
                    Debug.echoError("Invalid event 'in:<area>' switch [" + name + "] (invalid cuboid): '" + evtLine + "' for " + containerName);
                }
                return false;
            }
            return cuboid.isInsideCuboid(location);
        }
        if (EllipsoidTag.matches(inputText)) {
            EllipsoidTag ellipsoid = EllipsoidTag.valueOf(inputText, context);
            if (ellipsoid == null || !ellipsoid.isUnique()) {
                if (context.showErrors()) {
                    Debug.echoError("Invalid event 'in:<area>' switch [" + name + "] (invalid ellipsoid): '" + evtLine + "' for " + containerName);
                }
                return false;
            }
            return ellipsoid.contains(location);
        }
        if (PolygonTag.matches(inputText)) {
            PolygonTag polygon = PolygonTag.valueOf(inputText, context);
            if (polygon == null || !polygon.isUnique()) {
                if (context.showErrors()) {
                    Debug.echoError("Invalid event 'in:<area>' switch [" + name + "] (invalid polygon): '" + evtLine + "' for " + containerName);
                }
                return false;
            }
            return polygon.doesContainLocation(location);
        }
        if (BukkitScriptEvent.isAdvancedMatchable(lower)) {
            ScriptEvent.MatchHelper matcher = BukkitScriptEvent.createMatcher(lower);
            BoolHolder bool = new BoolHolder();
            NotedAreaTracker.forEachAreaThatContains(new LocationTag(location), a -> {
                if (matcher.doesMatch(a.getNoteName())) {
                    bool.bool = true;
                }
            });
            if (bool.bool) {
                return true;
            }
            return matcher.doesMatch(CoreUtilities.toLowerCase(location.getWorld().getName()));
        }
        if (context.showErrors()) {
            Debug.echoError("Invalid event 'in:<area>' switch [" + name + "] ('in:???') (did you make a typo, or forget to 'note' an object with that name?): '" + evtLine + "' for " + containerName);
        }
        return false;
    }

    public static boolean trySlot(ScriptEvent.ScriptPath path, String switchName, Entity entity, int slot) {
        String slotMatch = path.switches.get(switchName);
        if (slotMatch != null) {
            return SlotHelper.doesMatch(slotMatch, entity, slot);
        }
        return true;
    }

    public static boolean runWithCheck(ScriptEvent.ScriptPath path, ItemTag held) {
        return BukkitScriptEvent.runWithCheck(path, held, "with");
    }

    public static boolean runWithCheck(ScriptEvent.ScriptPath path, ItemTag held, String key) {
        String with = path.switches.get(key);
        if (with != null) {
            if (CoreUtilities.equalsIgnoreCase(with, "item")) {
                return true;
            }
            if (held == null || !held.tryAdvancedMatcher(with, path.context)) {
                return false;
            }
        }
        return true;
    }

    public static boolean runFlaggedCheck(ScriptEvent.ScriptPath path, PlayerTag player) {
        return BukkitScriptEvent.runFlaggedCheck(path, "flagged", player);
    }

    public static boolean runFlaggedCheck(ScriptEvent.ScriptPath path, String switchName, PlayerTag player) {
        String flagged = path.switches.get(switchName);
        if (flagged == null) {
            return true;
        }
        if (player == null) {
            return false;
        }
        return BukkitScriptEvent.coreFlaggedCheck(flagged, player.getFlagTracker());
    }

    public static boolean runPermissionCheck(ScriptEvent.ScriptPath path, PlayerTag player) {
        return BukkitScriptEvent.runPermissionCheck(path, "permission", player);
    }

    public static boolean runPermissionCheck(ScriptEvent.ScriptPath path, String switchName, PlayerTag player) {
        String perm = path.switches.get(switchName);
        if (perm == null) {
            return true;
        }
        if (player == null || !player.isOnline()) {
            return false;
        }
        for (String permName : CoreUtilities.split(perm, '|')) {
            boolean expect = true;
            if (permName.startsWith("!")) {
                permName = permName.substring(1);
                expect = false;
            }
            if (player.getPlayerEntity().hasPermission(permName) == expect) continue;
            return false;
        }
        return true;
    }

    public static boolean runAutomaticPlayerSwitches(ScriptEvent event, ScriptEvent.ScriptPath path) {
        if (!path.switches.containsKey("flagged") && !path.switches.containsKey("permission")) {
            return true;
        }
        BukkitScriptEntryData data = (BukkitScriptEntryData)event.getScriptEntryData();
        if (!data.hasPlayer()) {
            return false;
        }
        if (!BukkitScriptEvent.runFlaggedCheck(path, data.getPlayer())) {
            return false;
        }
        return BukkitScriptEvent.runPermissionCheck(path, data.getPlayer());
    }

    public static boolean runAssignedCheck(ScriptEvent.ScriptPath path, NPCTag npc) {
        String matcher = path.switches.get("assigned");
        if (matcher == null) {
            return true;
        }
        if (npc == null) {
            return false;
        }
        AssignmentTrait trait = (AssignmentTrait)npc.getCitizen().getTraitNullable(AssignmentTrait.class);
        if (trait == null) {
            return false;
        }
        for (String script : trait.assignments) {
            if (!BukkitScriptEvent.runGenericCheck(matcher, script)) continue;
            return true;
        }
        return false;
    }

    public static boolean runAutomaticNPCSwitches(ScriptEvent event, ScriptEvent.ScriptPath path) {
        if (!path.switches.containsKey("assigned")) {
            return true;
        }
        BukkitScriptEntryData data = (BukkitScriptEntryData)event.getScriptEntryData();
        if (!data.hasNPC()) {
            return false;
        }
        return BukkitScriptEvent.runAssignedCheck(path, data.getNPC());
    }

    static {
        try {
            REGISTERED_LISTENER_EXECUTOR_FIELD = RegisteredListener.class.getDeclaredField("executor");
            REGISTERED_LISTENER_EXECUTOR_FIELD.setAccessible(true);
        }
        catch (NoSuchFieldException ex) {
            Debug.echoError(ex);
        }
    }

    public static class BoolHolder {
        public boolean bool;
    }
}

