/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.item;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTagBuilder;
import com.denizenscript.denizen.nms.util.jnbt.Tag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.properties.item.ItemProperty;
import com.denizenscript.denizen.objects.properties.item.ItemRawNBT;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.utilities.debugging.Debug;

public class ItemCustomData
extends ItemProperty<MapTag> {
    public static final String[] DENIZEN_DATA = new String[]{"Denizen Item Script", "DenizenItemScript", "Denizen NBT", "Denizen"};

    public static boolean describes(ItemTag item) {
        return !item.getBukkitMaterial().isAir();
    }

    public ItemCustomData(ItemTag item) {
        this.object = item;
    }

    @Override
    public MapTag getPropertyValue() {
        CompoundTag customData = NMSHandler.itemHelper.getCustomData(this.getItemStack());
        if (customData == null) {
            return null;
        }
        if (customData.isEmpty()) {
            return new MapTag();
        }
        MapTag dataMap = (MapTag)ItemRawNBT.jnbtTagToObject(customData);
        for (String denizenKey : DENIZEN_DATA) {
            dataMap.remove(denizenKey);
        }
        return dataMap.isEmpty() ? null : dataMap;
    }

    @Override
    public void setPropertyValue(MapTag value, Mechanism mechanism) {
        CompoundTag customData;
        if (value == null) {
            this.setItemStack(NMSHandler.itemHelper.setCustomData(this.getItemStack(), this.addDenizenKeys(null)));
            return;
        }
        try {
            customData = (CompoundTag)ItemRawNBT.convertObjectToNbt(value.identify(), mechanism.context, "(data)");
        }
        catch (Exception ex) {
            mechanism.echoError("Invalid custom data specified:");
            Debug.echoError(ex);
            return;
        }
        if (customData == null) {
            mechanism.echoError("Invalid custom data specified.");
            return;
        }
        this.setItemStack(NMSHandler.itemHelper.setCustomData(this.getItemStack(), this.addDenizenKeys(customData)));
    }

    private CompoundTag addDenizenKeys(CompoundTag tag) {
        CompoundTag currentData = NMSHandler.itemHelper.getCustomData(this.getItemStack());
        if (currentData == null || currentData.isEmpty()) {
            return tag;
        }
        CompoundTagBuilder tagBuilder = null;
        for (String denizenKey : DENIZEN_DATA) {
            Tag denizenValue = (Tag)currentData.getValue().get(denizenKey);
            if (denizenValue == null) continue;
            if (tagBuilder == null) {
                tagBuilder = tag != null ? tag.createBuilder() : CompoundTagBuilder.create();
            }
            tagBuilder.put(denizenKey, denizenValue);
        }
        return tagBuilder != null ? tagBuilder.build() : tag;
    }

    @Override
    public String getPropertyId() {
        return "custom_data";
    }

    public static void register() {
        ItemCustomData.autoRegisterNullable("custom_data", ItemCustomData.class, MapTag.class, false, new String[0]);
    }
}

