/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.material;

import com.denizenscript.denizen.objects.MaterialTag;
import com.denizenscript.denizen.objects.properties.material.MaterialProperty;
import com.denizenscript.denizencore.exceptions.Unreachable;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Campfire;
import org.bukkit.block.data.type.CaveVinesPlant;
import org.bukkit.block.data.type.PointedDripstone;
import org.bukkit.block.data.type.Scaffolding;
import org.bukkit.block.data.type.Slab;
import org.bukkit.block.data.type.TechnicalPiston;

public class MaterialBlockType
extends MaterialProperty<ElementTag> {
    public static boolean describes(MaterialTag material) {
        BlockData data = material.getModernData();
        return data instanceof Slab || data instanceof TechnicalPiston || data instanceof Campfire || data instanceof Scaffolding || data instanceof PointedDripstone || data instanceof CaveVinesPlant;
    }

    @Override
    public ElementTag getPropertyValue() {
        return new ElementTag(this.getType());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setPropertyValue(ElementTag val, Mechanism mechanism) {
        BlockData data = this.getBlockData();
        if (data instanceof Slab) {
            Slab slab = (Slab)data;
            if (mechanism.requireEnum(Slab.Type.class)) {
                slab.setType(val.asEnum(Slab.Type.class));
                return;
            }
        }
        if (data instanceof TechnicalPiston) {
            TechnicalPiston piston = (TechnicalPiston)data;
            if (mechanism.requireEnum(TechnicalPiston.Type.class)) {
                piston.setType(val.asEnum(TechnicalPiston.Type.class));
                return;
            }
        }
        if (data instanceof Campfire) {
            Campfire campfire = (Campfire)data;
            campfire.setSignalFire(CoreUtilities.equalsIgnoreCase(mechanism.getValue().asString(), "signal"));
            return;
        }
        if (data instanceof PointedDripstone) {
            PointedDripstone dripstone = (PointedDripstone)data;
            if (mechanism.requireEnum(PointedDripstone.Thickness.class)) {
                dripstone.setThickness(val.asEnum(PointedDripstone.Thickness.class));
                return;
            }
        }
        if (data instanceof CaveVinesPlant) {
            CaveVinesPlant vines = (CaveVinesPlant)data;
            vines.setBerries(CoreUtilities.equalsIgnoreCase(val.asString(), "berries"));
            return;
        }
        if (!(data instanceof Scaffolding)) return;
        Scaffolding scaffolding = (Scaffolding)data;
        scaffolding.setBottom(CoreUtilities.equalsIgnoreCase(val.asString(), "bottom"));
    }

    @Override
    public String getPropertyId() {
        return "type";
    }

    public static void register() {
        MaterialBlockType.autoRegister("type", MaterialBlockType.class, ElementTag.class, true, "slab_type");
    }

    public String getType() {
        BlockData data = this.getBlockData();
        if (data instanceof Slab) {
            Slab slab = (Slab)data;
            return slab.getType().name();
        }
        if (data instanceof TechnicalPiston) {
            TechnicalPiston piston = (TechnicalPiston)data;
            return piston.getType().name();
        }
        if (data instanceof Campfire) {
            Campfire campfire = (Campfire)data;
            return campfire.isSignalFire() ? "SIGNAL" : "NORMAL";
        }
        if (data instanceof PointedDripstone) {
            PointedDripstone dripstone = (PointedDripstone)data;
            return dripstone.getThickness().name();
        }
        if (data instanceof CaveVinesPlant) {
            CaveVinesPlant vines = (CaveVinesPlant)data;
            return vines.isBerries() ? "BERRIES" : "NORMAL";
        }
        if (data instanceof Scaffolding) {
            Scaffolding scaffolding = (Scaffolding)data;
            return scaffolding.isBottom() ? "BOTTOM" : "NORMAL";
        }
        throw new Unreachable();
    }
}

