/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.objects.properties.item;

import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.tags.Attribute;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.inventory.meta.CompassMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemLodestoneLocation
implements Property {
    public static final String[] handledTags = new String[]{"lodestone_location"};
    public static final String[] handledMechs = new String[]{"lodestone_location"};
    ItemTag item;

    public static boolean describes(ObjectTag item) {
        return item instanceof ItemTag && ((ItemTag)item).getBukkitMaterial() == Material.COMPASS;
    }

    public static ItemLodestoneLocation getFrom(ObjectTag _item) {
        if (!ItemLodestoneLocation.describes(_item)) {
            return null;
        }
        return new ItemLodestoneLocation((ItemTag)_item);
    }

    public ItemLodestoneLocation(ItemTag _item) {
        this.item = _item;
    }

    @Override
    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("lodestone_location")) {
            LocationTag target = this.getTarget();
            if (target == null) {
                return null;
            }
            return target.getObjectAttribute(attribute.fulfill(1));
        }
        return null;
    }

    public LocationTag getTarget() {
        CompassMeta meta = (CompassMeta)this.item.getItemMeta();
        Location loc = meta.getLodestone();
        if (loc == null || loc.getWorld() == null) {
            return null;
        }
        return new LocationTag(meta.getLodestone());
    }

    @Override
    public String getPropertyString() {
        LocationTag target = this.getTarget();
        if (target == null) {
            return null;
        }
        return target.identify();
    }

    @Override
    public String getPropertyId() {
        return "lodestone_location";
    }

    @Override
    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("lodestone_location")) {
            CompassMeta meta = (CompassMeta)this.item.getItemMeta();
            if (mechanism.hasValue() && mechanism.requireObject(LocationTag.class)) {
                LocationTag loc = mechanism.valueAsType(LocationTag.class).clone();
                if (loc.getWorldName() != null && loc.getWorld() == null) {
                    return;
                }
                meta.setLodestone((Location)loc);
            } else {
                meta.setLodestone(null);
            }
            this.item.setItemMeta((ItemMeta)meta);
        }
    }
}

