/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.events;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import io.papermc.paper.event.player.PlayerItemFrameChangeEvent;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class PlayerChangesFramedItemScriptEvent
extends BukkitScriptEvent
implements Listener {
    public ItemTag item;
    public EntityTag frame;
    public ElementTag action;
    public PlayerItemFrameChangeEvent event;

    public PlayerChangesFramedItemScriptEvent() {
        this.registerCouldMatcher("player changes framed <item>");
        this.registerSwitches("frame", "action");
        this.registerDetermination("item", ItemTag.class, (evt, context, item) -> evt.event.setItemStack(item.getItemStack()));
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!path.tryArgObject(3, this.item)) {
            return false;
        }
        if (!path.tryObjectSwitch("frame", this.frame)) {
            return false;
        }
        if (!path.tryObjectSwitch("action", this.action)) {
            return false;
        }
        if (!this.runInCheck(path, this.frame.getLocation())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ObjectTag getContext(String name) {
        return switch (name) {
            case "frame" -> this.frame;
            case "item" -> new ItemTag(this.event.getItemStack());
            case "action" -> this.action;
            default -> super.getContext(name);
        };
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData((Entity)this.event.getPlayer());
    }

    @EventHandler
    public void onPlayerChangesFramedItem(PlayerItemFrameChangeEvent event) {
        this.item = new ItemTag(event.getItemStack());
        this.frame = new EntityTag((Entity)event.getItemFrame());
        this.action = new ElementTag((Enum<?>)event.getAction());
        this.event = event;
        this.fire((Event)event);
    }
}

