/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.entity;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityTransformEvent;

public class EntityTransformScriptEvent
extends BukkitScriptEvent
implements Listener {
    public EntityTransformEvent event;
    public EntityTag originalEntity;

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        if (!path.eventArgLowerAt(1).equals("transforms")) {
            return false;
        }
        return EntityTransformScriptEvent.couldMatchEntity(path.eventArgLowerAt(0));
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.originalEntity.getLocation())) {
            return false;
        }
        if (!EntityTransformScriptEvent.runGenericSwitchCheck(path, "because", this.event.getTransformReason().name())) {
            return false;
        }
        if (!path.tryArgObject(0, this.originalEntity)) {
            return false;
        }
        if (path.eventArgLowerAt(2).equals("into") && !path.tryArgObject(3, new EntityTag(this.event.getTransformedEntity()))) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ObjectTag getContext(String name) {
        switch (name) {
            case "entity": {
                return this.originalEntity.getDenizenObject();
            }
            case "new_entities": {
                ListTag output = new ListTag();
                for (Entity ent : this.event.getTransformedEntities()) {
                    output.addObject(new EntityTag(ent).getDenizenObject());
                }
                return output;
            }
            case "cause": {
                return new ElementTag((Enum<?>)this.event.getTransformReason());
            }
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onEntityTransform(EntityTransformEvent event) {
        this.event = event;
        this.originalEntity = new EntityTag(event.getEntity());
        this.fire((Event)event);
    }
}

