/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_20.impl.network.handlers.packet;

import com.denizenscript.denizen.nms.v1_20.impl.network.handlers.DenizenNetworkManagerImpl;
import com.denizenscript.denizen.utilities.entity.HideEntitiesHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutEntityVelocity;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntityExperienceOrb;
import net.minecraft.server.level.EntityPlayer;
import org.bukkit.entity.Entity;

public class HiddenEntitiesPacketHandlers {
    public static void registerHandlers() {
        DenizenNetworkManagerImpl.registerPacketHandler(PacketPlayOutSpawnEntity.class, HiddenEntitiesPacketHandlers::processHiddenEntitiesForPacket);
        DenizenNetworkManagerImpl.registerPacketHandler(PacketPlayOutSpawnEntityExperienceOrb.class, HiddenEntitiesPacketHandlers::processHiddenEntitiesForPacket);
        DenizenNetworkManagerImpl.registerPacketHandler(PacketPlayOutEntity.PacketPlayOutEntityLook.class, HiddenEntitiesPacketHandlers::processHiddenEntitiesForPacket);
        DenizenNetworkManagerImpl.registerPacketHandler(PacketPlayOutEntity.PacketPlayOutRelEntityMove.class, HiddenEntitiesPacketHandlers::processHiddenEntitiesForPacket);
        DenizenNetworkManagerImpl.registerPacketHandler(PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook.class, HiddenEntitiesPacketHandlers::processHiddenEntitiesForPacket);
        DenizenNetworkManagerImpl.registerPacketHandler(PacketPlayOutEntityMetadata.class, HiddenEntitiesPacketHandlers::processHiddenEntitiesForPacket);
        DenizenNetworkManagerImpl.registerPacketHandler(PacketPlayOutEntityVelocity.class, HiddenEntitiesPacketHandlers::processHiddenEntitiesForPacket);
        DenizenNetworkManagerImpl.registerPacketHandler(PacketPlayOutEntityTeleport.class, HiddenEntitiesPacketHandlers::processHiddenEntitiesForPacket);
    }

    public static boolean isHidden(EntityPlayer player, net.minecraft.world.entity.Entity entity) {
        return entity != null && HideEntitiesHelper.playerShouldHide(player.getBukkitEntity().getUniqueId(), (Entity)entity.getBukkitEntity());
    }

    public static Packet<PacketListenerPlayOut> processHiddenEntitiesForPacket(DenizenNetworkManagerImpl networkManager, Packet<PacketListenerPlayOut> packet) {
        if (!HideEntitiesHelper.hasAnyHides()) {
            return packet;
        }
        try {
            int ider = -1;
            net.minecraft.world.entity.Entity e2 = null;
            if (packet instanceof PacketPlayOutSpawnEntity) {
                ider = ((PacketPlayOutSpawnEntity)packet).b();
            } else if (packet instanceof PacketPlayOutSpawnEntityExperienceOrb) {
                ider = ((PacketPlayOutSpawnEntityExperienceOrb)packet).b();
            } else if (packet instanceof PacketPlayOutEntity) {
                e2 = ((PacketPlayOutEntity)packet).a(networkManager.player.dP());
            } else if (packet instanceof PacketPlayOutEntityMetadata) {
                ider = ((PacketPlayOutEntityMetadata)packet).b();
            } else if (packet instanceof PacketPlayOutEntityVelocity) {
                ider = ((PacketPlayOutEntityVelocity)packet).b();
            } else if (packet instanceof PacketPlayOutEntityTeleport) {
                ider = ((PacketPlayOutEntityTeleport)packet).b();
            }
            if (e2 == null && ider != -1) {
                e2 = networkManager.player.dP().a(ider);
            }
            if (e2 != null && HiddenEntitiesPacketHandlers.isHidden(networkManager.player, e2)) {
                return null;
            }
        }
        catch (Exception ex) {
            Debug.echoError(ex);
        }
        return packet;
    }
}

