/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.events;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import io.papermc.paper.connection.PlayerCommonConnection;
import io.papermc.paper.connection.PlayerConfigurationConnection;
import io.papermc.paper.connection.PlayerGameConnection;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerLinksSendEvent;

public class PlayerReceivesLinksScriptEvent
extends BukkitScriptEvent
implements Listener {
    public PlayerLinksSendEvent event;
    public PlayerTag player;

    public PlayerReceivesLinksScriptEvent() {
        this.registerCouldMatcher("player receives links");
        this.registerDetermination("links", ListTag.class, (evt, context, value) -> Utilities.replaceServerLinks(evt.event.getLinks(), value, context));
        this.registerDetermination("add_links", ListTag.class, (evt, context, value) -> Utilities.fillServerLinks(evt.event.getLinks(), value, context));
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.player, null);
    }

    @EventHandler
    public void onPlayerLinksSend(PlayerLinksSendEvent event) {
        PlayerCommonConnection playerCommonConnection = event.getConnection();
        if (playerCommonConnection instanceof PlayerGameConnection) {
            PlayerGameConnection gameConnection = (PlayerGameConnection)playerCommonConnection;
            this.player = new PlayerTag(gameConnection.getPlayer());
        } else {
            playerCommonConnection = event.getConnection();
            if (playerCommonConnection instanceof PlayerConfigurationConnection) {
                PlayerConfigurationConnection configConnection = (PlayerConfigurationConnection)playerCommonConnection;
                this.player = new PlayerTag(configConnection.getProfile().getId());
            } else {
                throw new IllegalStateException("Links send event fired with unknown connection type! " + String.valueOf(event.getConnection()) + " / " + event.getConnection().getClass().getName());
            }
        }
        this.event = event;
        this.fire((Event)event);
    }
}

