/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.utilities;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.VanillaTagHelper;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.destroystokyo.paper.event.server.ServerTickEndEvent;
import io.papermc.paper.plugin.bootstrap.BootstrapContext;
import io.papermc.paper.plugin.configuration.PluginMeta;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.TypedKey;
import io.papermc.paper.registry.tag.TagKey;
import io.papermc.paper.tag.PostFlattenTagRegistrar;
import java.lang.invoke.MethodHandle;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.BlockType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class BlockTagsSetter
implements Listener {
    public static final MethodHandle BOOTSTRAP_CONTEXT_CONSTRUCTOR;
    public static final BlockTagsSetter INSTANCE;
    public Map<TypedKey<BlockType>, Set<TagKey<BlockType>>> modifiedTags = new HashMap<TypedKey<BlockType>, Set<TagKey<BlockType>>>();
    public boolean batchReloadNeeded;

    public BlockTagsSetter(Denizen plugin) {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        try {
            BootstrapContext fakeContext = BOOTSTRAP_CONTEXT_CONSTRUCTOR.invoke(plugin.getPluginMeta(), plugin.getDataPath(), plugin.getComponentLogger(), plugin.getFile().toPath());
            fakeContext.getLifecycleManager().registerEventHandler((LifecycleEventType)LifecycleEvents.TAGS.postFlatten(RegistryKey.BLOCK), event -> {
                Map allTags = ((PostFlattenTagRegistrar)event.registrar()).getAllTags();
                for (Map.Entry<TypedKey<BlockType>, Set<TagKey<BlockType>>> entry : this.modifiedTags.entrySet()) {
                    TypedKey<BlockType> blockType = entry.getKey();
                    Set<TagKey<BlockType>> tags = entry.getValue();
                    for (Map.Entry entry2 : allTags.entrySet()) {
                        TagKey tagKey = (TagKey)entry2.getKey();
                        Collection values = (Collection)entry2.getValue();
                        if (!values.contains(blockType) || tags.contains(tagKey)) continue;
                        ArrayList modifiedValues = new ArrayList(values);
                        modifiedValues.remove(blockType);
                        ((PostFlattenTagRegistrar)event.registrar()).setTag(tagKey, modifiedValues);
                    }
                    for (TagKey tagKey : tags) {
                        ((PostFlattenTagRegistrar)event.registrar()).addToTag(tagKey, List.of(blockType));
                    }
                }
            });
        }
        catch (Throwable e2) {
            Debug.echoError(e2);
        }
    }

    @EventHandler
    public void onServerTickEnd(ServerTickEndEvent event) {
        if (this.batchReloadNeeded) {
            this.batchReloadNeeded = false;
            Bukkit.reloadData();
        }
    }

    public void setTags(Material material, Set<NamespacedKey> tags) {
        Set<TagKey<BlockType>> oldTagKeys;
        TypedKey blockKey = TypedKey.create((RegistryKey)RegistryKey.BLOCK, (Key)material.getKey());
        Set tagKeys = tags.stream().map(tag -> TagKey.create((RegistryKey)RegistryKey.BLOCK, (Key)tag)).collect(Collectors.toCollection(HashSet::new));
        if (tagKeys.equals(oldTagKeys = this.modifiedTags.put((TypedKey<BlockType>)blockKey, tagKeys))) {
            return;
        }
        VanillaTagHelper.tagsByMaterial.put(material, tags.stream().map(Utilities::namespacedKeyToString).collect(Collectors.toCollection(HashSet::new)));
        this.batchReloadNeeded = true;
    }

    static {
        try {
            Class<?> bootstrapContextImplClass = Class.forName("io.papermc.paper.plugin.bootstrap.PluginBootstrapContextImpl");
            BOOTSTRAP_CONTEXT_CONSTRUCTOR = ReflectionHelper.getConstructor(bootstrapContextImplClass, PluginMeta.class, Path.class, ComponentLogger.class, Path.class);
        }
        catch (Throwable e2) {
            throw new RuntimeException("Failed to initialize BlockTagsSetter", e2);
        }
        INSTANCE = new BlockTagsSetter(Denizen.getInstance());
    }
}

