/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.events;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import io.papermc.paper.event.player.PlayerInventorySlotChangeEvent;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class PlayerInventorySlotChangeScriptEvent
extends BukkitScriptEvent
implements Listener {
    public PlayerInventorySlotChangeEvent event;
    public ItemTag oldItem;
    public ItemTag newItem;

    public PlayerInventorySlotChangeScriptEvent() {
        this.registerCouldMatcher("player inventory slot changes");
        this.registerSwitches(new String[]{"from", "to", "slot"});
    }

    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!PlayerInventorySlotChangeScriptEvent.runGenericSwitchCheck((ScriptEvent.ScriptPath)path, (String)"slot", (String)String.valueOf(this.event.getSlot() + 1))) {
            return false;
        }
        if (!PlayerInventorySlotChangeScriptEvent.runWithCheck((ScriptEvent.ScriptPath)path, (ItemTag)this.oldItem, (String)"from")) {
            return false;
        }
        if (!PlayerInventorySlotChangeScriptEvent.runWithCheck((ScriptEvent.ScriptPath)path, (ItemTag)this.newItem, (String)"to")) {
            return false;
        }
        if (!this.runInCheck(path, this.event.getPlayer().getLocation())) {
            return false;
        }
        return super.matches(path);
    }

    public ObjectTag getContext(String name) {
        switch (name) {
            case "new_item": {
                return this.newItem;
            }
            case "old_item": {
                return this.oldItem;
            }
            case "slot": {
                return new ElementTag(this.event.getSlot() + 1);
            }
            case "raw_slot": {
                return new ElementTag(this.event.getRawSlot());
            }
        }
        return super.getContext(name);
    }

    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData((Entity)this.event.getPlayer());
    }

    @EventHandler
    public void onPlayerInventorySlotChange(PlayerInventorySlotChangeEvent event) {
        if (EntityTag.isNPC((Entity)event.getPlayer())) {
            return;
        }
        this.oldItem = new ItemTag(event.getOldItemStack());
        this.newItem = new ItemTag(event.getNewItemStack());
        this.event = event;
        this.fire((Event)event);
    }
}

