/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.properties;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import com.destroystokyo.paper.entity.villager.Reputation;
import com.destroystokyo.paper.entity.villager.ReputationType;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Villager;

public class EntityReputation
implements Property {
    EntityTag entity;

    public static boolean describes(ObjectTag entity) {
        return entity instanceof EntityTag && ((EntityTag)entity).getBukkitEntity() instanceof Villager;
    }

    public static EntityReputation getFrom(ObjectTag _entity) {
        if (!EntityReputation.describes(_entity)) {
            return null;
        }
        return new EntityReputation((EntityTag)_entity);
    }

    private EntityReputation(EntityTag _entity) {
        this.entity = _entity;
    }

    public String getPropertyString() {
        return this.getReputationMap().identify();
    }

    public String getPropertyId() {
        return "reputation";
    }

    public static void registerTags() {
        PropertyParser.registerTag(EntityReputation.class, MapTag.class, (String)"reputation", (attribute, object) -> object.getReputationMap(), (String[])new String[0]);
        PropertyParser.registerMechanism(EntityReputation.class, MapTag.class, (String)"reputation", (object, mechanism, input) -> {
            Villager villager = object.getVillager();
            villager.clearReputations();
            for (Map.Entry entry : input.map.entrySet()) {
                UUID uuid;
                try {
                    uuid = UUID.fromString(((StringHolder)entry.getKey()).str);
                }
                catch (IllegalArgumentException exception) {
                    mechanism.echoError("Invalid uuid specified: " + ((StringHolder)entry.getKey()).str);
                    continue;
                }
                MapTag reputationInput = (MapTag)((ObjectTag)entry.getValue()).asType(MapTag.class, mechanism.context);
                if (reputationInput == null) {
                    mechanism.echoError("Invalid reputation map specified: " + entry.getValue());
                    continue;
                }
                Reputation reputation = new Reputation();
                for (Map.Entry reputationEntry : reputationInput.map.entrySet()) {
                    ReputationType reputationType = (ReputationType)new ElementTag(((StringHolder)reputationEntry.getKey()).low).asEnum(ReputationType.class);
                    if (reputationType == null) {
                        mechanism.echoError("Invalid reputation type specified: " + ((StringHolder)reputationEntry.getKey()).str);
                        continue;
                    }
                    reputation.setReputation(reputationType, ((ObjectTag)reputationEntry.getValue()).asElement().asInt());
                }
                villager.setReputation(uuid, reputation);
            }
        }, (String[])new String[0]);
    }

    public Villager getVillager() {
        return (Villager)this.entity.getBukkitEntity();
    }

    public MapTag getReputationMap() {
        MapTag result = new MapTag();
        for (Map.Entry entry : this.getVillager().getReputations().entrySet()) {
            MapTag reputationMap = new MapTag();
            Reputation reputation = (Reputation)entry.getValue();
            for (ReputationType reputationType : ReputationType.values()) {
                reputationMap.putObject(reputationType.name(), (ObjectTag)new ElementTag(reputation.getReputation(reputationType)));
            }
            result.putObject(((UUID)entry.getKey()).toString(), (ObjectTag)reputationMap);
        }
        return result;
    }
}

