/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.properties;

import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.destroystokyo.paper.inventory.meta.ArmorStandMeta;
import org.bukkit.Material;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemArmorStand
implements Property {
    public static final String[] handledMechs = new String[]{"armor_stand_data"};
    ItemTag item;

    public static boolean describes(ObjectTag item) {
        return item instanceof ItemTag && ((ItemTag)item).getBukkitMaterial() == Material.ARMOR_STAND;
    }

    public static ItemArmorStand getFrom(ObjectTag item) {
        if (!ItemArmorStand.describes(item)) {
            return null;
        }
        return new ItemArmorStand((ItemTag)item);
    }

    private ItemArmorStand(ItemTag item) {
        this.item = item;
    }

    public MapTag getDataMap() {
        ArmorStandMeta meta = (ArmorStandMeta)this.item.getItemMeta();
        if (meta == null) {
            return null;
        }
        MapTag result = new MapTag();
        result.putObject("base_plate", (ObjectTag)new ElementTag(!meta.hasNoBasePlate()));
        result.putObject("visible", (ObjectTag)new ElementTag(!meta.isInvisible()));
        result.putObject("marker", (ObjectTag)new ElementTag(meta.isMarker()));
        result.putObject("is_small", (ObjectTag)new ElementTag(meta.isSmall()));
        result.putObject("arms", (ObjectTag)new ElementTag(meta.shouldShowArms()));
        return result;
    }

    public String getPropertyString() {
        MapTag result = this.getDataMap();
        if (result == null) {
            return null;
        }
        return result.toString();
    }

    public String getPropertyId() {
        return "armor_stand_data";
    }

    public static void register() {
        PropertyParser.registerTag(ItemArmorStand.class, MapTag.class, (String)"armor_stand_data", (attribute, item) -> item.getDataMap(), (String[])new String[0]);
    }

    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("armor_stand_data") && mechanism.requireObject(MapTag.class)) {
            MapTag map = (MapTag)mechanism.valueAsType(MapTag.class);
            ArmorStandMeta meta = (ArmorStandMeta)this.item.getItemMeta();
            ElementTag base_plate = map.getElement("base_plate");
            ElementTag visible = map.getElement("visible");
            ElementTag marker = map.getElement("marker");
            ElementTag is_small = map.getElement("is_small");
            ElementTag arms = map.getElement("arms");
            if (base_plate != null) {
                meta.setNoBasePlate(!base_plate.asBoolean());
            }
            if (visible != null) {
                meta.setInvisible(!visible.asBoolean());
            }
            if (marker != null) {
                meta.setMarker(marker.asBoolean());
            }
            if (is_small != null) {
                meta.setSmall(is_small.asBoolean());
            }
            if (arms != null) {
                meta.setShowArms(arms.asBoolean());
            }
            this.item.setItemMeta((ItemMeta)meta);
        }
    }
}

