/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.events;

import com.denizenscript.denizen.events.player.PlayerRaiseLowerItemScriptEvent;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import io.papermc.paper.event.player.PlayerStopUsingItemEvent;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class PlayerRaiseLowerItemScriptEventPaperImpl
extends PlayerRaiseLowerItemScriptEvent {
    public DurationTag heldFor;
    public ElementTag hand;

    public ObjectTag getContext(String name) {
        return switch (name) {
            case "held_for" -> this.heldFor;
            case "hand" -> this.hand;
            case "item" -> this.item;
            default -> super.getContext(name);
        };
    }

    public void run(Player pl) {
        this.cancelled = false;
        this.player = new PlayerTag(pl);
        this.item = new ItemTag(pl.getActiveItem());
        this.heldFor = this.state ? null : new DurationTag((long)pl.getHandRaisedTime());
        this.hand = new ElementTag((Enum)pl.getHandRaised());
        this.fire();
    }

    @EventHandler
    public void onStopUsingItem(PlayerStopUsingItemEvent event) {
        PlayerRaiseLowerItemScriptEventPaperImpl.signalDidLower((Player)event.getPlayer());
    }

    @EventHandler
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        if (event.getPlayer().isHandRaised() && event.getPlayer().getHandRaised() == EquipmentSlot.HAND && raisedItems.remove(event.getPlayer().getUniqueId())) {
            this.cancelled = false;
            this.state = false;
            Player pl = event.getPlayer();
            this.player = new PlayerTag(pl);
            ItemStack loweredItem = event.getItemDrop().getItemStack();
            this.item = new ItemTag(loweredItem);
            this.heldFor = new DurationTag((long)loweredItem.getMaxItemUseDuration() - (long)pl.getItemUseRemainingTime());
            this.hand = new ElementTag((Enum)pl.getHandRaised());
            this.fire();
        }
    }

    @EventHandler
    public void onPlayerChangeHeldItem(PlayerItemHeldEvent event) {
        if (event.getPlayer().isHandRaised() && event.getPlayer().getHandRaised() == EquipmentSlot.HAND) {
            PlayerRaiseLowerItemScriptEventPaperImpl.signalDidLower((Player)event.getPlayer());
        }
    }
}

