/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.events;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.destroystokyo.paper.event.player.PlayerElytraBoostEvent;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class PlayerElytraBoostScriptEvent
extends BukkitScriptEvent
implements Listener {
    public PlayerElytraBoostEvent event;
    public ItemTag firework;
    public PlayerTag player;

    public PlayerElytraBoostScriptEvent() {
        this.registerCouldMatcher("player boosts elytra");
        this.registerSwitches(new String[]{"with", "elytra"});
    }

    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, (Location)this.player.getLocation())) {
            return false;
        }
        if (!PlayerElytraBoostScriptEvent.runWithCheck((ScriptEvent.ScriptPath)path, (ItemTag)this.firework)) {
            return false;
        }
        if (!path.tryObjectSwitch("elytra", (ObjectTag)new ItemTag(this.player.getPlayerEntity().getEquipment().getChestplate()))) {
            return false;
        }
        return super.matches(path);
    }

    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.player, null);
    }

    public ObjectTag getContext(String name) {
        switch (name) {
            case "item": {
                return this.firework;
            }
            case "entity": {
                return new EntityTag((Entity)this.event.getFirework());
            }
            case "should_keep": {
                return new ElementTag(!this.event.shouldConsume());
            }
        }
        return super.getContext(name);
    }

    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        String determination = CoreUtilities.toLowerCase((String)determinationObj.toString());
        if (determination.startsWith("keep:")) {
            String value = determination.substring("keep:".length());
            this.event.setShouldConsume(!new ElementTag(value).asBoolean());
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    @EventHandler
    public void onPlayerElytraBoost(PlayerElytraBoostEvent event) {
        this.firework = new ItemTag(event.getItemStack());
        this.player = new PlayerTag(event.getPlayer());
        this.event = event;
        this.fire((Event)event);
    }
}

