/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_16.helpers;

import com.denizenscript.denizen.nms.interfaces.ItemHelper;
import com.denizenscript.denizen.nms.util.PlayerProfile;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.util.jnbt.IntArrayTag;
import com.denizenscript.denizen.nms.util.jnbt.Tag;
import com.denizenscript.denizen.nms.v1_16.impl.jnbt.CompoundTagImpl;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.utilities.FormattedTextHelper;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import net.minecraft.server.v1_16_R3.FurnaceRecipe;
import net.minecraft.server.v1_16_R3.GameProfileSerializer;
import net.minecraft.server.v1_16_R3.IRecipe;
import net.minecraft.server.v1_16_R3.IRegistry;
import net.minecraft.server.v1_16_R3.Item;
import net.minecraft.server.v1_16_R3.ItemStack;
import net.minecraft.server.v1_16_R3.MinecraftKey;
import net.minecraft.server.v1_16_R3.NBTBase;
import net.minecraft.server.v1_16_R3.NBTTagCompound;
import net.minecraft.server.v1_16_R3.NBTTagIntArray;
import net.minecraft.server.v1_16_R3.NBTTagList;
import net.minecraft.server.v1_16_R3.NBTTagString;
import net.minecraft.server.v1_16_R3.NonNullList;
import net.minecraft.server.v1_16_R3.PotionBrewer;
import net.minecraft.server.v1_16_R3.RecipeBlasting;
import net.minecraft.server.v1_16_R3.RecipeCampfire;
import net.minecraft.server.v1_16_R3.RecipeItemStack;
import net.minecraft.server.v1_16_R3.RecipeSmithing;
import net.minecraft.server.v1_16_R3.RecipeSmoking;
import net.minecraft.server.v1_16_R3.RecipeStonecutting;
import net.minecraft.server.v1_16_R3.ShapelessRecipes;
import net.minecraft.server.v1_16_R3.TileEntityFurnace;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.libs.it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import org.bukkit.craftbukkit.v1_16_R3.CraftServer;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftInventoryPlayer;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_16_R3.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_16_R3.util.CraftNamespacedKey;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;

public class ItemHelperImpl
extends ItemHelper {
    public static IRecipe<?> getNMSRecipe(NamespacedKey key) {
        MinecraftKey nmsKey = CraftNamespacedKey.toMinecraft((NamespacedKey)key);
        for (Object2ObjectLinkedOpenHashMap recipeMap : ((CraftServer)Bukkit.getServer()).getServer().getCraftingManager().recipes.values()) {
            IRecipe recipe = (IRecipe)recipeMap.get((Object)nmsKey);
            if (recipe == null) continue;
            return recipe;
        }
        return null;
    }

    public void setMaxStackSize(Material material, int size) {
        try {
            ReflectionHelper.getFinalSetter(Material.class, (String)"maxStack").invoke(material, size);
            ReflectionHelper.getFinalSetter(Item.class, (String)"maxStackSize").invoke((Item)IRegistry.ITEM.get(CraftNamespacedKey.toMinecraft((NamespacedKey)material.getKey())), size);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public Integer burnTime(Material material) {
        return (Integer)TileEntityFurnace.f().get(CraftMagicNumbers.getItem((Material)material));
    }

    public void removeRecipe(NamespacedKey key) {
        MinecraftKey nmsKey = CraftNamespacedKey.toMinecraft((NamespacedKey)key);
        for (Object2ObjectLinkedOpenHashMap recipeMap : ((CraftServer)Bukkit.getServer()).getServer().getCraftingManager().recipes.values()) {
            recipeMap.remove((Object)nmsKey);
        }
    }

    public void clearDenizenRecipes() {
        for (Object2ObjectLinkedOpenHashMap recipeMap : ((CraftServer)Bukkit.getServer()).getServer().getCraftingManager().recipes.values()) {
            for (MinecraftKey key : new ArrayList(recipeMap.keySet())) {
                if (!key.getNamespace().equalsIgnoreCase("denizen")) continue;
                recipeMap.remove((Object)key);
            }
        }
    }

    public void setShapedRecipeIngredient(ShapedRecipe recipe, char c2, org.bukkit.inventory.ItemStack[] item, boolean exact) {
        if (item.length == 1 && item[0].getType() == Material.AIR) {
            recipe.setIngredient(c2, (RecipeChoice)new RecipeChoice.MaterialChoice(Material.AIR));
        } else if (exact) {
            recipe.setIngredient(c2, (RecipeChoice)new RecipeChoice.ExactChoice(item));
        } else {
            Material[] mats = new Material[item.length];
            for (int i = 0; i < item.length; ++i) {
                mats[i] = item[i].getType();
            }
            recipe.setIngredient(c2, (RecipeChoice)new RecipeChoice.MaterialChoice(mats));
        }
    }

    public static RecipeItemStack itemArrayToRecipe(org.bukkit.inventory.ItemStack[] items, boolean exact) {
        RecipeItemStack.StackProvider[] stacks = new RecipeItemStack.StackProvider[items.length];
        for (int i = 0; i < items.length; ++i) {
            stacks[i] = new RecipeItemStack.StackProvider(CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)items[i]));
        }
        RecipeItemStack itemRecipe = new RecipeItemStack(Arrays.stream(stacks));
        itemRecipe.exact = exact;
        return itemRecipe;
    }

    public void registerFurnaceRecipe(String keyName, String group, org.bukkit.inventory.ItemStack result, org.bukkit.inventory.ItemStack[] ingredient, float exp, int time, String type, boolean exact) {
        MinecraftKey key = new MinecraftKey("denizen", keyName);
        RecipeItemStack itemRecipe = ItemHelperImpl.itemArrayToRecipe(ingredient, exact);
        Object recipe = type.equalsIgnoreCase("smoker") ? new RecipeSmoking(key, group, itemRecipe, CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)result), exp, time) : (type.equalsIgnoreCase("blast") ? new RecipeBlasting(key, group, itemRecipe, CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)result), exp, time) : (type.equalsIgnoreCase("campfire") ? new RecipeCampfire(key, group, itemRecipe, CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)result), exp, time) : new FurnaceRecipe(key, group, itemRecipe, CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)result), exp, time)));
        ((CraftServer)Bukkit.getServer()).getServer().getCraftingManager().addRecipe((IRecipe)recipe);
    }

    public void registerStonecuttingRecipe(String keyName, String group, org.bukkit.inventory.ItemStack result, org.bukkit.inventory.ItemStack[] ingredient, boolean exact) {
        MinecraftKey key = new MinecraftKey("denizen", keyName);
        RecipeItemStack itemRecipe = ItemHelperImpl.itemArrayToRecipe(ingredient, exact);
        RecipeStonecutting recipe = new RecipeStonecutting(key, group, itemRecipe, CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)result));
        ((CraftServer)Bukkit.getServer()).getServer().getCraftingManager().addRecipe((IRecipe)recipe);
    }

    public void registerSmithingRecipe(String keyName, org.bukkit.inventory.ItemStack result, org.bukkit.inventory.ItemStack[] baseItem, boolean baseExact, org.bukkit.inventory.ItemStack[] upgradeItem, boolean upgradeExact) {
        MinecraftKey key = new MinecraftKey("denizen", keyName);
        RecipeItemStack baseItemRecipe = ItemHelperImpl.itemArrayToRecipe(baseItem, baseExact);
        RecipeItemStack upgradeItemRecipe = ItemHelperImpl.itemArrayToRecipe(upgradeItem, upgradeExact);
        RecipeSmithing recipe = new RecipeSmithing(key, baseItemRecipe, upgradeItemRecipe, CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)result));
        ((CraftServer)Bukkit.getServer()).getServer().getCraftingManager().addRecipe((IRecipe)recipe);
    }

    public void registerShapelessRecipe(String keyName, String group, org.bukkit.inventory.ItemStack result, List<org.bukkit.inventory.ItemStack[]> ingredients, boolean[] exact) {
        MinecraftKey key = new MinecraftKey("denizen", keyName);
        ArrayList<RecipeItemStack> ingredientList = new ArrayList<RecipeItemStack>();
        for (int i = 0; i < ingredients.size(); ++i) {
            ingredientList.add(ItemHelperImpl.itemArrayToRecipe(ingredients.get(i), exact[i]));
        }
        ShapelessRecipes recipe = new ShapelessRecipes(key, group, CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)result), NonNullList.a(null, (Object[])ingredientList.toArray(new RecipeItemStack[0])));
        ((CraftServer)Bukkit.getServer()).getServer().getCraftingManager().addRecipe((IRecipe)recipe);
    }

    public String getJsonString(org.bukkit.inventory.ItemStack itemStack) {
        String json = CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)itemStack).C().getChatModifier().toString().replace("\\", "\\\\").replace("\"", "\\\"");
        return json.substring(176, json.length() - 185);
    }

    public String getRawHoverText(org.bukkit.inventory.ItemStack itemStack) {
        NBTTagCompound tag = CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)itemStack).getTag();
        if (tag == null) {
            return null;
        }
        return tag.toString();
    }

    public PlayerProfile getSkullSkin(org.bukkit.inventory.ItemStack is) {
        GameProfile profile;
        NBTTagCompound tag;
        ItemStack itemStack = CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)is);
        if (itemStack.hasTag() && (tag = itemStack.getTag()).hasKeyOfType("SkullOwner", 10) && (profile = GameProfileSerializer.deserialize((NBTTagCompound)tag.getCompound("SkullOwner"))) != null) {
            Property property = (Property)Iterables.getFirst((Iterable)profile.getProperties().get((Object)"textures"), null);
            return new PlayerProfile(profile.getName(), profile.getId(), property != null ? property.getValue() : null, property != null ? property.getSignature() : null);
        }
        return null;
    }

    public org.bukkit.inventory.ItemStack setSkullSkin(org.bukkit.inventory.ItemStack itemStack, PlayerProfile playerProfile) {
        ItemStack nmsItemStack;
        GameProfile gameProfile = new GameProfile(playerProfile.getUniqueId(), playerProfile.getName());
        if (playerProfile.hasTexture()) {
            gameProfile.getProperties().get((Object)"textures").clear();
            if (playerProfile.getTextureSignature() != null) {
                gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", playerProfile.getTexture(), playerProfile.getTextureSignature()));
            } else {
                gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", playerProfile.getTexture()));
            }
        }
        NBTTagCompound tag = (nmsItemStack = CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)itemStack)).hasTag() ? nmsItemStack.getTag() : new NBTTagCompound();
        tag.set("SkullOwner", (NBTBase)GameProfileSerializer.serialize((NBTTagCompound)new NBTTagCompound(), (GameProfile)gameProfile));
        nmsItemStack.setTag(tag);
        return CraftItemStack.asBukkitCopy((ItemStack)nmsItemStack);
    }

    public org.bukkit.inventory.ItemStack addNbtData(org.bukkit.inventory.ItemStack itemStack, String key, Tag value) {
        ItemStack nmsItemStack = CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)itemStack);
        NBTTagCompound tag = nmsItemStack.hasTag() ? nmsItemStack.getTag() : new NBTTagCompound();
        CompoundTag compound = CompoundTagImpl.fromNMSTag(tag).createBuilder().put(key, value).build();
        nmsItemStack.setTag(((CompoundTagImpl)compound).toNMSTag());
        return CraftItemStack.asBukkitCopy((ItemStack)nmsItemStack);
    }

    public CompoundTag getNbtData(org.bukkit.inventory.ItemStack itemStack) {
        ItemStack nmsItemStack = CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)itemStack);
        if (nmsItemStack != null && nmsItemStack.hasTag()) {
            return CompoundTagImpl.fromNMSTag(nmsItemStack.getTag());
        }
        return new CompoundTagImpl(new HashMap<String, Tag>());
    }

    public org.bukkit.inventory.ItemStack setNbtData(org.bukkit.inventory.ItemStack itemStack, CompoundTag compoundTag) {
        ItemStack nmsItemStack = CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)itemStack);
        nmsItemStack.setTag(((CompoundTagImpl)compoundTag).toNMSTag());
        return CraftItemStack.asBukkitCopy((ItemStack)nmsItemStack);
    }

    public void setInventoryItem(Inventory inventory, org.bukkit.inventory.ItemStack item, int slot) {
        if (inventory instanceof CraftInventoryPlayer && ((CraftInventoryPlayer)inventory).getInventory().player == null) {
            ((CraftInventoryPlayer)inventory).getInventory().setItem(slot, CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)item));
        } else {
            inventory.setItem(slot, item);
        }
    }

    public IntArrayTag convertUuidToNbt(UUID id) {
        return new IntArrayTag(GameProfileSerializer.a((UUID)id).getInts());
    }

    public UUID convertNbtToUuid(IntArrayTag id) {
        return GameProfileSerializer.a((NBTBase)new NBTTagIntArray(id.getValue()));
    }

    public String getDisplayName(ItemTag item) {
        if (!item.getItemMeta().hasDisplayName()) {
            return null;
        }
        ItemStack nmsItemStack = CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)item.getItemStack());
        String jsonText = ((NBTTagCompound)nmsItemStack.getTag().get("display")).getString("Name");
        BaseComponent[] nameComponent = ComponentSerializer.parse((String)jsonText);
        return FormattedTextHelper.stringify((BaseComponent[])nameComponent, (ChatColor)ChatColor.WHITE);
    }

    public List<String> getLore(ItemTag item) {
        if (!item.getItemMeta().hasLore()) {
            return null;
        }
        ItemStack nmsItemStack = CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)item.getItemStack());
        NBTTagList list = ((NBTTagCompound)nmsItemStack.getTag().get("display")).getList("Lore", 8);
        ArrayList<String> outList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            BaseComponent[] lineComponent = ComponentSerializer.parse((String)list.getString(i));
            outList.add(FormattedTextHelper.stringify((BaseComponent[])lineComponent, (ChatColor)ChatColor.WHITE));
        }
        return outList;
    }

    public void setDisplayName(ItemTag item, String name) {
        ItemStack nmsItemStack = CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)item.getItemStack());
        NBTTagCompound tag = nmsItemStack.getOrCreateTag();
        NBTTagCompound display = tag.getCompound("display");
        if (!tag.hasKey("display")) {
            tag.set("display", (NBTBase)display);
        }
        if (name == null || name.isEmpty()) {
            display.set("Name", null);
            return;
        }
        BaseComponent[] components = FormattedTextHelper.parse((String)name, (ChatColor)ChatColor.WHITE);
        display.set("Name", (NBTBase)NBTTagString.a((String)ComponentSerializer.toString((BaseComponent[])components)));
        item.setItemStack(CraftItemStack.asBukkitCopy((ItemStack)nmsItemStack));
    }

    public void setLore(ItemTag item, List<String> lore) {
        ItemStack nmsItemStack = CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)item.getItemStack());
        NBTTagCompound tag = nmsItemStack.getOrCreateTag();
        NBTTagCompound display = tag.getCompound("display");
        if (!tag.hasKey("display")) {
            tag.set("display", (NBTBase)display);
        }
        if (lore == null || lore.isEmpty()) {
            display.set("Lore", null);
        } else {
            NBTTagList tagList = new NBTTagList();
            for (String line : lore) {
                tagList.add((Object)NBTTagString.a((String)ComponentSerializer.toString((BaseComponent[])FormattedTextHelper.parse((String)line, (ChatColor)ChatColor.WHITE))));
            }
            display.set("Lore", (NBTBase)tagList);
        }
        item.setItemStack(CraftItemStack.asBukkitCopy((ItemStack)nmsItemStack));
    }

    public boolean isValidMix(org.bukkit.inventory.ItemStack input, org.bukkit.inventory.ItemStack ingredient) {
        ItemStack nmsInput = CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)input);
        ItemStack nmsIngredient = CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)ingredient);
        return PotionBrewer.a((ItemStack)nmsInput, (ItemStack)nmsIngredient);
    }
}

