/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_17.helpers;

import com.denizenscript.denizen.nms.interfaces.BlockHelper;
import com.denizenscript.denizen.nms.util.PlayerProfile;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTagBuilder;
import com.denizenscript.denizen.nms.v1_17.ReflectionMappingsInfo;
import com.denizenscript.denizen.nms.v1_17.impl.jnbt.CompoundTagImpl;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.util.Random;
import java.util.UUID;
import org.bukkit.Color;
import org.bukkit.Instrument;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Skull;
import org.bukkit.block.data.type.Bell;
import org.bukkit.craftbukkit.v1_17_R1.CraftChunk;
import org.bukkit.craftbukkit.v1_17_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_17_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_17_R1.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_17_R1.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_17_R1.block.CraftSkull;
import org.bukkit.craftbukkit.v1_17_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_17_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_17_R1.util.CraftMagicNumbers;
import org.bukkit.inventory.ItemStack;

public class BlockHelperImpl
implements BlockHelper {
    public static final Field craftBlockEntityState_tileEntity = ReflectionHelper.getFields(CraftBlockEntityState.class).get((Object)"tileEntity");
    public static final Field craftBlockEntityState_snapshot = ReflectionHelper.getFields(CraftBlockEntityState.class).get((Object)"snapshot");
    public static final Field craftSkull_profile = ReflectionHelper.getFields(CraftSkull.class).get((Object)"profile");
    public static final MethodHandle CRAFTBLOCKSTATE_CONSTRUCTOR = ReflectionHelper.getConstructor(CraftBlockState.class, (Class[])new Class[]{Block.class});
    public static final Field BLOCK_MATERIAL = ReflectionHelper.getFields(cks.class).getFirstOfType(dew.class);
    public static final MethodHandle MATERIAL_PUSH_REACTION_SETTER = ReflectionHelper.getFinalSetterForFirstOfType(dew.class, dey.class);
    public static final MethodHandle BLOCK_STRENGTH_SETTER = ReflectionHelper.getFinalSetterForFirstOfType(cks.a.class, Float.TYPE);
    public static MethodHandle BLOCKSTATEBASE_GETFLUIDSTATE = ReflectionHelper.getMethodHandle(cks.a.class, (String)"getFluid", (Class[])new Class[0]);
    public static MethodHandle FLUIDSTATE_ISRANDOMLYTICKING = ReflectionHelper.getMethodHandle((Class)BLOCKSTATEBASE_GETFLUIDSTATE.type().returnType(), (String)"f", (Class[])new Class[0]);
    public static MethodHandle FLUIDSTATE_ISEMPTY = ReflectionHelper.getMethodHandle((Class)BLOCKSTATEBASE_GETFLUIDSTATE.type().returnType(), (String)"isEmpty", (Class[])new Class[0]);
    public static MethodHandle FLUIDSTATE_CREATELEGACYBLOCK = ReflectionHelper.getMethodHandle((Class)BLOCKSTATEBASE_GETFLUIDSTATE.type().returnType(), (String)"getBlockData", (Class[])new Class[0]);
    public static MethodHandle FLUIDSTATE_ANIMATETICK = ReflectionHelper.getMethodHandle((Class)BLOCKSTATEBASE_GETFLUIDSTATE.type().returnType(), (String)"a", (Class[])new Class[]{bwq.class, gg.class, Random.class});

    public void makeBlockStateRaw(BlockState state) {
        try {
            craftBlockEntityState_snapshot.set(state, craftBlockEntityState_tileEntity.get(state));
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void applyPhysics(Location location) {
        gg pos = new gg(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        ((CraftWorld)location.getWorld()).getHandle().b(pos, CraftMagicNumbers.getBlock((Material)location.getBlock().getType()));
    }

    public static <T extends ciq> T getTE(CraftBlockEntityState<T> cbs) {
        try {
            return (T)((ciq)craftBlockEntityState_tileEntity.get(cbs));
        }
        catch (IllegalAccessException e2) {
            Debug.echoError((Throwable)e2);
            return null;
        }
    }

    public PlayerProfile getPlayerProfile(Skull skull) {
        GameProfile profile = ((cjr)BlockHelperImpl.getTE((CraftSkull)skull)).e;
        if (profile == null) {
            return null;
        }
        String name = profile.getName();
        UUID id = profile.getId();
        Property property = (Property)Iterables.getFirst((Iterable)profile.getProperties().get((Object)"textures"), null);
        return new PlayerProfile(name, id, property != null ? property.getValue() : null);
    }

    public void setPlayerProfile(Skull skull, PlayerProfile playerProfile) {
        GameProfile gameProfile = new GameProfile(playerProfile.getUniqueId(), playerProfile.getName());
        if (playerProfile.hasTexture()) {
            gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", playerProfile.getTexture(), playerProfile.getTextureSignature()));
        }
        try {
            craftSkull_profile.set(skull, gameProfile);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
        skull.update();
    }

    public CompoundTag getNbtData(Block block) {
        ciq te = ((CraftWorld)block.getWorld()).getHandle().getTileEntity(new gg(block.getX(), block.getY(), block.getZ()), true);
        if (te != null) {
            na compound = new na();
            te.b(compound);
            return CompoundTagImpl.fromNMSTag(compound);
        }
        return null;
    }

    public void setNbtData(Block block, CompoundTag ctag) {
        CompoundTagBuilder builder = ctag.createBuilder();
        builder.putInt("x", block.getX());
        builder.putInt("y", block.getY());
        builder.putInt("z", block.getZ());
        ctag = builder.build();
        gg blockPos = new gg(block.getX(), block.getY(), block.getZ());
        ciq te = ((CraftWorld)block.getWorld()).getHandle().getTileEntity(blockPos, true);
        te.a(((CompoundTagImpl)ctag).toNMSTag());
    }

    public boolean setBlockResistance(Material material, float resistance) {
        bzp block = this.getMaterialBlock(material);
        if (block == null) {
            return false;
        }
        ReflectionHelper.setFieldValue(cks.class, (String)ReflectionMappingsInfo.BlockBehaviour_explosionResistance, (Object)block, (Object)Float.valueOf(resistance));
        return true;
    }

    public float getBlockResistance(Material material) {
        bzp block = this.getMaterialBlock(material);
        if (block == null) {
            return 0.0f;
        }
        return ((Float)ReflectionHelper.getFieldValue(cks.class, (String)ReflectionMappingsInfo.BlockBehaviour_explosionResistance, (Object)block)).floatValue();
    }

    public BlockState generateBlockState(Block block, Material mat) {
        try {
            CraftBlockState state = CRAFTBLOCKSTATE_CONSTRUCTOR.invoke(block);
            state.setData(CraftMagicNumbers.getBlock((Material)mat).n());
            return state;
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
            return null;
        }
    }

    public bzp getMaterialBlock(Material bukkitMaterial) {
        if (!bukkitMaterial.isBlock()) {
            return null;
        }
        return ((CraftBlockData)bukkitMaterial.createBlockData()).getState().b();
    }

    public dew getInternalMaterial(Material bukkitMaterial) {
        try {
            return (dew)BLOCK_MATERIAL.get(this.getMaterialBlock(bukkitMaterial));
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
            return null;
        }
    }

    public BlockHelper.PistonPushReaction getPushReaction(Material mat) {
        return BlockHelper.PistonPushReaction.VALUES[this.getInternalMaterial(mat).g().ordinal()];
    }

    public void setPushReaction(Material mat, BlockHelper.PistonPushReaction reaction) {
        try {
            MATERIAL_PUSH_REACTION_SETTER.invoke(this.getInternalMaterial(mat), dey.values()[reaction.ordinal()]);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public float getBlockStrength(Material mat) {
        return this.getMaterialBlock((Material)mat).n().k;
    }

    public void setBlockStrength(Material mat, float strength) {
        try {
            BLOCK_STRENGTH_SETTER.invoke(this.getMaterialBlock(mat).n(), strength);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void doRandomTick(Location location) {
        gg pos = new gg(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        cmx nmsChunk = ((CraftChunk)location.getChunk()).getHandle();
        ckt nmsBlock = nmsChunk.a_(pos);
        abr nmsWorld = ((CraftWorld)location.getWorld()).getHandle();
        if (nmsBlock.o()) {
            nmsBlock.b(nmsWorld, pos, nmsWorld.w);
        }
        try {
            Object fluid = BLOCKSTATEBASE_GETFLUIDSTATE.invoke(nmsBlock);
            if (FLUIDSTATE_ISRANDOMLYTICKING.invoke(fluid)) {
                FLUIDSTATE_ANIMATETICK.invoke(fluid, nmsWorld, pos, nmsWorld.w);
            }
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public Instrument getInstrumentFor(Material mat) {
        bzp blockType = this.getMaterialBlock(mat);
        clu nmsInstrument = clu.a((ckt)blockType.n());
        return Instrument.values()[nmsInstrument.ordinal()];
    }

    public void ringBell(org.bukkit.block.Bell bell) {
        Bell bellData = (Bell)bell.getBlockData();
        gl face = CraftBlock.blockFaceToNotch((BlockFace)bellData.getFacing());
        gl dir = gl.c;
        switch (bellData.getAttachment()) {
            case DOUBLE_WALL: 
            case SINGLE_WALL: {
                switch (face) {
                    case c: 
                    case d: {
                        dir = gl.f;
                    }
                }
                break;
            }
            case FLOOR: {
                dir = face;
            }
        }
        CraftBlock craftBlock = (CraftBlock)bell.getBlock();
        ((bzl)bzq.mp).a((bwq)craftBlock.getCraftWorld().getHandle(), craftBlock.getPosition(), dir);
    }

    public int getExpDrop(Block block, ItemStack item) {
        bzp blockType = this.getMaterialBlock(block.getType());
        if (blockType == null) {
            return 0;
        }
        return blockType.getExpDrop(((CraftBlock)block).getNMS(), ((CraftBlock)block).getCraftWorld().getHandle(), ((CraftBlock)block).getPosition(), item == null ? null : CraftItemStack.asNMSCopy((ItemStack)item));
    }

    public Color getMapColor(Block block) {
        CraftBlock craftBlock = (CraftBlock)block;
        return Color.fromRGB((int)craftBlock.getNMS().d((bvu)craftBlock.getHandle(), (gg)craftBlock.getPosition()).al);
    }
}

