/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_19;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.abstracts.BiomeNMS;
import com.denizenscript.denizen.nms.abstracts.BlockLight;
import com.denizenscript.denizen.nms.abstracts.ParticleHelper;
import com.denizenscript.denizen.nms.abstracts.ProfileEditor;
import com.denizenscript.denizen.nms.abstracts.Sidebar;
import com.denizenscript.denizen.nms.util.PlayerProfile;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.util.jnbt.Tag;
import com.denizenscript.denizen.nms.v1_19.helpers.AdvancementHelperImpl;
import com.denizenscript.denizen.nms.v1_19.helpers.AnimationHelperImpl;
import com.denizenscript.denizen.nms.v1_19.helpers.BlockHelperImpl;
import com.denizenscript.denizen.nms.v1_19.helpers.ChunkHelperImpl;
import com.denizenscript.denizen.nms.v1_19.helpers.CustomEntityHelperImpl;
import com.denizenscript.denizen.nms.v1_19.helpers.EnchantmentHelperImpl;
import com.denizenscript.denizen.nms.v1_19.helpers.EntityHelperImpl;
import com.denizenscript.denizen.nms.v1_19.helpers.FishingHelperImpl;
import com.denizenscript.denizen.nms.v1_19.helpers.ItemHelperImpl;
import com.denizenscript.denizen.nms.v1_19.helpers.PacketHelperImpl;
import com.denizenscript.denizen.nms.v1_19.helpers.PlayerHelperImpl;
import com.denizenscript.denizen.nms.v1_19.helpers.SoundHelperImpl;
import com.denizenscript.denizen.nms.v1_19.helpers.WorldHelperImpl;
import com.denizenscript.denizen.nms.v1_19.impl.BiomeNMSImpl;
import com.denizenscript.denizen.nms.v1_19.impl.ProfileEditorImpl;
import com.denizenscript.denizen.nms.v1_19.impl.SidebarImpl;
import com.denizenscript.denizen.nms.v1_19.impl.blocks.BlockLightImpl;
import com.denizenscript.denizen.nms.v1_19.impl.jnbt.CompoundTagImpl;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.utilities.AdvancedTextImpl;
import com.denizenscript.denizen.utilities.FormattedTextHelper;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Entity;
import net.md_5.bungee.api.chat.hover.content.Item;
import net.md_5.bungee.api.chat.hover.content.Text;
import net.md_5.bungee.chat.ComponentSerializer;
import net.minecraft.core.IRegistry;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.IInventory;
import net.minecraft.world.INamableTileEntity;
import net.minecraft.world.level.biome.BiomeBase;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_19_R1.CraftServer;
import org.bukkit.craftbukkit.v1_19_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_19_R1.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_19_R1.inventory.CraftInventoryCustom;
import org.bukkit.craftbukkit.v1_19_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_19_R1.persistence.CraftPersistentDataContainer;
import org.bukkit.craftbukkit.v1_19_R1.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_19_R1.util.CraftMagicNumbers;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.persistence.PersistentDataContainer;
import org.spigotmc.AsyncCatcher;

public class Handler
extends NMSHandler {
    private final ProfileEditor profileEditor = new ProfileEditorImpl();
    private boolean wasAsyncCatcherEnabled;
    public static MethodHandle PAPER_INVENTORY_TITLE_GETTER;
    public static final Class MINECRAFT_INVENTORY;
    public static final Field INVENTORY_TITLE;
    public static final Field ENTITY_BUKKITYENTITY;

    public Handler() {
        advancementHelper = new AdvancementHelperImpl();
        animationHelper = new AnimationHelperImpl();
        blockHelper = new BlockHelperImpl();
        chunkHelper = new ChunkHelperImpl();
        customEntityHelper = new CustomEntityHelperImpl();
        entityHelper = new EntityHelperImpl();
        fishingHelper = new FishingHelperImpl();
        itemHelper = new ItemHelperImpl();
        soundHelper = new SoundHelperImpl();
        packetHelper = new PacketHelperImpl();
        particleHelper = new ParticleHelper();
        playerHelper = new PlayerHelperImpl();
        worldHelper = new WorldHelperImpl();
        enchantmentHelper = new EnchantmentHelperImpl();
    }

    public void disableAsyncCatcher() {
        this.wasAsyncCatcherEnabled = AsyncCatcher.enabled;
        AsyncCatcher.enabled = false;
    }

    public void undisableAsyncCatcher() {
        AsyncCatcher.enabled = this.wasAsyncCatcherEnabled;
    }

    public boolean isCorrectMappingsCode() {
        return ((CraftMagicNumbers)CraftMagicNumbers.INSTANCE).getMappingsVersion().equals("7b9de0da1357e5b251eddde9aa762916");
    }

    public double[] getRecentTps() {
        return ((CraftServer)Bukkit.getServer()).getServer().recentTps;
    }

    public CompoundTag createCompoundTag(Map<String, Tag> value) {
        return new CompoundTagImpl(value);
    }

    public Sidebar createSidebar(Player player) {
        return new SidebarImpl(player);
    }

    public BlockLight createBlockLight(Location location, int lightLevel, long ticks) {
        return BlockLightImpl.createLight(location, lightLevel, ticks);
    }

    public PlayerProfile fillPlayerProfile(PlayerProfile playerProfile) {
        if (playerProfile == null) {
            return null;
        }
        if (playerProfile.getName() == null && playerProfile.getUniqueId() == null) {
            return playerProfile;
        }
        if (playerProfile.hasTexture() && playerProfile.hasTextureSignature() && playerProfile.getName() != null && playerProfile.getUniqueId() != null) {
            return playerProfile;
        }
        try {
            Property textures;
            GameProfile profile = null;
            aep minecraftServer = ((CraftServer)Bukkit.getServer()).getServer();
            if (playerProfile.getUniqueId() != null) {
                profile = minecraftServer.ap().a(playerProfile.getUniqueId()).orElse(null);
            }
            if (profile == null && playerProfile.getName() != null) {
                profile = minecraftServer.ap().a(playerProfile.getName()).orElse(null);
            }
            if (profile == null) {
                profile = new GameProfile(playerProfile.getUniqueId(), playerProfile.getName());
            }
            Property property = textures = profile.getProperties().containsKey((Object)"textures") ? (Property)Iterables.getFirst((Iterable)profile.getProperties().get((Object)"textures"), null) : null;
            if (textures == null || !textures.hasSignature() || profile.getName() == null || profile.getId() == null) {
                profile = minecraftServer.am().fillProfileProperties(profile, true);
                textures = profile.getProperties().containsKey((Object)"textures") ? (Property)Iterables.getFirst((Iterable)profile.getProperties().get((Object)"textures"), null) : null;
            }
            return new PlayerProfile(profile.getName(), profile.getId(), textures == null ? null : textures.getValue(), textures == null ? null : textures.getSignature());
        }
        catch (Exception e) {
            if (CoreConfiguration.debugVerbose) {
                Debug.echoError((Throwable)e);
            }
            return null;
        }
    }

    public int getPort() {
        return ((CraftServer)Bukkit.getServer()).getServer().L();
    }

    public String getTitle(Inventory inventory) {
        IInventory nms = ((CraftInventory)inventory).getInventory();
        if (inventory instanceof CraftInventoryCustom && Denizen.supportsPaper) {
            try {
                if (PAPER_INVENTORY_TITLE_GETTER == null) {
                    PAPER_INVENTORY_TITLE_GETTER = ReflectionHelper.getMethodHandle(nms.getClass(), (String)"title", (Class[])new Class[0]);
                }
                return AdvancedTextImpl.instance.parseComponent(PAPER_INVENTORY_TITLE_GETTER.invoke(nms), ChatColor.BLACK);
            }
            catch (Throwable ex) {
                Debug.echoError((Throwable)ex);
            }
        }
        if (nms instanceof INamableTileEntity) {
            return CraftChatMessage.fromComponent((IChatBaseComponent)((INamableTileEntity)nms).C_());
        }
        if (MINECRAFT_INVENTORY.isInstance(nms)) {
            try {
                return (String)INVENTORY_TITLE.get(nms);
            }
            catch (IllegalAccessException e) {
                Debug.echoError((Throwable)e);
            }
        }
        return "Chest";
    }

    public PlayerProfile getPlayerProfile(Player player) {
        GameProfile gameProfile = ((CraftPlayer)player).getProfile();
        Property property = (Property)Iterables.getFirst((Iterable)gameProfile.getProperties().get((Object)"textures"), null);
        return new PlayerProfile(gameProfile.getName(), gameProfile.getId(), property != null ? property.getValue() : null, property != null ? property.getSignature() : null);
    }

    public ProfileEditor getProfileEditor() {
        return this.profileEditor;
    }

    public List<BiomeNMS> getBiomes(World world) {
        WorldServer level = ((CraftWorld)world).getHandle();
        ArrayList<BiomeNMS> output = new ArrayList<BiomeNMS>();
        for (Map.Entry pair : level.s().d(IRegistry.aR).f()) {
            output.add(new BiomeNMSImpl(level, ((aai)pair.getKey()).a().toString()));
        }
        return output;
    }

    public BiomeNMS getBiomeNMS(World world, String name) {
        BiomeNMSImpl impl = new BiomeNMSImpl(((CraftWorld)world).getHandle(), name);
        if (impl.biomeBase == null) {
            return null;
        }
        return impl;
    }

    public BiomeNMS getBiomeAt(Block block) {
        WorldServer level = ((CraftWorld)block.getWorld()).getHandle();
        hc biome = level.getNoiseBiome(block.getX() >> 2, block.getY() >> 2, block.getZ() >> 2);
        MinecraftKey key = level.s().d(IRegistry.aR).b((Object)((BiomeBase)biome.a()));
        String keyText = key.b().equals("minecraft") ? key.a() : key.toString();
        return new BiomeNMSImpl(level, keyText);
    }

    public String stringForHover(HoverEvent hover) {
        if (hover.getContents().isEmpty()) {
            return "";
        }
        Content contentObject = (Content)hover.getContents().get(0);
        if (contentObject instanceof Text) {
            Object value = ((Text)contentObject).getValue();
            if (value instanceof BaseComponent[]) {
                return FormattedTextHelper.stringify((BaseComponent[])((BaseComponent[])value), (ChatColor)ChatColor.WHITE);
            }
            return value.toString();
        }
        if (contentObject instanceof Item) {
            Item item = (Item)contentObject;
            try {
                NBTTagCompound tag = new NBTTagCompound();
                tag.a("id", item.getId());
                tag.a("Count", (byte)item.getCount());
                if (item.getTag() != null && item.getTag().getNbt() != null) {
                    tag.a("tag", (NBTBase)MojangsonParser.a((String)item.getTag().getNbt()));
                }
                caa itemStack = caa.a((NBTTagCompound)tag);
                return new ItemTag(CraftItemStack.asBukkitCopy((caa)itemStack)).identify();
            }
            catch (Throwable ex) {
                Debug.echoError((Throwable)ex);
                return null;
            }
        }
        if (contentObject instanceof Entity) {
            Entity entity = (Entity)contentObject;
            return "e@" + entity.getId();
        }
        throw new UnsupportedOperationException();
    }

    public ArrayList<String> containerListFlags(PersistentDataContainer container, String prefix) {
        prefix = "denizen:" + prefix;
        ArrayList<String> output = new ArrayList<String>();
        for (String key : ((CraftPersistentDataContainer)container).getRaw().keySet()) {
            if (!key.startsWith(prefix)) continue;
            output.add(key.substring(prefix.length()));
        }
        return output;
    }

    public boolean containerHas(PersistentDataContainer container, String key) {
        return ((CraftPersistentDataContainer)container).getRaw().containsKey(key);
    }

    public String containerGetString(PersistentDataContainer container, String key) {
        NBTBase base = (NBTBase)((CraftPersistentDataContainer)container).getRaw().get(key);
        if (base instanceof NBTTagString) {
            return base.e_();
        }
        if (base instanceof NBTTagByteArray) {
            return new String(((NBTTagByteArray)base).d(), StandardCharsets.UTF_8);
        }
        return null;
    }

    public static BaseComponent[] componentToSpigot(IChatBaseComponent nms) {
        String json = IChatBaseComponent.ChatSerializer.a((IChatBaseComponent)nms);
        return ComponentSerializer.parse((String)json);
    }

    public static IChatMutableComponent componentToNMS(BaseComponent[] spigot) {
        String json = ComponentSerializer.toString((BaseComponent[])spigot);
        return IChatBaseComponent.ChatSerializer.a((String)json);
    }

    static {
        ENTITY_BUKKITYENTITY = ReflectionHelper.getFields(baq.class).get((Object)"bukkitEntity");
        Class<?> minecraftInv = null;
        Field title = null;
        try {
            for (Class<?> clzz : CraftInventoryCustom.class.getDeclaredClasses()) {
                if (!CoreUtilities.toLowerCase((String)clzz.getName()).contains("minecraftinventory")) continue;
                minecraftInv = clzz;
                title = clzz.getDeclaredField("title");
                title.setAccessible(true);
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        MINECRAFT_INVENTORY = minecraftInv;
        INVENTORY_TITLE = title;
    }
}

