/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_19.helpers;

import com.denizenscript.denizen.nms.interfaces.EnchantmentHelper;
import com.denizenscript.denizen.nms.v1_19.Handler;
import com.denizenscript.denizen.nms.v1_19.ReflectionMappingsInfo;
import com.denizenscript.denizen.nms.v1_19.helpers.EntityHelperImpl;
import com.denizenscript.denizen.scripts.containers.core.EnchantmentScriptContainer;
import com.denizenscript.denizen.utilities.FormattedTextHelper;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import java.lang.reflect.Field;
import java.util.Map;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.minecraft.core.IRegistry;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentSlotType;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_19_R1.enchantments.CraftEnchantment;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_19_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_19_R1.util.CraftNamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.event.entity.EntityDamageEvent;

public class EnchantmentHelperImpl
extends EnchantmentHelper {
    public static Map<NamespacedKey, org.bukkit.enchantments.Enchantment> ENCHANTMENTS_BY_KEY = (Map)ReflectionHelper.getFieldValue(org.bukkit.enchantments.Enchantment.class, (String)"byKey", null);
    public static Map<String, org.bukkit.enchantments.Enchantment> ENCHANTMENTS_BY_NAME = (Map)ReflectionHelper.getFieldValue(org.bukkit.enchantments.Enchantment.class, (String)"byName", null);
    public static Field REGISTRY_FROZEN = ReflectionHelper.getFields(RegistryMaterials.class).get(ReflectionMappingsInfo.MappedRegistry_frozen, Boolean.TYPE);

    public org.bukkit.enchantments.Enchantment registerFakeEnchantment(final EnchantmentScriptContainer.EnchantmentReference script) {
        try {
            EnumItemSlot[] slots = new EnumItemSlot[script.script.slots.size()];
            for (int i = 0; i < slots.length; ++i) {
                slots[i] = EnumItemSlot.valueOf((String)((String)script.script.slots.get(i)).toUpperCase());
            }
            Enchantment nmsEnchant = new Enchantment(Enchantment.Rarity.valueOf((String)script.script.rarity), EnchantmentSlotType.valueOf((String)script.script.category), slots){

                public int e() {
                    return script.script.minLevel;
                }

                public int a() {
                    return script.script.maxLevel;
                }

                public int a(int level) {
                    return script.script.getMinCost(level);
                }

                public int b(int level) {
                    return script.script.getMaxCost(level);
                }

                public int a(int level, DamageSource src) {
                    return script.script.getDamageProtection(level, src.y, src.m() == null ? null : src.m().getBukkitEntity());
                }

                public float a(int level, EnumMonsterType type) {
                    String typeName = "UNDEFINED";
                    if (type == EnumMonsterType.c) {
                        typeName = "ARTHROPOD";
                    } else if (type == EnumMonsterType.d) {
                        typeName = "ILLAGER";
                    } else if (type == EnumMonsterType.b) {
                        typeName = "UNDEAD";
                    } else if (type == EnumMonsterType.e) {
                        typeName = "WATER";
                    }
                    return script.script.getDamageBonus(level, typeName);
                }

                protected boolean a(Enchantment nmsEnchantment) {
                    MinecraftKey nmsKey = IRegistry.W.b((Object)nmsEnchantment);
                    NamespacedKey bukkitKey = CraftNamespacedKey.fromMinecraft((MinecraftKey)nmsKey);
                    org.bukkit.enchantments.Enchantment bukkitEnchant = CraftEnchantment.getByKey((NamespacedKey)bukkitKey);
                    return script.script.isCompatible(bukkitEnchant);
                }

                protected String f() {
                    return script.script.descriptionId;
                }

                public String g() {
                    return script.script.descriptionId;
                }

                public IChatBaseComponent d(int level) {
                    return Handler.componentToNMS(script.script.getFullName(level));
                }

                public boolean a(ItemStack var0) {
                    return super.a(var0) && script.script.canEnchant(CraftItemStack.asBukkitCopy((ItemStack)var0));
                }

                public void a(EntityLiving attacker, net.minecraft.world.entity.Entity victim, int level) {
                    script.script.doPostAttack((Entity)attacker.getBukkitEntity(), (Entity)victim.getBukkitEntity(), level);
                }

                public void b(EntityLiving victim, net.minecraft.world.entity.Entity attacker, int level) {
                    script.script.doPostHurt((Entity)victim.getBukkitEntity(), (Entity)attacker.getBukkitEntity(), level);
                }

                public boolean b() {
                    return script.script.isTreasureOnly;
                }

                public boolean c() {
                    return script.script.isCurse;
                }

                public boolean h() {
                    return script.script.isTradable;
                }

                public boolean i() {
                    return script.script.isDiscoverable;
                }
            };
            final String enchName = script.script.id.toUpperCase();
            boolean wasFrozen = REGISTRY_FROZEN.getBoolean(IRegistry.W);
            REGISTRY_FROZEN.setBoolean(IRegistry.W, false);
            IRegistry.a((IRegistry)IRegistry.W, (String)("denizen:" + script.script.id), (Object)nmsEnchant);
            CraftEnchantment ench = new CraftEnchantment(nmsEnchant){

                public String getName() {
                    return enchName;
                }
            };
            if (wasFrozen) {
                ((RegistryMaterials)IRegistry.W).k();
            }
            ENCHANTMENTS_BY_KEY.put(ench.getKey(), (org.bukkit.enchantments.Enchantment)ench);
            ENCHANTMENTS_BY_NAME.put(enchName, (org.bukkit.enchantments.Enchantment)ench);
            return ench;
        }
        catch (Throwable ex) {
            Debug.echoError((String)("Failed to register enchantment " + script.script.id));
            Debug.echoError((Throwable)ex);
            return null;
        }
    }

    public String getRarity(org.bukkit.enchantments.Enchantment enchantment) {
        return ((CraftEnchantment)enchantment).getHandle().d().name();
    }

    public boolean isDiscoverable(org.bukkit.enchantments.Enchantment enchantment) {
        return ((CraftEnchantment)enchantment).getHandle().i();
    }

    public boolean isTradable(org.bukkit.enchantments.Enchantment enchantment) {
        return ((CraftEnchantment)enchantment).getHandle().h();
    }

    public boolean isCurse(org.bukkit.enchantments.Enchantment enchantment) {
        return ((CraftEnchantment)enchantment).getHandle().c();
    }

    public int getMinCost(org.bukkit.enchantments.Enchantment enchantment, int level) {
        return ((CraftEnchantment)enchantment).getHandle().a(level);
    }

    public int getMaxCost(org.bukkit.enchantments.Enchantment enchantment, int level) {
        return ((CraftEnchantment)enchantment).getHandle().b(level);
    }

    public String getFullName(org.bukkit.enchantments.Enchantment enchantment, int level) {
        return FormattedTextHelper.stringify((BaseComponent[])Handler.componentToSpigot(((CraftEnchantment)enchantment).getHandle().d(level)), (ChatColor)ChatColor.GRAY);
    }

    public float getDamageBonus(org.bukkit.enchantments.Enchantment enchantment, int level, String type) {
        EnumMonsterType mobType = EnumMonsterType.a;
        switch (type) {
            case "illager": {
                mobType = EnumMonsterType.d;
                break;
            }
            case "undead": {
                mobType = EnumMonsterType.b;
                break;
            }
            case "water": {
                mobType = EnumMonsterType.e;
                break;
            }
            case "arthropod": {
                mobType = EnumMonsterType.c;
            }
        }
        return ((CraftEnchantment)enchantment).getHandle().a(level, mobType);
    }

    public int getDamageProtection(org.bukkit.enchantments.Enchantment enchantment, int level, EntityDamageEvent.DamageCause type, Entity attacker) {
        DamageSource src = EntityHelperImpl.getSourceFor(((CraftEntity)attacker).getHandle(), type);
        if (src instanceof EntityHelperImpl.FakeDamageSrc) {
            src = ((EntityHelperImpl.FakeDamageSrc)src).real;
        }
        return ((CraftEnchantment)enchantment).getHandle().a(level, src);
    }
}

