/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_19.helpers;

import com.denizenscript.denizen.nms.interfaces.BlockHelper;
import com.denizenscript.denizen.nms.util.PlayerProfile;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTagBuilder;
import com.denizenscript.denizen.nms.v1_19.ReflectionMappingsInfo;
import com.denizenscript.denizen.nms.v1_19.helpers.PacketHelperImpl;
import com.denizenscript.denizen.nms.v1_19.impl.jnbt.CompoundTagImpl;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.VanillaTagHelper;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IRegistry;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutTags;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.MobSpawnerAbstract;
import net.minecraft.world.level.MobSpawnerData;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockBell;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityMobSpawner;
import net.minecraft.world.level.block.entity.TileEntitySkull;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyInstrument;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.material.EnumPistonReaction;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Instrument;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.Skull;
import org.bukkit.block.data.type.Bell;
import org.bukkit.craftbukkit.v1_19_R3.CraftChunk;
import org.bukkit.craftbukkit.v1_19_R3.CraftServer;
import org.bukkit.craftbukkit.v1_19_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_19_R3.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_19_R3.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_19_R3.block.CraftCreatureSpawner;
import org.bukkit.craftbukkit.v1_19_R3.block.CraftSkull;
import org.bukkit.craftbukkit.v1_19_R3.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_19_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_19_R3.tag.CraftBlockTag;
import org.bukkit.craftbukkit.v1_19_R3.util.CraftMagicNumbers;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class BlockHelperImpl
implements BlockHelper {
    public static final Field craftBlockEntityState_tileEntity = ReflectionHelper.getFields(CraftBlockEntityState.class).get((Object)"tileEntity");
    public static final Field craftBlockEntityState_snapshot = ReflectionHelper.getFields(CraftBlockEntityState.class).get((Object)"snapshot");
    public static final Field craftSkull_profile = ReflectionHelper.getFields(CraftSkull.class).get((Object)"profile");
    public static final MethodHandle CRAFTBLOCKSTATE_CONSTRUCTOR = ReflectionHelper.getConstructor(CraftBlockState.class, (Class[])new Class[]{Block.class});
    public static final Field BLOCK_MATERIAL = ReflectionHelper.getFields(BlockBase.class).getFirstOfType(dwn.class);
    public static final MethodHandle MATERIAL_PUSH_REACTION_SETTER = ReflectionHelper.getFinalSetterForFirstOfType(dwn.class, EnumPistonReaction.class);
    public static final MethodHandle BLOCK_STRENGTH_SETTER = ReflectionHelper.getFinalSetterForFirstOfType(BlockBase.BlockData.class, Float.TYPE);
    public static MethodHandle BLOCKSTATEBASE_GETFLUIDSTATE = ReflectionHelper.getMethodHandle(BlockBase.BlockData.class, (String)ReflectionMappingsInfo.BlockBehaviourBlockStateBase_getFluidState_method, (Class[])new Class[0]);
    public static MethodHandle FLUIDSTATE_ISRANDOMLYTICKING = ReflectionHelper.getMethodHandle((Class)BLOCKSTATEBASE_GETFLUIDSTATE.type().returnType(), (String)ReflectionMappingsInfo.FluidState_isRandomlyTicking_method, (Class[])new Class[0]);
    public static MethodHandle FLUIDSTATE_ISEMPTY = ReflectionHelper.getMethodHandle((Class)BLOCKSTATEBASE_GETFLUIDSTATE.type().returnType(), (String)ReflectionMappingsInfo.FluidState_isEmpty_method, (Class[])new Class[0]);
    public static MethodHandle FLUIDSTATE_CREATELEGACYBLOCK = ReflectionHelper.getMethodHandle((Class)BLOCKSTATEBASE_GETFLUIDSTATE.type().returnType(), (String)ReflectionMappingsInfo.FluidState_createLegacyBlock_method, (Class[])new Class[0]);
    public static MethodHandle FLUIDSTATE_ANIMATETICK = ReflectionHelper.getMethodHandle((Class)BLOCKSTATEBASE_GETFLUIDSTATE.type().returnType(), (String)ReflectionMappingsInfo.FluidState_animateTick_method, (Class[])new Class[]{World.class, BlockPosition.class, apo.class});
    public static MethodHandle HolderSet_Named_bind = ReflectionHelper.getMethodHandle(hh.c.class, (String)ReflectionMappingsInfo.HolderSetNamed_bind_method, (Class[])new Class[]{List.class});
    public static MethodHandle Holder_Reference_bindTags = ReflectionHelper.getMethodHandle(hd.c.class, (String)ReflectionMappingsInfo.HolderReference_bindTags_method, (Class[])new Class[]{Collection.class});

    public void makeBlockStateRaw(BlockState state) {
        try {
            craftBlockEntityState_snapshot.set(state, craftBlockEntityState_tileEntity.get(state));
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void applyPhysics(Location location) {
        BlockPosition pos = new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        ((CraftWorld)location.getWorld()).getHandle().a(pos, CraftMagicNumbers.getBlock((Material)location.getBlock().getType()));
    }

    public static <T extends TileEntity> T getTE(CraftBlockEntityState<T> cbs) {
        try {
            return (T)((TileEntity)craftBlockEntityState_tileEntity.get(cbs));
        }
        catch (IllegalAccessException e) {
            Debug.echoError((Throwable)e);
            return null;
        }
    }

    public PlayerProfile getPlayerProfile(Skull skull) {
        GameProfile profile = ((TileEntitySkull)BlockHelperImpl.getTE((CraftSkull)skull)).f;
        if (profile == null) {
            return null;
        }
        String name = profile.getName();
        UUID id = profile.getId();
        Property property = (Property)Iterables.getFirst((Iterable)profile.getProperties().get((Object)"textures"), null);
        return new PlayerProfile(name, id, property != null ? property.getValue() : null);
    }

    public void setPlayerProfile(Skull skull, PlayerProfile playerProfile) {
        GameProfile gameProfile = new GameProfile(playerProfile.getUniqueId(), playerProfile.getName());
        if (playerProfile.hasTexture()) {
            gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", playerProfile.getTexture(), playerProfile.getTextureSignature()));
        }
        try {
            craftSkull_profile.set(skull, gameProfile);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
        skull.update();
    }

    public CompoundTag getNbtData(Block block) {
        TileEntity te = ((CraftWorld)block.getWorld()).getHandle().getBlockEntity(new BlockPosition(block.getX(), block.getY(), block.getZ()), true);
        if (te != null) {
            NBTTagCompound compound = te.m();
            return CompoundTagImpl.fromNMSTag(compound);
        }
        return null;
    }

    public void setNbtData(Block block, CompoundTag ctag) {
        CompoundTagBuilder builder = ctag.createBuilder();
        builder.putInt("x", block.getX());
        builder.putInt("y", block.getY());
        builder.putInt("z", block.getZ());
        ctag = builder.build();
        BlockPosition blockPos = new BlockPosition(block.getX(), block.getY(), block.getZ());
        TileEntity te = ((CraftWorld)block.getWorld()).getHandle().getBlockEntity(blockPos, true);
        te.a(((CompoundTagImpl)ctag).toNMSTag());
    }

    public boolean setBlockResistance(Material material, float resistance) {
        cpi block = this.getMaterialBlock(material);
        if (block == null) {
            return false;
        }
        ReflectionHelper.setFieldValue(BlockBase.class, (String)ReflectionMappingsInfo.BlockBehaviour_explosionResistance, (Object)block, (Object)Float.valueOf(resistance));
        return true;
    }

    public float getBlockResistance(Material material) {
        cpi block = this.getMaterialBlock(material);
        if (block == null) {
            return 0.0f;
        }
        return ((Float)ReflectionHelper.getFieldValue(BlockBase.class, (String)ReflectionMappingsInfo.BlockBehaviour_explosionResistance, (Object)block)).floatValue();
    }

    public BlockState generateBlockState(Block block, Material mat) {
        try {
            CraftBlockState state = CRAFTBLOCKSTATE_CONSTRUCTOR.invoke(block);
            state.setData(CraftMagicNumbers.getBlock((Material)mat).o());
            return state;
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
            return null;
        }
    }

    public cpi getMaterialBlock(Material bukkitMaterial) {
        if (!bukkitMaterial.isBlock()) {
            return null;
        }
        return ((CraftBlockData)bukkitMaterial.createBlockData()).getState().b();
    }

    public dwn getInternalMaterial(Material bukkitMaterial) {
        try {
            return (dwn)BLOCK_MATERIAL.get(this.getMaterialBlock(bukkitMaterial));
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
            return null;
        }
    }

    public String getPushReaction(Material mat) {
        return this.getInternalMaterial(mat).g().name();
    }

    public void setPushReaction(Material mat, String reaction) {
        try {
            MATERIAL_PUSH_REACTION_SETTER.invoke(this.getInternalMaterial(mat), EnumPistonReaction.valueOf((String)reaction));
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public float getBlockStrength(Material mat) {
        return this.getMaterialBlock((Material)mat).o().k;
    }

    public void setBlockStrength(Material mat, float strength) {
        try {
            BLOCK_STRENGTH_SETTER.invoke(this.getMaterialBlock(mat).o(), strength);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void doRandomTick(Location location) {
        BlockPosition pos = new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        Chunk nmsChunk = ((CraftChunk)location.getChunk()).getHandle();
        IBlockData nmsBlock = nmsChunk.a_(pos);
        WorldServer nmsWorld = ((CraftWorld)location.getWorld()).getHandle();
        if (nmsBlock.s()) {
            nmsBlock.b(nmsWorld, pos, nmsWorld.z);
        }
        try {
            Object fluid = BLOCKSTATEBASE_GETFLUIDSTATE.invoke(nmsBlock);
            if (FLUIDSTATE_ISRANDOMLYTICKING.invoke(fluid)) {
                FLUIDSTATE_ANIMATETICK.invoke(fluid, nmsWorld, pos, nmsWorld.z);
            }
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public Instrument getInstrumentFor(Material mat) {
        cpi blockType = this.getMaterialBlock(mat);
        Optional aboveInstrument = BlockPropertyInstrument.a((IBlockData)blockType.o());
        BlockPropertyInstrument nmsInstrument = aboveInstrument.orElse(BlockPropertyInstrument.b((IBlockData)blockType.o()));
        return Instrument.values()[nmsInstrument.ordinal()];
    }

    public void ringBell(org.bukkit.block.Bell block) {
        Bell bellData = (Bell)block.getBlockData();
        EnumDirection face = EnumDirection.a((String)bellData.getFacing().name());
        EnumDirection dir = EnumDirection.c;
        switch (bellData.getAttachment()) {
            case DOUBLE_WALL: 
            case SINGLE_WALL: {
                switch (face) {
                    case c: 
                    case d: {
                        dir = EnumDirection.f;
                    }
                }
                break;
            }
            case FLOOR: {
                dir = face;
            }
        }
        CraftBlock craftBlock = (CraftBlock)block.getBlock();
        ((BlockBell)cpj.nZ).a((World)craftBlock.getCraftWorld().getHandle(), craftBlock.getPosition(), dir);
    }

    public int getExpDrop(Block block, ItemStack item) {
        cpi blockType = this.getMaterialBlock(block.getType());
        if (blockType == null) {
            return 0;
        }
        return blockType.getExpDrop(((CraftBlock)block).getNMS(), ((CraftBlock)block).getCraftWorld().getHandle(), ((CraftBlock)block).getPosition(), item == null ? null : CraftItemStack.asNMSCopy((ItemStack)item), true);
    }

    public void setSpawnerSpawnedType(CreatureSpawner spawner, EntityTag entity) {
        spawner.setSpawnedType(entity.getBukkitEntityType());
        if (entity.getWaitingMechanisms() == null || entity.getWaitingMechanisms().size() == 0) {
            return;
        }
        try {
            bfh nmsEntity = ((CraftWorld)spawner.getWorld()).createEntity(spawner.getLocation(), entity.getBukkitEntityType().getEntityClass());
            EntityTag entityTag = new EntityTag((Entity)nmsEntity.getBukkitEntity());
            entityTag.isFake = true;
            entityTag.isFakeValid = true;
            for (Mechanism mechanism : entity.getWaitingMechanisms()) {
                entityTag.safeAdjustDuplicate(mechanism);
            }
            nmsEntity.dD();
            CraftCreatureSpawner bukkitSpawner = (CraftCreatureSpawner)spawner;
            TileEntityMobSpawner nmsSnapshot = (TileEntityMobSpawner)craftBlockEntityState_snapshot.get(bukkitSpawner);
            MobSpawnerAbstract nmsSpawner = nmsSnapshot.d();
            MobSpawnerData toSpawn = nmsSpawner.f;
            NBTTagCompound tag = toSpawn.a();
            nmsEntity.f(tag);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void setSpawnerCustomRules(CreatureSpawner spawner, int skyMin, int skyMax, int blockMin, int blockMax) {
        try {
            CraftCreatureSpawner bukkitSpawner = (CraftCreatureSpawner)spawner;
            TileEntityMobSpawner nmsSnapshot = (TileEntityMobSpawner)craftBlockEntityState_snapshot.get(bukkitSpawner);
            MobSpawnerAbstract nmsSpawner = nmsSnapshot.d();
            MobSpawnerData toSpawn = nmsSpawner.f;
            MobSpawnerData.a rules = skyMin == -1 ? null : new MobSpawnerData.a(new apc((Comparable)Integer.valueOf(skyMin), (Comparable)Integer.valueOf(skyMax)), new apc((Comparable)Integer.valueOf(blockMin), (Comparable)Integer.valueOf(blockMax)));
            nmsSpawner.f = new MobSpawnerData(toSpawn.c(), Optional.ofNullable(rules));
            nmsSpawner.e = bci.b();
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public Color getMapColor(Block block) {
        CraftBlock craftBlock = (CraftBlock)block;
        return Color.fromRGB((int)craftBlock.getNMS().d((IBlockAccess)craftBlock.getHandle(), (BlockPosition)craftBlock.getPosition()).ak);
    }

    public void setVanillaTags(Material material, Set<String> tags) {
        hd.c nmsHolder = this.getMaterialBlock(material).r();
        nmsHolder.c().forEach(arg_0 -> BlockHelperImpl.lambda$setVanillaTags$0((hd)nmsHolder, arg_0));
        ArrayList<anv> newNmsTags = new ArrayList<anv>();
        for (String tag : tags) {
            anv newNmsTag = anv.a((adc)ja.f.c(), (MinecraftKey)new MinecraftKey(tag));
            hh.c nmsHolderSet = ja.f.a(newNmsTag);
            List nmsHolders = nmsHolderSet.a().collect(Collectors.toCollection(ArrayList::new));
            nmsHolders.add(nmsHolder);
            try {
                HolderSet_Named_bind.invoke(nmsHolderSet, nmsHolders);
            }
            catch (Throwable ex) {
                Debug.echoError((Throwable)ex);
            }
            newNmsTags.add(newNmsTag);
            VanillaTagHelper.addOrUpdateMaterialTag((Tag)new CraftBlockTag((IRegistry)ja.f, newNmsTag));
        }
        try {
            Holder_Reference_bindTags.invoke((hd)nmsHolder, newNmsTags);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
        PacketPlayOutTags tagsPacket = new PacketPlayOutTags(any.a((hk)((CraftServer)Bukkit.getServer()).getServer().aY()));
        for (Player player : Bukkit.getOnlinePlayers()) {
            PacketHelperImpl.send(player, tagsPacket);
        }
    }

    private static /* synthetic */ void lambda$setVanillaTags$0(hd nmsHolder, anv nmsTag) {
        hh.c nmsHolderSet = ja.f.b(nmsTag).orElse(null);
        if (nmsHolderSet == null) {
            return;
        }
        List nmsHolders = nmsHolderSet.a().collect(Collectors.toCollection(ArrayList::new));
        nmsHolders.remove(nmsHolder);
        try {
            HolderSet_Named_bind.invoke(nmsHolderSet, nmsHolders);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
        VanillaTagHelper.updateMaterialTag((Tag)new CraftBlockTag((IRegistry)ja.f, nmsTag));
    }
}

