/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_19.impl;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.abstracts.BiomeNMS;
import com.denizenscript.denizen.nms.v1_19.ReflectionMappingsInfo;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeSettingsMobs;
import net.minecraft.world.level.chunk.Chunk;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_19_R3.CraftWorld;
import org.bukkit.entity.EntityType;

public class BiomeNMSImpl
extends BiomeNMS {
    public static final MethodHandle BIOME_CLIMATESETTINGS_CONSTRUCTOR = ReflectionHelper.getConstructor(BiomeBase.class.getDeclaredClasses()[0], (Class[])new Class[]{Boolean.TYPE, Float.TYPE, BiomeBase.TemperatureModifier.class, Float.TYPE});
    public Holder<BiomeBase> biomeHolder;
    public WorldServer world;

    public BiomeNMSImpl(WorldServer world, String name) {
        super((World)world.getWorld(), name);
        this.world = world;
        this.biomeHolder = world.u_().d(Registries.an).b(ResourceKey.a((ResourceKey)Registries.an, (MinecraftKey)new MinecraftKey(name))).orElse(null);
    }

    public BiomeNMS.DownfallType getDownfallType() {
        throw new UnsupportedOperationException();
    }

    public float getHumidity() {
        return ((BiomeBase)this.biomeHolder.a()).i.d();
    }

    public float getTemperature() {
        return ((BiomeBase)this.biomeHolder.a()).g();
    }

    public List<EntityType> getAmbientEntities() {
        return this.getSpawnableEntities(EnumCreatureType.c);
    }

    public List<EntityType> getCreatureEntities() {
        return this.getSpawnableEntities(EnumCreatureType.b);
    }

    public List<EntityType> getMonsterEntities() {
        return this.getSpawnableEntities(EnumCreatureType.a);
    }

    public List<EntityType> getWaterEntities() {
        return this.getSpawnableEntities(EnumCreatureType.f);
    }

    public Object getClimate() {
        return ReflectionHelper.getFieldValue(BiomeBase.class, (String)ReflectionMappingsInfo.Biome_climateSettings, (Object)this.biomeHolder.a());
    }

    public void setClimate(boolean hasPrecipitation, float temperature, BiomeBase.TemperatureModifier temperatureModifier, float downfall) {
        try {
            Object newClimate = BIOME_CLIMATESETTINGS_CONSTRUCTOR.invoke(hasPrecipitation, temperature, temperatureModifier, downfall);
            ReflectionHelper.setFieldValue(BiomeBase.class, (String)ReflectionMappingsInfo.Biome_climateSettings, (Object)this.biomeHolder.a(), (Object)newClimate);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void setHumidity(float humidity) {
        this.setClimate(((BiomeBase)this.biomeHolder.a()).i.a(), this.getTemperature(), this.getTemperatureModifier(), humidity);
    }

    public void setTemperature(float temperature) {
        this.setClimate(((BiomeBase)this.biomeHolder.a()).c(), temperature, this.getTemperatureModifier(), this.getHumidity());
    }

    public void setPrecipitation(BiomeNMS.DownfallType type) {
        throw new UnsupportedOperationException();
    }

    private List<EntityType> getSpawnableEntities(EnumCreatureType creatureType) {
        BiomeSettingsMobs mobs = ((BiomeBase)this.biomeHolder.a()).b();
        WeightedRandomList typeSettingList = mobs.a(creatureType);
        ArrayList<EntityType> entityTypes = new ArrayList<EntityType>();
        if (typeSettingList == null) {
            return entityTypes;
        }
        for (BiomeSettingsMobs.c meta : typeSettingList.e()) {
            try {
                String n = EntityTypes.a((EntityTypes)meta.b).a();
                EntityType et = EntityType.fromName((String)n);
                if (et == null) {
                    et = EntityType.valueOf((String)n.toUpperCase(Locale.ENGLISH));
                }
                entityTypes.add(et);
            }
            catch (Throwable throwable) {}
        }
        return entityTypes;
    }

    public void setTo(Block block) {
        Chunk chunk;
        if (((CraftWorld)block.getWorld()).getHandle() != this.world) {
            NMSHandler.instance.getBiomeNMS(block.getWorld(), this.getName()).setTo(block);
            return;
        }
        BlockPosition pos = new BlockPosition(block.getX(), 0, block.getZ());
        if (this.world.D(pos) && (chunk = this.world.l(pos)) != null) {
            chunk.setBiome(block.getX() >> 2, block.getY() >> 2, block.getZ() >> 2, this.biomeHolder);
            chunk.a(true);
        }
    }

    public BiomeBase.TemperatureModifier getTemperatureModifier() {
        Object climate = this.getClimate();
        return (BiomeBase.TemperatureModifier)ReflectionHelper.getFieldValue(climate.getClass(), (String)ReflectionMappingsInfo.BiomeClimateSettings_temperatureModifier, (Object)climate);
    }
}

