/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_19.helpers;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.interfaces.EntityHelper;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.v1_19.ReflectionMappingsInfo;
import com.denizenscript.denizen.nms.v1_19.helpers.BlockHelperImpl;
import com.denizenscript.denizen.nms.v1_19.helpers.PacketHelperImpl;
import com.denizenscript.denizen.nms.v1_19.impl.jnbt.CompoundTagImpl;
import com.denizenscript.denizen.nms.v1_19.impl.network.handlers.DenizenNetworkManagerImpl;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.packets.NetworkInterceptHelper;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import io.netty.buffer.Unpooled;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_19_R3.CraftServer;
import org.bukkit.craftbukkit.v1_19_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_19_R3.block.CraftCreatureSpawner;
import org.bukkit.craftbukkit.v1_19_R3.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftEnderman;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftFallingBlock;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftItem;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftMob;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftZombie;
import org.bukkit.craftbukkit.v1_19_R3.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_19_R3.inventory.CraftItemStack;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Pose;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.Zombie;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;

public class EntityHelperImpl
extends EntityHelper {
    public static final MethodHandle ENTITY_ONGROUND_SETTER = ReflectionHelper.getFinalSetter(bfh.class, (String)ReflectionMappingsInfo.Entity_onGround, Boolean.TYPE);
    public static final acl<Boolean> ENTITY_ENDERMAN_DATAWATCHER_SCREAMING = (acl)ReflectionHelper.getFieldValue(bvq.class, (String)ReflectionMappingsInfo.EnderMan_DATA_CREEPY, null);
    public static final MethodHandle LIVINGENTITY_AUTOSPINATTACK_SETTER = ReflectionHelper.getFinalSetter(bfx.class, (String)ReflectionMappingsInfo.LivingEntity_autoSpinAttackTicks);
    public static final MethodHandle LIVINGENTITY_SETLIVINGENTITYFLAG = ReflectionHelper.getMethodHandle(bfx.class, (String)ReflectionMappingsInfo.LivingEntity_setLivingEntityFlag_method, (Class[])new Class[]{Integer.TYPE, Boolean.TYPE});
    private static final Map<UUID, BukkitTask> followTasks = new HashMap<UUID, BukkitTask>();
    public static ben backupDamageSources;
    public static final MethodHandle FALLINGBLOCK_TYPE_SETTER;
    public static final Field ZOMBIE_INWATERTIME;
    public static final MethodHandle TRACKING_RANGE_SETTER;
    public static final Field ENTITY_REMOVALREASON;
    public static final MethodHandle PLAYERLIST_REMOVE;

    public void setInvisible(Entity entity, boolean invisible) {
        ((CraftEntity)entity).getHandle().j(invisible);
    }

    public boolean isInvisible(Entity entity) {
        return ((CraftEntity)entity).getHandle().ca();
    }

    public void setPose(Entity entity, Pose pose) {
        ((CraftEntity)entity).getHandle().b(bgj.values()[pose.ordinal()]);
    }

    public double getDamageTo(LivingEntity attacker, Entity target) {
        bgc monsterType = target instanceof LivingEntity ? ((CraftLivingEntity)target).getHandle().eJ() : bgc.a;
        double damage = 0.0;
        AttributeInstance attrib = attacker.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE);
        if (attrib != null) {
            damage = attrib.getValue();
        }
        if (attacker.getEquipment() != null && attacker.getEquipment().getItemInMainHand() != null) {
            damage += (double)cke.a((cfv)CraftItemStack.asNMSCopy((ItemStack)attacker.getEquipment().getItemInMainHand()), (bgc)monsterType);
        }
        if (damage <= 0.0) {
            return 0.0;
        }
        if (target != null) {
            bem source;
            bfh nmsTarget = ((CraftEntity)target).getHandle();
            if (nmsTarget.b(source = attacker instanceof Player ? nmsTarget.H.af().a((bym)((CraftPlayer)attacker).getHandle()) : nmsTarget.H.af().b(((CraftLivingEntity)attacker).getHandle()))) {
                return 0.0;
            }
            if (!(nmsTarget instanceof bfx)) {
                return damage;
            }
            bfx livingTarget = (bfx)nmsTarget;
            damage = bei.a((float)((float)damage), (float)livingTarget.eB(), (float)((float)livingTarget.b(bhe.j)));
            int enchantDamageModifier = cke.a((Iterable)livingTarget.bI(), (bem)source);
            if (enchantDamageModifier > 0) {
                damage = bei.a((float)((float)damage), (float)enchantDamageModifier);
            }
        }
        return damage;
    }

    public void setRiptide(Entity entity, boolean state) {
        try {
            bfx nmsEntity = ((CraftLivingEntity)entity).getHandle();
            LIVINGENTITY_AUTOSPINATTACK_SETTER.invoke(nmsEntity, state ? 0 : 1);
            LIVINGENTITY_SETLIVINGENTITYFLAG.invoke(nmsEntity, 4, true);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void forceInteraction(Player player, Location location) {
        CraftPlayer craftPlayer = (CraftPlayer)player;
        gt pos = new gt(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        ((CraftBlock)location.getBlock()).getNMS().a((cmi)((CraftWorld)location.getWorld()).getHandle(), (bym)(craftPlayer != null ? craftPlayer.getHandle() : null), bdx.a, new eda(new ede(0.0, 0.0, 0.0), null, pos, false));
    }

    public Entity getEntity(World world, UUID uuid) {
        bfh entity = ((CraftWorld)world).getHandle().a(uuid);
        return entity == null ? null : entity.getBukkitEntity();
    }

    public CompoundTag getNbtData(Entity entity) {
        re compound = new re();
        ((CraftEntity)entity).getHandle().d(compound);
        return CompoundTagImpl.fromNMSTag(compound);
    }

    public void setNbtData(Entity entity, CompoundTag compoundTag) {
        ((CraftEntity)entity).getHandle().g(((CompoundTagImpl)compoundTag).toNMSTag());
    }

    public void stopFollowing(Entity follower) {
        if (follower == null) {
            return;
        }
        UUID uuid = follower.getUniqueId();
        if (followTasks.containsKey(uuid)) {
            followTasks.get(uuid).cancel();
        }
    }

    public void stopWalking(Entity entity) {
        bfh nmsEntity = ((CraftEntity)entity).getHandle();
        if (!(nmsEntity instanceof bfz)) {
            return;
        }
        ((bfz)nmsEntity).G().n();
    }

    public void follow(final Entity target, final Entity follower, final double speed, final double lead, final double maxRange, final boolean allowWander, final boolean teleport) {
        if (target == null || follower == null) {
            return;
        }
        bfh nmsEntityFollower = ((CraftEntity)follower).getHandle();
        if (!(nmsEntityFollower instanceof bfz)) {
            return;
        }
        final bfz nmsFollower = (bfz)nmsEntityFollower;
        final bph followerNavigation = nmsFollower.G();
        UUID uuid = follower.getUniqueId();
        if (followTasks.containsKey(uuid)) {
            followTasks.get(uuid).cancel();
        }
        final int locationNearInt = (int)Math.floor(lead);
        final boolean hasMax = maxRange > lead;
        followTasks.put(follower.getUniqueId(), new BukkitRunnable(){
            private boolean inRadius = false;

            public void run() {
                if (!target.isValid() || !follower.isValid()) {
                    this.cancel();
                }
                followerNavigation.a(2.0);
                Location targetLocation = target.getLocation();
                if (hasMax && !Utilities.checkLocation((Location)targetLocation, (Location)follower.getLocation(), (double)maxRange) && !target.isDead() && target.isOnGround()) {
                    if (!this.inRadius) {
                        if (teleport) {
                            follower.teleport(Utilities.getWalkableLocationNear((Location)targetLocation, (int)locationNearInt));
                        } else {
                            this.cancel();
                        }
                    } else {
                        this.inRadius = false;
                        dwz path = followerNavigation.a(targetLocation.getX(), targetLocation.getY(), targetLocation.getZ(), 0);
                        if (path != null) {
                            followerNavigation.a(path, 1.0);
                            followerNavigation.a(2.0);
                        }
                    }
                } else if (!this.inRadius && !Utilities.checkLocation((Location)targetLocation, (Location)follower.getLocation(), (double)lead)) {
                    dwz path = followerNavigation.a(targetLocation.getX(), targetLocation.getY(), targetLocation.getZ(), 0);
                    if (path != null) {
                        followerNavigation.a(path, 1.0);
                        followerNavigation.a(2.0);
                    }
                } else {
                    this.inRadius = true;
                }
                if (this.inRadius && !allowWander) {
                    followerNavigation.n();
                }
                nmsFollower.a(bhe.d).a(speed);
            }
        }.runTaskTimer((Plugin)NMSHandler.getJavaPlugin(), 0L, 10L));
    }

    public void walkTo(final LivingEntity entity, Location location, final Double speed, final Runnable callback) {
        dwz path;
        boolean aiDisabled;
        if (entity == null || location == null) {
            return;
        }
        bfh nmsEntity = ((CraftEntity)entity).getHandle();
        if (!(nmsEntity instanceof bfz)) {
            return;
        }
        final bfz nmsMob = (bfz)nmsEntity;
        final bph entityNavigation = nmsMob.G();
        boolean bl = aiDisabled = !entity.hasAI();
        if (aiDisabled) {
            entity.setAI(true);
            try {
                ENTITY_ONGROUND_SETTER.invoke(nmsMob, true);
            }
            catch (Throwable ex) {
                Debug.echoError((Throwable)ex);
            }
        }
        if ((path = entityNavigation.a(location.getX(), location.getY(), location.getZ(), 1)) != null) {
            nmsMob.bN.b(bmt.a.a);
            entityNavigation.a(path, 1.0);
            final double oldSpeed = nmsMob.a(bhe.d).b();
            if (speed != null) {
                nmsMob.a(bhe.d).a(speed.doubleValue());
            }
            new BukkitRunnable(){

                public void run() {
                    if (!entity.isValid()) {
                        if (callback != null) {
                            callback.run();
                        }
                        this.cancel();
                        return;
                    }
                    if (aiDisabled && entity instanceof Wolf) {
                        Wolf wolf = (Wolf)entity;
                        wolf.setAngry(false);
                    }
                    if (entityNavigation.l() || path.c()) {
                        if (callback != null) {
                            callback.run();
                        }
                        if (speed != null) {
                            nmsMob.a(bhe.d).a(oldSpeed);
                        }
                        if (aiDisabled) {
                            entity.setAI(false);
                        }
                        this.cancel();
                    }
                }
            }.runTaskTimer((Plugin)NMSHandler.getJavaPlugin(), 1L, 1L);
        } else {
            entity.teleport(location);
        }
    }

    public List<Player> getPlayersThatSee(Entity entity) {
        aic tracker = ((aip)((CraftEntity)entity).getHandle().H).k().a;
        aic.b entityTracker = (aic.b)tracker.L.get(entity.getEntityId());
        ArrayList<Player> output = new ArrayList<Player>();
        if (entityTracker == null) {
            return output;
        }
        for (ajl player : entityTracker.f) {
            output.add((Player)player.f().getBukkitEntity());
        }
        return output;
    }

    public void sendAllUpdatePackets(Entity entity) {
        aic tracker = ((aip)((CraftEntity)entity).getHandle().H).k().a;
        aic.b entityTracker = (aic.b)tracker.L.get(entity.getEntityId());
        if (entityTracker == null) {
            return;
        }
        try {
            aio serverEntity = (aio)PacketHelperImpl.ENTITY_TRACKER_ENTRY_GETTER.get(entityTracker);
            serverEntity.a();
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void sendHidePacket(Player pl, Entity entity) {
        if (entity instanceof Player) {
            pl.hidePlayer((Plugin)Denizen.getInstance(), (Player)entity);
            return;
        }
        CraftPlayer craftPlayer = (CraftPlayer)pl;
        aiq entityPlayer = craftPlayer.getHandle();
        if (entityPlayer.b != null && !craftPlayer.equals((Object)entity)) {
            aic tracker = ((aip)craftPlayer.getHandle().H).k().a;
            bfh other = ((CraftEntity)entity).getHandle();
            aic.b entry = (aic.b)tracker.L.get(other.af());
            if (entry != null) {
                entry.a(entityPlayer);
            }
            if (Denizen.supportsPaper) {
                entityPlayer.b.a((vb)new xp(new int[]{other.af()}));
            }
        }
    }

    public void sendShowPacket(Player pl, Entity entity) {
        if (entity instanceof Player) {
            pl.showPlayer((Plugin)Denizen.getInstance(), (Player)entity);
            return;
        }
        CraftPlayer craftPlayer = (CraftPlayer)pl;
        aiq entityPlayer = craftPlayer.getHandle();
        if (entityPlayer.b != null && !craftPlayer.equals((Object)entity)) {
            aic tracker = ((aip)craftPlayer.getHandle().H).k().a;
            bfh other = ((CraftEntity)entity).getHandle();
            aic.b entry = (aic.b)tracker.L.get(other.af());
            if (entry != null) {
                entry.a(entityPlayer);
                entry.b(entityPlayer);
            }
        }
    }

    public void rotate(Entity entity, float yaw, float pitch) {
        if (entity instanceof Player && ((Player)entity).isOnline()) {
            NetworkInterceptHelper.enable();
            float relYaw = (yaw - entity.getLocation().getYaw()) % 360.0f;
            if (relYaw > 180.0f) {
                relYaw -= 360.0f;
            }
            float actualRelYaw = relYaw;
            float relPitch = pitch - entity.getLocation().getPitch();
            NMSHandler.packetHelper.sendRelativeLookPacket((Player)entity, actualRelYaw, relPitch);
        } else if (entity instanceof LivingEntity) {
            if (entity instanceof EnderDragon) {
                yaw = EntityHelperImpl.normalizeYaw((float)(yaw - 180.0f));
            }
            this.look(entity, yaw, pitch);
        } else {
            bfh handle = ((CraftEntity)entity).getHandle();
            handle.f(yaw - 360.0f);
            handle.e(pitch);
        }
    }

    public float getBaseYaw(LivingEntity entity) {
        return ((CraftLivingEntity)entity).getHandle().aT;
    }

    public void look(Entity entity, float yaw, float pitch) {
        bfh handle = ((CraftEntity)entity).getHandle();
        if (handle != null) {
            handle.f(yaw);
            if (handle instanceof bfx) {
                bfx livingHandle = (bfx)handle;
                while (yaw < -180.0f) {
                    yaw += 360.0f;
                }
                while (yaw >= 180.0f) {
                    yaw -= 360.0f;
                }
                livingHandle.aU = yaw;
                if (!(handle instanceof bym)) {
                    livingHandle.s(yaw);
                }
                livingHandle.r(yaw);
            }
            handle.e(pitch);
        } else {
            Debug.echoError((String)("Cannot set look direction for unspawned entity " + entity.getUniqueId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static edc rayTrace(World world, Vector start, Vector end) {
        try {
            NMSHandler.chunkHelper.changeChunkServerThread(world);
            eda eda2 = ((CraftWorld)world).getHandle().a(new clr(new ede(start.getX(), start.getY(), start.getZ()), new ede(end.getX(), end.getY(), end.getZ()), clr.a.b, clr.b.a, null));
            return eda2;
        }
        finally {
            NMSHandler.chunkHelper.restoreServerThread(world);
        }
    }

    public boolean canTrace(World world, Vector start, Vector end) {
        edc pos = EntityHelperImpl.rayTrace(world, start, end);
        if (pos == null) {
            return true;
        }
        return pos.c() == edc.a.a;
    }

    public void snapPositionTo(Entity entity, Vector vector) {
        ((CraftEntity)entity).getHandle().p(vector.getX(), vector.getY(), vector.getZ());
    }

    public void move(Entity entity, Vector vector) {
        ((CraftEntity)entity).getHandle().a(bgd.a, new ede(vector.getX(), vector.getY(), vector.getZ()));
    }

    public boolean internalLook(Player player, Location at) {
        xm packet = new xm(ea.a.b, at.getX(), at.getY(), at.getZ());
        PacketHelperImpl.send(player, packet);
        return true;
    }

    public static long entityToPacket(double x) {
        return apj.b((double)(x * 4096.0));
    }

    public void fakeMove(Entity entity, Vector vector) {
        long x = EntityHelperImpl.entityToPacket(vector.getX());
        long y = EntityHelperImpl.entityToPacket(vector.getY());
        long z = EntityHelperImpl.entityToPacket(vector.getZ());
        wy.a packet = new wy.a(entity.getEntityId(), (short)x, (short)y, (short)z, entity.isOnGround());
        for (Player player : this.getPlayersThatSee(entity)) {
            PacketHelperImpl.send(player, packet);
        }
    }

    public void fakeTeleport(Entity entity, Location location) {
        ss packetData = new ss(Unpooled.buffer());
        packetData.d(entity.getEntityId());
        packetData.writeDouble(location.getX());
        packetData.writeDouble(location.getY());
        packetData.writeDouble(location.getZ());
        packetData.writeByte((int)((byte)(location.getYaw() * 256.0f / 360.0f)));
        packetData.writeByte((int)((byte)(location.getPitch() * 256.0f / 360.0f)));
        packetData.writeBoolean(entity.isOnGround());
        zf packet = new zf(packetData);
        for (Player player : this.getPlayersThatSee(entity)) {
            PacketHelperImpl.send(player, packet);
        }
    }

    public void clientResetLoc(Entity entity) {
        zf packet = new zf(((CraftEntity)entity).getHandle());
        for (Player player : this.getPlayersThatSee(entity)) {
            PacketHelperImpl.send(player, packet);
        }
    }

    public void teleport(Entity entity, Location loc) {
        bfh nmsEntity = ((CraftEntity)entity).getHandle();
        nmsEntity.f(loc.getYaw());
        nmsEntity.e(loc.getPitch());
        if (nmsEntity instanceof aiq) {
            nmsEntity.b(loc.getX(), loc.getY(), loc.getZ());
        }
        nmsEntity.e(loc.getX(), loc.getY(), loc.getZ());
    }

    public void setBoundingBox(Entity entity, BoundingBox box) {
        ((CraftEntity)entity).getHandle().a(new ecz(box.getMinX(), box.getMinY(), box.getMinZ(), box.getMaxX(), box.getMaxY(), box.getMaxZ()));
    }

    public void setTicksLived(Entity entity, int ticks) {
        ((CraftEntity)entity).getHandle().ag = ticks;
        if (entity instanceof CraftFallingBlock) {
            ((CraftFallingBlock)entity).getHandle().b = ticks;
        } else if (entity instanceof CraftItem) {
            ((bvf)((CraftItem)entity).getHandle()).g = ticks;
        }
    }

    public void setHeadAngle(LivingEntity entity, float angle) {
        bfx handle = ((CraftLivingEntity)entity).getHandle();
        handle.aV = angle;
        handle.r(angle);
    }

    public void setEndermanAngry(Enderman enderman, boolean angry) {
        ((CraftEnderman)enderman).getHandle().aj().b(ENTITY_ENDERMAN_DATAWATCHER_SCREAMING, (Object)angry);
    }

    public static ben getReusableDamageSources() {
        if (backupDamageSources == null) {
            backupDamageSources = ((CraftWorld)Bukkit.getWorlds().get(0)).getHandle().af();
        }
        return backupDamageSources;
    }

    public static bem getSourceFor(bfh nmsSource, EntityDamageEvent.DamageCause cause, bfh nmsSourceProvider) {
        ben sources = nmsSourceProvider == null ? EntityHelperImpl.getReusableDamageSources() : nmsSourceProvider.H.af();
        bem src = sources.n();
        if (nmsSource != null) {
            if (nmsSource instanceof bym) {
                src = nmsSource.H.af().a((bym)nmsSource);
            } else if (nmsSource instanceof bfx) {
                src = nmsSource.H.af().b((bfx)nmsSource);
            }
        }
        if (cause == null) {
            return src;
        }
        switch (cause) {
            case CONTACT: {
                return sources.j();
            }
            case ENTITY_ATTACK: {
                return sources.b(nmsSource instanceof bfx ? (bfx)nmsSource : null);
            }
            case ENTITY_SWEEP_ATTACK: {
                if (src != sources.n()) {
                    src.sweep();
                }
                return src;
            }
            case PROJECTILE: {
                return sources.b(nmsSource, nmsSource != null && nmsSource.getBukkitEntity() instanceof Projectile && ((Projectile)nmsSource.getBukkitEntity()).getShooter() instanceof Entity ? ((CraftEntity)((Projectile)nmsSource.getBukkitEntity()).getShooter()).getHandle() : null);
            }
            case SUFFOCATION: {
                return sources.f();
            }
            case FALL: {
                return sources.k();
            }
            case FIRE: {
                return sources.a();
            }
            case FIRE_TICK: {
                return sources.c();
            }
            case MELTING: {
                return sources.melting;
            }
            case LAVA: {
                return sources.d();
            }
            case DROWNING: {
                return sources.h();
            }
            case BLOCK_EXPLOSION: {
                return sources.d(nmsSource instanceof TNTPrimed && ((TNTPrimed)nmsSource).getSource() instanceof bfx ? (bfx)((TNTPrimed)nmsSource).getSource() : null, null);
            }
            case ENTITY_EXPLOSION: {
                return sources.d(nmsSource, null);
            }
            case VOID: {
                return sources.m();
            }
            case LIGHTNING: {
                return sources.b();
            }
            case STARVATION: {
                return sources.i();
            }
            case POISON: {
                return sources.poison;
            }
            case MAGIC: {
                return sources.o();
            }
            case WITHER: {
                return sources.p();
            }
            case FALLING_BLOCK: {
                return sources.a(nmsSource);
            }
            case THORNS: {
                return sources.d(nmsSource);
            }
            case DRAGON_BREATH: {
                return sources.q();
            }
            case CUSTOM: {
                return sources.n();
            }
            case FLY_INTO_WALL: {
                return sources.l();
            }
            case HOT_FLOOR: {
                return sources.e();
            }
            case CRAMMING: {
                return sources.g();
            }
            case DRYOUT: {
                return sources.r();
            }
        }
        return new FakeDamageSrc(src);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void damage(LivingEntity target, float amount, EntityTag source, Location sourceLoc, EntityDamageEvent.DamageCause cause) {
        bfh nmsSource;
        if (target == null) {
            return;
        }
        bfx nmsTarget = ((CraftLivingEntity)target).getHandle();
        CraftEventFactory.entityDamage = nmsSource = source == null ? null : ((CraftEntity)source.getBukkitEntity()).getHandle();
        CraftEventFactory.blockDamage = sourceLoc == null ? null : sourceLoc.getBlock();
        try {
            bem src = EntityHelperImpl.getSourceFor(nmsSource, cause, (bfh)nmsTarget);
            if (src instanceof FakeDamageSrc) {
                src = ((FakeDamageSrc)src).real;
                EntityDamageEvent ede2 = EntityHelperImpl.fireFakeDamageEvent((Entity)target, (EntityTag)source, (Location)sourceLoc, (EntityDamageEvent.DamageCause)cause, (float)amount);
                if (ede2.isCancelled()) {
                    return;
                }
            }
            nmsTarget.a(src, amount);
        }
        finally {
            CraftEventFactory.entityDamage = null;
            CraftEventFactory.blockDamage = null;
        }
    }

    public void setLastHurtBy(LivingEntity mob, LivingEntity damager) {
        ((CraftLivingEntity)mob).getHandle().a(((CraftLivingEntity)damager).getHandle());
    }

    public void setFallingBlockType(FallingBlock fallingBlock, BlockData block) {
        dbq state = ((CraftBlockData)block).getState();
        bve nmsEntity = ((CraftFallingBlock)fallingBlock).getHandle();
        try {
            FALLINGBLOCK_TYPE_SETTER.invoke(nmsEntity, state);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public EntityTag getMobSpawnerDisplayEntity(CreatureSpawner spawner) {
        dan nmsSpawner = (dan)BlockHelperImpl.getTE((CraftCreatureSpawner)spawner);
        aip level = ((CraftWorld)spawner.getWorld()).getHandle();
        bfh nmsEntity = nmsSpawner.d().a((cmi)level, level.z, nmsSpawner.p());
        return new EntityTag((Entity)nmsEntity.getBukkitEntity());
    }

    public int getInWaterTime(Zombie zombie) {
        try {
            return ZOMBIE_INWATERTIME.getInt(((CraftZombie)zombie).getHandle());
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
            return 0;
        }
    }

    public void setInWaterTime(Zombie zombie, int ticks) {
        try {
            ZOMBIE_INWATERTIME.setInt(((CraftZombie)zombie).getHandle(), ticks);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void setTrackingRange(Entity entity, int range) {
        try {
            aic map = ((CraftWorld)entity.getWorld()).getHandle().k().a;
            aic.b entry = (aic.b)map.L.get(entity.getEntityId());
            if (entry != null) {
                TRACKING_RANGE_SETTER.invoke(entry, range);
            }
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public boolean isAggressive(Mob mob) {
        return ((CraftMob)mob).getHandle().fM();
    }

    public void setAggressive(Mob mob, boolean aggressive) {
        ((CraftMob)mob).getHandle().v(aggressive);
    }

    public void setUUID(Entity entity, UUID id) {
        try {
            bfh nmsEntity = ((CraftEntity)entity).getHandle();
            nmsEntity.bz();
            nmsEntity.cM().forEach(bfh::bz);
            cmi level = nmsEntity.H;
            ahp playerList = ((CraftServer)Bukkit.getServer()).getHandle();
            if (nmsEntity instanceof aiq) {
                PLAYERLIST_REMOVE.invoke(playerList, nmsEntity);
            } else {
                nmsEntity.a(bfh.c.b);
            }
            ENTITY_REMOVALREASON.set(nmsEntity, null);
            nmsEntity.a_(id);
            if (nmsEntity instanceof aiq) {
                playerList.a(DenizenNetworkManagerImpl.getConnection((aiq)nmsEntity), (aiq)nmsEntity);
            } else {
                level.b(nmsEntity);
            }
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public float getStepHeight(Entity entity) {
        return ((CraftEntity)entity).getHandle().dA();
    }

    public void setStepHeight(Entity entity, float stepHeight) {
        ((CraftEntity)entity).getHandle().v(stepHeight);
    }

    static {
        FALLINGBLOCK_TYPE_SETTER = ReflectionHelper.getFinalSetterForFirstOfType(bve.class, dbq.class);
        ZOMBIE_INWATERTIME = ReflectionHelper.getFields(bwt.class).get(ReflectionMappingsInfo.Zombie_inWaterTime, Integer.TYPE);
        TRACKING_RANGE_SETTER = ReflectionHelper.getFinalSetterForFirstOfType(aic.b.class, Integer.TYPE);
        ENTITY_REMOVALREASON = ReflectionHelper.getFields(bfh.class).getFirstOfType(bfh.c.class);
        PLAYERLIST_REMOVE = ReflectionHelper.getMethodHandle(alu.class, (String)"remove", (Class[])new Class[]{aiq.class});
    }

    public static class FakeDamageSrc
    extends bem {
        public bem real;

        public FakeDamageSrc(bem src) {
            super(null);
            this.real = src;
        }
    }
}

