/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_19.impl;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.abstracts.BiomeNMS;
import com.denizenscript.denizen.nms.v1_19.ReflectionMappingsInfo;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_19_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R3.util.CraftLocation;
import org.bukkit.craftbukkit.v1_19_R3.util.CraftNamespacedKey;
import org.bukkit.entity.EntityType;

public class BiomeNMSImpl
extends BiomeNMS {
    public static final MethodHandle BIOME_CLIMATESETTINGS_CONSTRUCTOR = ReflectionHelper.getConstructor(cnf.b.class, (Class[])new Class[]{Boolean.TYPE, Float.TYPE, cnf.d.class, Float.TYPE});
    public hd<cnf> biomeHolder;
    public aip world;

    public BiomeNMSImpl(aip world, NamespacedKey key) {
        super((World)world.getWorld(), key);
        this.world = world;
        this.biomeHolder = world.u_().d(jb.an).b(adc.a((adc)jb.an, (add)CraftNamespacedKey.toMinecraft((NamespacedKey)key))).orElse(null);
    }

    public BiomeNMS.DownfallType getDownfallTypeAt(Location location) {
        cnf.c precipitation = ((cnf)this.biomeHolder.a()).a(CraftLocation.toBlockPosition((Location)location));
        return switch (precipitation) {
            default -> throw new IncompatibleClassChangeError();
            case cnf.c.b -> BiomeNMS.DownfallType.RAIN;
            case cnf.c.c -> BiomeNMS.DownfallType.SNOW;
            case cnf.c.a -> BiomeNMS.DownfallType.NONE;
        };
    }

    public float getHumidity() {
        return ((cnf)this.biomeHolder.a()).i.d();
    }

    public float getBaseTemperature() {
        return ((cnf)this.biomeHolder.a()).g();
    }

    public float getTemperatureAt(Location location) {
        return ((cnf)this.biomeHolder.a()).f(CraftLocation.toBlockPosition((Location)location));
    }

    public boolean hasDownfall() {
        return ((cnf)this.biomeHolder.a()).c();
    }

    public List<EntityType> getAmbientEntities() {
        return this.getSpawnableEntities(bga.c);
    }

    public List<EntityType> getCreatureEntities() {
        return this.getSpawnableEntities(bga.b);
    }

    public List<EntityType> getMonsterEntities() {
        return this.getSpawnableEntities(bga.a);
    }

    public List<EntityType> getWaterEntities() {
        return this.getSpawnableEntities(bga.f);
    }

    public int getFoliageColor() {
        if (((cnf)this.biomeHolder.a()).f() != 0) {
            return ((cnf)this.biomeHolder.a()).f();
        }
        float temperature = this.clampColor(this.getBaseTemperature());
        float humidity = this.clampColor(this.getHumidity());
        int temperatureValue = (int)((1.0f - temperature) * 255.0f);
        int humidityValue = (int)((1.0f - (humidity *= temperature)) * 255.0f);
        int index = temperatureValue << 8 | humidityValue;
        return index >= 65536 ? 4764952 : this.getColor(index / 256, index % 256).asRGB();
    }

    public void setClimate(boolean hasPrecipitation, float temperature, cnf.d temperatureModifier, float downfall) {
        try {
            Object newClimate = BIOME_CLIMATESETTINGS_CONSTRUCTOR.invoke(hasPrecipitation, temperature, temperatureModifier, downfall);
            ReflectionHelper.setFieldValue(cnf.class, (String)ReflectionMappingsInfo.Biome_climateSettings, (Object)this.biomeHolder.a(), (Object)newClimate);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void setHumidity(float humidity) {
        this.setClimate(this.hasDownfall(), this.getBaseTemperature(), this.getTemperatureModifier(), humidity);
    }

    public void setBaseTemperature(float baseTemperature) {
        this.setClimate(this.hasDownfall(), baseTemperature, this.getTemperatureModifier(), this.getHumidity());
    }

    public void setHasDownfall(boolean hasDownfall) {
        this.setClimate(hasDownfall, this.getBaseTemperature(), this.getTemperatureModifier(), this.getHumidity());
    }

    public void setFoliageColor(int color) {
        ReflectionHelper.setFieldValue(cnl.class, (String)ReflectionMappingsInfo.BiomeSpecialEffects_foliageColorOverride, (Object)((cnf)this.biomeHolder.a()).h(), Optional.of(color));
    }

    public int getFogColor() {
        return ((cnf)this.biomeHolder.a()).e();
    }

    public void setFogColor(int color) {
        ReflectionHelper.setFieldValue(cnl.class, (String)ReflectionMappingsInfo.BiomeSpecialEffects_fogColor, (Object)((cnf)this.biomeHolder.a()).h(), (Object)color);
    }

    public int getWaterFogColor() {
        return ((cnf)this.biomeHolder.a()).j();
    }

    public void setWaterFogColor(int color) {
        ReflectionHelper.setFieldValue(cnl.class, (String)ReflectionMappingsInfo.BiomeSpecialEffects_waterFogColor, (Object)((cnf)this.biomeHolder.a()).h(), (Object)color);
    }

    private List<EntityType> getSpawnableEntities(bga creatureType) {
        cnr mobs = ((cnf)this.biomeHolder.a()).b();
        bcm typeSettingList = mobs.a(creatureType);
        ArrayList<EntityType> entityTypes = new ArrayList<EntityType>();
        if (typeSettingList == null) {
            return entityTypes;
        }
        for (cnr.c meta : typeSettingList.e()) {
            try {
                String n = bfl.a((bfl)meta.b).a();
                EntityType et = EntityType.fromName((String)n);
                if (et == null) {
                    et = EntityType.valueOf((String)n.toUpperCase(Locale.ENGLISH));
                }
                entityTypes.add(et);
            }
            catch (Throwable throwable) {}
        }
        return entityTypes;
    }

    public void setTo(Block block) {
        ddy chunk;
        if (((CraftWorld)block.getWorld()).getHandle() != this.world) {
            NMSHandler.instance.getBiomeNMS(block.getWorld(), this.getKey()).setTo(block);
            return;
        }
        gt pos = new gt(block.getX(), 0, block.getZ());
        if (this.world.D(pos) && (chunk = this.world.l(pos)) != null) {
            chunk.setBiome(block.getX() >> 2, block.getY() >> 2, block.getZ() >> 2, this.biomeHolder);
            chunk.a(true);
        }
    }

    public cnf.d getTemperatureModifier() {
        return ((cnf)this.biomeHolder.a()).i.c();
    }
}

