/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_20.helpers;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.interfaces.EntityHelper;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.v1_20.ReflectionMappingsInfo;
import com.denizenscript.denizen.nms.v1_20.helpers.BlockHelperImpl;
import com.denizenscript.denizen.nms.v1_20.helpers.PacketHelperImpl;
import com.denizenscript.denizen.nms.v1_20.impl.jnbt.CompoundTagImpl;
import com.denizenscript.denizen.nms.v1_20.impl.network.handlers.DenizenNetworkManagerImpl;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.packets.NetworkInterceptHelper;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import io.netty.buffer.Unpooled;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_20_R1.CraftServer;
import org.bukkit.craftbukkit.v1_20_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_20_R1.block.CraftCreatureSpawner;
import org.bukkit.craftbukkit.v1_20_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftEnderman;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftFallingBlock;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftItem;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftMob;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftZombie;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftLocation;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Pose;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.Zombie;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;

public class EntityHelperImpl
extends EntityHelper {
    public static final MethodHandle ENTITY_ONGROUND_SETTER = ReflectionHelper.getFinalSetter(bfj.class, (String)ReflectionMappingsInfo.Entity_onGround, Boolean.TYPE);
    public static final aby<Boolean> ENDERMAN_DATA_ACCESSOR_SCREAMING = (aby)ReflectionHelper.getFieldValue(bvs.class, (String)ReflectionMappingsInfo.EnderMan_DATA_CREEPY, null);
    public static final MethodHandle LIVINGENTITY_AUTOSPINATTACK_SETTER = ReflectionHelper.getFinalSetter(bfz.class, (String)ReflectionMappingsInfo.LivingEntity_autoSpinAttackTicks);
    public static final MethodHandle LIVINGENTITY_SETLIVINGENTITYFLAG = ReflectionHelper.getMethodHandle(bfz.class, (String)ReflectionMappingsInfo.LivingEntity_setLivingEntityFlag_method, (Class[])new Class[]{Integer.TYPE, Boolean.TYPE});
    private static final Map<UUID, BukkitTask> followTasks = new HashMap<UUID, BukkitTask>();
    public static beo backupDamageSources;
    public static final Field FALLINGBLOCK_BLOCK_STATE;
    public static final Field ZOMBIE_INWATERTIME;
    public static final MethodHandle TRACKING_RANGE_SETTER;
    public static final MethodHandle PLAYERLIST_REMOVE;

    public void setInvisible(Entity entity, boolean invisible) {
        ((CraftEntity)entity).getHandle().j(invisible);
    }

    public boolean isInvisible(Entity entity) {
        return ((CraftEntity)entity).getHandle().cb();
    }

    public void setPose(Entity entity, Pose pose) {
        ((CraftEntity)entity).getHandle().b(bgl.values()[pose.ordinal()]);
    }

    public double getDamageTo(LivingEntity attacker, Entity target) {
        bge monsterType = target instanceof LivingEntity ? ((CraftLivingEntity)target).getHandle().eN() : bge.a;
        double damage = 0.0;
        AttributeInstance attrib = attacker.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE);
        if (attrib != null) {
            damage = attrib.getValue();
        }
        if (attacker.getEquipment() != null && attacker.getEquipment().getItemInMainHand() != null) {
            damage += (double)cki.a((cfz)CraftItemStack.asNMSCopy((ItemStack)attacker.getEquipment().getItemInMainHand()), (bge)monsterType);
        }
        if (damage <= 0.0) {
            return 0.0;
        }
        if (target != null) {
            ben source;
            bfj nmsTarget = ((CraftEntity)target).getHandle();
            if (attacker instanceof CraftPlayer) {
                CraftPlayer playerAttacker = (CraftPlayer)attacker;
                source = nmsTarget.dI().ag().a((byo)playerAttacker.getHandle());
            } else {
                source = nmsTarget.dI().ag().b(((CraftLivingEntity)attacker).getHandle());
            }
            if (nmsTarget.b(source)) {
                return 0.0;
            }
            if (!(nmsTarget instanceof bfz)) {
                return damage;
            }
            bfz livingTarget = (bfz)nmsTarget;
            damage = bej.a((float)((float)damage), (float)livingTarget.eF(), (float)((float)livingTarget.b(bhg.j)));
            int enchantDamageModifier = cki.a((Iterable)livingTarget.bJ(), (ben)source);
            if (enchantDamageModifier > 0) {
                damage = bej.a((float)((float)damage), (float)enchantDamageModifier);
            }
        }
        return damage;
    }

    public void setRiptide(Entity entity, boolean state) {
        try {
            bfz nmsEntity = ((CraftLivingEntity)entity).getHandle();
            LIVINGENTITY_AUTOSPINATTACK_SETTER.invoke(nmsEntity, state ? 0 : 1);
            LIVINGENTITY_SETLIVINGENTITYFLAG.invoke(nmsEntity, 4, true);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void forceInteraction(Player player, Location location) {
        CraftPlayer craftPlayer = (CraftPlayer)player;
        ((CraftBlock)location.getBlock()).getNMS().a((cmm)((CraftWorld)location.getWorld()).getHandle(), (byo)(craftPlayer != null ? craftPlayer.getHandle() : null), bdw.a, new eee(new eei(0.0, 0.0, 0.0), null, CraftLocation.toBlockPosition((Location)location), false));
    }

    public Entity getEntity(World world, UUID uuid) {
        bfj entity = ((CraftWorld)world).getHandle().a(uuid);
        return entity == null ? null : entity.getBukkitEntity();
    }

    public CompoundTag getNbtData(Entity entity) {
        qr compound = new qr();
        ((CraftEntity)entity).getHandle().d(compound);
        return CompoundTagImpl.fromNMSTag(compound);
    }

    public void setNbtData(Entity entity, CompoundTag compoundTag) {
        ((CraftEntity)entity).getHandle().g(((CompoundTagImpl)compoundTag).toNMSTag());
    }

    public void stopFollowing(Entity follower) {
        if (follower == null) {
            return;
        }
        UUID uuid = follower.getUniqueId();
        if (followTasks.containsKey(uuid)) {
            followTasks.get(uuid).cancel();
        }
    }

    public void stopWalking(Entity entity) {
        bfj bfj2 = ((CraftEntity)entity).getHandle();
        if (bfj2 instanceof bgb) {
            bgb nmsMob = (bgb)bfj2;
            nmsMob.J().n();
        }
    }

    public void follow(final Entity target, final Entity follower, final double speed, final double lead, final double maxRange, final boolean allowWander, final boolean teleport) {
        if (target == null || follower == null) {
            return;
        }
        bfj nmsEntityFollower = ((CraftEntity)follower).getHandle();
        if (!(nmsEntityFollower instanceof bgb)) {
            return;
        }
        final bgb nmsFollower = (bgb)nmsEntityFollower;
        final bpj followerNavigation = nmsFollower.J();
        UUID uuid = follower.getUniqueId();
        if (followTasks.containsKey(uuid)) {
            followTasks.get(uuid).cancel();
        }
        final int locationNearInt = (int)Math.floor(lead);
        final boolean hasMax = maxRange > lead;
        followTasks.put(follower.getUniqueId(), new BukkitRunnable(){
            private boolean inRadius = false;

            public void run() {
                if (!target.isValid() || !follower.isValid()) {
                    this.cancel();
                }
                followerNavigation.a(2.0);
                Location targetLocation = target.getLocation();
                if (hasMax && !Utilities.checkLocation((Location)targetLocation, (Location)follower.getLocation(), (double)maxRange) && !target.isDead() && target.isOnGround()) {
                    if (!this.inRadius) {
                        if (teleport) {
                            follower.teleport(Utilities.getWalkableLocationNear((Location)targetLocation, (int)locationNearInt));
                        } else {
                            this.cancel();
                        }
                    } else {
                        this.inRadius = false;
                        dxt path = followerNavigation.a(targetLocation.getX(), targetLocation.getY(), targetLocation.getZ(), 0);
                        if (path != null) {
                            followerNavigation.a(path, 1.0);
                            followerNavigation.a(2.0);
                        }
                    }
                } else if (!this.inRadius && !Utilities.checkLocation((Location)targetLocation, (Location)follower.getLocation(), (double)lead)) {
                    dxt path = followerNavigation.a(targetLocation.getX(), targetLocation.getY(), targetLocation.getZ(), 0);
                    if (path != null) {
                        followerNavigation.a(path, 1.0);
                        followerNavigation.a(2.0);
                    }
                } else {
                    this.inRadius = true;
                }
                if (this.inRadius && !allowWander) {
                    followerNavigation.n();
                }
                nmsFollower.a(bhg.d).a(speed);
            }
        }.runTaskTimer((Plugin)NMSHandler.getJavaPlugin(), 0L, 10L));
    }

    public void walkTo(final LivingEntity entity, Location location, final Double speed, final Runnable callback) {
        dxt path;
        boolean aiDisabled;
        if (entity == null || location == null) {
            return;
        }
        bfj nmsEntity = ((CraftEntity)entity).getHandle();
        if (!(nmsEntity instanceof bgb)) {
            return;
        }
        final bgb nmsMob = (bgb)nmsEntity;
        final bpj entityNavigation = nmsMob.J();
        boolean bl = aiDisabled = !entity.hasAI();
        if (aiDisabled) {
            entity.setAI(true);
            try {
                ENTITY_ONGROUND_SETTER.invoke(nmsMob, true);
            }
            catch (Throwable ex) {
                Debug.echoError((Throwable)ex);
            }
        }
        if ((path = entityNavigation.a(location.getX(), location.getY(), location.getZ(), 1)) != null) {
            nmsMob.bO.b(bmv.a.a);
            entityNavigation.a(path, 1.0);
            final double oldSpeed = nmsMob.a(bhg.d).b();
            if (speed != null) {
                nmsMob.a(bhg.d).a(speed.doubleValue());
            }
            new BukkitRunnable(){

                public void run() {
                    if (!entity.isValid()) {
                        if (callback != null) {
                            callback.run();
                        }
                        this.cancel();
                        return;
                    }
                    if (aiDisabled && entity instanceof Wolf) {
                        Wolf wolf = (Wolf)entity;
                        wolf.setAngry(false);
                    }
                    if (entityNavigation.l() || path.c()) {
                        if (callback != null) {
                            callback.run();
                        }
                        if (speed != null) {
                            nmsMob.a(bhg.d).a(oldSpeed);
                        }
                        if (aiDisabled) {
                            entity.setAI(false);
                        }
                        this.cancel();
                    }
                }
            }.runTaskTimer((Plugin)NMSHandler.getJavaPlugin(), 1L, 1L);
        } else {
            entity.teleport(location);
        }
    }

    public List<Player> getPlayersThatSee(Entity entity) {
        ahr tracker = ((aif)((CraftEntity)entity).getHandle().dI()).k().a;
        ahr.b entityTracker = (ahr.b)tracker.K.get(entity.getEntityId());
        ArrayList<Player> output = new ArrayList<Player>();
        if (entityTracker == null) {
            return output;
        }
        for (ajb player : entityTracker.f) {
            output.add((Player)player.f().getBukkitEntity());
        }
        return output;
    }

    public void sendAllUpdatePackets(Entity entity) {
        ahr tracker = ((aif)((CraftEntity)entity).getHandle().dI()).k().a;
        ahr.b entityTracker = (ahr.b)tracker.K.get(entity.getEntityId());
        if (entityTracker == null) {
            return;
        }
        try {
            aie serverEntity = (aie)PacketHelperImpl.ENTITY_TRACKER_ENTRY_GETTER.get(entityTracker);
            serverEntity.a();
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void sendHidePacket(Player pl, Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            pl.hidePlayer((Plugin)Denizen.getInstance(), player);
            return;
        }
        aig nmsPlayer = ((CraftPlayer)pl).getHandle();
        if (nmsPlayer.c != null && !pl.equals(entity)) {
            ahr.b entry = (ahr.b)nmsPlayer.x().k().a.K.get(entity.getEntityId());
            if (entry != null) {
                entry.a(nmsPlayer);
            }
            if (Denizen.supportsPaper) {
                nmsPlayer.c.a((uo)new xc(new int[]{entity.getEntityId()}));
            }
        }
    }

    public void sendShowPacket(Player pl, Entity entity) {
        ahr.b entry;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            pl.showPlayer((Plugin)Denizen.getInstance(), player);
            return;
        }
        aig nmsPlayer = ((CraftPlayer)pl).getHandle();
        if (nmsPlayer.c != null && !pl.equals(entity) && (entry = (ahr.b)nmsPlayer.x().k().a.K.get(entity.getEntityId())) != null) {
            entry.a(nmsPlayer);
            entry.b(nmsPlayer);
        }
    }

    public void rotate(Entity entity, float yaw, float pitch) {
        Player player;
        if (entity instanceof Player && (player = (Player)entity).isOnline()) {
            NetworkInterceptHelper.enable();
            float relYaw = (yaw - entity.getLocation().getYaw()) % 360.0f;
            if (relYaw > 180.0f) {
                relYaw -= 360.0f;
            }
            float actualRelYaw = relYaw;
            float relPitch = pitch - entity.getLocation().getPitch();
            NMSHandler.packetHelper.sendRelativeLookPacket(player, actualRelYaw, relPitch);
        } else if (entity instanceof LivingEntity) {
            if (entity instanceof EnderDragon) {
                yaw = EntityHelperImpl.normalizeYaw((float)(yaw - 180.0f));
            }
            this.look(entity, yaw, pitch);
        } else {
            bfj handle = ((CraftEntity)entity).getHandle();
            handle.a_(yaw - 360.0f);
            handle.b_(pitch);
        }
    }

    public float getBaseYaw(LivingEntity entity) {
        return ((CraftLivingEntity)entity).getHandle().aV;
    }

    public void look(Entity entity, float yaw, float pitch) {
        bfj handle = ((CraftEntity)entity).getHandle();
        if (handle == null) {
            Debug.echoError((String)("Cannot set look direction for unspawned entity " + entity.getUniqueId()));
            return;
        }
        handle.a_(yaw);
        if (handle instanceof bfz) {
            bfz nmsLivingEntity = (bfz)handle;
            while (yaw < -180.0f) {
                yaw += 360.0f;
            }
            while (yaw >= 180.0f) {
                yaw -= 360.0f;
            }
            nmsLivingEntity.aW = yaw;
            if (!(handle instanceof byo)) {
                nmsLivingEntity.o(yaw);
            }
            nmsLivingEntity.n(yaw);
        }
        handle.b_(pitch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static eeg rayTrace(World world, Vector start, Vector end) {
        try {
            NMSHandler.chunkHelper.changeChunkServerThread(world);
            eee eee2 = ((CraftWorld)world).getHandle().a(new clv(new eei(start.getX(), start.getY(), start.getZ()), new eei(end.getX(), end.getY(), end.getZ()), clv.a.b, clv.b.a, null));
            return eee2;
        }
        finally {
            NMSHandler.chunkHelper.restoreServerThread(world);
        }
    }

    public boolean canTrace(World world, Vector start, Vector end) {
        eeg pos = EntityHelperImpl.rayTrace(world, start, end);
        if (pos == null) {
            return true;
        }
        return pos.c() == eeg.a.a;
    }

    public void snapPositionTo(Entity entity, Vector vector) {
        ((CraftEntity)entity).getHandle().p(vector.getX(), vector.getY(), vector.getZ());
    }

    public void move(Entity entity, Vector vector) {
        ((CraftEntity)entity).getHandle().a(bgf.a, new eei(vector.getX(), vector.getY(), vector.getZ()));
    }

    public boolean internalLook(Player player, Location at) {
        PacketHelperImpl.send(player, new wz(eb.a.b, at.getX(), at.getY(), at.getZ()));
        return true;
    }

    public static long entityToPacket(double x) {
        return apa.b((double)(x * 4096.0));
    }

    public void fakeMove(Entity entity, Vector vector) {
        long x = EntityHelperImpl.entityToPacket(vector.getX());
        long y = EntityHelperImpl.entityToPacket(vector.getY());
        long z = EntityHelperImpl.entityToPacket(vector.getZ());
        wl.a packet = new wl.a(entity.getEntityId(), (short)x, (short)y, (short)z, entity.isOnGround());
        for (Player player : this.getPlayersThatSee(entity)) {
            PacketHelperImpl.send(player, packet);
        }
    }

    public void fakeTeleport(Entity entity, Location location) {
        sf packetData = new sf(Unpooled.buffer());
        packetData.d(entity.getEntityId());
        packetData.writeDouble(location.getX());
        packetData.writeDouble(location.getY());
        packetData.writeDouble(location.getZ());
        packetData.writeByte((int)((byte)(location.getYaw() * 256.0f / 360.0f)));
        packetData.writeByte((int)((byte)(location.getPitch() * 256.0f / 360.0f)));
        packetData.writeBoolean(entity.isOnGround());
        ys packet = new ys(packetData);
        for (Player player : this.getPlayersThatSee(entity)) {
            PacketHelperImpl.send(player, packet);
        }
    }

    public void clientResetLoc(Entity entity) {
        ys packet = new ys(((CraftEntity)entity).getHandle());
        for (Player player : this.getPlayersThatSee(entity)) {
            PacketHelperImpl.send(player, packet);
        }
    }

    public void teleport(Entity entity, Location loc) {
        bfj nmsEntity = ((CraftEntity)entity).getHandle();
        nmsEntity.a_(loc.getYaw());
        nmsEntity.b_(loc.getPitch());
        if (nmsEntity instanceof aig) {
            nmsEntity.b(loc.getX(), loc.getY(), loc.getZ());
        }
        nmsEntity.e(loc.getX(), loc.getY(), loc.getZ());
    }

    public void setBoundingBox(Entity entity, BoundingBox box) {
        ((CraftEntity)entity).getHandle().a(new eed(box.getMinX(), box.getMinY(), box.getMinZ(), box.getMaxX(), box.getMaxY(), box.getMaxZ()));
    }

    public void setTicksLived(Entity entity, int ticks) {
        ((CraftEntity)entity).getHandle().ag = ticks;
        if (entity instanceof CraftFallingBlock) {
            CraftFallingBlock craftFallingBlock = (CraftFallingBlock)entity;
            craftFallingBlock.getHandle().b = ticks;
        } else if (entity instanceof CraftItem) {
            CraftItem craftItem = (CraftItem)entity;
            ((bvh)craftItem.getHandle()).g = ticks;
        }
    }

    public void setHeadAngle(LivingEntity entity, float angle) {
        ((CraftLivingEntity)entity).getHandle().n(angle);
    }

    public void setEndermanAngry(Enderman enderman, boolean angry) {
        ((CraftEnderman)enderman).getHandle().aj().b(ENDERMAN_DATA_ACCESSOR_SCREAMING, (Object)angry);
    }

    public static beo getReusableDamageSources() {
        if (backupDamageSources == null) {
            backupDamageSources = ((CraftWorld)Bukkit.getWorlds().get(0)).getHandle().ag();
        }
        return backupDamageSources;
    }

    public static ben getSourceFor(bfj nmsSource, EntityDamageEvent.DamageCause cause, bfj nmsSourceProvider) {
        beo sources = nmsSourceProvider == null ? EntityHelperImpl.getReusableDamageSources() : nmsSourceProvider.dI().ag();
        ben src = sources.n();
        if (nmsSource != null) {
            if (nmsSource instanceof byo) {
                byo nmsPlayer = (byo)nmsSource;
                src = nmsSource.dI().ag().a(nmsPlayer);
            } else if (nmsSource instanceof bfz) {
                bfz nmsLivingEntity = (bfz)nmsSource;
                src = nmsSource.dI().ag().b(nmsLivingEntity);
            }
        }
        if (cause == null) {
            return src;
        }
        return switch (cause) {
            default -> throw new IncompatibleClassChangeError();
            case EntityDamageEvent.DamageCause.CONTACT -> sources.j();
            case EntityDamageEvent.DamageCause.ENTITY_ATTACK -> {
                bfz nmsLivingEntity;
                yield sources.b(nmsSource instanceof bfz ? (nmsLivingEntity = (bfz)nmsSource) : null);
            }
            case EntityDamageEvent.DamageCause.ENTITY_SWEEP_ATTACK -> {
                if (src != sources.n()) {
                    yield src.sweep();
                }
                yield src;
            }
            case EntityDamageEvent.DamageCause.PROJECTILE -> {
                bfj v1;
                Projectile projectile;
                CraftEntity var7_7;
                if (nmsSource != null && (var7_7 = nmsSource.getBukkitEntity()) instanceof Projectile && (var7_7 = (projectile = (Projectile)var7_7).getShooter()) instanceof CraftEntity) {
                    CraftEntity shooter = var7_7;
                    v1 = shooter.getHandle();
                } else {
                    v1 = null;
                }
                yield sources.b(nmsSource, v1);
            }
            case EntityDamageEvent.DamageCause.SUFFOCATION -> sources.f();
            case EntityDamageEvent.DamageCause.FALL -> sources.k();
            case EntityDamageEvent.DamageCause.FIRE -> sources.a();
            case EntityDamageEvent.DamageCause.FIRE_TICK -> sources.c();
            case EntityDamageEvent.DamageCause.MELTING -> sources.melting;
            case EntityDamageEvent.DamageCause.LAVA -> sources.d();
            case EntityDamageEvent.DamageCause.DROWNING -> sources.h();
            case EntityDamageEvent.DamageCause.BLOCK_EXPLOSION -> {
                if (nmsSource instanceof bvi) {
                    bvi primedTnt = (bvi)nmsSource;
                    yield sources.d((bfj)primedTnt, (bfj)primedTnt.j());
                }
                yield sources.a(null);
            }
            case EntityDamageEvent.DamageCause.ENTITY_EXPLOSION -> sources.d(nmsSource, null);
            case EntityDamageEvent.DamageCause.VOID -> sources.m();
            case EntityDamageEvent.DamageCause.LIGHTNING -> sources.b();
            case EntityDamageEvent.DamageCause.STARVATION -> sources.i();
            case EntityDamageEvent.DamageCause.POISON -> sources.poison;
            case EntityDamageEvent.DamageCause.MAGIC -> sources.o();
            case EntityDamageEvent.DamageCause.WITHER -> sources.p();
            case EntityDamageEvent.DamageCause.FALLING_BLOCK -> sources.a(nmsSource);
            case EntityDamageEvent.DamageCause.THORNS -> sources.d(nmsSource);
            case EntityDamageEvent.DamageCause.DRAGON_BREATH -> sources.q();
            case EntityDamageEvent.DamageCause.CUSTOM -> sources.n();
            case EntityDamageEvent.DamageCause.FLY_INTO_WALL -> sources.l();
            case EntityDamageEvent.DamageCause.HOT_FLOOR -> sources.e();
            case EntityDamageEvent.DamageCause.CRAMMING -> sources.g();
            case EntityDamageEvent.DamageCause.DRYOUT -> sources.r();
            case EntityDamageEvent.DamageCause.FREEZE -> sources.t();
            case EntityDamageEvent.DamageCause.SONIC_BOOM -> sources.e(nmsSource);
            case EntityDamageEvent.DamageCause.WORLD_BORDER -> sources.v();
            case EntityDamageEvent.DamageCause.KILL -> sources.w();
            case EntityDamageEvent.DamageCause.SUICIDE -> new FakeDamageSrc(src);
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void damage(LivingEntity target, float amount, EntityTag source, Location sourceLoc, EntityDamageEvent.DamageCause cause) {
        bfj nmsSource;
        if (target == null) {
            return;
        }
        bfz nmsTarget = ((CraftLivingEntity)target).getHandle();
        CraftEventFactory.entityDamage = nmsSource = source == null ? null : ((CraftEntity)source.getBukkitEntity()).getHandle();
        CraftEventFactory.blockDamage = sourceLoc == null ? null : sourceLoc.getBlock();
        try {
            ben src = EntityHelperImpl.getSourceFor(nmsSource, cause, (bfj)nmsTarget);
            if (src instanceof FakeDamageSrc) {
                FakeDamageSrc fakeDamageSrc = (FakeDamageSrc)src;
                src = fakeDamageSrc.real;
                if (EntityHelperImpl.fireFakeDamageEvent((Entity)target, (EntityTag)source, (Location)sourceLoc, (EntityDamageEvent.DamageCause)cause, (float)amount).isCancelled()) {
                    return;
                }
            }
            nmsTarget.a(src, amount);
        }
        finally {
            CraftEventFactory.entityDamage = null;
            CraftEventFactory.blockDamage = null;
        }
    }

    public void setLastHurtBy(LivingEntity mob, LivingEntity damager) {
        ((CraftLivingEntity)mob).getHandle().a(((CraftLivingEntity)damager).getHandle());
    }

    public void setFallingBlockType(FallingBlock fallingBlock, BlockData block) {
        dcb state = ((CraftBlockData)block).getState();
        bvg nmsEntity = ((CraftFallingBlock)fallingBlock).getHandle();
        try {
            FALLINGBLOCK_BLOCK_STATE.set(nmsEntity, state);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public EntityTag getMobSpawnerDisplayEntity(CreatureSpawner spawner) {
        daz nmsSpawner = (daz)BlockHelperImpl.getTE((CraftCreatureSpawner)spawner);
        aif level = ((CraftWorld)spawner.getWorld()).getHandle();
        bfj nmsEntity = nmsSpawner.d().a((cmm)level, level.z, nmsSpawner.p());
        return new EntityTag((Entity)nmsEntity.getBukkitEntity());
    }

    public int getInWaterTime(Zombie zombie) {
        try {
            return ZOMBIE_INWATERTIME.getInt(((CraftZombie)zombie).getHandle());
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
            return 0;
        }
    }

    public void setInWaterTime(Zombie zombie, int ticks) {
        try {
            ZOMBIE_INWATERTIME.setInt(((CraftZombie)zombie).getHandle(), ticks);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void setTrackingRange(Entity entity, int range) {
        try {
            ahr map = ((CraftWorld)entity.getWorld()).getHandle().k().a;
            ahr.b entry = (ahr.b)map.K.get(entity.getEntityId());
            if (entry != null) {
                TRACKING_RANGE_SETTER.invoke(entry, range);
            }
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public boolean isAggressive(Mob mob) {
        return ((CraftMob)mob).getHandle().fS();
    }

    public void setAggressive(Mob mob, boolean aggressive) {
        ((CraftMob)mob).getHandle().v(aggressive);
    }

    public void setUUID(Entity entity, UUID id) {
        try {
            aig nmsPlayer;
            bfj nmsEntity = ((CraftEntity)entity).getHandle();
            nmsEntity.Y();
            nmsEntity.cN().forEach(bfj::Y);
            cmm level = nmsEntity.dI();
            ahd playerList = ((CraftServer)Bukkit.getServer()).getHandle();
            if (nmsEntity instanceof aig) {
                nmsPlayer = (aig)nmsEntity;
                PLAYERLIST_REMOVE.invoke(playerList, nmsPlayer);
            } else {
                nmsEntity.a(bfj.c.b);
            }
            nmsEntity.dF();
            nmsEntity.a_(id);
            if (nmsEntity instanceof aig) {
                nmsPlayer = (aig)nmsEntity;
                playerList.a(DenizenNetworkManagerImpl.getConnection(nmsPlayer), nmsPlayer);
            } else {
                level.b(nmsEntity);
            }
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public float getStepHeight(Entity entity) {
        return ((CraftEntity)entity).getHandle().dC();
    }

    public void setStepHeight(Entity entity, float stepHeight) {
        ((CraftEntity)entity).getHandle().r(stepHeight);
    }

    static {
        FALLINGBLOCK_BLOCK_STATE = ReflectionHelper.getFields(bvg.class).getFirstOfType(dcb.class);
        ZOMBIE_INWATERTIME = ReflectionHelper.getFields(bwv.class).get(ReflectionMappingsInfo.Zombie_inWaterTime, Integer.TYPE);
        TRACKING_RANGE_SETTER = ReflectionHelper.getFinalSetterForFirstOfType(ahr.b.class, Integer.TYPE);
        PLAYERLIST_REMOVE = ReflectionHelper.getMethodHandle(alk.class, (String)"remove", (Class[])new Class[]{aig.class});
    }

    public static class FakeDamageSrc
    extends ben {
        public ben real;

        public FakeDamageSrc(ben src) {
            super(null);
            this.real = src;
        }
    }
}

