/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_20.impl;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.abstracts.BiomeNMS;
import com.denizenscript.denizen.nms.v1_20.ReflectionMappingsInfo;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_20_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R1.util.CraftLocation;
import org.bukkit.entity.EntityType;

public class BiomeNMSImpl
extends BiomeNMS {
    public static final MethodHandle BIOME_CLIMATESETTINGS_CONSTRUCTOR = ReflectionHelper.getConstructor(cnk.b.class, (Class[])new Class[]{Boolean.TYPE, Float.TYPE, cnk.d.class, Float.TYPE});
    public he<cnk> biomeHolder;
    public aif world;

    public BiomeNMSImpl(aif world, String name) {
        super((World)world.getWorld(), name);
        this.world = world;
        this.biomeHolder = world.B_().d(jc.ap).b(acp.a((acp)jc.ap, (acq)new acq(name))).orElse(null);
    }

    public BiomeNMS.DownfallType getDownfallTypeAt(Location location) {
        cnk.c precipitation = ((cnk)this.biomeHolder.a()).a(CraftLocation.toBlockPosition((Location)location));
        return switch (precipitation) {
            default -> throw new IncompatibleClassChangeError();
            case cnk.c.b -> BiomeNMS.DownfallType.RAIN;
            case cnk.c.c -> BiomeNMS.DownfallType.SNOW;
            case cnk.c.a -> BiomeNMS.DownfallType.NONE;
        };
    }

    public float getHumidity() {
        return ((cnk)this.biomeHolder.a()).i.d();
    }

    public float getBaseTemperature() {
        return ((cnk)this.biomeHolder.a()).g();
    }

    public float getTemperatureAt(Location location) {
        return ((cnk)this.biomeHolder.a()).f(CraftLocation.toBlockPosition((Location)location));
    }

    public boolean hasDownfall() {
        return ((cnk)this.biomeHolder.a()).c();
    }

    public List<EntityType> getAmbientEntities() {
        return this.getSpawnableEntities(bgc.c);
    }

    public List<EntityType> getCreatureEntities() {
        return this.getSpawnableEntities(bgc.b);
    }

    public List<EntityType> getMonsterEntities() {
        return this.getSpawnableEntities(bgc.a);
    }

    public List<EntityType> getWaterEntities() {
        return this.getSpawnableEntities(bgc.f);
    }

    public int getFoliageColor() {
        if (((cnk)this.biomeHolder.a()).f() != 0) {
            return ((cnk)this.biomeHolder.a()).f();
        }
        float temperature = this.clampColor(this.getBaseTemperature());
        float humidity = this.clampColor(this.getHumidity());
        int temperatureValue = (int)((1.0f - temperature) * 255.0f);
        int humidityValue = (int)((1.0f - (humidity *= temperature)) * 255.0f);
        int index = temperatureValue << 8 | humidityValue;
        return index >= 65536 ? 4764952 : this.getColor(index / 256, index % 256).asRGB();
    }

    public void setClimate(boolean hasPrecipitation, float temperature, cnk.d temperatureModifier, float downfall) {
        try {
            Object newClimate = BIOME_CLIMATESETTINGS_CONSTRUCTOR.invoke(hasPrecipitation, temperature, temperatureModifier, downfall);
            ReflectionHelper.setFieldValue(cnk.class, (String)ReflectionMappingsInfo.Biome_climateSettings, (Object)this.biomeHolder.a(), (Object)newClimate);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void setHumidity(float humidity) {
        this.setClimate(this.hasDownfall(), this.getBaseTemperature(), this.getTemperatureModifier(), humidity);
    }

    public void setBaseTemperature(float baseTemperature) {
        this.setClimate(this.hasDownfall(), baseTemperature, this.getTemperatureModifier(), this.getHumidity());
    }

    public void setHasDownfall(boolean hasDownfall) {
        this.setClimate(hasDownfall, this.getBaseTemperature(), this.getTemperatureModifier(), this.getHumidity());
    }

    public void setFoliageColor(int color) {
        ReflectionHelper.setFieldValue(cnq.class, (String)ReflectionMappingsInfo.BiomeSpecialEffects_foliageColorOverride, (Object)((cnk)this.biomeHolder.a()).h(), Optional.of(color));
    }

    public int getFogColor() {
        return ((cnk)this.biomeHolder.a()).e();
    }

    public void setFogColor(int color) {
        ReflectionHelper.setFieldValue(cnq.class, (String)ReflectionMappingsInfo.BiomeSpecialEffects_fogColor, (Object)((cnk)this.biomeHolder.a()).h(), (Object)color);
    }

    public int getWaterFogColor() {
        return ((cnk)this.biomeHolder.a()).j();
    }

    public void setWaterFogColor(int color) {
        ReflectionHelper.setFieldValue(cnq.class, (String)ReflectionMappingsInfo.BiomeSpecialEffects_waterFogColor, (Object)((cnk)this.biomeHolder.a()).h(), (Object)color);
    }

    private List<EntityType> getSpawnableEntities(bgc creatureType) {
        cnw mobs = ((cnk)this.biomeHolder.a()).b();
        bcl typeSettingList = mobs.a(creatureType);
        ArrayList<EntityType> entityTypes = new ArrayList<EntityType>();
        if (typeSettingList == null) {
            return entityTypes;
        }
        for (cnw.c meta : typeSettingList.e()) {
            try {
                String n = bfn.a((bfn)meta.b).a();
                EntityType et = EntityType.fromName((String)n);
                if (et == null) {
                    et = EntityType.valueOf((String)n.toUpperCase(Locale.ENGLISH));
                }
                entityTypes.add(et);
            }
            catch (Throwable throwable) {}
        }
        return entityTypes;
    }

    public void setTo(Block block) {
        dei chunk;
        if (((CraftWorld)block.getWorld()).getHandle() != this.world) {
            NMSHandler.instance.getBiomeNMS(block.getWorld(), this.getName()).setTo(block);
            return;
        }
        gu pos = new gu(block.getX(), 0, block.getZ());
        if (this.world.A(pos) && (chunk = this.world.l(pos)) != null) {
            chunk.setBiome(block.getX() >> 2, block.getY() >> 2, block.getZ() >> 2, this.biomeHolder);
            chunk.a(true);
        }
    }

    public cnk.d getTemperatureModifier() {
        return ((cnk)this.biomeHolder.a()).i.c();
    }
}

