/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_20.helpers;

import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.ElementTag;
import java.util.HashMap;
import java.util.Map;

public class EntityDataNameMapper {
    public static final Map<Class<? extends biq>, Map<String, Integer>> entityDataNames = new HashMap<Class<? extends biq>, Map<String, Integer>>();

    public static void registerDataName(Class<? extends biq> entityClass, int id, String name) {
        entityDataNames.computeIfAbsent(entityClass, k -> new HashMap()).put(name, id);
    }

    public static int getIdForName(Class<? extends biq> entityClass, String name) {
        Class<? extends biq> currentClass = entityClass;
        int id = EntityDataNameMapper.getIdFromClass(currentClass, name);
        while (id == -1 && (currentClass = currentClass.getSuperclass()) != Object.class) {
            id = EntityDataNameMapper.getIdFromClass(currentClass, name);
        }
        return id;
    }

    private static int getIdFromClass(Class<?> entityClass, String name) {
        int id;
        Map<String, Integer> nameToId = entityDataNames.get(entityClass);
        int n = id = nameToId != null ? nameToId.getOrDefault(name, -1) : -1;
        if (id == -1 && ArgumentHelper.matchesInteger((String)name)) {
            id = new ElementTag(name).asInt();
        }
        return id;
    }

    static {
        EntityDataNameMapper.registerDataName(biq.class, 0, "entity_flags");
        EntityDataNameMapper.registerDataName(biq.class, 1, "air_ticks");
        EntityDataNameMapper.registerDataName(biq.class, 2, "custom_name");
        EntityDataNameMapper.registerDataName(biq.class, 3, "custom_name_visible");
        EntityDataNameMapper.registerDataName(biq.class, 4, "silent");
        EntityDataNameMapper.registerDataName(biq.class, 5, "no_gravity");
        EntityDataNameMapper.registerDataName(biq.class, 6, "pose");
        EntityDataNameMapper.registerDataName(biq.class, 7, "frozen_ticks");
        EntityDataNameMapper.registerDataName(bjb.class, 8, "width");
        EntityDataNameMapper.registerDataName(bjb.class, 9, "height");
        EntityDataNameMapper.registerDataName(bjb.class, 10, "responsive");
        EntityDataNameMapper.registerDataName(bip.class, 8, "interpolation_delay");
        EntityDataNameMapper.registerDataName(bip.class, 9, "interpolation_duration");
        EntityDataNameMapper.registerDataName(bip.class, 10, "translation");
        EntityDataNameMapper.registerDataName(bip.class, 11, "scale");
        EntityDataNameMapper.registerDataName(bip.class, 12, "left_rotation");
        EntityDataNameMapper.registerDataName(bip.class, 13, "right_rotation");
        EntityDataNameMapper.registerDataName(bip.class, 14, "billboard");
        EntityDataNameMapper.registerDataName(bip.class, 15, "brightness");
        EntityDataNameMapper.registerDataName(bip.class, 16, "view_range");
        EntityDataNameMapper.registerDataName(bip.class, 17, "shadow_radius");
        EntityDataNameMapper.registerDataName(bip.class, 18, "shadow_strength");
        EntityDataNameMapper.registerDataName(bip.class, 19, "width");
        EntityDataNameMapper.registerDataName(bip.class, 20, "height");
        EntityDataNameMapper.registerDataName(bip.class, 21, "glow_color");
        EntityDataNameMapper.registerDataName(bip.b.class, 22, "material");
        EntityDataNameMapper.registerDataName(bip.g.class, 22, "item");
        EntityDataNameMapper.registerDataName(bip.g.class, 23, "model_transform");
        EntityDataNameMapper.registerDataName(bip.l.class, 22, "text");
        EntityDataNameMapper.registerDataName(bip.l.class, 23, "line_width");
        EntityDataNameMapper.registerDataName(bip.l.class, 24, "background_color");
        EntityDataNameMapper.registerDataName(bip.l.class, 25, "text_opacity");
        EntityDataNameMapper.registerDataName(bip.l.class, 26, "text_display_flags");
        EntityDataNameMapper.registerDataName(cct.class, 8, "item");
        EntityDataNameMapper.registerDataName(ccf.class, 8, "item");
        EntityDataNameMapper.registerDataName(cch.class, 8, "spawn_position");
        EntityDataNameMapper.registerDataName(bin.class, 8, "radius");
        EntityDataNameMapper.registerDataName(bin.class, 9, "color");
        EntityDataNameMapper.registerDataName(bin.class, 10, "waiting");
        EntityDataNameMapper.registerDataName(bin.class, 11, "particle");
        EntityDataNameMapper.registerDataName(cci.class, 8, "hooked_entity_id");
        EntityDataNameMapper.registerDataName(cci.class, 9, "catchable");
        EntityDataNameMapper.registerDataName(cca.class, 8, "abstract_arrow_flags");
        EntityDataNameMapper.registerDataName(cca.class, 9, "piercing_level");
        EntityDataNameMapper.registerDataName(ccc.class, 10, "color");
        EntityDataNameMapper.registerDataName(ccy.class, 10, "loyalty_level");
        EntityDataNameMapper.registerDataName(ccy.class, 11, "enchantment_glint");
        EntityDataNameMapper.registerDataName(cdn.class, 8, "shaking_ticks");
        EntityDataNameMapper.registerDataName(cdn.class, 9, "shaking_direction");
        EntityDataNameMapper.registerDataName(cdn.class, 10, "damage_taken");
        EntityDataNameMapper.registerDataName(cdn.class, 11, "type");
        EntityDataNameMapper.registerDataName(cdn.class, 12, "left_paddle_moving");
        EntityDataNameMapper.registerDataName(cdn.class, 13, "right_paddle_moving");
        EntityDataNameMapper.registerDataName(cdn.class, 14, "bubble_shaking_ticks");
        EntityDataNameMapper.registerDataName(bxg.class, 8, "beam_target");
        EntityDataNameMapper.registerDataName(bxg.class, 9, "showing_bottom");
        EntityDataNameMapper.registerDataName(ccp.class, 8, "item");
        EntityDataNameMapper.registerDataName(ccg.class, 8, "item");
        EntityDataNameMapper.registerDataName(ccz.class, 8, "invulnerable");
        EntityDataNameMapper.registerDataName(cch.class, 8, "item");
        EntityDataNameMapper.registerDataName(cch.class, 9, "shooter_id");
        EntityDataNameMapper.registerDataName(cch.class, 10, "shot_at_angle");
        EntityDataNameMapper.registerDataName(byg.class, 8, "item");
        EntityDataNameMapper.registerDataName(byg.class, 9, "rotation");
        EntityDataNameMapper.registerDataName(byi.class, 8, "painting_variant");
        EntityDataNameMapper.registerDataName(bjg.class, 8, "living_entity_flags");
        EntityDataNameMapper.registerDataName(bjg.class, 9, "health");
        EntityDataNameMapper.registerDataName(bjg.class, 10, "potion_effect_color");
        EntityDataNameMapper.registerDataName(bjg.class, 11, "is_potion_effect_ambient");
        EntityDataNameMapper.registerDataName(bjg.class, 12, "arrows_in_body");
        EntityDataNameMapper.registerDataName(bjg.class, 13, "bee_stingers_in_body");
        EntityDataNameMapper.registerDataName(bjg.class, 14, "bed_location");
        EntityDataNameMapper.registerDataName(cbu.class, 15, "additional_hearts");
        EntityDataNameMapper.registerDataName(cbu.class, 16, "score");
        EntityDataNameMapper.registerDataName(cbu.class, 17, "skin_parts");
        EntityDataNameMapper.registerDataName(cbu.class, 18, "main_hand");
        EntityDataNameMapper.registerDataName(cbu.class, 19, "left_shoulder_entity");
        EntityDataNameMapper.registerDataName(cbu.class, 20, "right_shoulder_entity");
        EntityDataNameMapper.registerDataName(byd.class, 15, "armor_stand_flags");
        EntityDataNameMapper.registerDataName(byd.class, 16, "head_rotation");
        EntityDataNameMapper.registerDataName(byd.class, 17, "body_rotation");
        EntityDataNameMapper.registerDataName(byd.class, 18, "left_arm_rotation");
        EntityDataNameMapper.registerDataName(byd.class, 19, "right_arm_rotation");
        EntityDataNameMapper.registerDataName(byd.class, 20, "left_leg_rotation");
        EntityDataNameMapper.registerDataName(byd.class, 21, "right_leg_rotation");
        EntityDataNameMapper.registerDataName(bji.class, 15, "mob_flags");
        EntityDataNameMapper.registerDataName(bum.class, 16, "bat_flags");
        EntityDataNameMapper.registerDataName(buz.class, 16, "treasure_location");
        EntityDataNameMapper.registerDataName(buz.class, 17, "has_fish");
        EntityDataNameMapper.registerDataName(buz.class, 18, "moisture_level");
        EntityDataNameMapper.registerDataName(buo.class, 16, "from_bucket");
        EntityDataNameMapper.registerDataName(bvk.class, 17, "puff_state");
        EntityDataNameMapper.registerDataName(bvr.class, 17, "variant");
        EntityDataNameMapper.registerDataName(bil.class, 16, "is_baby");
        EntityDataNameMapper.registerDataName(bxd.class, 17, "sniffer_state");
        EntityDataNameMapper.registerDataName(bxd.class, 18, "finish_dig_time");
        EntityDataNameMapper.registerDataName(bwq.class, 17, "horse_flags");
        EntityDataNameMapper.registerDataName(bws.class, 18, "variant");
        EntityDataNameMapper.registerDataName(bwd.class, 18, "is_dashing");
        EntityDataNameMapper.registerDataName(bwd.class, 19, "last_pose_change");
        EntityDataNameMapper.registerDataName(bwp.class, 18, "has_chest");
        EntityDataNameMapper.registerDataName(bwt.class, 19, "strength");
        EntityDataNameMapper.registerDataName(bwt.class, 20, "carpet_color");
        EntityDataNameMapper.registerDataName(bwt.class, 21, "variant");
        EntityDataNameMapper.registerDataName(bvy.class, 17, "variant");
        EntityDataNameMapper.registerDataName(bvy.class, 18, "playing_dead");
        EntityDataNameMapper.registerDataName(bvy.class, 19, "from_bucket");
        EntityDataNameMapper.registerDataName(bus.class, 17, "bee_flags");
        EntityDataNameMapper.registerDataName(bus.class, 18, "anger_time");
        EntityDataNameMapper.registerDataName(bvb.class, 17, "type");
        EntityDataNameMapper.registerDataName(bvb.class, 18, "fox_flags");
        EntityDataNameMapper.registerDataName(bvb.class, 19, "first_trusted_uuid");
        EntityDataNameMapper.registerDataName(bvb.class, 20, "second_trusted_uuid");
        EntityDataNameMapper.registerDataName(bwg.class, 17, "variant");
        EntityDataNameMapper.registerDataName(bwg.class, 18, "target_id");
        EntityDataNameMapper.registerDataName(bvf.class, 17, "is_trusting");
        EntityDataNameMapper.registerDataName(bvg.class, 17, "ask_for_bamboo_timer");
        EntityDataNameMapper.registerDataName(bvg.class, 18, "sneeze_timer");
        EntityDataNameMapper.registerDataName(bvg.class, 19, "eat_timer");
        EntityDataNameMapper.registerDataName(bvg.class, 20, "main_gene");
        EntityDataNameMapper.registerDataName(bvg.class, 21, "hidden_gene");
        EntityDataNameMapper.registerDataName(bvg.class, 22, "panda_flags");
        EntityDataNameMapper.registerDataName(bvi.class, 17, "has_saddle");
        EntityDataNameMapper.registerDataName(bvi.class, 18, "boost_ticks");
        EntityDataNameMapper.registerDataName(bvl.class, 17, "type");
        EntityDataNameMapper.registerDataName(bvs.class, 17, "home_location");
        EntityDataNameMapper.registerDataName(bvs.class, 18, "has_egg");
        EntityDataNameMapper.registerDataName(bvs.class, 19, "laying_egg");
        EntityDataNameMapper.registerDataName(bvs.class, 20, "travel_location");
        EntityDataNameMapper.registerDataName(bvs.class, 21, "going_home");
        EntityDataNameMapper.registerDataName(bvs.class, 20, "traveling");
        EntityDataNameMapper.registerDataName(bvj.class, 17, "standing_up");
        EntityDataNameMapper.registerDataName(cae.class, 17, "immune_to_zombification");
        EntityDataNameMapper.registerDataName(bve.class, 17, "variant");
        EntityDataNameMapper.registerDataName(bvn.class, 17, "sheep_wool_flags");
        EntityDataNameMapper.registerDataName(bzv.class, 17, "boost_ticks");
        EntityDataNameMapper.registerDataName(bzv.class, 18, "shaking");
        EntityDataNameMapper.registerDataName(bzv.class, 19, "has_saddle");
        EntityDataNameMapper.registerDataName(bkb.class, 17, "tamable_animal_flags");
        EntityDataNameMapper.registerDataName(bkb.class, 18, "owner");
        EntityDataNameMapper.registerDataName(buu.class, 19, "variant");
        EntityDataNameMapper.registerDataName(buu.class, 20, "lying");
        EntityDataNameMapper.registerDataName(buu.class, 20, "relaxed");
        EntityDataNameMapper.registerDataName(buu.class, 21, "collar_color");
        EntityDataNameMapper.registerDataName(bvu.class, 19, "begging");
        EntityDataNameMapper.registerDataName(bvu.class, 20, "collar_color");
        EntityDataNameMapper.registerDataName(bvu.class, 21, "anger_time");
        EntityDataNameMapper.registerDataName(bvh.class, 19, "variant");
        EntityDataNameMapper.registerDataName(cbc.class, 17, "head_shake_ticks");
        EntityDataNameMapper.registerDataName(cbh.class, 18, "villager_data");
        EntityDataNameMapper.registerDataName(bvd.class, 16, "iron_golem_flags");
        EntityDataNameMapper.registerDataName(bvp.class, 16, "snow_golem_pumpkin_flags");
        EntityDataNameMapper.registerDataName(bzo.class, 16, "attach_face");
        EntityDataNameMapper.registerDataName(bzo.class, 17, "attachment_location");
        EntityDataNameMapper.registerDataName(bzo.class, 18, "peek");
        EntityDataNameMapper.registerDataName(bzo.class, 19, "color");
        EntityDataNameMapper.registerDataName(caj.class, 16, "immune_to_zombification");
        EntityDataNameMapper.registerDataName(cak.class, 17, "is_baby");
        EntityDataNameMapper.registerDataName(cak.class, 18, "charging_crossbow");
        EntityDataNameMapper.registerDataName(cak.class, 19, "dancing");
        EntityDataNameMapper.registerDataName(bys.class, 16, "blaze_flags");
        EntityDataNameMapper.registerDataName(byu.class, 16, "state");
        EntityDataNameMapper.registerDataName(byu.class, 17, "charged");
        EntityDataNameMapper.registerDataName(byu.class, 18, "ignited");
        EntityDataNameMapper.registerDataName(bwm.class, 17, "screaming");
        EntityDataNameMapper.registerDataName(bwm.class, 18, "has_left_horn");
        EntityDataNameMapper.registerDataName(bwm.class, 19, "has_right_horn");
        EntityDataNameMapper.registerDataName(bze.class, 16, "spikes_retracted");
        EntityDataNameMapper.registerDataName(bze.class, 17, "target_id");
        EntityDataNameMapper.registerDataName(cdc.class, 16, "celebrating");
        EntityDataNameMapper.registerDataName(bzl.class, 17, "charging_crossbow");
        EntityDataNameMapper.registerDataName(bzs.class, 17, "spell");
        EntityDataNameMapper.registerDataName(bzy.class, 17, "drinking_potion");
        EntityDataNameMapper.registerDataName(bzw.class, 16, "vex_flags");
        EntityDataNameMapper.registerDataName(bzt.class, 16, "spider_flags");
        EntityDataNameMapper.registerDataName(cay.class, 16, "anger_level");
        EntityDataNameMapper.registerDataName(byb.class, 16, "center_head_target");
        EntityDataNameMapper.registerDataName(byb.class, 17, "left_head_target");
        EntityDataNameMapper.registerDataName(byb.class, 18, "right_head_target");
        EntityDataNameMapper.registerDataName(byb.class, 19, "invulnerable_time");
        EntityDataNameMapper.registerDataName(caa.class, 16, "is_baby");
        EntityDataNameMapper.registerDataName(cab.class, 16, "is_baby");
        EntityDataNameMapper.registerDataName(cab.class, 17, "type");
        EntityDataNameMapper.registerDataName(cab.class, 18, "converting_in_water");
        EntityDataNameMapper.registerDataName(cac.class, 19, "is_converting");
        EntityDataNameMapper.registerDataName(cac.class, 20, "villager_data");
        EntityDataNameMapper.registerDataName(byy.class, 16, "carried_block");
        EntityDataNameMapper.registerDataName(byy.class, 17, "screaming");
        EntityDataNameMapper.registerDataName(byy.class, 18, "staring");
        EntityDataNameMapper.registerDataName(bxh.class, 16, "phase");
        EntityDataNameMapper.registerDataName(bzc.class, 16, "attacking");
        EntityDataNameMapper.registerDataName(bzk.class, 16, "size");
        EntityDataNameMapper.registerDataName(bzr.class, 16, "size");
        EntityDataNameMapper.registerDataName(cdl.class, 8, "shaking_ticks");
        EntityDataNameMapper.registerDataName(cdl.class, 9, "shaking_direction");
        EntityDataNameMapper.registerDataName(cdl.class, 10, "damage_taken");
        EntityDataNameMapper.registerDataName(cdl.class, 11, "display_block_id");
        EntityDataNameMapper.registerDataName(cdl.class, 12, "display_block_y");
        EntityDataNameMapper.registerDataName(cdl.class, 13, "show_display_block");
        EntityDataNameMapper.registerDataName(cdu.class, 14, "has_fuel");
        EntityDataNameMapper.registerDataName(cdt.class, 14, "command");
        EntityDataNameMapper.registerDataName(cdt.class, 15, "last_output");
        EntityDataNameMapper.registerDataName(byo.class, 8, "fuse_ticks");
    }
}

