/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_20.helpers;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.interfaces.EntityHelper;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.v1_20.ReflectionMappingsInfo;
import com.denizenscript.denizen.nms.v1_20.helpers.BlockHelperImpl;
import com.denizenscript.denizen.nms.v1_20.helpers.EntityDataNameMapper;
import com.denizenscript.denizen.nms.v1_20.helpers.PacketHelperImpl;
import com.denizenscript.denizen.nms.v1_20.impl.jnbt.CompoundTagImpl;
import com.denizenscript.denizen.nms.v1_20.impl.network.handlers.DenizenNetworkManagerImpl;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.packets.NetworkInterceptHelper;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.scripts.commands.core.ReflectionSetCommand;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutLookAt;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.server.dedicated.DedicatedPlayerList;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.server.players.PlayerList;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.damagesource.CombatMath;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.item.EntityFallingBlock;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.item.EntityTNTPrimed;
import net.minecraft.world.entity.monster.EntityEnderman;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.block.entity.TileEntityMobSpawner;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_20_R2.CraftServer;
import org.bukkit.craftbukkit.v1_20_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R2.block.CraftBlock;
import org.bukkit.craftbukkit.v1_20_R2.block.CraftCreatureSpawner;
import org.bukkit.craftbukkit.v1_20_R2.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftEnderman;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftExperienceOrb;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftFallingBlock;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftItem;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftMob;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftZombie;
import org.bukkit.craftbukkit.v1_20_R2.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_20_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R2.util.CraftLocation;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Pose;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.Zombie;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;

public class EntityHelperImpl
extends EntityHelper {
    public static final MethodHandle ENTITY_ONGROUND_SETTER = ReflectionHelper.getFinalSetter(net.minecraft.world.entity.Entity.class, (String)ReflectionMappingsInfo.Entity_onGround, Boolean.TYPE);
    public static final DataWatcherObject<Boolean> ENDERMAN_DATA_ACCESSOR_SCREAMING = (DataWatcherObject)ReflectionHelper.getFieldValue(EntityEnderman.class, (String)ReflectionMappingsInfo.EnderMan_DATA_CREEPY, null);
    public static final MethodHandle LIVINGENTITY_AUTOSPINATTACK_SETTER = ReflectionHelper.getFinalSetter(EntityLiving.class, (String)ReflectionMappingsInfo.LivingEntity_autoSpinAttackTicks);
    public static final MethodHandle LIVINGENTITY_SETLIVINGENTITYFLAG = ReflectionHelper.getMethodHandle(EntityLiving.class, (String)ReflectionMappingsInfo.LivingEntity_setLivingEntityFlag_method, (Class[])new Class[]{Integer.TYPE, Boolean.TYPE});
    private static final Map<UUID, BukkitTask> followTasks = new HashMap<UUID, BukkitTask>();
    public static final Field EXPERIENCE_ORB_AGE = ReflectionHelper.getFields(EntityExperienceOrb.class).get(ReflectionMappingsInfo.ExperienceOrb_age, Integer.TYPE);
    public static DamageSources backupDamageSources;
    public static final Field FALLINGBLOCK_BLOCK_STATE;
    public static final Field ZOMBIE_INWATERTIME;
    public static final MethodHandle TRACKING_RANGE_SETTER;
    public static final MethodHandle PLAYERLIST_REMOVE;

    public void setInvisible(Entity entity, boolean invisible) {
        ((CraftEntity)entity).getHandle().j(invisible);
    }

    public boolean isInvisible(Entity entity) {
        return ((CraftEntity)entity).getHandle().cd();
    }

    public void setPose(Entity entity, Pose pose) {
        ((CraftEntity)entity).getHandle().b(EntityPose.values()[pose.ordinal()]);
    }

    public double getDamageTo(LivingEntity attacker, Entity target) {
        EnumMonsterType monsterType = target instanceof LivingEntity ? ((CraftLivingEntity)target).getHandle().eR() : EnumMonsterType.a;
        double damage = 0.0;
        AttributeInstance attrib = attacker.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE);
        if (attrib != null) {
            damage = attrib.getValue();
        }
        if (attacker.getEquipment() != null && attacker.getEquipment().getItemInMainHand() != null) {
            damage += (double)EnchantmentManager.a((net.minecraft.world.item.ItemStack)CraftItemStack.asNMSCopy((ItemStack)attacker.getEquipment().getItemInMainHand()), (EnumMonsterType)monsterType);
        }
        if (damage <= 0.0) {
            return 0.0;
        }
        if (target != null) {
            DamageSource source;
            net.minecraft.world.entity.Entity nmsTarget = ((CraftEntity)target).getHandle();
            if (attacker instanceof CraftPlayer) {
                CraftPlayer playerAttacker = (CraftPlayer)attacker;
                source = nmsTarget.dL().ag().a((EntityHuman)playerAttacker.getHandle());
            } else {
                source = nmsTarget.dL().ag().b(((CraftLivingEntity)attacker).getHandle());
            }
            if (nmsTarget.b(source)) {
                return 0.0;
            }
            if (!(nmsTarget instanceof EntityLiving)) {
                return damage;
            }
            EntityLiving livingTarget = (EntityLiving)nmsTarget;
            damage = CombatMath.a((float)((float)damage), (float)livingTarget.eI(), (float)((float)livingTarget.b(GenericAttributes.j)));
            int enchantDamageModifier = EnchantmentManager.a((Iterable)livingTarget.bK(), (DamageSource)source);
            if (enchantDamageModifier > 0) {
                damage = CombatMath.a((float)((float)damage), (float)enchantDamageModifier);
            }
        }
        return damage;
    }

    public void setRiptide(Entity entity, boolean state) {
        try {
            EntityLiving nmsEntity = ((CraftLivingEntity)entity).getHandle();
            LIVINGENTITY_AUTOSPINATTACK_SETTER.invoke(nmsEntity, state ? 0 : 1);
            LIVINGENTITY_SETLIVINGENTITYFLAG.invoke(nmsEntity, 4, true);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void forceInteraction(Player player, Location location) {
        CraftPlayer craftPlayer = (CraftPlayer)player;
        ((CraftBlock)location.getBlock()).getNMS().a((net.minecraft.world.level.World)((CraftWorld)location.getWorld()).getHandle(), (EntityHuman)(craftPlayer != null ? craftPlayer.getHandle() : null), EnumHand.a, new MovingObjectPositionBlock(new Vec3D(0.0, 0.0, 0.0), null, CraftLocation.toBlockPosition((Location)location), false));
    }

    public Entity getEntity(World world, UUID uuid) {
        net.minecraft.world.entity.Entity entity = ((CraftWorld)world).getHandle().a(uuid);
        return entity == null ? null : entity.getBukkitEntity();
    }

    public CompoundTag getNbtData(Entity entity) {
        NBTTagCompound compound = new NBTTagCompound();
        ((CraftEntity)entity).getHandle().d(compound);
        return CompoundTagImpl.fromNMSTag(compound);
    }

    public void setNbtData(Entity entity, CompoundTag compoundTag) {
        ((CraftEntity)entity).getHandle().g(((CompoundTagImpl)compoundTag).toNMSTag());
    }

    public void stopFollowing(Entity follower) {
        if (follower == null) {
            return;
        }
        UUID uuid = follower.getUniqueId();
        if (followTasks.containsKey(uuid)) {
            followTasks.get(uuid).cancel();
        }
    }

    public void stopWalking(Entity entity) {
        net.minecraft.world.entity.Entity entity2 = ((CraftEntity)entity).getHandle();
        if (entity2 instanceof EntityInsentient) {
            EntityInsentient nmsMob = (EntityInsentient)entity2;
            nmsMob.L().n();
        }
    }

    public void follow(final Entity target, final Entity follower, final double speed, final double lead, final double maxRange, final boolean allowWander, final boolean teleport) {
        if (target == null || follower == null) {
            return;
        }
        net.minecraft.world.entity.Entity nmsEntityFollower = ((CraftEntity)follower).getHandle();
        if (!(nmsEntityFollower instanceof EntityInsentient)) {
            return;
        }
        final EntityInsentient nmsFollower = (EntityInsentient)nmsEntityFollower;
        final NavigationAbstract followerNavigation = nmsFollower.L();
        UUID uuid = follower.getUniqueId();
        if (followTasks.containsKey(uuid)) {
            followTasks.get(uuid).cancel();
        }
        final int locationNearInt = (int)Math.floor(lead);
        final boolean hasMax = maxRange > lead;
        followTasks.put(follower.getUniqueId(), new BukkitRunnable(){
            private boolean inRadius = false;

            public void run() {
                if (!target.isValid() || !follower.isValid()) {
                    this.cancel();
                }
                followerNavigation.a(2.0);
                Location targetLocation = target.getLocation();
                if (hasMax && !Utilities.checkLocation((Location)targetLocation, (Location)follower.getLocation(), (double)maxRange) && !target.isDead() && target.isOnGround()) {
                    if (!this.inRadius) {
                        if (teleport) {
                            follower.teleport(Utilities.getWalkableLocationNear((Location)targetLocation, (int)locationNearInt));
                        } else {
                            this.cancel();
                        }
                    } else {
                        this.inRadius = false;
                        PathEntity path = followerNavigation.a(targetLocation.getX(), targetLocation.getY(), targetLocation.getZ(), 0);
                        if (path != null) {
                            followerNavigation.a(path, 1.0);
                            followerNavigation.a(2.0);
                        }
                    }
                } else if (!this.inRadius && !Utilities.checkLocation((Location)targetLocation, (Location)follower.getLocation(), (double)lead)) {
                    PathEntity path = followerNavigation.a(targetLocation.getX(), targetLocation.getY(), targetLocation.getZ(), 0);
                    if (path != null) {
                        followerNavigation.a(path, 1.0);
                        followerNavigation.a(2.0);
                    }
                } else {
                    this.inRadius = true;
                }
                if (this.inRadius && !allowWander) {
                    followerNavigation.n();
                }
                nmsFollower.a(GenericAttributes.d).a(speed);
            }
        }.runTaskTimer((Plugin)NMSHandler.getJavaPlugin(), 0L, 10L));
    }

    public void walkTo(final LivingEntity entity, Location location, final Double speed, final Runnable callback) {
        PathEntity path;
        boolean aiDisabled;
        if (entity == null || location == null) {
            return;
        }
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        if (!(nmsEntity instanceof EntityInsentient)) {
            return;
        }
        final EntityInsentient nmsMob = (EntityInsentient)nmsEntity;
        final NavigationAbstract entityNavigation = nmsMob.L();
        boolean bl = aiDisabled = !entity.hasAI();
        if (aiDisabled) {
            entity.setAI(true);
            try {
                ENTITY_ONGROUND_SETTER.invoke(nmsMob, true);
            }
            catch (Throwable ex) {
                Debug.echoError((Throwable)ex);
            }
        }
        if ((path = entityNavigation.a(location.getX(), location.getY(), location.getZ(), 1)) != null) {
            nmsMob.bO.b(PathfinderGoal.Type.a);
            entityNavigation.a(path, 1.0);
            final double oldSpeed = nmsMob.a(GenericAttributes.d).b();
            if (speed != null) {
                nmsMob.a(GenericAttributes.d).a(speed.doubleValue());
            }
            new BukkitRunnable(){

                public void run() {
                    if (!entity.isValid()) {
                        if (callback != null) {
                            callback.run();
                        }
                        this.cancel();
                        return;
                    }
                    if (aiDisabled && entity instanceof Wolf) {
                        Wolf wolf = (Wolf)entity;
                        wolf.setAngry(false);
                    }
                    if (entityNavigation.l() || path.c()) {
                        if (callback != null) {
                            callback.run();
                        }
                        if (speed != null) {
                            nmsMob.a(GenericAttributes.d).a(oldSpeed);
                        }
                        if (aiDisabled) {
                            entity.setAI(false);
                        }
                        this.cancel();
                    }
                }
            }.runTaskTimer((Plugin)NMSHandler.getJavaPlugin(), 1L, 1L);
        } else {
            entity.teleport(location);
        }
    }

    public List<Player> getPlayersThatSee(Entity entity) {
        PlayerChunkMap tracker = ((WorldServer)((CraftEntity)entity).getHandle().dL()).k().a;
        PlayerChunkMap.EntityTracker entityTracker = (PlayerChunkMap.EntityTracker)tracker.K.get(entity.getEntityId());
        ArrayList<Player> output = new ArrayList<Player>();
        if (entityTracker == null) {
            return output;
        }
        for (ServerPlayerConnection player : entityTracker.f) {
            output.add((Player)player.p().getBukkitEntity());
        }
        return output;
    }

    public void sendAllUpdatePackets(Entity entity) {
        PlayerChunkMap tracker = ((WorldServer)((CraftEntity)entity).getHandle().dL()).k().a;
        PlayerChunkMap.EntityTracker entityTracker = (PlayerChunkMap.EntityTracker)tracker.K.get(entity.getEntityId());
        if (entityTracker == null) {
            return;
        }
        try {
            EntityTrackerEntry serverEntity = (EntityTrackerEntry)PacketHelperImpl.ENTITY_TRACKER_ENTRY_GETTER.get(entityTracker);
            serverEntity.a();
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void sendHidePacket(Player pl, Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            pl.hidePlayer((Plugin)Denizen.getInstance(), player);
            return;
        }
        EntityPlayer nmsPlayer = ((CraftPlayer)pl).getHandle();
        if (nmsPlayer.c != null && !pl.equals(entity)) {
            PlayerChunkMap.EntityTracker entry = (PlayerChunkMap.EntityTracker)nmsPlayer.x().k().a.K.get(entity.getEntityId());
            if (entry != null) {
                entry.a(nmsPlayer);
            }
            if (Denizen.supportsPaper) {
                nmsPlayer.c.b((Packet)new PacketPlayOutEntityDestroy(new int[]{entity.getEntityId()}));
            }
        }
    }

    public void sendShowPacket(Player pl, Entity entity) {
        PlayerChunkMap.EntityTracker entry;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            pl.showPlayer((Plugin)Denizen.getInstance(), player);
            return;
        }
        EntityPlayer nmsPlayer = ((CraftPlayer)pl).getHandle();
        if (nmsPlayer.c != null && !pl.equals(entity) && (entry = (PlayerChunkMap.EntityTracker)nmsPlayer.x().k().a.K.get(entity.getEntityId())) != null) {
            entry.a(nmsPlayer);
            entry.b(nmsPlayer);
        }
    }

    public void rotate(Entity entity, float yaw, float pitch) {
        Player player;
        if (entity instanceof Player && (player = (Player)entity).isOnline()) {
            NetworkInterceptHelper.enable();
            float relYaw = (yaw - entity.getLocation().getYaw()) % 360.0f;
            if (relYaw > 180.0f) {
                relYaw -= 360.0f;
            }
            float actualRelYaw = relYaw;
            float relPitch = pitch - entity.getLocation().getPitch();
            NMSHandler.packetHelper.sendRelativeLookPacket(player, actualRelYaw, relPitch);
        } else if (entity instanceof LivingEntity) {
            if (entity instanceof EnderDragon) {
                yaw = EntityHelperImpl.normalizeYaw((float)(yaw - 180.0f));
            }
            this.look(entity, yaw, pitch);
        } else {
            net.minecraft.world.entity.Entity handle = ((CraftEntity)entity).getHandle();
            handle.r(yaw - 360.0f);
            handle.s(pitch);
        }
    }

    public float getBaseYaw(LivingEntity entity) {
        return ((CraftLivingEntity)entity).getHandle().aU;
    }

    public void look(Entity entity, float yaw, float pitch) {
        net.minecraft.world.entity.Entity handle = ((CraftEntity)entity).getHandle();
        if (handle == null) {
            Debug.echoError((String)("Cannot set look direction for unspawned entity " + entity.getUniqueId()));
            return;
        }
        handle.r(yaw);
        if (handle instanceof EntityLiving) {
            EntityLiving nmsLivingEntity = (EntityLiving)handle;
            while (yaw < -180.0f) {
                yaw += 360.0f;
            }
            while (yaw >= 180.0f) {
                yaw -= 360.0f;
            }
            nmsLivingEntity.aV = yaw;
            if (!(handle instanceof EntityHuman)) {
                nmsLivingEntity.o(yaw);
            }
            nmsLivingEntity.n(yaw);
        }
        handle.s(pitch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MovingObjectPosition rayTrace(World world, Vector start, Vector end) {
        try {
            NMSHandler.chunkHelper.changeChunkServerThread(world);
            MovingObjectPositionBlock movingObjectPositionBlock = ((CraftWorld)world).getHandle().a(new RayTrace(new Vec3D(start.getX(), start.getY(), start.getZ()), new Vec3D(end.getX(), end.getY(), end.getZ()), RayTrace.BlockCollisionOption.b, RayTrace.FluidCollisionOption.a, null));
            return movingObjectPositionBlock;
        }
        finally {
            NMSHandler.chunkHelper.restoreServerThread(world);
        }
    }

    public boolean canTrace(World world, Vector start, Vector end) {
        MovingObjectPosition pos = EntityHelperImpl.rayTrace(world, start, end);
        if (pos == null) {
            return true;
        }
        return pos.c() == MovingObjectPosition.EnumMovingObjectType.a;
    }

    public void snapPositionTo(Entity entity, Vector vector) {
        ((CraftEntity)entity).getHandle().p(vector.getX(), vector.getY(), vector.getZ());
    }

    public void move(Entity entity, Vector vector) {
        ((CraftEntity)entity).getHandle().a(EnumMoveType.a, new Vec3D(vector.getX(), vector.getY(), vector.getZ()));
    }

    public boolean internalLook(Player player, Location at) {
        PacketHelperImpl.send(player, new PacketPlayOutLookAt(ArgumentAnchor.Anchor.b, at.getX(), at.getY(), at.getZ()));
        return true;
    }

    public static long entityToPacket(double x) {
        return MathHelper.b((double)(x * 4096.0));
    }

    public void fakeMove(Entity entity, Vector vector) {
        long x = EntityHelperImpl.entityToPacket(vector.getX());
        long y = EntityHelperImpl.entityToPacket(vector.getY());
        long z = EntityHelperImpl.entityToPacket(vector.getZ());
        PacketPlayOutEntity.PacketPlayOutRelEntityMove packet = new PacketPlayOutEntity.PacketPlayOutRelEntityMove(entity.getEntityId(), (short)x, (short)y, (short)z, entity.isOnGround());
        for (Player player : this.getPlayersThatSee(entity)) {
            PacketHelperImpl.send(player, packet);
        }
    }

    public void fakeTeleport(Entity entity, Location location) {
        PacketDataSerializer packetData = new PacketDataSerializer(Unpooled.buffer());
        packetData.c(entity.getEntityId());
        packetData.a(location.getX());
        packetData.a(location.getY());
        packetData.a(location.getZ());
        packetData.k((int)((byte)(location.getYaw() * 256.0f / 360.0f)));
        packetData.k((int)((byte)(location.getPitch() * 256.0f / 360.0f)));
        packetData.a(entity.isOnGround());
        PacketPlayOutEntityTeleport packet = new PacketPlayOutEntityTeleport(packetData);
        for (Player player : this.getPlayersThatSee(entity)) {
            PacketHelperImpl.send(player, packet);
        }
    }

    public void clientResetLoc(Entity entity) {
        PacketPlayOutEntityTeleport packet = new PacketPlayOutEntityTeleport(((CraftEntity)entity).getHandle());
        for (Player player : this.getPlayersThatSee(entity)) {
            PacketHelperImpl.send(player, packet);
        }
    }

    public void teleport(Entity entity, Location loc) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        nmsEntity.r(loc.getYaw());
        nmsEntity.s(loc.getPitch());
        if (nmsEntity instanceof EntityPlayer) {
            nmsEntity.b(loc.getX(), loc.getY(), loc.getZ());
        }
        nmsEntity.e(loc.getX(), loc.getY(), loc.getZ());
    }

    public void setBoundingBox(Entity entity, BoundingBox box) {
        ((CraftEntity)entity).getHandle().a(new AxisAlignedBB(box.getMinX(), box.getMinY(), box.getMinZ(), box.getMaxX(), box.getMaxY(), box.getMaxZ()));
    }

    public void setTicksLived(Entity entity, int ticks) {
        ((CraftEntity)entity).getHandle().ah = ticks;
        if (entity instanceof CraftFallingBlock) {
            CraftFallingBlock craftFallingBlock = (CraftFallingBlock)entity;
            craftFallingBlock.getHandle().b = ticks;
        } else if (entity instanceof CraftItem) {
            CraftItem craftItem = (CraftItem)entity;
            ((EntityItem)craftItem.getHandle()).g = ticks;
        } else if (entity instanceof CraftExperienceOrb) {
            CraftExperienceOrb craftExperienceOrb = (CraftExperienceOrb)entity;
            try {
                EXPERIENCE_ORB_AGE.setInt(craftExperienceOrb.getHandle(), ticks);
            }
            catch (Throwable ex) {
                Debug.echoError((Throwable)ex);
            }
        }
    }

    public void setHeadAngle(LivingEntity entity, float angle) {
        ((CraftLivingEntity)entity).getHandle().n(angle);
    }

    public void setEndermanAngry(Enderman enderman, boolean angry) {
        ((CraftEnderman)enderman).getHandle().al().b(ENDERMAN_DATA_ACCESSOR_SCREAMING, (Object)angry);
    }

    public static DamageSources getReusableDamageSources() {
        if (backupDamageSources == null) {
            backupDamageSources = ((CraftWorld)Bukkit.getWorlds().get(0)).getHandle().ag();
        }
        return backupDamageSources;
    }

    public static DamageSource getSourceFor(net.minecraft.world.entity.Entity nmsSource, EntityDamageEvent.DamageCause cause, net.minecraft.world.entity.Entity nmsSourceProvider) {
        DamageSources sources = nmsSourceProvider == null ? EntityHelperImpl.getReusableDamageSources() : nmsSourceProvider.dL().ag();
        DamageSource src = sources.n();
        if (nmsSource != null) {
            if (nmsSource instanceof EntityHuman) {
                EntityHuman nmsPlayer = (EntityHuman)nmsSource;
                src = nmsSource.dL().ag().a(nmsPlayer);
            } else if (nmsSource instanceof EntityLiving) {
                EntityLiving nmsLivingEntity = (EntityLiving)nmsSource;
                src = nmsSource.dL().ag().b(nmsLivingEntity);
            }
        }
        if (cause == null) {
            return src;
        }
        return switch (cause) {
            default -> throw new IncompatibleClassChangeError();
            case EntityDamageEvent.DamageCause.CONTACT -> sources.j();
            case EntityDamageEvent.DamageCause.ENTITY_ATTACK -> {
                EntityLiving nmsLivingEntity;
                yield sources.b(nmsSource instanceof EntityLiving ? (nmsLivingEntity = (EntityLiving)nmsSource) : null);
            }
            case EntityDamageEvent.DamageCause.ENTITY_SWEEP_ATTACK -> {
                if (src != sources.n()) {
                    yield src.sweep();
                }
                yield src;
            }
            case EntityDamageEvent.DamageCause.PROJECTILE -> {
                net.minecraft.world.entity.Entity v1;
                Projectile projectile;
                CraftEntity var7_7;
                if (nmsSource != null && (var7_7 = nmsSource.getBukkitEntity()) instanceof Projectile && (var7_7 = (projectile = (Projectile)var7_7).getShooter()) instanceof CraftEntity) {
                    CraftEntity shooter = var7_7;
                    v1 = shooter.getHandle();
                } else {
                    v1 = null;
                }
                yield sources.b(nmsSource, v1);
            }
            case EntityDamageEvent.DamageCause.SUFFOCATION -> sources.f();
            case EntityDamageEvent.DamageCause.FALL -> sources.k();
            case EntityDamageEvent.DamageCause.FIRE -> sources.a();
            case EntityDamageEvent.DamageCause.FIRE_TICK -> sources.c();
            case EntityDamageEvent.DamageCause.MELTING -> sources.melting;
            case EntityDamageEvent.DamageCause.LAVA -> sources.d();
            case EntityDamageEvent.DamageCause.DROWNING -> sources.h();
            case EntityDamageEvent.DamageCause.BLOCK_EXPLOSION -> {
                if (nmsSource instanceof EntityTNTPrimed) {
                    EntityTNTPrimed primedTnt = (EntityTNTPrimed)nmsSource;
                    yield sources.d((net.minecraft.world.entity.Entity)primedTnt, (net.minecraft.world.entity.Entity)primedTnt.q());
                }
                yield sources.a(null);
            }
            case EntityDamageEvent.DamageCause.ENTITY_EXPLOSION -> sources.d(nmsSource, null);
            case EntityDamageEvent.DamageCause.VOID -> sources.m();
            case EntityDamageEvent.DamageCause.LIGHTNING -> sources.b();
            case EntityDamageEvent.DamageCause.STARVATION -> sources.i();
            case EntityDamageEvent.DamageCause.POISON -> sources.poison;
            case EntityDamageEvent.DamageCause.MAGIC -> sources.o();
            case EntityDamageEvent.DamageCause.WITHER -> sources.p();
            case EntityDamageEvent.DamageCause.FALLING_BLOCK -> sources.a(nmsSource);
            case EntityDamageEvent.DamageCause.THORNS -> sources.d(nmsSource);
            case EntityDamageEvent.DamageCause.DRAGON_BREATH -> sources.q();
            case EntityDamageEvent.DamageCause.CUSTOM -> sources.n();
            case EntityDamageEvent.DamageCause.FLY_INTO_WALL -> sources.l();
            case EntityDamageEvent.DamageCause.HOT_FLOOR -> sources.e();
            case EntityDamageEvent.DamageCause.CRAMMING -> sources.g();
            case EntityDamageEvent.DamageCause.DRYOUT -> sources.r();
            case EntityDamageEvent.DamageCause.FREEZE -> sources.t();
            case EntityDamageEvent.DamageCause.SONIC_BOOM -> sources.e(nmsSource);
            case EntityDamageEvent.DamageCause.WORLD_BORDER -> sources.v();
            case EntityDamageEvent.DamageCause.KILL -> sources.w();
            case EntityDamageEvent.DamageCause.SUICIDE -> new FakeDamageSrc(src);
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void damage(LivingEntity target, float amount, EntityTag source, Location sourceLoc, EntityDamageEvent.DamageCause cause) {
        net.minecraft.world.entity.Entity nmsSource;
        if (target == null) {
            return;
        }
        EntityLiving nmsTarget = ((CraftLivingEntity)target).getHandle();
        CraftEventFactory.entityDamage = nmsSource = source == null ? null : ((CraftEntity)source.getBukkitEntity()).getHandle();
        CraftEventFactory.blockDamage = sourceLoc == null ? null : sourceLoc.getBlock();
        try {
            DamageSource src = EntityHelperImpl.getSourceFor(nmsSource, cause, (net.minecraft.world.entity.Entity)nmsTarget);
            if (src instanceof FakeDamageSrc) {
                FakeDamageSrc fakeDamageSrc = (FakeDamageSrc)src;
                src = fakeDamageSrc.real;
                if (EntityHelperImpl.fireFakeDamageEvent((Entity)target, (EntityTag)source, (Location)sourceLoc, (EntityDamageEvent.DamageCause)cause, (float)amount).isCancelled()) {
                    return;
                }
            }
            nmsTarget.a(src, amount);
        }
        finally {
            CraftEventFactory.entityDamage = null;
            CraftEventFactory.blockDamage = null;
        }
    }

    public void setLastHurtBy(LivingEntity mob, LivingEntity damager) {
        ((CraftLivingEntity)mob).getHandle().a(((CraftLivingEntity)damager).getHandle());
    }

    public void setFallingBlockType(FallingBlock fallingBlock, BlockData block) {
        IBlockData state = ((CraftBlockData)block).getState();
        EntityFallingBlock nmsEntity = ((CraftFallingBlock)fallingBlock).getHandle();
        try {
            FALLINGBLOCK_BLOCK_STATE.set(nmsEntity, state);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public EntityTag getMobSpawnerDisplayEntity(CreatureSpawner spawner) {
        TileEntityMobSpawner nmsSpawner = (TileEntityMobSpawner)BlockHelperImpl.getTE((CraftCreatureSpawner)spawner);
        WorldServer level = ((CraftWorld)spawner.getWorld()).getHandle();
        net.minecraft.world.entity.Entity nmsEntity = nmsSpawner.d().a((net.minecraft.world.level.World)level, level.z, nmsSpawner.p());
        return new EntityTag((Entity)nmsEntity.getBukkitEntity());
    }

    public int getInWaterTime(Zombie zombie) {
        try {
            return ZOMBIE_INWATERTIME.getInt(((CraftZombie)zombie).getHandle());
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
            return 0;
        }
    }

    public void setInWaterTime(Zombie zombie, int ticks) {
        try {
            ZOMBIE_INWATERTIME.setInt(((CraftZombie)zombie).getHandle(), ticks);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void setTrackingRange(Entity entity, int range) {
        try {
            PlayerChunkMap map = ((CraftWorld)entity.getWorld()).getHandle().k().a;
            PlayerChunkMap.EntityTracker entry = (PlayerChunkMap.EntityTracker)map.K.get(entity.getEntityId());
            if (entry != null) {
                TRACKING_RANGE_SETTER.invoke(entry, range);
            }
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public boolean isAggressive(Mob mob) {
        return ((CraftMob)mob).getHandle().fV();
    }

    public void setAggressive(Mob mob, boolean aggressive) {
        ((CraftMob)mob).getHandle().v(aggressive);
    }

    public void setUUID(Entity entity, UUID id) {
        try {
            EntityPlayer nmsPlayer;
            net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
            nmsEntity.aa();
            nmsEntity.cP().forEach(net.minecraft.world.entity.Entity::aa);
            net.minecraft.world.level.World level = nmsEntity.dL();
            DedicatedPlayerList playerList = ((CraftServer)Bukkit.getServer()).getHandle();
            if (nmsEntity instanceof EntityPlayer) {
                nmsPlayer = (EntityPlayer)nmsEntity;
                PLAYERLIST_REMOVE.invoke(playerList, nmsPlayer);
            } else {
                nmsEntity.a(Entity.RemovalReason.b);
            }
            nmsEntity.dI();
            nmsEntity.a_(id);
            if (nmsEntity instanceof EntityPlayer) {
                nmsPlayer = (EntityPlayer)nmsEntity;
                playerList.a(DenizenNetworkManagerImpl.getConnection(nmsPlayer), nmsPlayer, new CommonListenerCookie(nmsPlayer.fQ(), nmsPlayer.c.l(), nmsPlayer.z()));
            } else {
                level.b(nmsEntity);
            }
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public float getStepHeight(Entity entity) {
        return ((CraftEntity)entity).getHandle().dF();
    }

    public void setStepHeight(Entity entity, float stepHeight) {
        ((CraftEntity)entity).getHandle().t(stepHeight);
    }

    public int mapInternalEntityDataName(Entity entity, String name) {
        return EntityDataNameMapper.getIdForName(((CraftEntity)entity).getHandle().getClass(), name);
    }

    public void modifyInternalEntityData(Entity entity, Map<Integer, ObjectTag> internalData) {
        DataWatcher nmsEntityData = ((CraftEntity)entity).getHandle().al();
        Int2ObjectMap dataItemsById = (Int2ObjectMap)ReflectionHelper.getFieldValue(DataWatcher.class, (String)ReflectionMappingsInfo.SynchedEntityData_itemsById, (Object)nmsEntityData);
        for (Map.Entry<Integer, ObjectTag> entry : internalData.entrySet()) {
            DataWatcher.Item dataItem = (DataWatcher.Item)dataItemsById.get(entry.getKey().intValue());
            if (dataItem == null) {
                Debug.echoError((String)("Invalid internal data id '" + entry.getKey() + "': couldn't be matched to any internal data for entity of type '" + entity.getType() + "'."));
                continue;
            }
            Object converted = ReflectionSetCommand.convertObjectTypeFor(dataItem.b().getClass(), (ObjectTag)entry.getValue());
            if (converted == null) continue;
            nmsEntityData.b(dataItem.a(), converted);
        }
    }

    static {
        FALLINGBLOCK_BLOCK_STATE = ReflectionHelper.getFields(EntityFallingBlock.class).getFirstOfType(IBlockData.class);
        ZOMBIE_INWATERTIME = ReflectionHelper.getFields(EntityZombie.class).get(ReflectionMappingsInfo.Zombie_inWaterTime, Integer.TYPE);
        TRACKING_RANGE_SETTER = ReflectionHelper.getFinalSetterForFirstOfType(PlayerChunkMap.EntityTracker.class, Integer.TYPE);
        PLAYERLIST_REMOVE = ReflectionHelper.getMethodHandle(PlayerList.class, (String)"remove", (Class[])new Class[]{EntityPlayer.class});
    }

    public static class FakeDamageSrc
    extends DamageSource {
        public DamageSource real;

        public FakeDamageSrc(DamageSource src) {
            super(null);
            this.real = src;
        }
    }
}

