/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_20.impl;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.abstracts.BiomeNMS;
import com.denizenscript.denizen.nms.v1_20.ReflectionMappingsInfo;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_20_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R2.util.CraftLocation;
import org.bukkit.entity.EntityType;

public class BiomeNMSImpl
extends BiomeNMS {
    public static final MethodHandle BIOME_CLIMATESETTINGS_CONSTRUCTOR = ReflectionHelper.getConstructor(cqt.b.class, (Class[])new Class[]{Boolean.TYPE, Float.TYPE, cqt.d.class, Float.TYPE});
    public he<cqt> biomeHolder;
    public akq world;

    public BiomeNMSImpl(akq world, String name) {
        super((World)world.getWorld(), name);
        this.world = world;
        this.biomeHolder = world.G_().d(jc.ap).b(aev.a((aev)jc.ap, (aew)new aew(name))).orElse(null);
    }

    public BiomeNMS.DownfallType getDownfallTypeAt(Location location) {
        cqt.c precipitation = ((cqt)this.biomeHolder.a()).a(CraftLocation.toBlockPosition((Location)location));
        return switch (precipitation) {
            default -> throw new IncompatibleClassChangeError();
            case cqt.c.b -> BiomeNMS.DownfallType.RAIN;
            case cqt.c.c -> BiomeNMS.DownfallType.SNOW;
            case cqt.c.a -> BiomeNMS.DownfallType.NONE;
        };
    }

    public float getHumidity() {
        return ((cqt)this.biomeHolder.a()).i.d();
    }

    public float getBaseTemperature() {
        return ((cqt)this.biomeHolder.a()).g();
    }

    public float getTemperatureAt(Location location) {
        return ((cqt)this.biomeHolder.a()).f(CraftLocation.toBlockPosition((Location)location));
    }

    public boolean hasDownfall() {
        return ((cqt)this.biomeHolder.a()).c();
    }

    public List<EntityType> getAmbientEntities() {
        return this.getSpawnableEntities(bjj.c);
    }

    public List<EntityType> getCreatureEntities() {
        return this.getSpawnableEntities(bjj.b);
    }

    public List<EntityType> getMonsterEntities() {
        return this.getSpawnableEntities(bjj.a);
    }

    public List<EntityType> getWaterEntities() {
        return this.getSpawnableEntities(bjj.f);
    }

    public int getFoliageColor() {
        if (((cqt)this.biomeHolder.a()).f() != 0) {
            return ((cqt)this.biomeHolder.a()).f();
        }
        float temperature = this.clampColor(this.getBaseTemperature());
        float humidity = this.clampColor(this.getHumidity());
        int temperatureValue = (int)((1.0f - temperature) * 255.0f);
        int humidityValue = (int)((1.0f - (humidity *= temperature)) * 255.0f);
        int index = temperatureValue << 8 | humidityValue;
        return index >= 65536 ? 4764952 : this.getColor(index / 256, index % 256).asRGB();
    }

    public void setClimate(boolean hasPrecipitation, float temperature, cqt.d temperatureModifier, float downfall) {
        try {
            Object newClimate = BIOME_CLIMATESETTINGS_CONSTRUCTOR.invoke(hasPrecipitation, temperature, temperatureModifier, downfall);
            ReflectionHelper.setFieldValue(cqt.class, (String)ReflectionMappingsInfo.Biome_climateSettings, (Object)this.biomeHolder.a(), (Object)newClimate);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void setHumidity(float humidity) {
        this.setClimate(this.hasDownfall(), this.getBaseTemperature(), this.getTemperatureModifier(), humidity);
    }

    public void setBaseTemperature(float baseTemperature) {
        this.setClimate(this.hasDownfall(), baseTemperature, this.getTemperatureModifier(), this.getHumidity());
    }

    public void setHasDownfall(boolean hasDownfall) {
        this.setClimate(hasDownfall, this.getBaseTemperature(), this.getTemperatureModifier(), this.getHumidity());
    }

    public void setFoliageColor(int color) {
        ReflectionHelper.setFieldValue(cqz.class, (String)ReflectionMappingsInfo.BiomeSpecialEffects_foliageColorOverride, (Object)((cqt)this.biomeHolder.a()).h(), Optional.of(color));
    }

    public int getFogColor() {
        return ((cqt)this.biomeHolder.a()).e();
    }

    public void setFogColor(int color) {
        ReflectionHelper.setFieldValue(cqz.class, (String)ReflectionMappingsInfo.BiomeSpecialEffects_fogColor, (Object)((cqt)this.biomeHolder.a()).h(), (Object)color);
    }

    public int getWaterFogColor() {
        return ((cqt)this.biomeHolder.a()).j();
    }

    public void setWaterFogColor(int color) {
        ReflectionHelper.setFieldValue(cqz.class, (String)ReflectionMappingsInfo.BiomeSpecialEffects_waterFogColor, (Object)((cqt)this.biomeHolder.a()).h(), (Object)color);
    }

    private List<EntityType> getSpawnableEntities(bjj creatureType) {
        crf mobs = ((cqt)this.biomeHolder.a()).b();
        bfm typeSettingList = mobs.a(creatureType);
        ArrayList<EntityType> entityTypes = new ArrayList<EntityType>();
        if (typeSettingList == null) {
            return entityTypes;
        }
        for (crf.c meta : typeSettingList.e()) {
            try {
                String n = biu.a((biu)meta.b).a();
                EntityType et = EntityType.fromName((String)n);
                if (et == null) {
                    et = EntityType.valueOf((String)n.toUpperCase(Locale.ENGLISH));
                }
                entityTypes.add(et);
            }
            catch (Throwable throwable) {}
        }
        return entityTypes;
    }

    public void setTo(Block block) {
        dhq chunk;
        if (((CraftWorld)block.getWorld()).getHandle() != this.world) {
            NMSHandler.instance.getBiomeNMS(block.getWorld(), this.getName()).setTo(block);
            return;
        }
        gw pos = new gw(block.getX(), 0, block.getZ());
        if (this.world.A(pos) && (chunk = this.world.l(pos)) != null) {
            chunk.setBiome(block.getX() >> 2, block.getY() >> 2, block.getZ() >> 2, this.biomeHolder);
            chunk.a(true);
        }
    }

    public cqt.d getTemperatureModifier() {
        return ((cqt)this.biomeHolder.a()).i.c();
    }
}

