/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_20.helpers;

import com.denizenscript.denizen.nms.interfaces.BlockHelper;
import com.denizenscript.denizen.nms.util.PlayerProfile;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTagBuilder;
import com.denizenscript.denizen.nms.v1_20.ReflectionMappingsInfo;
import com.denizenscript.denizen.nms.v1_20.helpers.PacketHelperImpl;
import com.denizenscript.denizen.nms.v1_20.impl.ProfileEditorImpl;
import com.denizenscript.denizen.nms.v1_20.impl.jnbt.CompoundTagImpl;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.VanillaTagHelper;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Instrument;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.Skull;
import org.bukkit.craftbukkit.v1_20_R2.CraftChunk;
import org.bukkit.craftbukkit.v1_20_R2.CraftServer;
import org.bukkit.craftbukkit.v1_20_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R2.block.CraftBlock;
import org.bukkit.craftbukkit.v1_20_R2.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_20_R2.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_20_R2.block.CraftCreatureSpawner;
import org.bukkit.craftbukkit.v1_20_R2.block.CraftSkull;
import org.bukkit.craftbukkit.v1_20_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R2.tag.CraftBlockTag;
import org.bukkit.craftbukkit.v1_20_R2.util.CraftLocation;
import org.bukkit.craftbukkit.v1_20_R2.util.CraftMagicNumbers;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class BlockHelperImpl
implements BlockHelper {
    public static final Field craftBlockEntityState_tileEntity = ReflectionHelper.getFields(CraftBlockEntityState.class).get((Object)"tileEntity");
    public static final Field craftBlockEntityState_snapshot = ReflectionHelper.getFields(CraftBlockEntityState.class).get((Object)"snapshot");
    public static final Field craftSkull_profile = ReflectionHelper.getFields(CraftSkull.class).get((Object)"profile");
    public static final MethodHandle CRAFTBLOCKSTATE_CONSTRUCTOR = ReflectionHelper.getConstructor(CraftBlockState.class, (Class[])new Class[]{Block.class});
    public static final MethodHandle MATERIAL_PUSH_REACTION_SETTER = ReflectionHelper.getFinalSetterForFirstOfType(dfi.a.class, ear.class);
    public static final MethodHandle BLOCK_STRENGTH_SETTER = ReflectionHelper.getFinalSetterForFirstOfType(dfi.a.class, Float.TYPE);
    public static final MethodHandle HOLDERSET_NAMED_BIND = ReflectionHelper.getMethodHandle(hi.c.class, (String)ReflectionMappingsInfo.HolderSetNamed_bind_method, (Class[])new Class[]{List.class});
    public static final MethodHandle HOLDER_REFERENCE_BINDTAGS = ReflectionHelper.getMethodHandle(he.c.class, (String)ReflectionMappingsInfo.HolderReference_bindTags_method, (Class[])new Class[]{Collection.class});

    public void makeBlockStateRaw(BlockState state) {
        try {
            craftBlockEntityState_snapshot.set(state, craftBlockEntityState_tileEntity.get(state));
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void applyPhysics(Location location) {
        ((CraftWorld)location.getWorld()).getHandle().a(CraftLocation.toBlockPosition((Location)location), CraftMagicNumbers.getBlock((Material)location.getBlock().getType()));
    }

    public static <T extends dcv> T getTE(CraftBlockEntityState<T> cbs) {
        try {
            return (T)((dcv)craftBlockEntityState_tileEntity.get(cbs));
        }
        catch (IllegalAccessException e) {
            Debug.echoError((Throwable)e);
            return null;
        }
    }

    public PlayerProfile getPlayerProfile(Skull skull) {
        GameProfile profile = ((def)BlockHelperImpl.getTE((CraftSkull)skull)).g;
        if (profile == null) {
            return null;
        }
        String name = profile.getName();
        UUID id = profile.getId();
        Property property = (Property)Iterables.getFirst((Iterable)profile.getProperties().get((Object)"textures"), null);
        return new PlayerProfile(name, id, property != null ? property.value() : null);
    }

    public void setPlayerProfile(Skull skull, PlayerProfile playerProfile) {
        GameProfile gameProfile = ProfileEditorImpl.getGameProfile(playerProfile);
        try {
            craftSkull_profile.set(skull, gameProfile);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
        skull.update();
    }

    public CompoundTag getNbtData(Block block) {
        dcv te = ((CraftWorld)block.getWorld()).getHandle().getBlockEntity(new gw(block.getX(), block.getY(), block.getZ()), true);
        if (te != null) {
            qw compound = te.m();
            return CompoundTagImpl.fromNMSTag(compound);
        }
        return null;
    }

    public void setNbtData(Block block, CompoundTag ctag) {
        CompoundTagBuilder builder = ctag.createBuilder();
        builder.putInt("x", block.getX());
        builder.putInt("y", block.getY());
        builder.putInt("z", block.getZ());
        ctag = builder.build();
        gw blockPos = new gw(block.getX(), block.getY(), block.getZ());
        dcv te = ((CraftWorld)block.getWorld()).getHandle().getBlockEntity(blockPos, true);
        te.a(((CompoundTagImpl)ctag).toNMSTag());
    }

    public boolean setBlockResistance(Material material, float resistance) {
        csv block = CraftMagicNumbers.getBlock((Material)material);
        if (block == null) {
            return false;
        }
        ReflectionHelper.setFieldValue(dfi.class, (String)ReflectionMappingsInfo.BlockBehaviour_explosionResistance, (Object)block, (Object)Float.valueOf(resistance));
        return true;
    }

    public float getBlockResistance(Material material) {
        csv block = CraftMagicNumbers.getBlock((Material)material);
        if (block == null) {
            return 0.0f;
        }
        return ((Float)ReflectionHelper.getFieldValue(dfi.class, (String)ReflectionMappingsInfo.BlockBehaviour_explosionResistance, (Object)block)).floatValue();
    }

    public BlockState generateBlockState(Block block, Material mat) {
        try {
            CraftBlockState state = CRAFTBLOCKSTATE_CONSTRUCTOR.invoke(block);
            state.setData(this.getMaterialBlockState(mat));
            return state;
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
            return null;
        }
    }

    public dfj getMaterialBlockState(Material bukkitMaterial) {
        csv nmsBlock = CraftMagicNumbers.getBlock((Material)bukkitMaterial);
        return nmsBlock != null ? nmsBlock.n() : null;
    }

    public void setPushReaction(Material mat, BlockHelper.PistonPushReaction reaction) {
        try {
            MATERIAL_PUSH_REACTION_SETTER.invoke(this.getMaterialBlockState(mat), ear.values()[reaction.ordinal()]);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public float getBlockStrength(Material mat) {
        return this.getMaterialBlockState((Material)mat).n;
    }

    public void setBlockStrength(Material mat, float strength) {
        try {
            BLOCK_STRENGTH_SETTER.invoke(this.getMaterialBlockState(mat), strength);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void doRandomTick(Location location) {
        eam fluid;
        gw pos = CraftLocation.toBlockPosition((Location)location);
        dhf nmsChunk = ((CraftChunk)location.getChunk()).getHandle(dhk.n);
        dfj nmsBlock = nmsChunk.a_(pos);
        akq nmsWorld = ((CraftWorld)location.getWorld()).getHandle();
        if (nmsBlock.v()) {
            nmsBlock.b(nmsWorld, pos, nmsWorld.z);
        }
        if ((fluid = nmsBlock.u()).f()) {
            fluid.a((cpv)nmsWorld, pos, nmsWorld.z);
        }
    }

    public Instrument getInstrumentFor(Material mat) {
        return Instrument.values()[this.getMaterialBlockState(mat).A().ordinal()];
    }

    public int getExpDrop(Block block, ItemStack item) {
        csv blockType = CraftMagicNumbers.getBlock((Material)block.getType());
        if (blockType == null) {
            return 0;
        }
        return blockType.getExpDrop(((CraftBlock)block).getNMS(), ((CraftBlock)block).getCraftWorld().getHandle(), ((CraftBlock)block).getPosition(), item == null ? null : CraftItemStack.asNMSCopy((ItemStack)item), true);
    }

    public void setSpawnerSpawnedType(CreatureSpawner spawner, EntityTag entity) {
        spawner.setSpawnedType(entity.getBukkitEntityType());
        if (entity.getWaitingMechanisms() == null || entity.getWaitingMechanisms().size() == 0) {
            return;
        }
        try {
            biq nmsEntity = ((CraftWorld)spawner.getWorld()).createEntity(spawner.getLocation(), entity.getBukkitEntityType().getEntityClass());
            EntityTag entityTag = new EntityTag((Entity)nmsEntity.getBukkitEntity());
            entityTag.isFake = true;
            entityTag.isFakeValid = true;
            for (Mechanism mechanism : entity.getWaitingMechanisms()) {
                entityTag.safeAdjustDuplicate(mechanism);
            }
            nmsEntity.dI();
            CraftCreatureSpawner bukkitSpawner = (CraftCreatureSpawner)spawner;
            deh nmsSnapshot = (deh)craftBlockEntityState_snapshot.get(bukkitSpawner);
            cox nmsSpawner = nmsSnapshot.d();
            cqm toSpawn = nmsSpawner.f;
            qw tag = toSpawn.a();
            nmsEntity.f(tag);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void setSpawnerCustomRules(CreatureSpawner spawner, int skyMin, int skyMax, int blockMin, int blockMax) {
        try {
            CraftCreatureSpawner bukkitSpawner = (CraftCreatureSpawner)spawner;
            deh nmsSnapshot = (deh)craftBlockEntityState_snapshot.get(bukkitSpawner);
            cox nmsSpawner = nmsSnapshot.d();
            cqm toSpawn = nmsSpawner.f;
            cqm.a rules = skyMin == -1 ? null : new cqm.a(new arp((Comparable)Integer.valueOf(skyMin), (Comparable)Integer.valueOf(skyMax)), new arp((Comparable)Integer.valueOf(blockMin), (Comparable)Integer.valueOf(blockMax)));
            nmsSpawner.f = new cqm(toSpawn.c(), Optional.ofNullable(rules));
            nmsSpawner.e = bfi.b();
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public Color getMapColor(Block block) {
        CraftBlock craftBlock = (CraftBlock)block;
        return Color.fromRGB((int)craftBlock.getNMS().d((cpb)craftBlock.getHandle(), (gw)craftBlock.getPosition()).ak);
    }

    public void setVanillaTags(Material material, Set<String> tags) {
        he.c nmsHolder = CraftMagicNumbers.getBlock((Material)material).q();
        nmsHolder.c().forEach(arg_0 -> BlockHelperImpl.lambda$setVanillaTags$0((he)nmsHolder, arg_0));
        ArrayList<aqh> newNmsTags = new ArrayList<aqh>();
        for (String tag : tags) {
            aqh newNmsTag = aqh.a((aev)jb.f.c(), (aew)new aew(tag));
            hi.c nmsHolderSet = jb.f.a(newNmsTag);
            List nmsHolders = nmsHolderSet.a().collect(Collectors.toCollection(ArrayList::new));
            nmsHolders.add(nmsHolder);
            try {
                HOLDERSET_NAMED_BIND.invoke(nmsHolderSet, nmsHolders);
            }
            catch (Throwable ex) {
                Debug.echoError((Throwable)ex);
            }
            newNmsTags.add(newNmsTag);
            VanillaTagHelper.addOrUpdateMaterialTag((Tag)new CraftBlockTag((hq)jb.f, newNmsTag));
        }
        try {
            HOLDER_REFERENCE_BINDTAGS.invoke((he)nmsHolder, newNmsTags);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
        vm tagsPacket = new vm(aqk.a((hl)((CraftServer)Bukkit.getServer()).getServer().aV()));
        for (Player player : Bukkit.getOnlinePlayers()) {
            PacketHelperImpl.send(player, tagsPacket);
        }
    }

    private static /* synthetic */ void lambda$setVanillaTags$0(he nmsHolder, aqh nmsTag) {
        hi.c nmsHolderSet = jb.f.b(nmsTag).orElse(null);
        if (nmsHolderSet == null) {
            return;
        }
        List nmsHolders = nmsHolderSet.a().collect(Collectors.toCollection(ArrayList::new));
        nmsHolders.remove(nmsHolder);
        try {
            HOLDERSET_NAMED_BIND.invoke(nmsHolderSet, nmsHolders);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
        VanillaTagHelper.updateMaterialTag((Tag)new CraftBlockTag((hq)jb.f, nmsTag));
    }
}

