/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_20.helpers;

import com.denizenscript.denizen.nms.interfaces.ItemHelper;
import com.denizenscript.denizen.nms.util.PlayerProfile;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.util.jnbt.IntArrayTag;
import com.denizenscript.denizen.nms.util.jnbt.Tag;
import com.denizenscript.denizen.nms.v1_20.ReflectionMappingsInfo;
import com.denizenscript.denizen.nms.v1_20.impl.ProfileEditorImpl;
import com.denizenscript.denizen.nms.v1_20.impl.jnbt.CompoundTagImpl;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.utilities.FormattedTextHelper;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_20_R2.CraftServer;
import org.bukkit.craftbukkit.v1_20_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R2.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_20_R2.inventory.CraftInventoryPlayer;
import org.bukkit.craftbukkit.v1_20_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R2.inventory.CraftRecipe;
import org.bukkit.craftbukkit.v1_20_R2.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_20_R2.util.CraftNamespacedKey;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;

public class ItemHelperImpl
extends ItemHelper {
    public static Field RECIPE_MANAGER_BY_NAME = ReflectionHelper.getFields(cml.class).get(ReflectionMappingsInfo.RecipeManager_byName, Map.class);
    public static Class<?> PaperPotionMix_CLASS = null;
    public static Map<NamespacedKey, ItemHelper.BrewingRecipe> customBrewingRecipes = null;

    public static cmk<?> getNMSRecipe(NamespacedKey key) {
        aew nmsKey = CraftNamespacedKey.toMinecraft((NamespacedKey)key);
        for (Object2ObjectLinkedOpenHashMap recipeMap : ((CraftServer)Bukkit.getServer()).getServer().aE().c.values()) {
            cmk recipe = (cmk)recipeMap.get((Object)nmsKey);
            if (recipe == null) continue;
            return recipe;
        }
        return null;
    }

    public void setMaxStackSize(Material material, int size) {
        try {
            ReflectionHelper.getFinalSetter(Material.class, (String)"maxStack").invoke(material, size);
            ReflectionHelper.getFinalSetter(cja.class, (String)ReflectionMappingsInfo.Item_maxStackSize).invoke((cja)jb.i.a(CraftNamespacedKey.toMinecraft((NamespacedKey)material.getKey())), size);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public Integer burnTime(Material material) {
        return (Integer)dck.f().get(CraftMagicNumbers.getItem((Material)material));
    }

    public void clearDenizenRecipes() {
        Map byName;
        cml recipeManager = ((CraftServer)Bukkit.getServer()).getServer().aE();
        try {
            byName = (Map)RECIPE_MANAGER_BY_NAME.get(recipeManager);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
            return;
        }
        for (Object2ObjectLinkedOpenHashMap recipeMap : recipeManager.c.values()) {
            for (aew key : new ArrayList(recipeMap.keySet())) {
                if (!key.b().equalsIgnoreCase("denizen")) continue;
                recipeMap.remove((Object)key);
                byName.remove(key);
            }
        }
    }

    public void setShapedRecipeIngredient(ShapedRecipe recipe, char c2, ItemStack[] item, boolean exact) {
        if (item.length == 1 && item[0].getType() == Material.AIR) {
            recipe.setIngredient(c2, (RecipeChoice)new RecipeChoice.MaterialChoice(Material.AIR));
        } else if (exact) {
            recipe.setIngredient(c2, (RecipeChoice)new RecipeChoice.ExactChoice(item));
        } else {
            Material[] mats = new Material[item.length];
            for (int i = 0; i < item.length; ++i) {
                mats[i] = item[i].getType();
            }
            recipe.setIngredient(c2, (RecipeChoice)new RecipeChoice.MaterialChoice(mats));
        }
    }

    public static cmg itemArrayToRecipe(ItemStack[] items, boolean exact) {
        cmg.a[] stacks = new cmg.a[items.length];
        for (int i = 0; i < items.length; ++i) {
            stacks[i] = new cmg.a(CraftItemStack.asNMSCopy((ItemStack)items[i]));
        }
        cmg itemRecipe = new cmg(Arrays.stream(stacks));
        itemRecipe.exact = exact;
        return itemRecipe;
    }

    public void registerFurnaceRecipe(String keyName, String group, ItemStack result, ItemStack[] ingredient, float exp, int time, String type, boolean exact, String category) {
        clx categoryValue;
        aew key = new aew("denizen", keyName);
        cmg itemRecipe = ItemHelperImpl.itemArrayToRecipe(ingredient, exact);
        clx clx2 = categoryValue = category == null ? clx.c : clx.valueOf((String)CoreUtilities.toUpperCase((String)category));
        Object recipe = type.equalsIgnoreCase("smoker") ? new cna(group, categoryValue, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result), exp, time) : (type.equalsIgnoreCase("blast") ? new clu(group, categoryValue, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result), exp, time) : (type.equalsIgnoreCase("campfire") ? new clw(group, categoryValue, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result), exp, time) : new cmw(group, categoryValue, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result), exp, time)));
        cmk holder = new cmk(key, (cmj)recipe);
        ((CraftServer)Bukkit.getServer()).getServer().aE().addRecipe(holder);
    }

    public void registerStonecuttingRecipe(String keyName, String group, ItemStack result, ItemStack[] ingredient, boolean exact) {
        aew key = new aew("denizen", keyName);
        cmg itemRecipe = ItemHelperImpl.itemArrayToRecipe(ingredient, exact);
        cnb recipe = new cnb(group, itemRecipe, CraftItemStack.asNMSCopy((ItemStack)result));
        cmk holder = new cmk(key, (cmj)recipe);
        ((CraftServer)Bukkit.getServer()).getServer().aE().addRecipe(holder);
    }

    public void registerSmithingRecipe(String keyName, ItemStack result, ItemStack[] baseItem, boolean baseExact, ItemStack[] upgradeItem, boolean upgradeExact, ItemStack[] templateItem, boolean templateExact) {
        aew key = new aew("denizen", keyName);
        cmg templateItemRecipe = ItemHelperImpl.itemArrayToRecipe(templateItem, templateExact);
        cmg baseItemRecipe = ItemHelperImpl.itemArrayToRecipe(baseItem, baseExact);
        cmg upgradeItemRecipe = ItemHelperImpl.itemArrayToRecipe(upgradeItem, upgradeExact);
        cmy recipe = new cmy(templateItemRecipe, baseItemRecipe, upgradeItemRecipe, CraftItemStack.asNMSCopy((ItemStack)result));
        cmk holder = new cmk(key, (cmj)recipe);
        ((CraftServer)Bukkit.getServer()).getServer().aE().addRecipe(holder);
    }

    public void registerShapelessRecipe(String keyName, String group, ItemStack result, List<ItemStack[]> ingredients, boolean[] exact, String category) {
        aew key = new aew("denizen", keyName);
        ArrayList<cmg> ingredientList = new ArrayList<cmg>();
        cly categoryValue = category == null ? cly.d : cly.valueOf((String)CoreUtilities.toUpperCase((String)category));
        for (int i = 0; i < ingredients.size(); ++i) {
            ingredientList.add(ItemHelperImpl.itemArrayToRecipe(ingredients.get(i), exact[i]));
        }
        cmq recipe = new cmq(group, categoryValue, CraftItemStack.asNMSCopy((ItemStack)result), hn.a(null, (Object[])ingredientList.toArray(new cmg[0])));
        cmk holder = new cmk(key, (cmj)recipe);
        ((CraftServer)Bukkit.getServer()).getServer().aE().addRecipe(holder);
    }

    public String getJsonString(ItemStack itemStack) {
        String json = CraftItemStack.asNMSCopy((ItemStack)itemStack).J().a().toString().replace("\\", "\\\\").replace("\"", "\\\"");
        return json.substring(176, json.length() - 185);
    }

    public String getRawHoverText(ItemStack itemStack) {
        qw tag = CraftItemStack.asNMSCopy((ItemStack)itemStack).v();
        if (tag == null) {
            return null;
        }
        return tag.toString();
    }

    public PlayerProfile getSkullSkin(ItemStack is) {
        GameProfile profile;
        qw tag;
        cjf itemStack = CraftItemStack.asNMSCopy((ItemStack)is);
        if (itemStack.u() && (tag = itemStack.v()).b("SkullOwner", 10) && (profile = rj.a((qw)tag.p("SkullOwner"))) != null) {
            Property property = (Property)Iterables.getFirst((Iterable)profile.getProperties().get((Object)"textures"), null);
            return new PlayerProfile(profile.getName(), profile.getId(), property != null ? property.value() : null, property != null ? property.signature() : null);
        }
        return null;
    }

    public ItemStack setSkullSkin(ItemStack itemStack, PlayerProfile playerProfile) {
        GameProfile gameProfile = ProfileEditorImpl.getGameProfile(playerProfile);
        cjf nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        qw tag = nmsItemStack.u() ? nmsItemStack.v() : new qw();
        tag.a("SkullOwner", (rq)rj.a((qw)new qw(), (GameProfile)gameProfile));
        nmsItemStack.c(tag);
        return CraftItemStack.asBukkitCopy((cjf)nmsItemStack);
    }

    public ItemStack addNbtData(ItemStack itemStack, String key, Tag value) {
        cjf nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        qw tag = nmsItemStack.u() ? nmsItemStack.v() : new qw();
        CompoundTag compound = CompoundTagImpl.fromNMSTag(tag).createBuilder().put(key, value).build();
        nmsItemStack.c(((CompoundTagImpl)compound).toNMSTag());
        return CraftItemStack.asBukkitCopy((cjf)nmsItemStack);
    }

    public CompoundTag getNbtData(ItemStack itemStack) {
        cjf nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        if (nmsItemStack != null && nmsItemStack.u()) {
            return CompoundTagImpl.fromNMSTag(nmsItemStack.v());
        }
        return new CompoundTagImpl(new HashMap<String, Tag>());
    }

    public ItemStack setNbtData(ItemStack itemStack, CompoundTag compoundTag) {
        cjf nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        nmsItemStack.c(((CompoundTagImpl)compoundTag).toNMSTag());
        return CraftItemStack.asBukkitCopy((cjf)nmsItemStack);
    }

    public void setInventoryItem(Inventory inventory, ItemStack item, int slot) {
        if (inventory instanceof CraftInventoryPlayer && ((CraftInventoryPlayer)inventory).getInventory().m == null) {
            ((CraftInventoryPlayer)inventory).getInventory().a(slot, CraftItemStack.asNMSCopy((ItemStack)item));
        } else {
            inventory.setItem(slot, item);
        }
    }

    public IntArrayTag convertUuidToNbt(UUID id) {
        return new IntArrayTag(rj.a((UUID)id).g());
    }

    public UUID convertNbtToUuid(IntArrayTag id) {
        return rj.a((rq)new ra(id.getValue()));
    }

    public String getDisplayName(ItemTag item) {
        if (!item.getItemMeta().hasDisplayName()) {
            return null;
        }
        cjf nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item.getItemStack());
        String jsonText = ((qw)nmsItemStack.v().c("display")).l("Name");
        try {
            BaseComponent[] nameComponent = ComponentSerializer.parse((String)jsonText);
            return FormattedTextHelper.stringify((BaseComponent[])nameComponent);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
            return null;
        }
    }

    public List<String> getLore(ItemTag item) {
        if (!item.getItemMeta().hasLore()) {
            return null;
        }
        cjf nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item.getItemStack());
        rc list = ((qw)nmsItemStack.v().c("display")).c("Lore", 8);
        ArrayList<String> outList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            try {
                BaseComponent[] lineComponent = ComponentSerializer.parse((String)list.j(i));
                outList.add(FormattedTextHelper.stringify((BaseComponent[])lineComponent));
                continue;
            }
            catch (Throwable ex) {
                Debug.echoError((Throwable)ex);
            }
        }
        return outList;
    }

    public void setDisplayName(ItemTag item, String name) {
        cjf nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item.getItemStack());
        qw tag = nmsItemStack.w();
        qw display = tag.p("display");
        if (!tag.e("display")) {
            tag.a("display", (rq)display);
        }
        if (name == null || name.isEmpty()) {
            display.a("Name", null);
            return;
        }
        BaseComponent[] components = FormattedTextHelper.parse((String)name, (ChatColor)ChatColor.WHITE);
        display.a("Name", (rq)ro.a((String)FormattedTextHelper.componentToJson((BaseComponent[])components)));
        item.setItemStack(CraftItemStack.asBukkitCopy((cjf)nmsItemStack));
    }

    public void setLore(ItemTag item, List<String> lore) {
        cjf nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)item.getItemStack());
        qw tag = nmsItemStack.w();
        qw display = tag.p("display");
        if (!tag.e("display")) {
            tag.a("display", (rq)display);
        }
        if (lore == null || lore.isEmpty()) {
            display.r("Lore");
            if (display.g()) {
                tag.r("display");
            }
        } else {
            rc tagList = new rc();
            for (String line : lore) {
                tagList.add((Object)ro.a((String)FormattedTextHelper.componentToJson((BaseComponent[])FormattedTextHelper.parse((String)line, (ChatColor)ChatColor.WHITE))));
            }
            display.a("Lore", (rq)tagList);
        }
        item.setItemStack(CraftItemStack.asBukkitCopy((cjf)nmsItemStack));
    }

    public static dfj getCorrectStateForFluidBlock(cpv world, dfj blockState, gw blockPos) {
        eam fluid = blockState.u();
        return !fluid.c() && !blockState.d((cpb)world, blockPos, ha.b) ? fluid.g() : blockState;
    }

    public static void renderFullMap(ebw worldmap, int xMin, int zMin, int xMax, int zMax) {
        akq world = ((CraftWorld)worldmap.mapView.getWorld()).getHandle();
        int scale = 1 << worldmap.f;
        int mapX = worldmap.c;
        int mapZ = worldmap.d;
        for (int x = xMin; x < xMax; ++x) {
            double d0 = 0.0;
            for (int z = zMin; z < zMax; ++z) {
                eaq materialmapcolor;
                int k2 = (mapX / scale + x - 64) * scale;
                int l2 = (mapZ / scale + z - 64) * scale;
                LinkedHashMultiset multiset = LinkedHashMultiset.create();
                dhq chunk = world.l(new gw(k2, 0, l2));
                if (chunk.C()) continue;
                cpc chunkcoordintpair = chunk.f();
                int i3 = k2 & 0xF;
                int j3 = l2 & 0xF;
                int k3 = 0;
                double d1 = 0.0;
                if (world.C_().h()) {
                    int l3 = k2 + l2 * 231871;
                    if (((l3 = l3 * l3 * 31287121 + l3 * 11) >> 20 & 1) == 0) {
                        multiset.add((Object)csw.j.n().d((cpb)world, gw.b), 10);
                    } else {
                        multiset.add((Object)csw.b.n().d((cpb)world, gw.b), 100);
                    }
                    d1 = 100.0;
                } else {
                    gw.a blockposition_mutableblockposition = new gw.a();
                    gw.a blockposition_mutableblockposition1 = new gw.a();
                    for (int i4 = 0; i4 < scale; ++i4) {
                        for (int j4 = 0; j4 < scale; ++j4) {
                            dfj iblockdata;
                            int k4 = chunk.a(dks.a.b, i4 + i3, j4 + j3) + 1;
                            if (k4 <= world.H_() + 1) {
                                iblockdata = csw.F.n();
                            } else {
                                do {
                                    blockposition_mutableblockposition.d(chunkcoordintpair.d() + i4 + i3, --k4, chunkcoordintpair.e() + j4 + j3);
                                } while ((iblockdata = chunk.a_((gw)blockposition_mutableblockposition)).d((cpb)world, (gw)blockposition_mutableblockposition) == eaq.a && k4 > world.H_());
                                if (k4 > world.H_() && !iblockdata.u().c()) {
                                    dfj iblockdata1;
                                    int l4 = k4 - 1;
                                    blockposition_mutableblockposition1.g((hy)blockposition_mutableblockposition);
                                    do {
                                        blockposition_mutableblockposition1.q(l4--);
                                        iblockdata1 = chunk.a_((gw)blockposition_mutableblockposition1);
                                        ++k3;
                                    } while (l4 > world.H_() && !iblockdata1.u().c());
                                    iblockdata = ItemHelperImpl.getCorrectStateForFluidBlock((cpv)world, iblockdata, (gw)blockposition_mutableblockposition);
                                }
                            }
                            worldmap.a((cpb)world, chunkcoordintpair.d() + i4 + i3, chunkcoordintpair.e() + j4 + j3);
                            d1 += (double)k4 / (double)(scale * scale);
                            multiset.add((Object)iblockdata.d((cpb)world, (gw)blockposition_mutableblockposition));
                        }
                    }
                }
                k3 /= scale * scale;
                double d2 = (d1 - d0) * 4.0 / (double)(scale + 4) + ((double)(x + z & 1) - 0.5) * 0.4;
                int b0 = 1;
                if (d2 > 0.6) {
                    b0 = 2;
                }
                if (d2 < -0.6) {
                    b0 = 0;
                }
                if ((materialmapcolor = (eaq)Iterables.getFirst((Iterable)Multisets.copyHighestCountFirst((Multiset)multiset), (Object)eaq.a)) == eaq.m) {
                    d2 = (double)k3 * 0.1 + (double)(x + z & 1) * 0.2;
                    b0 = 1;
                    if (d2 < 0.5) {
                        b0 = 2;
                    }
                    if (d2 > 0.9) {
                        b0 = 0;
                    }
                }
                d0 = d1;
                worldmap.a(x, z, (byte)(materialmapcolor.al * 4 + b0));
            }
        }
    }

    public boolean renderEntireMap(int mapId, int xMin, int zMin, int xMax, int zMax) {
        ebw worldmap = ((CraftServer)Bukkit.getServer()).getServer().a(cpv.h).a("map_" + mapId);
        if (worldmap == null) {
            return false;
        }
        ItemHelperImpl.renderFullMap(worldmap, xMin, zMin, xMax, zMax);
        return true;
    }

    public BlockData getPlacedBlock(Material material) {
        cja nmsItem = jb.i.b(CraftNamespacedKey.toMinecraft((NamespacedKey)material.getKey())).orElse(null);
        if (nmsItem instanceof cgy) {
            csv block = ((cgy)nmsItem).e();
            return CraftBlockData.fromData((dfj)block.n());
        }
        return null;
    }

    public boolean isValidMix(ItemStack input, ItemStack ingredient) {
        cjf nmsInput = CraftItemStack.asNMSCopy((ItemStack)input);
        cjf nmsIngredient = CraftItemStack.asNMSCopy((ItemStack)ingredient);
        return cld.a((cjf)nmsInput, (cjf)nmsIngredient);
    }

    public Map<NamespacedKey, ItemHelper.BrewingRecipe> getCustomBrewingRecipes() {
        if (customBrewingRecipes == null) {
            customBrewingRecipes = Maps.transformValues((Map)((Map)ReflectionHelper.getFieldValue(cld.class, (String)"CUSTOM_MIXES", null)), paperMix -> {
                RecipeChoice recipeChoice;
                RecipeChoice ingredientChoice;
                if (PaperPotionMix_CLASS == null) {
                    PaperPotionMix_CLASS = paperMix.getClass();
                }
                Predicate ingredient = (Predicate)ReflectionHelper.getFieldValue(PaperPotionMix_CLASS, (String)"ingredient", (Object)paperMix);
                Predicate input = (Predicate)ReflectionHelper.getFieldValue(PaperPotionMix_CLASS, (String)"input", (Object)paperMix);
                if (ingredient instanceof cmg) {
                    cmg nmsRecipeChoice = (cmg)ingredient;
                    v0 = CraftRecipe.toBukkit((cmg)nmsRecipeChoice);
                } else {
                    v0 = ingredientChoice = null;
                }
                if (input instanceof cmg) {
                    cmg nmsRecipeChoice = (cmg)input;
                    recipeChoice = CraftRecipe.toBukkit((cmg)nmsRecipeChoice);
                } else {
                    recipeChoice = null;
                }
                RecipeChoice inputChoice = recipeChoice;
                ItemStack result = CraftItemStack.asBukkitCopy((cjf)((cjf)ReflectionHelper.getFieldValue(PaperPotionMix_CLASS, (String)"result", (Object)paperMix)));
                return new ItemHelper.BrewingRecipe(inputChoice, ingredientChoice, result);
            });
        }
        return customBrewingRecipes;
    }
}

