/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_20.impl.network.handlers.packet;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.v1_20.ReflectionMappingsInfo;
import com.denizenscript.denizen.nms.v1_20.helpers.PacketHelperImpl;
import com.denizenscript.denizen.nms.v1_20.impl.network.handlers.DenizenNetworkManagerImpl;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.scripts.commands.player.DisguiseCommand;
import com.denizenscript.denizen.utilities.entity.EntityAttachmentHelper;
import com.denizenscript.denizen.utilities.entity.FakeEntity;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.ToIntFunction;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftEntity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;

public class DisguisePacketHandlers {
    public static final Field TELEPORT_PACKET_ENTITY_ID = ReflectionHelper.getFields(acz.class).get(ReflectionMappingsInfo.ClientboundTeleportEntityPacket_id, Integer.TYPE);
    public static final Field TELEPORT_PACKET_X = ReflectionHelper.getFields(acz.class).get(ReflectionMappingsInfo.ClientboundTeleportEntityPacket_x, Double.TYPE);
    public static final Field TELEPORT_PACKET_Y = ReflectionHelper.getFields(acz.class).get(ReflectionMappingsInfo.ClientboundTeleportEntityPacket_y, Double.TYPE);
    public static final Field TELEPORT_PACKET_Z = ReflectionHelper.getFields(acz.class).get(ReflectionMappingsInfo.ClientboundTeleportEntityPacket_z, Double.TYPE);
    public static final Field TELEPORT_PACKET_YAW = ReflectionHelper.getFields(acz.class).get(ReflectionMappingsInfo.ClientboundTeleportEntityPacket_yRot, Byte.TYPE);
    public static final Field TELEPORT_PACKET_PITCH = ReflectionHelper.getFields(acz.class).get(ReflectionMappingsInfo.ClientboundTeleportEntityPacket_xRot, Byte.TYPE);
    private static boolean antiDuplicate = false;

    public static void registerHandlers() {
        DisguisePacketHandlers.registerPacketHandler(acc.class, acc::a, DisguisePacketHandlers::processEntityDataPacket);
        DisguisePacketHandlers.registerPacketHandler(add.class, add::a, DisguisePacketHandlers::processAttributesPacket);
        DisguisePacketHandlers.registerPacketHandler(zb.class, zb::a, DisguisePacketHandlers::sendDisguiseForPacket);
        DisguisePacketHandlers.registerPacketHandler(acz.class, acz::a, DisguisePacketHandlers::processTeleportPacket);
        DisguisePacketHandlers.registerPacketHandler(aas.c.class, aas::a, DisguisePacketHandlers::processMoveEntityRotPacket);
        DisguisePacketHandlers.registerPacketHandler(aas.b.class, aas::a, DisguisePacketHandlers::processMoveEntityPosRotPacket);
    }

    public static <T extends xf<za>> void registerPacketHandler(Class<T> packetType, ToIntFunction<T> idGetter, DisguisePacketHandler<T> handler) {
        DisguisePacketHandlers.registerPacketHandler(packetType, (T packet, ctp level) -> level.a(idGetter.applyAsInt(packet)), handler);
    }

    public static <T extends xf<za>> void registerPacketHandler(Class<T> packetType, BiFunction<T, ctp, blv> entityGetter, DisguisePacketHandler<T> handler) {
        DenizenNetworkManagerImpl.registerPacketHandler(packetType, (networkManager, packet) -> {
            if (DisguiseCommand.disguises.isEmpty() || antiDuplicate) {
                return packet;
            }
            blv entity = (blv)entityGetter.apply(packet, networkManager.player.dM());
            if (entity == null) {
                return packet;
            }
            Map playerMap = (Map)DisguiseCommand.disguises.get(entity.cw());
            if (playerMap == null) {
                return packet;
            }
            DisguiseCommand.TrackedDisguise disguise = (DisguiseCommand.TrackedDisguise)playerMap.get(networkManager.player.cw());
            if (disguise == null) {
                disguise = (DisguiseCommand.TrackedDisguise)playerMap.get(null);
            }
            if (disguise == null || !disguise.isActive) {
                return packet;
            }
            if (NMSHandler.debugPackets) {
                DenizenNetworkManagerImpl.doPacketOutput("DISGUISED packet " + packet.getClass().getName() + " for entity " + entity.aj() + " to player " + networkManager.player.cy());
            }
            try {
                return handler.handle(networkManager, packet, disguise);
            }
            catch (Exception e) {
                antiDuplicate = false;
                throw e;
            }
        });
    }

    public static acc processEntityDataPacket(DenizenNetworkManagerImpl networkManager, acc entityDataPacket, DisguiseCommand.TrackedDisguise disguise) {
        if (entityDataPacket.a() == networkManager.player.aj()) {
            if (!disguise.shouldFake) {
                return entityDataPacket;
            }
            for (agp.b dataValue : entityDataPacket.d()) {
                if (dataValue.a() != 0) continue;
                ArrayList<agp.b<Byte>> newData = new ArrayList<agp.b<Byte>>(entityDataPacket.d());
                newData.remove(dataValue);
                byte flags = (Byte)dataValue.c();
                flags = (byte)(flags | 0x20);
                newData.add(PacketHelperImpl.createEntityData(PacketHelperImpl.ENTITY_DATA_ACCESSOR_FLAGS, flags));
                return new acc(entityDataPacket.a(), newData);
            }
        } else {
            List data = ((CraftEntity)disguise.toOthers.entity.entity).getHandle().an().c();
            return data != null ? new acc(entityDataPacket.a(), data) : null;
        }
        return entityDataPacket;
    }

    public static add processAttributesPacket(DenizenNetworkManagerImpl networkManager, add attributesPacket, DisguiseCommand.TrackedDisguise disguise) {
        FakeEntity fake = attributesPacket.a() == networkManager.player.aj() ? disguise.fakeToSelf : disguise.toOthers;
        return fake == null || fake.entity.entity instanceof LivingEntity ? attributesPacket : null;
    }

    public static acz processTeleportPacket(DenizenNetworkManagerImpl networkManager, acz teleportEntityPacket, DisguiseCommand.TrackedDisguise disguise) throws IllegalAccessException {
        if (disguise.as.getBukkitEntityType() == EntityType.ENDER_DRAGON) {
            acz pNew = new acz(((CraftEntity)disguise.entity.getBukkitEntity()).getHandle());
            TELEPORT_PACKET_ENTITY_ID.setInt(pNew, teleportEntityPacket.a());
            TELEPORT_PACKET_X.setDouble(pNew, teleportEntityPacket.d());
            TELEPORT_PACKET_Y.setDouble(pNew, teleportEntityPacket.e());
            TELEPORT_PACKET_Z.setDouble(pNew, teleportEntityPacket.f());
            TELEPORT_PACKET_YAW.setByte(pNew, EntityAttachmentHelper.adaptedCompressedAngle((byte)teleportEntityPacket.g(), (float)180.0f));
            TELEPORT_PACKET_PITCH.setByte(pNew, teleportEntityPacket.h());
            return pNew;
        }
        return DisguisePacketHandlers.sendDisguiseForPacket(networkManager, teleportEntityPacket, disguise);
    }

    public static aas.c processMoveEntityRotPacket(DenizenNetworkManagerImpl networkManager, aas.c rotPacket, DisguiseCommand.TrackedDisguise disguise) {
        if (disguise.as.getBukkitEntityType() == EntityType.ENDER_DRAGON) {
            return new aas.c(disguise.entity.getBukkitEntity().getEntityId(), EntityAttachmentHelper.adaptedCompressedAngle((byte)rotPacket.f(), (float)180.0f), rotPacket.g(), rotPacket.j());
        }
        return DisguisePacketHandlers.sendDisguiseForPacket(networkManager, rotPacket, disguise);
    }

    public static aas.b processMoveEntityPosRotPacket(DenizenNetworkManagerImpl networkManager, aas.b posRotPacket, DisguiseCommand.TrackedDisguise disguise) {
        if (disguise.as.getBukkitEntityType() == EntityType.ENDER_DRAGON) {
            return new aas.b(disguise.entity.getBukkitEntity().getEntityId(), posRotPacket.a(), posRotPacket.d(), posRotPacket.e(), EntityAttachmentHelper.adaptedCompressedAngle((byte)posRotPacket.f(), (float)180.0f), posRotPacket.g(), posRotPacket.j());
        }
        return DisguisePacketHandlers.sendDisguiseForPacket(networkManager, posRotPacket, disguise);
    }

    public static <T extends xf<za>> T sendDisguiseForPacket(DenizenNetworkManagerImpl networkManager, T packet, DisguiseCommand.TrackedDisguise disguise) {
        antiDuplicate = true;
        disguise.sendTo(List.of(new PlayerTag(networkManager.player.cw())));
        antiDuplicate = false;
        return null;
    }

    @FunctionalInterface
    public static interface DisguisePacketHandler<T extends xf<za>> {
        public T handle(DenizenNetworkManagerImpl var1, T var2, DisguiseCommand.TrackedDisguise var3) throws Exception;
    }
}

