/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_20.helpers;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.interfaces.EntityHelper;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.v1_20.ReflectionMappingsInfo;
import com.denizenscript.denizen.nms.v1_20.helpers.BlockHelperImpl;
import com.denizenscript.denizen.nms.v1_20.helpers.EntityDataNameMapper;
import com.denizenscript.denizen.nms.v1_20.helpers.PacketHelperImpl;
import com.denizenscript.denizen.nms.v1_20.impl.jnbt.CompoundTagImpl;
import com.denizenscript.denizen.nms.v1_20.impl.network.handlers.DenizenNetworkManagerImpl;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.packets.NetworkInterceptHelper;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.scripts.commands.core.ReflectionSetCommand;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import org.bukkit.Art;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_20_R4.CraftServer;
import org.bukkit.craftbukkit.v1_20_R4.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R4.block.CraftBlock;
import org.bukkit.craftbukkit.v1_20_R4.block.CraftCreatureSpawner;
import org.bukkit.craftbukkit.v1_20_R4.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftAbstractHorse;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftEnderman;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftEntityType;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftExperienceOrb;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftFallingBlock;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftItem;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftMob;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftZombie;
import org.bukkit.craftbukkit.v1_20_R4.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R4.util.CraftLocation;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Pose;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.Zombie;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;

public class EntityHelperImpl
extends EntityHelper {
    public static final MethodHandle ENTITY_ONGROUND_SETTER = ReflectionHelper.getFinalSetter(bsw.class, (String)ReflectionMappingsInfo.Entity_onGround, Boolean.TYPE);
    public static final akk<Boolean> ENDERMAN_DATA_ACCESSOR_SCREAMING = (akk)ReflectionHelper.getFieldValue(cjv.class, (String)ReflectionMappingsInfo.EnderMan_DATA_CREEPY, null);
    public static final MethodHandle LIVINGENTITY_AUTOSPINATTACK_SETTER = ReflectionHelper.getFinalSetter(btr.class, (String)ReflectionMappingsInfo.LivingEntity_autoSpinAttackTicks);
    public static final MethodHandle LIVINGENTITY_SETLIVINGENTITYFLAG = ReflectionHelper.getMethodHandle(btr.class, (String)ReflectionMappingsInfo.LivingEntity_setLivingEntityFlag_method, (Class[])new Class[]{Integer.TYPE, Boolean.TYPE});
    private static final Map<UUID, BukkitTask> followTasks = new HashMap<UUID, BukkitTask>();
    public static final Field EXPERIENCE_ORB_AGE = ReflectionHelper.getFields(bth.class).get(ReflectionMappingsInfo.ExperienceOrb_age, Integer.TYPE);
    public static brq backupDamageSources;
    public static final Field FALLINGBLOCK_BLOCK_STATE;
    public static final Field ZOMBIE_INWATERTIME;
    public static final MethodHandle TRACKING_RANGE_SETTER;
    public static final MethodHandle PLAYERLIST_REMOVE;
    public static final Field SynchedEntityData_itemsById;

    public int getBlockHeight(Art art) {
        return art.getBlockHeight();
    }

    public int getBlockWidth(Art art) {
        return art.getBlockWidth();
    }

    public void setInvisible(Entity entity, boolean invisible) {
        ((CraftEntity)entity).getHandle().k(invisible);
    }

    public boolean isInvisible(Entity entity) {
        return ((CraftEntity)entity).getHandle().ch();
    }

    public void setPose(Entity entity, Pose pose) {
        ((CraftEntity)entity).getHandle().b(bud.values()[pose.ordinal()]);
    }

    public double getDamageTo(LivingEntity attacker, Entity target) {
        double damage = 0.0;
        AttributeInstance attrib = attacker.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE);
        if (attrib != null) {
            damage = attrib.getValue();
        }
        if (attacker.getEquipment() != null) {
            damage += (double)dad.a((cur)CraftItemStack.asNMSCopy((ItemStack)attacker.getEquipment().getItemInMainHand()), (btc)CraftEntityType.bukkitToMinecraft((EntityType)target.getType()));
        }
        if (damage <= 0.0) {
            return 0.0;
        }
        if (target != null) {
            brp source;
            bsw nmsTarget = ((CraftEntity)target).getHandle();
            if (attacker instanceof CraftPlayer) {
                CraftPlayer playerAttacker = (CraftPlayer)attacker;
                source = nmsTarget.dP().aj().a((cmz)playerAttacker.getHandle());
            } else {
                source = nmsTarget.dP().aj().b(((CraftLivingEntity)attacker).getHandle());
            }
            if (nmsTarget.b(source)) {
                return 0.0;
            }
            if (!(nmsTarget instanceof btr)) {
                return damage;
            }
            btr livingTarget = (btr)nmsTarget;
            damage = brl.a((float)((float)damage), (brp)source, (float)livingTarget.eO(), (float)((float)livingTarget.g(buz.b)));
            int enchantDamageModifier = dad.a((Iterable)livingTarget.eZ(), (brp)source);
            if (enchantDamageModifier > 0) {
                damage = brl.a((float)((float)damage), (float)enchantDamageModifier);
            }
        }
        return damage;
    }

    public void setRiptide(Entity entity, boolean state) {
        try {
            btr nmsEntity = ((CraftLivingEntity)entity).getHandle();
            LIVINGENTITY_AUTOSPINATTACK_SETTER.invoke(nmsEntity, state ? 0 : 1);
            LIVINGENTITY_SETLIVINGENTITYFLAG.invoke(nmsEntity, 4, true);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void forceInteraction(Player player, Location location) {
        CraftPlayer craftPlayer = (CraftPlayer)player;
        ((CraftBlock)location.getBlock()).getNMS().a(craftPlayer.getHandle().eX(), (dca)((CraftWorld)location.getWorld()).getHandle(), (cmz)craftPlayer.getHandle(), bqv.a, new evp(new evt(0.0, 0.0, 0.0), null, CraftLocation.toBlockPosition((Location)location), false));
    }

    public CompoundTag getNbtData(Entity entity) {
        us compound = new us();
        ((CraftEntity)entity).getHandle().d(compound);
        return CompoundTagImpl.fromNMSTag(compound);
    }

    public void setNbtData(Entity entity, CompoundTag compoundTag) {
        ((CraftEntity)entity).getHandle().g(((CompoundTagImpl)compoundTag).toNMSTag());
    }

    public void stopFollowing(Entity follower) {
        if (follower == null) {
            return;
        }
        UUID uuid = follower.getUniqueId();
        if (followTasks.containsKey(uuid)) {
            followTasks.get(uuid).cancel();
        }
    }

    public void stopWalking(Entity entity) {
        bsw bsw2 = ((CraftEntity)entity).getHandle();
        if (bsw2 instanceof btt) {
            btt nmsMob = (btt)bsw2;
            nmsMob.K().n();
        }
    }

    public void follow(final Entity target, final Entity follower, final double speed, final double lead, final double maxRange, final boolean allowWander, final boolean teleport) {
        if (target == null || follower == null) {
            return;
        }
        bsw nmsEntityFollower = ((CraftEntity)follower).getHandle();
        if (!(nmsEntityFollower instanceof btt)) {
            return;
        }
        final btt nmsFollower = (btt)nmsEntityFollower;
        final cdd followerNavigation = nmsFollower.K();
        UUID uuid = follower.getUniqueId();
        if (followTasks.containsKey(uuid)) {
            followTasks.get(uuid).cancel();
        }
        final int locationNearInt = (int)Math.floor(lead);
        final boolean hasMax = maxRange > lead;
        followTasks.put(follower.getUniqueId(), new BukkitRunnable(){
            private boolean inRadius = false;

            public void run() {
                if (!target.isValid() || !follower.isValid()) {
                    this.cancel();
                }
                followerNavigation.a(2.0);
                Location targetLocation = target.getLocation();
                if (hasMax && !Utilities.checkLocation((Location)targetLocation, (Location)follower.getLocation(), (double)maxRange) && !target.isDead() && target.isOnGround()) {
                    if (!this.inRadius) {
                        if (teleport) {
                            follower.teleport(Utilities.getWalkableLocationNear((Location)targetLocation, (int)locationNearInt));
                        } else {
                            this.cancel();
                        }
                    } else {
                        this.inRadius = false;
                        eol path = followerNavigation.a(targetLocation.getX(), targetLocation.getY(), targetLocation.getZ(), 0);
                        if (path != null) {
                            followerNavigation.a(path, 1.0);
                            followerNavigation.a(2.0);
                        }
                    }
                } else if (!this.inRadius && !Utilities.checkLocation((Location)targetLocation, (Location)follower.getLocation(), (double)lead)) {
                    eol path = followerNavigation.a(targetLocation.getX(), targetLocation.getY(), targetLocation.getZ(), 0);
                    if (path != null) {
                        followerNavigation.a(path, 1.0);
                        followerNavigation.a(2.0);
                    }
                } else {
                    this.inRadius = true;
                }
                if (this.inRadius && !allowWander) {
                    followerNavigation.n();
                }
                nmsFollower.f(buz.r).a(speed);
            }
        }.runTaskTimer((Plugin)NMSHandler.getJavaPlugin(), 0L, 10L));
    }

    public void walkTo(final LivingEntity entity, Location location, final Double speed, final Runnable callback) {
        eol path;
        boolean aiDisabled;
        if (entity == null || location == null) {
            return;
        }
        bsw nmsEntity = ((CraftEntity)entity).getHandle();
        if (!(nmsEntity instanceof btt)) {
            return;
        }
        final btt nmsMob = (btt)nmsEntity;
        final cdd entityNavigation = nmsMob.K();
        boolean bl = aiDisabled = !entity.hasAI();
        if (aiDisabled) {
            entity.setAI(true);
            try {
                ENTITY_ONGROUND_SETTER.invoke(nmsMob, true);
            }
            catch (Throwable ex) {
                Debug.echoError((Throwable)ex);
            }
        }
        if ((path = entityNavigation.a(location.getX(), location.getY(), location.getZ(), 1)) != null) {
            nmsMob.bS.b(cap.a.a);
            entityNavigation.a(path, 1.0);
            final double oldSpeed = nmsMob.f(buz.r).b();
            if (speed != null) {
                nmsMob.f(buz.r).a(speed.doubleValue());
            }
            new BukkitRunnable(){

                public void run() {
                    if (!entity.isValid()) {
                        if (callback != null) {
                            callback.run();
                        }
                        this.cancel();
                        return;
                    }
                    if (aiDisabled && entity instanceof Wolf) {
                        Wolf wolf = (Wolf)entity;
                        wolf.setAngry(false);
                    }
                    if (entityNavigation.l() || path.c()) {
                        if (callback != null) {
                            callback.run();
                        }
                        if (speed != null) {
                            nmsMob.f(buz.r).a(oldSpeed);
                        }
                        if (aiDisabled) {
                            entity.setAI(false);
                        }
                        this.cancel();
                    }
                }
            }.runTaskTimer((Plugin)NMSHandler.getJavaPlugin(), 1L, 1L);
        } else {
            entity.teleport(location);
        }
    }

    public void sendAllUpdatePackets(Entity entity) {
        aqo tracker = ((arf)((CraftEntity)entity).getHandle().dP()).l().a;
        aqo.b entityTracker = (aqo.b)tracker.J.get(entity.getEntityId());
        if (entityTracker == null) {
            return;
        }
        try {
            are serverEntity = (are)PacketHelperImpl.ENTITY_TRACKER_ENTRY_GETTER.get(entityTracker);
            serverEntity.a();
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void sendHidePacket(Player pl, Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            pl.hidePlayer((Plugin)Denizen.getInstance(), player);
            return;
        }
        arg nmsPlayer = ((CraftPlayer)pl).getHandle();
        if (nmsPlayer.c != null && !pl.equals((Object)entity)) {
            aqo.b entry = (aqo.b)nmsPlayer.z().l().a.J.get(entity.getEntityId());
            if (entry != null) {
                entry.a(nmsPlayer);
            }
            if (Denizen.supportsPaper) {
                nmsPlayer.c.b((zw)new aet(new int[]{entity.getEntityId()}));
            }
        }
    }

    public void sendShowPacket(Player pl, Entity entity) {
        aqo.b entry;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            pl.showPlayer((Plugin)Denizen.getInstance(), player);
            return;
        }
        arg nmsPlayer = ((CraftPlayer)pl).getHandle();
        if (nmsPlayer.c != null && !pl.equals((Object)entity) && (entry = (aqo.b)nmsPlayer.z().l().a.J.get(entity.getEntityId())) != null) {
            entry.a(nmsPlayer);
            entry.b(nmsPlayer);
        }
    }

    public void rotate(Entity entity, float yaw, float pitch) {
        Player player;
        if (entity instanceof Player && (player = (Player)entity).isOnline()) {
            NetworkInterceptHelper.enable();
            float relYaw = (yaw - entity.getLocation().getYaw()) % 360.0f;
            if (relYaw > 180.0f) {
                relYaw -= 360.0f;
            }
            float actualRelYaw = relYaw;
            float relPitch = pitch - entity.getLocation().getPitch();
            NMSHandler.packetHelper.sendRelativeLookPacket(player, actualRelYaw, relPitch);
        } else if (entity instanceof LivingEntity) {
            if (entity instanceof EnderDragon) {
                yaw = EntityHelperImpl.normalizeYaw((float)(yaw - 180.0f));
            }
            this.look(entity, yaw, pitch);
        } else {
            bsw handle = ((CraftEntity)entity).getHandle();
            handle.r(yaw - 360.0f);
            handle.s(pitch);
        }
    }

    public float getBaseYaw(LivingEntity entity) {
        return ((CraftLivingEntity)entity).getHandle().aY;
    }

    public void look(Entity entity, float yaw, float pitch) {
        bsw handle = ((CraftEntity)entity).getHandle();
        if (handle == null) {
            Debug.echoError((String)("Cannot set look direction for unspawned entity " + String.valueOf(entity.getUniqueId())));
            return;
        }
        handle.r(yaw);
        if (handle instanceof btr) {
            btr nmsLivingEntity = (btr)handle;
            while (yaw < -180.0f) {
                yaw += 360.0f;
            }
            while (yaw >= 180.0f) {
                yaw -= 360.0f;
            }
            nmsLivingEntity.aZ = yaw;
            if (!(handle instanceof cmz)) {
                nmsLivingEntity.o(yaw);
            }
            nmsLivingEntity.n(yaw);
        }
        handle.s(pitch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static evr rayTrace(World world, Vector start, Vector end) {
        try {
            NMSHandler.chunkHelper.changeChunkServerThread(world);
            evp evp2 = ((CraftWorld)world).getHandle().a(new dbj(new evt(start.getX(), start.getY(), start.getZ()), new evt(end.getX(), end.getY(), end.getZ()), dbj.a.b, dbj.b.a, evy.a()));
            return evp2;
        }
        finally {
            NMSHandler.chunkHelper.restoreServerThread(world);
        }
    }

    public boolean canTrace(World world, Vector start, Vector end) {
        evr pos = EntityHelperImpl.rayTrace(world, start, end);
        if (pos == null) {
            return true;
        }
        return pos.c() == evr.a.a;
    }

    public void snapPositionTo(Entity entity, Vector vector) {
        ((CraftEntity)entity).getHandle().p(vector.getX(), vector.getY(), vector.getZ());
    }

    public void move(Entity entity, Vector vector) {
        ((CraftEntity)entity).getHandle().a(btw.a, new evt(vector.getX(), vector.getY(), vector.getZ()));
    }

    public boolean internalLook(Player player, Location at) {
        PacketHelperImpl.send(player, new aep(fb.a.b, at.getX(), at.getY(), at.getZ()));
        return true;
    }

    public static long entityToPacket(double x) {
        return ayz.b((double)(x * 4096.0));
    }

    public void fakeMove(Entity entity, Vector vector) {
        long x = EntityHelperImpl.entityToPacket(vector.getX());
        long y = EntityHelperImpl.entityToPacket(vector.getY());
        long z = EntityHelperImpl.entityToPacket(vector.getZ());
        aec.a packet = new aec.a(entity.getEntityId(), (short)x, (short)y, (short)z, entity.isOnGround());
        for (Player player : this.getPlayersThatSee(entity)) {
            PacketHelperImpl.send(player, packet);
        }
    }

    public void fakeTeleport(Entity entity, Location location) {
        wm packetData = new wm(Unpooled.buffer());
        packetData.c(entity.getEntityId());
        packetData.a(location.getX());
        packetData.a(location.getY());
        packetData.a(location.getZ());
        packetData.k((int)((byte)(location.getYaw() * 256.0f / 360.0f)));
        packetData.k((int)((byte)(location.getPitch() * 256.0f / 360.0f)));
        packetData.a(entity.isOnGround());
        agk packet = (agk)agk.a.decode((Object)packetData);
        for (Player player : this.getPlayersThatSee(entity)) {
            PacketHelperImpl.send(player, packet);
        }
    }

    public void clientResetLoc(Entity entity) {
        agk packet = new agk(((CraftEntity)entity).getHandle());
        for (Player player : this.getPlayersThatSee(entity)) {
            PacketHelperImpl.send(player, packet);
        }
    }

    public void teleport(Entity entity, Location loc) {
        bsw nmsEntity = ((CraftEntity)entity).getHandle();
        nmsEntity.r(loc.getYaw());
        nmsEntity.s(loc.getPitch());
        if (nmsEntity instanceof arg) {
            nmsEntity.c(loc.getX(), loc.getY(), loc.getZ());
        }
        nmsEntity.a_(loc.getX(), loc.getY(), loc.getZ());
    }

    public void setBoundingBox(Entity entity, BoundingBox box) {
        ((CraftEntity)entity).getHandle().a(new evo(box.getMinX(), box.getMinY(), box.getMinZ(), box.getMaxX(), box.getMaxY(), box.getMaxZ()));
    }

    public void setTicksLived(Entity entity, int ticks) {
        ((CraftEntity)entity).getHandle().ai = ticks;
        if (entity instanceof CraftFallingBlock) {
            CraftFallingBlock craftFallingBlock = (CraftFallingBlock)entity;
            craftFallingBlock.getHandle().b = ticks;
        } else if (entity instanceof CraftItem) {
            CraftItem craftItem = (CraftItem)entity;
            craftItem.getHandle().i = ticks;
        } else if (entity instanceof CraftExperienceOrb) {
            CraftExperienceOrb craftExperienceOrb = (CraftExperienceOrb)entity;
            try {
                EXPERIENCE_ORB_AGE.setInt(craftExperienceOrb.getHandle(), ticks);
            }
            catch (Throwable ex) {
                Debug.echoError((Throwable)ex);
            }
        }
    }

    public void setHeadAngle(LivingEntity entity, float angle) {
        ((CraftLivingEntity)entity).getHandle().n(angle);
    }

    public void setEndermanAngry(Enderman enderman, boolean angry) {
        ((CraftEnderman)enderman).getHandle().ap().a(ENDERMAN_DATA_ACCESSOR_SCREAMING, (Object)angry);
    }

    public static brq getReusableDamageSources() {
        if (backupDamageSources == null) {
            backupDamageSources = ((CraftWorld)Bukkit.getWorlds().get(0)).getHandle().aj();
        }
        return backupDamageSources;
    }

    public static brp getSourceFor(bsw nmsSource, EntityDamageEvent.DamageCause cause, bsw nmsSourceProvider) {
        brq sources = nmsSourceProvider == null ? EntityHelperImpl.getReusableDamageSources() : nmsSourceProvider.dP().aj();
        brp src = sources.n();
        if (nmsSource != null) {
            if (nmsSource instanceof cmz) {
                cmz nmsPlayer = (cmz)nmsSource;
                src = nmsSource.dP().aj().a(nmsPlayer);
            } else if (nmsSource instanceof btr) {
                btr nmsLivingEntity = (btr)nmsSource;
                src = nmsSource.dP().aj().b(nmsLivingEntity);
            }
        }
        if (cause == null) {
            return src;
        }
        return switch (cause) {
            default -> throw new IncompatibleClassChangeError();
            case EntityDamageEvent.DamageCause.CONTACT -> sources.j();
            case EntityDamageEvent.DamageCause.ENTITY_ATTACK -> {
                btr nmsLivingEntity;
                yield sources.b(nmsSource instanceof btr ? (nmsLivingEntity = (btr)nmsSource) : null);
            }
            case EntityDamageEvent.DamageCause.ENTITY_SWEEP_ATTACK -> {
                if (src != sources.n()) {
                    yield src.sweep();
                }
                yield src;
            }
            case EntityDamageEvent.DamageCause.PROJECTILE -> {
                bsw v1;
                Projectile projectile;
                CraftEntity var7_7;
                if (nmsSource != null && (var7_7 = nmsSource.getBukkitEntity()) instanceof Projectile && (var7_7 = (projectile = (Projectile)var7_7).getShooter()) instanceof CraftEntity) {
                    CraftEntity shooter = var7_7;
                    v1 = shooter.getHandle();
                } else {
                    v1 = null;
                }
                yield sources.b(nmsSource, v1);
            }
            case EntityDamageEvent.DamageCause.SUFFOCATION -> sources.f();
            case EntityDamageEvent.DamageCause.FALL -> sources.k();
            case EntityDamageEvent.DamageCause.FIRE -> sources.a();
            case EntityDamageEvent.DamageCause.FIRE_TICK -> sources.c();
            case EntityDamageEvent.DamageCause.MELTING -> sources.melting();
            case EntityDamageEvent.DamageCause.LAVA -> sources.d();
            case EntityDamageEvent.DamageCause.DROWNING -> sources.h();
            case EntityDamageEvent.DamageCause.BLOCK_EXPLOSION -> {
                if (nmsSource instanceof cjk) {
                    cjk primedTnt = (cjk)nmsSource;
                    yield sources.d((bsw)primedTnt, (bsw)primedTnt.p());
                }
                yield sources.a(null);
            }
            case EntityDamageEvent.DamageCause.ENTITY_EXPLOSION -> sources.d(nmsSource, null);
            case EntityDamageEvent.DamageCause.VOID -> sources.m();
            case EntityDamageEvent.DamageCause.LIGHTNING -> sources.b();
            case EntityDamageEvent.DamageCause.STARVATION -> sources.i();
            case EntityDamageEvent.DamageCause.POISON -> sources.poison();
            case EntityDamageEvent.DamageCause.MAGIC -> sources.o();
            case EntityDamageEvent.DamageCause.WITHER -> sources.p();
            case EntityDamageEvent.DamageCause.FALLING_BLOCK -> sources.a(nmsSource);
            case EntityDamageEvent.DamageCause.THORNS -> sources.d(nmsSource);
            case EntityDamageEvent.DamageCause.DRAGON_BREATH -> sources.q();
            case EntityDamageEvent.DamageCause.CUSTOM -> sources.n();
            case EntityDamageEvent.DamageCause.FLY_INTO_WALL -> sources.l();
            case EntityDamageEvent.DamageCause.HOT_FLOOR -> sources.e();
            case EntityDamageEvent.DamageCause.CRAMMING -> sources.g();
            case EntityDamageEvent.DamageCause.DRYOUT -> sources.r();
            case EntityDamageEvent.DamageCause.FREEZE -> sources.t();
            case EntityDamageEvent.DamageCause.SONIC_BOOM -> sources.e(nmsSource);
            case EntityDamageEvent.DamageCause.WORLD_BORDER -> sources.v();
            case EntityDamageEvent.DamageCause.KILL -> sources.w();
            case EntityDamageEvent.DamageCause.SUICIDE -> new FakeDamageSrc(src);
        };
    }

    public void damage(LivingEntity target, float amount, EntityTag source, Location sourceLoc, EntityDamageEvent.DamageCause cause) {
        btr nmsTarget;
        if (target == null) {
            return;
        }
        bsw nmsSource = source == null ? null : ((CraftEntity)source.getBukkitEntity()).getHandle();
        brp src = EntityHelperImpl.getSourceFor(nmsSource, cause, (bsw)(nmsTarget = ((CraftLivingEntity)target).getHandle()));
        if (src instanceof FakeDamageSrc) {
            FakeDamageSrc fakeDamageSrc = (FakeDamageSrc)src;
            src = fakeDamageSrc.real;
            if (EntityHelperImpl.fireFakeDamageEvent((Entity)target, (EntityTag)source, (Location)sourceLoc, (EntityDamageEvent.DamageCause)cause, (float)amount).isCancelled()) {
                return;
            }
        }
        nmsTarget.a(src, amount);
    }

    public void setLastHurtBy(LivingEntity mob, LivingEntity damager) {
        ((CraftLivingEntity)mob).getHandle().a(((CraftLivingEntity)damager).getHandle());
    }

    public void setFallingBlockType(FallingBlock fallingBlock, BlockData block) {
        dse state = ((CraftBlockData)block).getState();
        cji nmsEntity = ((CraftFallingBlock)fallingBlock).getHandle();
        try {
            FALLINGBLOCK_BLOCK_STATE.set(nmsEntity, state);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public EntityTag getMobSpawnerDisplayEntity(CreatureSpawner spawner) {
        dqx nmsSpawner = (dqx)BlockHelperImpl.getTE((CraftCreatureSpawner)spawner);
        arf level = ((CraftWorld)spawner.getWorld()).getHandle();
        bsw nmsEntity = nmsSpawner.c().b((dca)level, nmsSpawner.ay_());
        return new EntityTag((Entity)nmsEntity.getBukkitEntity());
    }

    public int getInWaterTime(Zombie zombie) {
        try {
            return ZOMBIE_INWATERTIME.getInt(((CraftZombie)zombie).getHandle());
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
            return 0;
        }
    }

    public void setInWaterTime(Zombie zombie, int ticks) {
        try {
            ZOMBIE_INWATERTIME.setInt(((CraftZombie)zombie).getHandle(), ticks);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void setTrackingRange(Entity entity, int range) {
        try {
            aqo map = ((CraftWorld)entity.getWorld()).getHandle().l().a;
            aqo.b entry = (aqo.b)map.J.get(entity.getEntityId());
            if (entry != null) {
                TRACKING_RANGE_SETTER.invoke(entry, range);
            }
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public boolean isAggressive(Mob mob) {
        return ((CraftMob)mob).getHandle().gi();
    }

    public void setAggressive(Mob mob, boolean aggressive) {
        ((CraftMob)mob).getHandle().v(aggressive);
    }

    public void setUUID(Entity entity, UUID id) {
        try {
            arg nmsPlayer;
            bsw nmsEntity = ((CraftEntity)entity).getHandle();
            nmsEntity.ac();
            nmsEntity.cS().forEach(bsw::ac);
            dca level = nmsEntity.dP();
            aqa playerList = ((CraftServer)Bukkit.getServer()).getHandle();
            if (nmsEntity instanceof arg) {
                nmsPlayer = (arg)nmsEntity;
                PLAYERLIST_REMOVE.invoke(playerList, nmsPlayer);
            } else {
                nmsEntity.a(bsw.c.b);
            }
            nmsEntity.dM();
            nmsEntity.a_(id);
            if (nmsEntity instanceof arg) {
                nmsPlayer = (arg)nmsEntity;
                playerList.a(DenizenNetworkManagerImpl.getConnection(nmsPlayer), nmsPlayer, new aru(nmsPlayer.gb(), nmsPlayer.c.k(), nmsPlayer.B(), nmsPlayer.c.isTransferred()));
            } else {
                level.b(nmsEntity);
            }
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public static Int2ObjectMap<ako.b<Object>> getDataItems(Entity entity) {
        try {
            return (Int2ObjectMap)SynchedEntityData_itemsById.get(((CraftEntity)entity).getHandle().ap());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void convertToInternalData(Entity entity, MapTag internalData, BiConsumer<ako.b<Object>, Object> processConverted) {
        Int2ObjectMap<ako.b<Object>> dataItemsById = EntityHelperImpl.getDataItems(entity);
        for (Map.Entry entry : internalData.entrySet()) {
            int id = EntityDataNameMapper.getIdForName(((CraftEntity)entity).getHandle().getClass(), ((StringHolder)entry.getKey()).low);
            if (id == -1) {
                Debug.echoError((String)("Invalid internal data key: " + String.valueOf(entry.getKey())));
                return;
            }
            ako.b dataItem = (ako.b)dataItemsById.get(id);
            if (dataItem == null) {
                Debug.echoError((String)("Invalid internal data id '" + id + "': couldn't be matched to any internal data for entity of type '" + String.valueOf(entity.getType()) + "'."));
                return;
            }
            Object converted = ReflectionSetCommand.convertObjectTypeFor(dataItem.b().getClass(), (ObjectTag)((ObjectTag)entry.getValue()));
            if (converted == null) continue;
            processConverted.accept((ako.b<Object>)dataItem, converted);
        }
    }

    public List<Object> convertInternalEntityDataValues(Entity entity, MapTag internalData) {
        ArrayList<Object> dataValues = new ArrayList<Object>(internalData.size());
        EntityHelperImpl.convertToInternalData(entity, internalData, (dataItem, converted) -> dataValues.add(PacketHelperImpl.createEntityData(dataItem.a(), converted)));
        return dataValues;
    }

    public void modifyInternalEntityData(Entity entity, MapTag internalData) {
        ako nmsEntityData = ((CraftEntity)entity).getHandle().ap();
        EntityHelperImpl.convertToInternalData(entity, internalData, (dataItem, converted) -> nmsEntityData.a(dataItem.a(), converted));
    }

    public void startUsingItem(LivingEntity entity, EquipmentSlot hand) {
        ((CraftLivingEntity)entity).getHandle().c(hand == EquipmentSlot.HAND ? bqv.a : bqv.b);
    }

    public void stopUsingItem(LivingEntity entity) {
        ((CraftLivingEntity)entity).getHandle().fB();
    }

    public void openHorseInventory(Player player, AbstractHorse horse) {
        chl nmsHorse = ((CraftAbstractHorse)horse).getHandle();
        ((CraftPlayer)player).getHandle().a(nmsHorse, (bqp)nmsHorse.cs);
    }

    private us getRawEntityNBT(bsw entity) {
        return entity.f(new us());
    }

    public CompoundTag getRawNBT(Entity entity) {
        return CompoundTagImpl.fromNMSTag(this.getRawEntityNBT(((CraftEntity)entity).getHandle()));
    }

    public void modifyRawNBT(Entity entity, CompoundTag tag) {
        bsw nmsEntity = ((CraftEntity)entity).getHandle();
        us nmsTag = ((CompoundTagImpl)tag).toNMSTag();
        us nmsMergedTag = this.getRawEntityNBT(nmsEntity).a(nmsTag);
        UUID uuid = nmsEntity.cz();
        nmsEntity.g(nmsMergedTag);
        nmsEntity.a_(uuid);
    }

    static {
        FALLINGBLOCK_BLOCK_STATE = ReflectionHelper.getFields(cji.class).getFirstOfType(dse.class);
        ZOMBIE_INWATERTIME = ReflectionHelper.getFields(cky.class).get(ReflectionMappingsInfo.Zombie_inWaterTime, Integer.TYPE);
        TRACKING_RANGE_SETTER = ReflectionHelper.getFinalSetterForFirstOfType(aqo.b.class, Integer.TYPE);
        PLAYERLIST_REMOVE = ReflectionHelper.getMethodHandle(avd.class, (String)"remove", (Class[])new Class[]{arg.class});
        SynchedEntityData_itemsById = ReflectionHelper.getFields(ako.class).get((Object)ReflectionMappingsInfo.SynchedEntityData_itemsById);
    }

    public static class FakeDamageSrc
    extends brp {
        public brp real;

        public FakeDamageSrc(brp src) {
            super(null);
            this.real = src;
        }
    }
}

