/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_21.helpers;

import com.denizenscript.denizen.nms.interfaces.BlockHelper;
import com.denizenscript.denizen.nms.util.PlayerProfile;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTag;
import com.denizenscript.denizen.nms.util.jnbt.CompoundTagBuilder;
import com.denizenscript.denizen.nms.v1_21.ReflectionMappingsInfo;
import com.denizenscript.denizen.nms.v1_21.helpers.PacketHelperImpl;
import com.denizenscript.denizen.nms.v1_21.impl.ProfileEditorImpl;
import com.denizenscript.denizen.nms.v1_21.impl.jnbt.CompoundTagImpl;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.VanillaTagHelper;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Instrument;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.Skull;
import org.bukkit.craftbukkit.v1_21_R1.CraftChunk;
import org.bukkit.craftbukkit.v1_21_R1.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftCreatureSpawner;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftSkull;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R1.tag.CraftBlockTag;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftMagicNumbers;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;

public class BlockHelperImpl
implements BlockHelper {
    public static final Field craftBlockEntityState_tileEntity = ReflectionHelper.getFields(CraftBlockEntityState.class).get((Object)"tileEntity");
    public static final Field craftBlockEntityState_snapshot = ReflectionHelper.getFields(CraftBlockEntityState.class).get((Object)"snapshot");
    public static final Field craftSkull_profile = ReflectionHelper.getFields(CraftSkull.class).get((Object)"profile");
    public static final MethodHandle MATERIAL_PUSH_REACTION_SETTER = ReflectionHelper.getFinalSetterForFirstOfType(dtb.a.class, epj.class);
    public static final MethodHandle BLOCK_STRENGTH_SETTER = ReflectionHelper.getFinalSetterForFirstOfType(dtb.a.class, Float.TYPE);
    public static final MethodHandle HOLDERSET_NAMED_BIND = ReflectionHelper.getMethodHandle(jq.c.class, (String)ReflectionMappingsInfo.HolderSetNamed_bind_method, (Class[])new Class[]{List.class});
    public static final MethodHandle HOLDER_REFERENCE_BINDTAGS = ReflectionHelper.getMethodHandle(jm.c.class, (String)ReflectionMappingsInfo.HolderReference_bindTags_method, (Class[])new Class[]{Collection.class});

    public void makeBlockStateRaw(BlockState state) {
        try {
            craftBlockEntityState_snapshot.set(state, craftBlockEntityState_tileEntity.get(state));
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void applyPhysics(Location location) {
        ((CraftWorld)location.getWorld()).getHandle().a(CraftLocation.toBlockPosition((Location)location), CraftMagicNumbers.getBlock((Material)location.getBlock().getType()));
    }

    public static <T extends dqh> T getTE(CraftBlockEntityState<T> cbs) {
        try {
            return (T)((dqh)craftBlockEntityState_tileEntity.get(cbs));
        }
        catch (IllegalAccessException e) {
            Debug.echoError((Throwable)e);
            return null;
        }
    }

    public PlayerProfile getPlayerProfile(Skull skull) {
        cxu profile = ((dru)BlockHelperImpl.getTE((CraftSkull)skull)).i;
        if (profile == null) {
            return null;
        }
        Property property = (Property)Iterables.getFirst((Iterable)profile.e().get((Object)"textures"), null);
        return new PlayerProfile((String)profile.c().orElse(null), (UUID)profile.d().orElse(null), property != null ? property.value() : null);
    }

    public void setPlayerProfile(Skull skull, PlayerProfile playerProfile) {
        GameProfile gameProfile = ProfileEditorImpl.getGameProfile(playerProfile);
        try {
            craftSkull_profile.set(skull, gameProfile);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
        skull.update();
    }

    public CompoundTag getNbtData(Block block) {
        dqh te = ((CraftWorld)block.getWorld()).getHandle().getBlockEntity(new jd(block.getX(), block.getY(), block.getZ()), true);
        if (te != null) {
            ub compound = te.b((jo.a)CraftRegistry.getMinecraftRegistry());
            return CompoundTagImpl.fromNMSTag(compound);
        }
        return null;
    }

    public void setNbtData(Block block, CompoundTag ctag) {
        CompoundTagBuilder builder = ctag.createBuilder();
        builder.putInt("x", block.getX());
        builder.putInt("y", block.getY());
        builder.putInt("z", block.getZ());
        ctag = builder.build();
        jd blockPos = new jd(block.getX(), block.getY(), block.getZ());
        dqh te = ((CraftWorld)block.getWorld()).getHandle().getBlockEntity(blockPos, true);
        te.c(((CompoundTagImpl)ctag).toNMSTag(), (jo.a)CraftRegistry.getMinecraftRegistry());
    }

    public boolean setBlockResistance(Material material, float resistance) {
        dfy block = CraftMagicNumbers.getBlock((Material)material);
        if (block == null) {
            return false;
        }
        ReflectionHelper.setFieldValue(dtb.class, (String)ReflectionMappingsInfo.BlockBehaviour_explosionResistance, (Object)block, (Object)Float.valueOf(resistance));
        return true;
    }

    public float getBlockResistance(Material material) {
        dfy block = CraftMagicNumbers.getBlock((Material)material);
        if (block == null) {
            return 0.0f;
        }
        return ((Float)ReflectionHelper.getFieldValue(dtb.class, (String)ReflectionMappingsInfo.BlockBehaviour_explosionResistance, (Object)block)).floatValue();
    }

    public dtc getMaterialBlockState(Material bukkitMaterial) {
        dfy nmsBlock = CraftMagicNumbers.getBlock((Material)bukkitMaterial);
        return nmsBlock != null ? nmsBlock.o() : null;
    }

    public void setPushReaction(Material mat, BlockHelper.PistonPushReaction reaction) {
        try {
            MATERIAL_PUSH_REACTION_SETTER.invoke(this.getMaterialBlockState(mat), epj.values()[reaction.ordinal()]);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public float getBlockStrength(Material mat) {
        return this.getMaterialBlockState((Material)mat).n;
    }

    public void setBlockStrength(Material mat, float strength) {
        try {
            BLOCK_STRENGTH_SETTER.invoke(this.getMaterialBlockState(mat), strength);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void doRandomTick(Location location) {
        epe fluid;
        jd pos = CraftLocation.toBlockPosition((Location)location);
        duy nmsChunk = ((CraftChunk)location.getChunk()).getHandle(dvz.n);
        dtc nmsBlock = nmsChunk.a_(pos);
        aqu nmsWorld = ((CraftWorld)location.getWorld()).getHandle();
        if (nmsBlock.v()) {
            nmsBlock.b(nmsWorld, pos, nmsWorld.z);
        }
        if ((fluid = nmsBlock.u()).f()) {
            fluid.a((dcw)nmsWorld, pos, nmsWorld.z);
        }
    }

    public Instrument getInstrumentFor(Material mat) {
        return Instrument.values()[this.getMaterialBlockState(mat).A().ordinal()];
    }

    public int getExpDrop(Block block, ItemStack item) {
        dfy blockType = CraftMagicNumbers.getBlock((Material)block.getType());
        if (blockType == null) {
            return 0;
        }
        return blockType.getExpDrop(((CraftBlock)block).getNMS(), ((CraftBlock)block).getCraftWorld().getHandle(), ((CraftBlock)block).getPosition(), item == null ? null : CraftItemStack.asNMSCopy((ItemStack)item), true);
    }

    public void setSpawnerSpawnedType(CreatureSpawner spawner, EntityTag entity) {
        spawner.setSpawnedType(entity.getBukkitEntityType());
        if (entity.getWaitingMechanisms() == null || entity.getWaitingMechanisms().size() == 0) {
            return;
        }
        try {
            Entity bukkitEntity = ((CraftWorld)spawner.getWorld()).createEntity(spawner.getLocation(), entity.getBukkitEntityType().getEntityClass());
            bsr nmsEntity = ((CraftEntity)bukkitEntity).getHandle();
            EntityTag entityTag = new EntityTag(bukkitEntity);
            entityTag.isFake = true;
            entityTag.isFakeValid = true;
            for (Mechanism mechanism : entity.getWaitingMechanisms()) {
                entityTag.safeAdjustDuplicate(mechanism);
            }
            nmsEntity.dL();
            CraftCreatureSpawner bukkitSpawner = (CraftCreatureSpawner)spawner;
            drw nmsSnapshot = (drw)craftBlockEntityState_snapshot.get(bukkitSpawner);
            dby nmsSpawner = nmsSnapshot.c();
            ddo toSpawn = nmsSpawner.f;
            ub tag = toSpawn.a();
            nmsEntity.f(tag);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void setSpawnerCustomRules(CreatureSpawner spawner, int skyMin, int skyMax, int blockMin, int blockMax) {
        try {
            CraftCreatureSpawner bukkitSpawner = (CraftCreatureSpawner)spawner;
            drw nmsSnapshot = (drw)craftBlockEntityState_snapshot.get(bukkitSpawner);
            dby nmsSpawner = nmsSnapshot.c();
            ddo toSpawn = nmsSpawner.f;
            ddo.a rules = skyMin == -1 ? null : new ddo.a(new ayg((Comparable)Integer.valueOf(skyMin), (Comparable)Integer.valueOf(skyMax)), new ayg((Comparable)Integer.valueOf(blockMin), (Comparable)Integer.valueOf(blockMax)));
            nmsSpawner.f = new ddo(toSpawn.d(), Optional.ofNullable(rules), toSpawn.f());
            nmsSpawner.e = bpb.b();
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void setVanillaTags(Material material, Set<String> tags) {
        jm.c nmsHolder = CraftMagicNumbers.getBlock((Material)material).s();
        nmsHolder.c().forEach(arg_0 -> BlockHelperImpl.lambda$setVanillaTags$0((jm)nmsHolder, arg_0));
        ArrayList<awu> newNmsTags = new ArrayList<awu>();
        for (String tag : tags) {
            awu newNmsTag = awu.a((akq)lt.e.d(), (akr)akr.b((String)tag));
            jq.c nmsHolderSet = lt.e.a(newNmsTag);
            List nmsHolders = nmsHolderSet.a().collect(Collectors.toCollection(ArrayList::new));
            nmsHolders.add(nmsHolder);
            try {
                HOLDERSET_NAMED_BIND.invoke(nmsHolderSet, nmsHolders);
            }
            catch (Throwable ex) {
                Debug.echoError((Throwable)ex);
            }
            newNmsTags.add(newNmsTag);
            VanillaTagHelper.addOrUpdateMaterialTag((Tag)new CraftBlockTag((jz)lt.e, newNmsTag));
        }
        try {
            HOLDER_REFERENCE_BINDTAGS.invoke((jm)nmsHolder, newNmsTags);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
        PacketHelperImpl.broadcast(new zx(awx.a((jt)((CraftServer)Bukkit.getServer()).getServer().bd())));
    }

    private static /* synthetic */ void lambda$setVanillaTags$0(jm nmsHolder, awu nmsTag) {
        jq.c nmsHolderSet = lt.e.b(nmsTag).orElse(null);
        if (nmsHolderSet == null) {
            return;
        }
        List nmsHolders = nmsHolderSet.a().collect(Collectors.toCollection(ArrayList::new));
        nmsHolders.remove(nmsHolder);
        try {
            HOLDERSET_NAMED_BIND.invoke(nmsHolderSet, nmsHolders);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
        VanillaTagHelper.updateMaterialTag((Tag)new CraftBlockTag((jz)lt.e, nmsTag));
    }
}

