/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_21.helpers;

import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.ElementTag;
import java.util.HashMap;
import java.util.Map;

public class EntityDataNameMapper {
    public static final Map<Class<? extends bsr>, Map<String, Integer>> entityDataNames = new HashMap<Class<? extends bsr>, Map<String, Integer>>();

    public static void registerDataName(Class<? extends bsr> entityClass, int id, String name) {
        entityDataNames.computeIfAbsent(entityClass, k -> new HashMap()).put(name, id);
    }

    public static int getIdForName(Class<? extends bsr> entityClass, String name) {
        Class<? extends bsr> currentClass = entityClass;
        int id = EntityDataNameMapper.getIdFromClass(currentClass, name);
        while (id == -1 && (currentClass = currentClass.getSuperclass()) != Object.class) {
            id = EntityDataNameMapper.getIdFromClass(currentClass, name);
        }
        return id;
    }

    private static int getIdFromClass(Class<?> entityClass, String name) {
        int id;
        Map<String, Integer> nameToId = entityDataNames.get(entityClass);
        int n = id = nameToId != null ? nameToId.getOrDefault(name, -1) : -1;
        if (id == -1 && ArgumentHelper.matchesInteger((String)name)) {
            id = new ElementTag(name).asInt();
        }
        return id;
    }

    static {
        EntityDataNameMapper.registerDataName(bsr.class, 0, "entity_flags");
        EntityDataNameMapper.registerDataName(bsr.class, 1, "air_ticks");
        EntityDataNameMapper.registerDataName(bsr.class, 2, "custom_name");
        EntityDataNameMapper.registerDataName(bsr.class, 3, "custom_name_visible");
        EntityDataNameMapper.registerDataName(bsr.class, 4, "silent");
        EntityDataNameMapper.registerDataName(bsr.class, 5, "no_gravity");
        EntityDataNameMapper.registerDataName(bsr.class, 6, "pose");
        EntityDataNameMapper.registerDataName(bsr.class, 7, "frozen_ticks");
        EntityDataNameMapper.registerDataName(bth.class, 8, "width");
        EntityDataNameMapper.registerDataName(bth.class, 9, "height");
        EntityDataNameMapper.registerDataName(bth.class, 10, "responsive");
        EntityDataNameMapper.registerDataName(bsq.class, 8, "transform_interpolation_start");
        EntityDataNameMapper.registerDataName(bsq.class, 9, "transform_interpolation_duration");
        EntityDataNameMapper.registerDataName(bsq.class, 10, "movement_interpolation_duration");
        EntityDataNameMapper.registerDataName(bsq.class, 11, "translation");
        EntityDataNameMapper.registerDataName(bsq.class, 12, "scale");
        EntityDataNameMapper.registerDataName(bsq.class, 13, "left_rotation");
        EntityDataNameMapper.registerDataName(bsq.class, 14, "right_rotation");
        EntityDataNameMapper.registerDataName(bsq.class, 15, "billboard");
        EntityDataNameMapper.registerDataName(bsq.class, 16, "brightness");
        EntityDataNameMapper.registerDataName(bsq.class, 17, "view_range");
        EntityDataNameMapper.registerDataName(bsq.class, 18, "shadow_radius");
        EntityDataNameMapper.registerDataName(bsq.class, 19, "shadow_strength");
        EntityDataNameMapper.registerDataName(bsq.class, 20, "width");
        EntityDataNameMapper.registerDataName(bsq.class, 21, "height");
        EntityDataNameMapper.registerDataName(bsq.class, 22, "glow_color");
        EntityDataNameMapper.registerDataName(bsq.b.class, 23, "material");
        EntityDataNameMapper.registerDataName(bsq.g.class, 23, "item");
        EntityDataNameMapper.registerDataName(bsq.g.class, 24, "model_transform");
        EntityDataNameMapper.registerDataName(bsq.l.class, 23, "text");
        EntityDataNameMapper.registerDataName(bsq.l.class, 24, "line_width");
        EntityDataNameMapper.registerDataName(bsq.l.class, 25, "background_color");
        EntityDataNameMapper.registerDataName(bsq.l.class, 26, "text_opacity");
        EntityDataNameMapper.registerDataName(bsq.l.class, 27, "text_display_flags");
        EntityDataNameMapper.registerDataName(cnx.class, 8, "item");
        EntityDataNameMapper.registerDataName(cni.class, 8, "item");
        EntityDataNameMapper.registerDataName(cnk.class, 8, "spawn_position");
        EntityDataNameMapper.registerDataName(bsn.class, 8, "radius");
        EntityDataNameMapper.registerDataName(bsn.class, 9, "color");
        EntityDataNameMapper.registerDataName(bsn.class, 10, "waiting");
        EntityDataNameMapper.registerDataName(bsn.class, 11, "particle");
        EntityDataNameMapper.registerDataName(cnl.class, 8, "hooked_entity_id");
        EntityDataNameMapper.registerDataName(cnl.class, 9, "catchable");
        EntityDataNameMapper.registerDataName(cnd.class, 8, "abstract_arrow_flags");
        EntityDataNameMapper.registerDataName(cnd.class, 9, "piercing_level");
        EntityDataNameMapper.registerDataName(cnf.class, 10, "color");
        EntityDataNameMapper.registerDataName(coc.class, 10, "loyalty_level");
        EntityDataNameMapper.registerDataName(coc.class, 11, "enchantment_glint");
        EntityDataNameMapper.registerDataName(cov.class, 8, "shaking_ticks");
        EntityDataNameMapper.registerDataName(cov.class, 9, "shaking_direction");
        EntityDataNameMapper.registerDataName(cov.class, 10, "damage_taken");
        EntityDataNameMapper.registerDataName(cov.class, 11, "type");
        EntityDataNameMapper.registerDataName(cov.class, 12, "left_paddle_moving");
        EntityDataNameMapper.registerDataName(cov.class, 13, "right_paddle_moving");
        EntityDataNameMapper.registerDataName(cov.class, 14, "bubble_shaking_ticks");
        EntityDataNameMapper.registerDataName(chz.class, 8, "beam_target");
        EntityDataNameMapper.registerDataName(chz.class, 9, "showing_bottom");
        EntityDataNameMapper.registerDataName(cnt.class, 8, "item");
        EntityDataNameMapper.registerDataName(cnj.class, 8, "item");
        EntityDataNameMapper.registerDataName(cod.class, 8, "invulnerable");
        EntityDataNameMapper.registerDataName(cnk.class, 8, "item");
        EntityDataNameMapper.registerDataName(cnk.class, 9, "shooter_id");
        EntityDataNameMapper.registerDataName(cnk.class, 10, "shot_at_angle");
        EntityDataNameMapper.registerDataName(cja.class, 8, "item");
        EntityDataNameMapper.registerDataName(cja.class, 9, "rotation");
        EntityDataNameMapper.registerDataName(cjc.class, 8, "painting_variant");
        EntityDataNameMapper.registerDataName(btn.class, 8, "living_entity_flags");
        EntityDataNameMapper.registerDataName(btn.class, 9, "health");
        EntityDataNameMapper.registerDataName(btn.class, 10, "potion_effect_color");
        EntityDataNameMapper.registerDataName(btn.class, 11, "is_potion_effect_ambient");
        EntityDataNameMapper.registerDataName(btn.class, 12, "arrows_in_body");
        EntityDataNameMapper.registerDataName(btn.class, 13, "bee_stingers_in_body");
        EntityDataNameMapper.registerDataName(btn.class, 14, "bed_location");
        EntityDataNameMapper.registerDataName(cmx.class, 15, "additional_hearts");
        EntityDataNameMapper.registerDataName(cmx.class, 16, "score");
        EntityDataNameMapper.registerDataName(cmx.class, 17, "skin_parts");
        EntityDataNameMapper.registerDataName(cmx.class, 18, "main_hand");
        EntityDataNameMapper.registerDataName(cmx.class, 19, "left_shoulder_entity");
        EntityDataNameMapper.registerDataName(cmx.class, 20, "right_shoulder_entity");
        EntityDataNameMapper.registerDataName(ciw.class, 15, "armor_stand_flags");
        EntityDataNameMapper.registerDataName(ciw.class, 16, "head_rotation");
        EntityDataNameMapper.registerDataName(ciw.class, 17, "body_rotation");
        EntityDataNameMapper.registerDataName(ciw.class, 18, "left_arm_rotation");
        EntityDataNameMapper.registerDataName(ciw.class, 19, "right_arm_rotation");
        EntityDataNameMapper.registerDataName(ciw.class, 20, "left_leg_rotation");
        EntityDataNameMapper.registerDataName(ciw.class, 21, "right_leg_rotation");
        EntityDataNameMapper.registerDataName(btp.class, 15, "mob_flags");
        EntityDataNameMapper.registerDataName(cez.class, 16, "bat_flags");
        EntityDataNameMapper.registerDataName(cfm.class, 16, "treasure_location");
        EntityDataNameMapper.registerDataName(cfm.class, 17, "has_fish");
        EntityDataNameMapper.registerDataName(cfm.class, 18, "moisture_level");
        EntityDataNameMapper.registerDataName(cfb.class, 16, "from_bucket");
        EntityDataNameMapper.registerDataName(cfx.class, 17, "puff_state");
        EntityDataNameMapper.registerDataName(cge.class, 17, "variant");
        EntityDataNameMapper.registerDataName(bsl.class, 16, "is_baby");
        EntityDataNameMapper.registerDataName(chv.class, 17, "sniffer_state");
        EntityDataNameMapper.registerDataName(chv.class, 18, "finish_dig_time");
        EntityDataNameMapper.registerDataName(chi.class, 17, "horse_flags");
        EntityDataNameMapper.registerDataName(chk.class, 18, "variant");
        EntityDataNameMapper.registerDataName(cgv.class, 18, "is_dashing");
        EntityDataNameMapper.registerDataName(cgv.class, 19, "last_pose_change");
        EntityDataNameMapper.registerDataName(chh.class, 18, "has_chest");
        EntityDataNameMapper.registerDataName(chl.class, 19, "strength");
        EntityDataNameMapper.registerDataName(chl.class, 20, "carpet_color");
        EntityDataNameMapper.registerDataName(chl.class, 21, "variant");
        EntityDataNameMapper.registerDataName(cgq.class, 17, "variant");
        EntityDataNameMapper.registerDataName(cgq.class, 18, "playing_dead");
        EntityDataNameMapper.registerDataName(cgq.class, 19, "from_bucket");
        EntityDataNameMapper.registerDataName(cff.class, 17, "bee_flags");
        EntityDataNameMapper.registerDataName(cff.class, 18, "anger_time");
        EntityDataNameMapper.registerDataName(cfo.class, 17, "type");
        EntityDataNameMapper.registerDataName(cfo.class, 18, "fox_flags");
        EntityDataNameMapper.registerDataName(cfo.class, 19, "first_trusted_uuid");
        EntityDataNameMapper.registerDataName(cfo.class, 20, "second_trusted_uuid");
        EntityDataNameMapper.registerDataName(cgy.class, 17, "variant");
        EntityDataNameMapper.registerDataName(cgy.class, 18, "target_id");
        EntityDataNameMapper.registerDataName(cfs.class, 17, "is_trusting");
        EntityDataNameMapper.registerDataName(cft.class, 17, "ask_for_bamboo_timer");
        EntityDataNameMapper.registerDataName(cft.class, 18, "sneeze_timer");
        EntityDataNameMapper.registerDataName(cft.class, 19, "eat_timer");
        EntityDataNameMapper.registerDataName(cft.class, 20, "main_gene");
        EntityDataNameMapper.registerDataName(cft.class, 21, "hidden_gene");
        EntityDataNameMapper.registerDataName(cft.class, 22, "panda_flags");
        EntityDataNameMapper.registerDataName(cfv.class, 17, "has_saddle");
        EntityDataNameMapper.registerDataName(cfv.class, 18, "boost_ticks");
        EntityDataNameMapper.registerDataName(cfy.class, 17, "type");
        EntityDataNameMapper.registerDataName(cgf.class, 17, "home_location");
        EntityDataNameMapper.registerDataName(cgf.class, 18, "has_egg");
        EntityDataNameMapper.registerDataName(cgf.class, 19, "laying_egg");
        EntityDataNameMapper.registerDataName(cgf.class, 20, "travel_location");
        EntityDataNameMapper.registerDataName(cgf.class, 21, "going_home");
        EntityDataNameMapper.registerDataName(cgf.class, 20, "traveling");
        EntityDataNameMapper.registerDataName(cfw.class, 17, "standing_up");
        EntityDataNameMapper.registerDataName(clh.class, 17, "immune_to_zombification");
        EntityDataNameMapper.registerDataName(cfr.class, 17, "variant");
        EntityDataNameMapper.registerDataName(cga.class, 17, "sheep_wool_flags");
        EntityDataNameMapper.registerDataName(ckq.class, 17, "boost_ticks");
        EntityDataNameMapper.registerDataName(ckq.class, 18, "shaking");
        EntityDataNameMapper.registerDataName(ckq.class, 19, "has_saddle");
        EntityDataNameMapper.registerDataName(bul.class, 17, "tamable_animal_flags");
        EntityDataNameMapper.registerDataName(bul.class, 18, "owner");
        EntityDataNameMapper.registerDataName(cfh.class, 19, "variant");
        EntityDataNameMapper.registerDataName(cfh.class, 20, "lying");
        EntityDataNameMapper.registerDataName(cfh.class, 20, "relaxed");
        EntityDataNameMapper.registerDataName(cfh.class, 21, "collar_color");
        EntityDataNameMapper.registerDataName(cgh.class, 19, "begging");
        EntityDataNameMapper.registerDataName(cgh.class, 20, "collar_color");
        EntityDataNameMapper.registerDataName(cgh.class, 21, "anger_time");
        EntityDataNameMapper.registerDataName(cfu.class, 19, "variant");
        EntityDataNameMapper.registerDataName(cmf.class, 17, "head_shake_ticks");
        EntityDataNameMapper.registerDataName(cmk.class, 18, "villager_data");
        EntityDataNameMapper.registerDataName(cfq.class, 16, "iron_golem_flags");
        EntityDataNameMapper.registerDataName(cgc.class, 16, "snow_golem_pumpkin_flags");
        EntityDataNameMapper.registerDataName(ckj.class, 16, "attach_face");
        EntityDataNameMapper.registerDataName(ckj.class, 17, "attachment_location");
        EntityDataNameMapper.registerDataName(ckj.class, 18, "peek");
        EntityDataNameMapper.registerDataName(ckj.class, 19, "color");
        EntityDataNameMapper.registerDataName(clm.class, 16, "immune_to_zombification");
        EntityDataNameMapper.registerDataName(cln.class, 17, "is_baby");
        EntityDataNameMapper.registerDataName(cln.class, 18, "charging_crossbow");
        EntityDataNameMapper.registerDataName(cln.class, 19, "dancing");
        EntityDataNameMapper.registerDataName(cjm.class, 16, "blaze_flags");
        EntityDataNameMapper.registerDataName(cjp.class, 16, "state");
        EntityDataNameMapper.registerDataName(cjp.class, 17, "charged");
        EntityDataNameMapper.registerDataName(cjp.class, 18, "ignited");
        EntityDataNameMapper.registerDataName(che.class, 17, "screaming");
        EntityDataNameMapper.registerDataName(che.class, 18, "has_left_horn");
        EntityDataNameMapper.registerDataName(che.class, 19, "has_right_horn");
        EntityDataNameMapper.registerDataName(cjz.class, 16, "spikes_retracted");
        EntityDataNameMapper.registerDataName(cjz.class, 17, "target_id");
        EntityDataNameMapper.registerDataName(coj.class, 16, "celebrating");
        EntityDataNameMapper.registerDataName(ckg.class, 17, "charging_crossbow");
        EntityDataNameMapper.registerDataName(ckn.class, 17, "spell");
        EntityDataNameMapper.registerDataName(ckt.class, 17, "drinking_potion");
        EntityDataNameMapper.registerDataName(ckr.class, 16, "vex_flags");
        EntityDataNameMapper.registerDataName(cko.class, 16, "spider_flags");
        EntityDataNameMapper.registerDataName(cmb.class, 16, "anger_level");
        EntityDataNameMapper.registerDataName(ciu.class, 16, "center_head_target");
        EntityDataNameMapper.registerDataName(ciu.class, 17, "left_head_target");
        EntityDataNameMapper.registerDataName(ciu.class, 18, "right_head_target");
        EntityDataNameMapper.registerDataName(ciu.class, 19, "invulnerable_time");
        EntityDataNameMapper.registerDataName(ckv.class, 16, "is_baby");
        EntityDataNameMapper.registerDataName(ckw.class, 16, "is_baby");
        EntityDataNameMapper.registerDataName(ckw.class, 17, "type");
        EntityDataNameMapper.registerDataName(ckw.class, 18, "converting_in_water");
        EntityDataNameMapper.registerDataName(ckx.class, 19, "is_converting");
        EntityDataNameMapper.registerDataName(ckx.class, 20, "villager_data");
        EntityDataNameMapper.registerDataName(cjt.class, 16, "carried_block");
        EntityDataNameMapper.registerDataName(cjt.class, 17, "screaming");
        EntityDataNameMapper.registerDataName(cjt.class, 18, "staring");
        EntityDataNameMapper.registerDataName(cia.class, 16, "phase");
        EntityDataNameMapper.registerDataName(cjx.class, 16, "attacking");
        EntityDataNameMapper.registerDataName(ckf.class, 16, "size");
        EntityDataNameMapper.registerDataName(ckm.class, 16, "size");
        EntityDataNameMapper.registerDataName(cot.class, 8, "shaking_ticks");
        EntityDataNameMapper.registerDataName(cot.class, 9, "shaking_direction");
        EntityDataNameMapper.registerDataName(cot.class, 10, "damage_taken");
        EntityDataNameMapper.registerDataName(cot.class, 11, "display_block_id");
        EntityDataNameMapper.registerDataName(cot.class, 12, "display_block_y");
        EntityDataNameMapper.registerDataName(cot.class, 13, "show_display_block");
        EntityDataNameMapper.registerDataName(cpc.class, 14, "has_fuel");
        EntityDataNameMapper.registerDataName(cpb.class, 14, "command");
        EntityDataNameMapper.registerDataName(cpb.class, 15, "last_output");
        EntityDataNameMapper.registerDataName(cji.class, 8, "fuse_ticks");
    }
}

