/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_21.impl;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.abstracts.BiomeNMS;
import com.denizenscript.denizen.nms.v1_21.ReflectionMappingsInfo;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntityType;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftLocation;
import org.bukkit.entity.EntityType;

public class BiomeNMSImpl
extends BiomeNMS {
    public static final MethodHandle BIOME_CLIMATESETTINGS_CONSTRUCTOR = ReflectionHelper.getConstructor(ddw.b.class, (Class[])new Class[]{Boolean.TYPE, Float.TYPE, ddw.d.class, Float.TYPE});
    public jm<ddw> biomeHolder;
    public aqu world;

    public BiomeNMSImpl(aqu world, String name) {
        super((World)world.getWorld(), name);
        this.world = world;
        this.biomeHolder = world.H_().d(lu.aF).b(akq.a((akq)lu.aF, (akr)akr.b((String)name))).orElse(null);
    }

    public BiomeNMS.DownfallType getDownfallTypeAt(Location location) {
        ddw.c precipitation = ((ddw)this.biomeHolder.a()).a(CraftLocation.toBlockPosition((Location)location));
        return switch (precipitation) {
            default -> throw new IncompatibleClassChangeError();
            case ddw.c.b -> BiomeNMS.DownfallType.RAIN;
            case ddw.c.c -> BiomeNMS.DownfallType.SNOW;
            case ddw.c.a -> BiomeNMS.DownfallType.NONE;
        };
    }

    public float getHumidity() {
        return ((ddw)this.biomeHolder.a()).i.d();
    }

    public float getBaseTemperature() {
        return ((ddw)this.biomeHolder.a()).g();
    }

    public float getTemperatureAt(Location location) {
        return ((ddw)this.biomeHolder.a()).f(CraftLocation.toBlockPosition((Location)location));
    }

    public boolean hasDownfall() {
        return ((ddw)this.biomeHolder.a()).c();
    }

    public List<EntityType> getAmbientEntities() {
        return this.getSpawnableEntities(btq.c);
    }

    public List<EntityType> getCreatureEntities() {
        return this.getSpawnableEntities(btq.b);
    }

    public List<EntityType> getMonsterEntities() {
        return this.getSpawnableEntities(btq.a);
    }

    public List<EntityType> getWaterEntities() {
        return this.getSpawnableEntities(btq.f);
    }

    public int getFoliageColor() {
        if (((ddw)this.biomeHolder.a()).f() != 0) {
            return ((ddw)this.biomeHolder.a()).f();
        }
        float temperature = this.clampColor(this.getBaseTemperature());
        float humidity = this.clampColor(this.getHumidity());
        int temperatureValue = (int)((1.0f - temperature) * 255.0f);
        int humidityValue = (int)((1.0f - (humidity *= temperature)) * 255.0f);
        int index = temperatureValue << 8 | humidityValue;
        return index >= 65536 ? 4764952 : this.getColor(index / 256, index % 256).asRGB();
    }

    public void setClimate(boolean hasPrecipitation, float temperature, ddw.d temperatureModifier, float downfall) {
        try {
            Object newClimate = BIOME_CLIMATESETTINGS_CONSTRUCTOR.invoke(hasPrecipitation, temperature, temperatureModifier, downfall);
            ReflectionHelper.setFieldValue(ddw.class, (String)ReflectionMappingsInfo.Biome_climateSettings, (Object)this.biomeHolder.a(), (Object)newClimate);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void setHumidity(float humidity) {
        this.setClimate(this.hasDownfall(), this.getBaseTemperature(), this.getTemperatureModifier(), humidity);
    }

    public void setBaseTemperature(float baseTemperature) {
        this.setClimate(this.hasDownfall(), baseTemperature, this.getTemperatureModifier(), this.getHumidity());
    }

    public void setHasDownfall(boolean hasDownfall) {
        this.setClimate(hasDownfall, this.getBaseTemperature(), this.getTemperatureModifier(), this.getHumidity());
    }

    public void setFoliageColor(int color) {
        ReflectionHelper.setFieldValue(dec.class, (String)ReflectionMappingsInfo.BiomeSpecialEffects_foliageColorOverride, (Object)((ddw)this.biomeHolder.a()).h(), Optional.of(color));
    }

    public int getFogColor() {
        return ((ddw)this.biomeHolder.a()).e();
    }

    public void setFogColor(int color) {
        ReflectionHelper.setFieldValue(dec.class, (String)ReflectionMappingsInfo.BiomeSpecialEffects_fogColor, (Object)((ddw)this.biomeHolder.a()).h(), (Object)color);
    }

    public int getWaterFogColor() {
        return ((ddw)this.biomeHolder.a()).j();
    }

    public void setWaterFogColor(int color) {
        ReflectionHelper.setFieldValue(dec.class, (String)ReflectionMappingsInfo.BiomeSpecialEffects_waterFogColor, (Object)((ddw)this.biomeHolder.a()).h(), (Object)color);
    }

    private List<EntityType> getSpawnableEntities(btq creatureType) {
        dei mobs = ((ddw)this.biomeHolder.a()).b();
        bpf typeSettingList = mobs.a(creatureType);
        ArrayList<EntityType> entityTypes = new ArrayList<EntityType>();
        if (typeSettingList == null) {
            return entityTypes;
        }
        for (dei.c meta : typeSettingList.e()) {
            entityTypes.add(CraftEntityType.minecraftToBukkit((bsx)meta.b));
        }
        return entityTypes;
    }

    public void setTo(Block block) {
        dvi chunk;
        if (((CraftWorld)block.getWorld()).getHandle() != this.world) {
            NMSHandler.instance.getBiomeNMS(block.getWorld(), this.getName()).setTo(block);
            return;
        }
        jd pos = new jd(block.getX(), 0, block.getZ());
        if (this.world.B(pos) && (chunk = this.world.m(pos)) != null) {
            chunk.setBiome(block.getX() >> 2, block.getY() >> 2, block.getZ() >> 2, this.biomeHolder);
            chunk.a(true);
        }
    }

    public ddw.d getTemperatureModifier() {
        return ((ddw)this.biomeHolder.a()).i.c();
    }
}

