/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_21.helpers;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.nms.abstracts.ImprovedOfflinePlayer;
import com.denizenscript.denizen.nms.enums.CustomEntityType;
import com.denizenscript.denizen.nms.interfaces.PlayerHelper;
import com.denizenscript.denizen.nms.v1_21.Handler;
import com.denizenscript.denizen.nms.v1_21.ReflectionMappingsInfo;
import com.denizenscript.denizen.nms.v1_21.helpers.ItemHelperImpl;
import com.denizenscript.denizen.nms.v1_21.helpers.PacketHelperImpl;
import com.denizenscript.denizen.nms.v1_21.impl.ImprovedOfflinePlayerImpl;
import com.denizenscript.denizen.nms.v1_21.impl.ProfileEditorImpl;
import com.denizenscript.denizen.nms.v1_21.impl.entities.CraftFakePlayerImpl;
import com.denizenscript.denizen.nms.v1_21.impl.entities.EntityItemProjectileImpl;
import com.denizenscript.denizen.nms.v1_21.impl.network.handlers.AbstractListenerPlayInImpl;
import com.denizenscript.denizen.nms.v1_21.impl.network.handlers.DenizenNetworkManagerImpl;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.FormattedTextHelper;
import com.denizenscript.denizen.utilities.entity.DenizenEntityType;
import com.denizenscript.denizen.utilities.entity.FakeEntity;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import it.unimi.dsi.fastutil.ints.IntList;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.md_5.bungee.api.ChatColor;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.boss.BossBar;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R1.boss.CraftBossBar;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftMagicNumbers;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PlayerHelperImpl
extends PlayerHelper {
    public static final Field ATTACK_COOLDOWN_TICKS = ReflectionHelper.getFields(btn.class).get(ReflectionMappingsInfo.LivingEntity_attackStrengthTicker, Integer.TYPE);
    public static final Field FLY_TICKS = ReflectionHelper.getFields(aru.class).get(ReflectionMappingsInfo.ServerGamePacketListenerImpl_aboveGroundTickCount, Integer.TYPE);
    public static final Field VEHICLE_FLY_TICKS = ReflectionHelper.getFields(aru.class).get(ReflectionMappingsInfo.ServerGamePacketListenerImpl_aboveGroundVehicleTickCount, Integer.TYPE);
    public static final Field PASSENGERS_PACKET_PASSENGERS = ReflectionHelper.getFields(afg.class).get(ReflectionMappingsInfo.ClientboundSetPassengersPacket_passengers, int[].class);
    public static final MethodHandle PLAYER_RESPAWNFORCED_SETTER = ReflectionHelper.getFinalSetter(aqv.class, (String)ReflectionMappingsInfo.ServerPlayer_respawnForced, Boolean.TYPE);
    public static final ajw<Byte> PLAYER_DATA_ACCESSOR_SKINLAYERS = (ajw)ReflectionHelper.getFieldValue(cmx.class, (String)ReflectionMappingsInfo.Player_DATA_PLAYER_MODE_CUSTOMISATION, null);

    public void stopSound(Player player, String sound, SoundCategory category) {
        ((CraftPlayer)player).getHandle().c.b((zg)new afr(sound == null ? null : akr.b((String)sound), null));
    }

    public void deTrackEntity(Player player, Entity entity) {
        aqv nmsPlayer = ((CraftPlayer)player).getHandle();
        aqb.b tracker = (aqb.b)nmsPlayer.A().l().a.K.get(entity.getEntityId());
        if (tracker == null) {
            if (NMSHandler.debugPackets) {
                DenizenNetworkManagerImpl.doPacketOutput("Failed to de-track entity " + entity.getEntityId() + " for " + player.getName() + ": tracker null");
            }
            return;
        }
        this.sendEntityDestroy(player, entity);
        tracker.a(nmsPlayer);
    }

    public void addFakePassenger(List<PlayerTag> players, Entity vehicle, FakeEntity fakePassenger) {
        afg packet = new afg(((CraftEntity)vehicle).getHandle());
        int[] newPassengers = Arrays.copyOf(packet.b(), packet.b().length + 1);
        newPassengers[packet.b().length] = fakePassenger.id;
        try {
            PASSENGERS_PACKET_PASSENGERS.set(packet, newPassengers);
        }
        catch (IllegalAccessException e) {
            Debug.echoError((Throwable)e);
        }
        for (PlayerTag player : players) {
            PacketHelperImpl.send(player.getPlayerEntity(), packet);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FakeEntity sendEntitySpawn(List<PlayerTag> players, DenizenEntityType entityType, LocationTag location, ArrayList<Mechanism> mechanisms, int customId, UUID customUUID, boolean autoTrack) {
        void var9_15;
        Entity entity;
        CraftWorld world = (CraftWorld)location.getWorld();
        if (entityType.isCustom()) {
            if (entityType.customEntityType == CustomEntityType.ITEM_PROJECTILE) {
                ItemStack itemStack = new ItemStack(Material.STONE);
                for (Mechanism mechanism : mechanisms) {
                    if (!mechanism.matches("item") || !mechanism.requireObject(ItemTag.class)) continue;
                    itemStack = ((ItemTag)mechanism.valueAsType(ItemTag.class)).getItemStack();
                }
                EntityItemProjectileImpl entityItemProjectileImpl = new EntityItemProjectileImpl((dcw)world.getHandle(), (Location)location, CraftItemStack.asNMSCopy((ItemStack)itemStack));
            } else {
                if (entityType.customEntityType != CustomEntityType.FAKE_PLAYER) throw new IllegalArgumentException("entityType");
                String name = null;
                Object skin = null;
                String blob = null;
                for (Mechanism mechanism : new ArrayList<Mechanism>(mechanisms)) {
                    if (mechanism.matches("name")) {
                        name = mechanism.getValue().asString();
                        mechanisms.remove(mechanism);
                    } else if (mechanism.matches("skin")) {
                        skin = mechanism.getValue().asString();
                        mechanisms.remove(mechanism);
                    } else if (mechanism.matches("skin_blob")) {
                        blob = mechanism.getValue().asString();
                        mechanisms.remove(mechanism);
                    }
                    if (name == null || skin == null && blob == null) continue;
                    break;
                }
                aqv aqv2 = ((CraftFakePlayerImpl)NMSHandler.customEntityHelper.spawnFakePlayer((Location)location, name, skin, blob, false)).getHandle();
            }
        } else {
            entity = world.createEntity((Location)location, entityType.getBukkitEntityType().getEntityClass());
            bsr bsr2 = ((CraftEntity)entity).getHandle();
        }
        if (customUUID != null) {
            var9_15.e(customId);
            var9_15.a_(customUUID);
        }
        entity = new EntityTag((Entity)var9_15.getBukkitEntity());
        entity.isFake = true;
        entity.isFakeValid = true;
        for (Mechanism mechanism : mechanisms) {
            entity.safeAdjustDuplicate(mechanism);
        }
        var9_15.dL();
        FakeEntity fake = new FakeEntity(players, location, entity.getBukkitEntity().getEntityId());
        fake.entity = new EntityTag(entity.getBukkitEntity());
        fake.entity.isFake = true;
        fake.entity.isFakeValid = true;
        ArrayList trackers = new ArrayList();
        fake.triggerSpawnPacket = arg_0 -> this.lambda$sendEntitySpawn$0(world, (bsr)var9_15, trackers, autoTrack, fake, arg_0);
        for (PlayerTag player : players) {
            fake.triggerSpawnPacket.accept(player);
        }
        fake.triggerUpdatePacket = () -> {
            for (TrackerData tracker : trackers) {
                if (!tracker.player.isOnline()) continue;
                tracker.tracker.a();
            }
        };
        fake.triggerDestroyPacket = () -> {
            for (TrackerData tracker : trackers) {
                if (!tracker.player.isOnline()) continue;
                tracker.tracker.a(((CraftPlayer)tracker.player.getPlayerEntity()).getHandle());
            }
            trackers.clear();
        };
        return fake;
    }

    public void sendEntityDestroy(Player player, Entity entity) {
        ((CraftPlayer)player).getHandle().c.b((zg)new aef(new int[]{entity.getEntityId()}));
    }

    public int getFlyKickCooldown(Player player) {
        aru conn = ((CraftPlayer)player).getHandle().c;
        if (conn instanceof AbstractListenerPlayInImpl) {
            AbstractListenerPlayInImpl denizenListener = (AbstractListenerPlayInImpl)conn;
            conn = denizenListener.oldListener;
        }
        try {
            return Math.max(80 - Math.max(FLY_TICKS.getInt(conn), VEHICLE_FLY_TICKS.getInt(conn)), 0);
        }
        catch (IllegalAccessException e) {
            Debug.echoError((Throwable)e);
            return 80;
        }
    }

    public void setFlyKickCooldown(Player player, int ticks) {
        ticks = 80 - ticks;
        aru conn = ((CraftPlayer)player).getHandle().c;
        if (conn instanceof AbstractListenerPlayInImpl) {
            AbstractListenerPlayInImpl denizenListener = (AbstractListenerPlayInImpl)conn;
            conn = denizenListener.oldListener;
        }
        try {
            FLY_TICKS.setInt(conn, ticks);
            VEHICLE_FLY_TICKS.setInt(conn, ticks);
        }
        catch (IllegalAccessException e) {
            Debug.echoError((Throwable)e);
        }
    }

    public int ticksPassedDuringCooldown(Player player) {
        try {
            return ATTACK_COOLDOWN_TICKS.getInt(((CraftPlayer)player).getHandle());
        }
        catch (IllegalAccessException e) {
            Debug.echoError((Throwable)e);
            return -1;
        }
    }

    public float getMaxAttackCooldownTicks(Player player) {
        return ((CraftPlayer)player).getHandle().gr() + 3.0f;
    }

    public void setAttackCooldown(Player player, int ticks) {
        try {
            ATTACK_COOLDOWN_TICKS.setInt(((CraftPlayer)player).getHandle(), ticks);
        }
        catch (IllegalAccessException e) {
            Debug.echoError((Throwable)e);
        }
    }

    public boolean hasChunkLoaded(Player player, Chunk chunk) {
        return ((CraftWorld)chunk.getWorld()).getHandle().l().a.a(new dcd(chunk.getX(), chunk.getZ()), false).stream().anyMatch(entityPlayer -> entityPlayer.cz().equals(player.getUniqueId()));
    }

    public void setTemporaryOp(Player player, boolean op) {
        apn server = ((CraftServer)Bukkit.getServer()).getServer();
        GameProfile profile = ((CraftPlayer)player).getProfile();
        aus opList = server.ah().k();
        if (op) {
            opList.a((auv)new aut(profile, server.k(), opList.a(profile)));
        } else {
            opList.c((Object)profile);
        }
        player.recalculatePermissions();
    }

    public void showEndCredits(Player player) {
        ((CraftPlayer)player).getHandle().h = true;
        ((CraftPlayer)player).getHandle().c.b((zg)new adb(adb.f, 1.0f));
    }

    public ImprovedOfflinePlayer getOfflineData(UUID uuid) {
        return new ImprovedOfflinePlayerImpl(uuid);
    }

    public void resendRecipeDetails(Player player) {
        Collection recipes = ((CraftServer)Bukkit.getServer()).getServer().aJ().d();
        agc updatePacket = new agc(recipes);
        ((CraftPlayer)player).getHandle().c.b((zg)updatePacket);
    }

    public void resendDiscoveredRecipes(Player player) {
        avu recipeBook = ((CraftPlayer)player).getHandle().J();
        recipeBook.a(((CraftPlayer)player).getHandle());
    }

    public void quietlyAddRecipe(Player player, NamespacedKey key) {
        avu recipeBook = ((CraftPlayer)player).getHandle().J();
        czb<?> recipe = ItemHelperImpl.getNMSRecipe(key);
        if (recipe == null) {
            Debug.echoError((String)("Cannot add recipe '" + String.valueOf(key) + "': it does not exist."));
            return;
        }
        recipeBook.a(recipe);
        recipeBook.f(recipe);
    }

    public byte getSkinLayers(Player player) {
        return (Byte)((CraftPlayer)player).getHandle().ar().a(PLAYER_DATA_ACCESSOR_SKINLAYERS);
    }

    public void setSkinLayers(Player player, byte flags) {
        ((CraftPlayer)player).getHandle().ar().a(PLAYER_DATA_ACCESSOR_SKINLAYERS, (Object)flags);
    }

    public void setBossBarTitle(BossBar bar, String title) {
        ((CraftBossBar)bar).getHandle().a = Handler.componentToNMS(FormattedTextHelper.parse((String)title, (ChatColor)ChatColor.WHITE));
        ((CraftBossBar)bar).getHandle().a(ace::c);
    }

    public boolean getSpawnForced(Player player) {
        return ((CraftPlayer)player).getHandle().V();
    }

    public void setSpawnForced(Player player, boolean forced) {
        aqv nmsPlayer = ((CraftPlayer)player).getHandle();
        try {
            PLAYER_RESPAWNFORCED_SETTER.invoke(nmsPlayer, forced);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public Location getBedSpawnLocation(Player player) {
        aqv nmsPlayer = ((CraftPlayer)player).getHandle();
        jd spawnPosition = nmsPlayer.S();
        if (spawnPosition == null) {
            return null;
        }
        aqu nmsWorld = MinecraftServer.getServer().a(nmsPlayer.U());
        if (nmsWorld == null) {
            return null;
        }
        return new Location((World)nmsWorld.getWorld(), (double)spawnPosition.u(), (double)spawnPosition.v(), (double)spawnPosition.w(), nmsPlayer.T(), 0.0f);
    }

    public long getLastActionTime(Player player) {
        return ((CraftPlayer)player).getHandle().N();
    }

    public void sendPlayerInfoAddPacket(Player player, EnumSet<PlayerHelper.ProfileEditMode> editModes, String name, String display, UUID id, String texture, String signature, int latency, GameMode gameMode, boolean listed) {
        EnumSet<aea.a> actions = EnumSet.noneOf(aea.a.class);
        for (PlayerHelper.ProfileEditMode editMode : editModes) {
            actions.add(switch (editMode) {
                default -> throw new IncompatibleClassChangeError();
                case PlayerHelper.ProfileEditMode.ADD -> aea.a.a;
                case PlayerHelper.ProfileEditMode.UPDATE_DISPLAY -> aea.a.f;
                case PlayerHelper.ProfileEditMode.UPDATE_LATENCY -> aea.a.e;
                case PlayerHelper.ProfileEditMode.UPDATE_GAME_MODE -> aea.a.c;
                case PlayerHelper.ProfileEditMode.UPDATE_LISTED -> aea.a.d;
            });
        }
        GameProfile profile = new GameProfile(id, name != null ? name : "");
        if (texture != null) {
            profile.getProperties().put((Object)"textures", (Object)new Property("textures", texture, signature));
        }
        aea.b entry = new aea.b(id, profile, listed, latency, gameMode == null ? null : dct.a((int)gameMode.getValue()), display == null ? null : Handler.componentToNMS(FormattedTextHelper.parse((String)display, (ChatColor)ChatColor.WHITE)), null);
        PacketHelperImpl.send(player, ProfileEditorImpl.createInfoPacket(actions, List.of(entry)));
    }

    public void sendPlayerInfoRemovePacket(Player player, UUID id) {
        PacketHelperImpl.send(player, new adz(List.of(id)));
    }

    public void sendClimbableMaterials(Player player, List<Material> materials) {
        Map packetInput = awx.a((jt)((CraftServer)Bukkit.getServer()).getServer().bd());
        Map tags = (Map)ReflectionHelper.getFieldValue(awx.a.class, (String)ReflectionMappingsInfo.TagNetworkSerializationNetworkPayload_tags, packetInput.get(lt.e.d()));
        IntList climbableBlocks = (IntList)tags.get(awe.aQ.b());
        climbableBlocks.clear();
        for (Material material : materials) {
            climbableBlocks.add(lt.e.a((Object)CraftMagicNumbers.getBlock((Material)material)));
        }
        PacketHelperImpl.send(player, new zx(packetInput));
    }

    public void refreshPlayer(Player player) {
        aqv nmsPlayer = ((CraftPlayer)player).getHandle();
        aqu nmsWorld = (aqu)nmsPlayer.dO();
        nmsPlayer.c.b((zg)new aei(nmsPlayer.b(nmsWorld), 3));
        nmsPlayer.c.teleport(player.getLocation());
        if (nmsPlayer.bS()) {
            nmsPlayer.c.b((zg)new afg(nmsPlayer.dc()));
        }
        if (nmsPlayer.bT()) {
            nmsPlayer.c.b((zg)new afg((bsr)nmsPlayer));
        }
        ewx boundingBox = new ewx(nmsPlayer.dm(), nmsPlayer.dm()).g(10.0);
        for (btp nmsMob2 : nmsWorld.a(btp.class, boundingBox, nmsMob -> nmsPlayer.equals((Object)nmsMob.A()))) {
            nmsPlayer.c.b((zg)new afa((bsr)nmsMob2, (bsr)nmsPlayer));
        }
        if (!nmsPlayer.gt().a.isEmpty()) {
            int tickCount = nmsPlayer.gt().b;
            for (Map.Entry entry : nmsPlayer.gt().a.entrySet()) {
                nmsPlayer.c.b((zg)new acs((cul)entry.getKey(), ((cum.a)entry.getValue()).b - tickCount));
            }
        }
        nmsPlayer.z();
        nmsPlayer.d.ah().e(nmsPlayer);
        nmsPlayer.d.ah().a(nmsPlayer, nmsWorld);
        nmsPlayer.d.ah().f(nmsPlayer);
    }

    private /* synthetic */ void lambda$sendEntitySpawn$0(CraftWorld world, bsr nmsEntity, List trackers, boolean autoTrack, final FakeEntity fake, final PlayerTag player) {
        aqv nmsPlayer = ((CraftPlayer)player.getPlayerEntity()).getHandle();
        aru conn = nmsPlayer.c;
        final aqt tracker = new aqt(world.getHandle(), nmsEntity, 1, true, arg_0 -> ((aru)conn).b(arg_0), Collections.singleton(nmsPlayer.c));
        tracker.b(nmsPlayer);
        TrackerData data = new TrackerData(player, tracker);
        trackers.add(data);
        if (autoTrack) {
            new BukkitRunnable(){
                boolean wasOnline = true;

                public void run() {
                    if (!fake.entity.isFakeValid) {
                        this.cancel();
                        return;
                    }
                    if (player.isOnline()) {
                        if (!this.wasOnline) {
                            tracker.b(((CraftPlayer)player.getPlayerEntity()).getHandle());
                            this.wasOnline = true;
                        }
                        tracker.a();
                    } else if (this.wasOnline) {
                        this.wasOnline = false;
                    }
                }
            }.runTaskTimer((Plugin)Denizen.getInstance(), 1L, 1L);
        }
    }

    public record TrackerData(PlayerTag player, aqt tracker) {
    }
}

