/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_21.helpers;

import com.denizenscript.denizen.nms.interfaces.FishingHelper;
import com.denizenscript.denizen.nms.v1_21.ReflectionMappingsInfo;
import com.denizenscript.denizencore.utilities.ReflectionHelper;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.reflect.Field;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityFishingHook;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.World;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftFishHook;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.inventory.ItemStack;

public class FishingHelperImpl
implements FishingHelper {
    public static final Field FISHING_HOOK_NIBBLE = ReflectionHelper.getFields(EntityFishingHook.class).get(ReflectionMappingsInfo.FishingHook_nibble, Integer.TYPE);
    public static final Field FISHING_HOOK_LURE_TIME = ReflectionHelper.getFields(EntityFishingHook.class).get(ReflectionMappingsInfo.FishingHook_timeUntilLured, Integer.TYPE);
    public static final Field FISHING_HOOK_HOOK_TIME = ReflectionHelper.getFields(EntityFishingHook.class).get(ReflectionMappingsInfo.FishingHook_timeUntilHooked, Integer.TYPE);

    public ItemStack getResult(FishHook fishHook, FishingHelper.CatchType catchType) {
        EntityFishingHook nmsHook = ((CraftFishHook)fishHook).getHandle();
        net.minecraft.world.item.ItemStack result = switch (catchType) {
            case FishingHelper.CatchType.DEFAULT -> {
                WorldServer nmsWorld = ((CraftWorld)fishHook.getWorld()).getHandle();
                net.minecraft.world.item.ItemStack nmsFishingRod = nmsHook.t().eT();
                float f = nmsWorld.z.i();
                float i = EnchantmentManager.b((WorldServer)nmsWorld, (net.minecraft.world.item.ItemStack)nmsFishingRod, (Entity)nmsHook.t());
                int j = EnchantmentManager.a((WorldServer)nmsWorld, (net.minecraft.world.item.ItemStack)nmsFishingRod, (Entity)nmsHook.t());
                float f1 = 0.1f - i * 0.025f - (float)j * 0.01f;
                float f2 = 0.05f + i * 0.01f - (float)j * 0.01f;
                f1 = MathHelper.a((float)f1, (float)0.0f, (float)1.0f);
                f2 = MathHelper.a((float)f2, (float)0.0f, (float)1.0f);
                if (f < f1) {
                    yield this.catchRandomJunk(nmsHook);
                }
                if ((f -= f1) < f2) {
                    yield this.catchRandomTreasure(nmsHook);
                }
                yield this.catchRandomFish(nmsHook);
            }
            case FishingHelper.CatchType.JUNK -> this.catchRandomJunk(nmsHook);
            case FishingHelper.CatchType.TREASURE -> this.catchRandomTreasure(nmsHook);
            case FishingHelper.CatchType.FISH -> this.catchRandomFish(nmsHook);
            default -> null;
        };
        return result != null ? CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)result) : null;
    }

    public net.minecraft.world.item.ItemStack getRandomReward(EntityFishingHook nmsHook, ResourceKey<LootTable> key) {
        WorldServer nmsWorld = (WorldServer)nmsHook.dO();
        IdentityHashMap params = Maps.newIdentityHashMap();
        params.put(LootContextParameters.f, new Vec3D(nmsHook.dt(), nmsHook.dv(), nmsHook.dz()));
        params.put(LootContextParameters.i, new net.minecraft.world.item.ItemStack((IMaterial)Items.qV));
        LootParams nmsLootParams = new LootParams(nmsWorld, (Map)params, (Map)Maps.newHashMap(), 0.0f);
        ObjectArrayList nmsItems = ((LootTable)nmsHook.dQ().d(Registries.bc).a(key)).a(nmsLootParams);
        return (net.minecraft.world.item.ItemStack)nmsItems.get(nmsWorld.z.a(nmsItems.size()));
    }

    public FishHook spawnHook(Location location, Player player) {
        WorldServer nmsWorld = ((CraftWorld)location.getWorld()).getHandle();
        EntityFishingHook hook = new EntityFishingHook((EntityHuman)((CraftPlayer)player).getHandle(), (World)nmsWorld, 0, 0);
        nmsWorld.addFreshEntity((Entity)hook, CreatureSpawnEvent.SpawnReason.CUSTOM);
        return (FishHook)hook.getBukkitEntity();
    }

    private net.minecraft.world.item.ItemStack catchRandomJunk(EntityFishingHook fishHook) {
        return this.getRandomReward(fishHook, (ResourceKey<LootTable>)LootTables.aD);
    }

    private net.minecraft.world.item.ItemStack catchRandomTreasure(EntityFishingHook fishHook) {
        return this.getRandomReward(fishHook, (ResourceKey<LootTable>)LootTables.aE);
    }

    private net.minecraft.world.item.ItemStack catchRandomFish(EntityFishingHook fishHook) {
        return this.getRandomReward(fishHook, (ResourceKey<LootTable>)LootTables.aF);
    }

    public FishHook getHookFrom(Player player) {
        EntityFishingHook nmsHook = ((CraftPlayer)player).getHandle().cv;
        if (nmsHook == null) {
            return null;
        }
        return (FishHook)nmsHook.getBukkitEntity();
    }

    public void setNibble(FishHook hook, int ticks) {
        EntityFishingHook nmsHook = ((CraftFishHook)hook).getHandle();
        try {
            FISHING_HOOK_NIBBLE.setInt(nmsHook, ticks);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public void setHookTime(FishHook hook, int ticks) {
        EntityFishingHook nmsHook = ((CraftFishHook)hook).getHandle();
        try {
            FISHING_HOOK_HOOK_TIME.setInt(nmsHook, ticks);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }

    public int getLureTime(FishHook hook) {
        EntityFishingHook nmsHook = ((CraftFishHook)hook).getHandle();
        try {
            return FISHING_HOOK_LURE_TIME.getInt(nmsHook);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
            return -1;
        }
    }

    public void setLureTime(FishHook hook, int ticks) {
        EntityFishingHook nmsHook = ((CraftFishHook)hook).getHandle();
        try {
            FISHING_HOOK_LURE_TIME.setInt(nmsHook, ticks);
        }
        catch (Throwable ex) {
            Debug.echoError((Throwable)ex);
        }
    }
}

