/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_21.helpers;

import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.ElementTag;
import java.util.HashMap;
import java.util.Map;

public class EntityDataNameMapper {
    public static final Map<Class<? extends bvk>, Map<String, Integer>> entityDataNames = new HashMap<Class<? extends bvk>, Map<String, Integer>>();

    public static void registerDataName(Class<? extends bvk> entityClass, int id, String name) {
        entityDataNames.computeIfAbsent(entityClass, k -> new HashMap()).put(name, id);
    }

    public static int getIdForName(Class<? extends bvk> entityClass, String name) {
        Class<? extends bvk> currentClass = entityClass;
        int id = EntityDataNameMapper.getIdFromClass(currentClass, name);
        while (id == -1 && (currentClass = currentClass.getSuperclass()) != Object.class) {
            id = EntityDataNameMapper.getIdFromClass(currentClass, name);
        }
        return id;
    }

    private static int getIdFromClass(Class<?> entityClass, String name) {
        int id;
        Map<String, Integer> nameToId = entityDataNames.get(entityClass);
        int n = id = nameToId != null ? nameToId.getOrDefault(name, -1) : -1;
        if (id == -1 && ArgumentHelper.matchesInteger((String)name)) {
            id = new ElementTag(name).asInt();
        }
        return id;
    }

    static {
        EntityDataNameMapper.registerDataName(bvk.class, 0, "entity_flags");
        EntityDataNameMapper.registerDataName(bvk.class, 1, "air_ticks");
        EntityDataNameMapper.registerDataName(bvk.class, 2, "custom_name");
        EntityDataNameMapper.registerDataName(bvk.class, 3, "custom_name_visible");
        EntityDataNameMapper.registerDataName(bvk.class, 4, "silent");
        EntityDataNameMapper.registerDataName(bvk.class, 5, "no_gravity");
        EntityDataNameMapper.registerDataName(bvk.class, 6, "pose");
        EntityDataNameMapper.registerDataName(bvk.class, 7, "frozen_ticks");
        EntityDataNameMapper.registerDataName(bwb.class, 8, "width");
        EntityDataNameMapper.registerDataName(bwb.class, 9, "height");
        EntityDataNameMapper.registerDataName(bwb.class, 10, "responsive");
        EntityDataNameMapper.registerDataName(bvi.class, 8, "transform_interpolation_start");
        EntityDataNameMapper.registerDataName(bvi.class, 9, "transform_interpolation_duration");
        EntityDataNameMapper.registerDataName(bvi.class, 10, "movement_interpolation_duration");
        EntityDataNameMapper.registerDataName(bvi.class, 11, "translation");
        EntityDataNameMapper.registerDataName(bvi.class, 12, "scale");
        EntityDataNameMapper.registerDataName(bvi.class, 13, "left_rotation");
        EntityDataNameMapper.registerDataName(bvi.class, 14, "right_rotation");
        EntityDataNameMapper.registerDataName(bvi.class, 15, "billboard");
        EntityDataNameMapper.registerDataName(bvi.class, 16, "brightness");
        EntityDataNameMapper.registerDataName(bvi.class, 17, "view_range");
        EntityDataNameMapper.registerDataName(bvi.class, 18, "shadow_radius");
        EntityDataNameMapper.registerDataName(bvi.class, 19, "shadow_strength");
        EntityDataNameMapper.registerDataName(bvi.class, 20, "width");
        EntityDataNameMapper.registerDataName(bvi.class, 21, "height");
        EntityDataNameMapper.registerDataName(bvi.class, 22, "glow_color");
        EntityDataNameMapper.registerDataName(bvi.b.class, 23, "material");
        EntityDataNameMapper.registerDataName(bvi.g.class, 23, "item");
        EntityDataNameMapper.registerDataName(bvi.g.class, 24, "model_transform");
        EntityDataNameMapper.registerDataName(bvi.l.class, 23, "text");
        EntityDataNameMapper.registerDataName(bvi.l.class, 24, "line_width");
        EntityDataNameMapper.registerDataName(bvi.l.class, 25, "background_color");
        EntityDataNameMapper.registerDataName(bvi.l.class, 26, "text_opacity");
        EntityDataNameMapper.registerDataName(bvi.l.class, 27, "text_display_flags");
        EntityDataNameMapper.registerDataName(cqy.class, 8, "item");
        EntityDataNameMapper.registerDataName(cqj.class, 8, "item");
        EntityDataNameMapper.registerDataName(cql.class, 8, "spawn_position");
        EntityDataNameMapper.registerDataName(bvd.class, 8, "radius");
        EntityDataNameMapper.registerDataName(bvd.class, 9, "color");
        EntityDataNameMapper.registerDataName(bvd.class, 10, "waiting");
        EntityDataNameMapper.registerDataName(bvd.class, 11, "particle");
        EntityDataNameMapper.registerDataName(cqm.class, 8, "hooked_entity_id");
        EntityDataNameMapper.registerDataName(cqm.class, 9, "catchable");
        EntityDataNameMapper.registerDataName(cqe.class, 8, "abstract_arrow_flags");
        EntityDataNameMapper.registerDataName(cqe.class, 9, "piercing_level");
        EntityDataNameMapper.registerDataName(cqg.class, 10, "color");
        EntityDataNameMapper.registerDataName(crd.class, 10, "loyalty_level");
        EntityDataNameMapper.registerDataName(crd.class, 11, "enchantment_glint");
        EntityDataNameMapper.registerDataName(cry.class, 8, "shaking_ticks");
        EntityDataNameMapper.registerDataName(cry.class, 9, "shaking_direction");
        EntityDataNameMapper.registerDataName(cry.class, 10, "damage_taken");
        EntityDataNameMapper.registerDataName(cry.class, 11, "type");
        EntityDataNameMapper.registerDataName(cry.class, 12, "left_paddle_moving");
        EntityDataNameMapper.registerDataName(cry.class, 13, "right_paddle_moving");
        EntityDataNameMapper.registerDataName(cry.class, 14, "bubble_shaking_ticks");
        EntityDataNameMapper.registerDataName(ckt.class, 8, "beam_target");
        EntityDataNameMapper.registerDataName(ckt.class, 9, "showing_bottom");
        EntityDataNameMapper.registerDataName(cqu.class, 8, "item");
        EntityDataNameMapper.registerDataName(cqk.class, 8, "item");
        EntityDataNameMapper.registerDataName(cre.class, 8, "invulnerable");
        EntityDataNameMapper.registerDataName(cql.class, 8, "item");
        EntityDataNameMapper.registerDataName(cql.class, 9, "shooter_id");
        EntityDataNameMapper.registerDataName(cql.class, 10, "shot_at_angle");
        EntityDataNameMapper.registerDataName(clu.class, 8, "item");
        EntityDataNameMapper.registerDataName(clu.class, 9, "rotation");
        EntityDataNameMapper.registerDataName(clw.class, 8, "painting_variant");
        EntityDataNameMapper.registerDataName(bwg.class, 8, "living_entity_flags");
        EntityDataNameMapper.registerDataName(bwg.class, 9, "health");
        EntityDataNameMapper.registerDataName(bwg.class, 10, "potion_effect_color");
        EntityDataNameMapper.registerDataName(bwg.class, 11, "is_potion_effect_ambient");
        EntityDataNameMapper.registerDataName(bwg.class, 12, "arrows_in_body");
        EntityDataNameMapper.registerDataName(bwg.class, 13, "bee_stingers_in_body");
        EntityDataNameMapper.registerDataName(bwg.class, 14, "bed_location");
        EntityDataNameMapper.registerDataName(cpx.class, 15, "additional_hearts");
        EntityDataNameMapper.registerDataName(cpx.class, 16, "score");
        EntityDataNameMapper.registerDataName(cpx.class, 17, "skin_parts");
        EntityDataNameMapper.registerDataName(cpx.class, 18, "main_hand");
        EntityDataNameMapper.registerDataName(cpx.class, 19, "left_shoulder_entity");
        EntityDataNameMapper.registerDataName(cpx.class, 20, "right_shoulder_entity");
        EntityDataNameMapper.registerDataName(clq.class, 15, "armor_stand_flags");
        EntityDataNameMapper.registerDataName(clq.class, 16, "head_rotation");
        EntityDataNameMapper.registerDataName(clq.class, 17, "body_rotation");
        EntityDataNameMapper.registerDataName(clq.class, 18, "left_arm_rotation");
        EntityDataNameMapper.registerDataName(clq.class, 19, "right_arm_rotation");
        EntityDataNameMapper.registerDataName(clq.class, 20, "left_leg_rotation");
        EntityDataNameMapper.registerDataName(clq.class, 21, "right_leg_rotation");
        EntityDataNameMapper.registerDataName(bwi.class, 15, "mob_flags");
        EntityDataNameMapper.registerDataName(chr.class, 16, "bat_flags");
        EntityDataNameMapper.registerDataName(cif.class, 16, "treasure_location");
        EntityDataNameMapper.registerDataName(cif.class, 17, "has_fish");
        EntityDataNameMapper.registerDataName(cif.class, 18, "moisture_level");
        EntityDataNameMapper.registerDataName(cht.class, 16, "from_bucket");
        EntityDataNameMapper.registerDataName(ciq.class, 17, "puff_state");
        EntityDataNameMapper.registerDataName(cix.class, 17, "variant");
        EntityDataNameMapper.registerDataName(bvb.class, 16, "is_baby");
        EntityDataNameMapper.registerDataName(cko.class, 17, "sniffer_state");
        EntityDataNameMapper.registerDataName(cko.class, 18, "finish_dig_time");
        EntityDataNameMapper.registerDataName(ckb.class, 17, "horse_flags");
        EntityDataNameMapper.registerDataName(ckd.class, 18, "variant");
        EntityDataNameMapper.registerDataName(cjo.class, 18, "is_dashing");
        EntityDataNameMapper.registerDataName(cjo.class, 19, "last_pose_change");
        EntityDataNameMapper.registerDataName(cka.class, 18, "has_chest");
        EntityDataNameMapper.registerDataName(cke.class, 19, "strength");
        EntityDataNameMapper.registerDataName(cke.class, 20, "carpet_color");
        EntityDataNameMapper.registerDataName(cke.class, 21, "variant");
        EntityDataNameMapper.registerDataName(cjj.class, 17, "variant");
        EntityDataNameMapper.registerDataName(cjj.class, 18, "playing_dead");
        EntityDataNameMapper.registerDataName(cjj.class, 19, "from_bucket");
        EntityDataNameMapper.registerDataName(chy.class, 17, "bee_flags");
        EntityDataNameMapper.registerDataName(chy.class, 18, "anger_time");
        EntityDataNameMapper.registerDataName(cih.class, 17, "type");
        EntityDataNameMapper.registerDataName(cih.class, 18, "fox_flags");
        EntityDataNameMapper.registerDataName(cih.class, 19, "first_trusted_uuid");
        EntityDataNameMapper.registerDataName(cih.class, 20, "second_trusted_uuid");
        EntityDataNameMapper.registerDataName(cjr.class, 17, "variant");
        EntityDataNameMapper.registerDataName(cjr.class, 18, "target_id");
        EntityDataNameMapper.registerDataName(cil.class, 17, "is_trusting");
        EntityDataNameMapper.registerDataName(cim.class, 17, "ask_for_bamboo_timer");
        EntityDataNameMapper.registerDataName(cim.class, 18, "sneeze_timer");
        EntityDataNameMapper.registerDataName(cim.class, 19, "eat_timer");
        EntityDataNameMapper.registerDataName(cim.class, 20, "main_gene");
        EntityDataNameMapper.registerDataName(cim.class, 21, "hidden_gene");
        EntityDataNameMapper.registerDataName(cim.class, 22, "panda_flags");
        EntityDataNameMapper.registerDataName(cio.class, 17, "has_saddle");
        EntityDataNameMapper.registerDataName(cio.class, 18, "boost_ticks");
        EntityDataNameMapper.registerDataName(cir.class, 17, "type");
        EntityDataNameMapper.registerDataName(ciy.class, 17, "home_location");
        EntityDataNameMapper.registerDataName(ciy.class, 18, "has_egg");
        EntityDataNameMapper.registerDataName(ciy.class, 19, "laying_egg");
        EntityDataNameMapper.registerDataName(ciy.class, 20, "travel_location");
        EntityDataNameMapper.registerDataName(ciy.class, 21, "going_home");
        EntityDataNameMapper.registerDataName(ciy.class, 20, "traveling");
        EntityDataNameMapper.registerDataName(cip.class, 17, "standing_up");
        EntityDataNameMapper.registerDataName(cof.class, 17, "immune_to_zombification");
        EntityDataNameMapper.registerDataName(cik.class, 17, "variant");
        EntityDataNameMapper.registerDataName(cit.class, 17, "sheep_wool_flags");
        EntityDataNameMapper.registerDataName(cnk.class, 17, "boost_ticks");
        EntityDataNameMapper.registerDataName(cnk.class, 18, "shaking");
        EntityDataNameMapper.registerDataName(cnk.class, 19, "has_saddle");
        EntityDataNameMapper.registerDataName(bxd.class, 17, "tamable_animal_flags");
        EntityDataNameMapper.registerDataName(bxd.class, 18, "owner");
        EntityDataNameMapper.registerDataName(cia.class, 19, "variant");
        EntityDataNameMapper.registerDataName(cia.class, 20, "lying");
        EntityDataNameMapper.registerDataName(cia.class, 20, "relaxed");
        EntityDataNameMapper.registerDataName(cia.class, 21, "collar_color");
        EntityDataNameMapper.registerDataName(cja.class, 19, "begging");
        EntityDataNameMapper.registerDataName(cja.class, 20, "collar_color");
        EntityDataNameMapper.registerDataName(cja.class, 21, "anger_time");
        EntityDataNameMapper.registerDataName(cin.class, 19, "variant");
        EntityDataNameMapper.registerDataName(cpe.class, 17, "head_shake_ticks");
        EntityDataNameMapper.registerDataName(cpj.class, 18, "villager_data");
        EntityDataNameMapper.registerDataName(cij.class, 16, "iron_golem_flags");
        EntityDataNameMapper.registerDataName(civ.class, 16, "snow_golem_pumpkin_flags");
        EntityDataNameMapper.registerDataName(cnd.class, 16, "attach_face");
        EntityDataNameMapper.registerDataName(cnd.class, 17, "attachment_location");
        EntityDataNameMapper.registerDataName(cnd.class, 18, "peek");
        EntityDataNameMapper.registerDataName(cnd.class, 19, "color");
        EntityDataNameMapper.registerDataName(cok.class, 16, "immune_to_zombification");
        EntityDataNameMapper.registerDataName(col.class, 17, "is_baby");
        EntityDataNameMapper.registerDataName(col.class, 18, "charging_crossbow");
        EntityDataNameMapper.registerDataName(col.class, 19, "dancing");
        EntityDataNameMapper.registerDataName(cmg.class, 16, "blaze_flags");
        EntityDataNameMapper.registerDataName(cmj.class, 16, "state");
        EntityDataNameMapper.registerDataName(cmj.class, 17, "charged");
        EntityDataNameMapper.registerDataName(cmj.class, 18, "ignited");
        EntityDataNameMapper.registerDataName(cjx.class, 17, "screaming");
        EntityDataNameMapper.registerDataName(cjx.class, 18, "has_left_horn");
        EntityDataNameMapper.registerDataName(cjx.class, 19, "has_right_horn");
        EntityDataNameMapper.registerDataName(cmt.class, 16, "spikes_retracted");
        EntityDataNameMapper.registerDataName(cmt.class, 17, "target_id");
        EntityDataNameMapper.registerDataName(crl.class, 16, "celebrating");
        EntityDataNameMapper.registerDataName(cna.class, 17, "charging_crossbow");
        EntityDataNameMapper.registerDataName(cnh.class, 17, "spell");
        EntityDataNameMapper.registerDataName(cnn.class, 17, "drinking_potion");
        EntityDataNameMapper.registerDataName(cnl.class, 16, "vex_flags");
        EntityDataNameMapper.registerDataName(cni.class, 16, "spider_flags");
        EntityDataNameMapper.registerDataName(cpa.class, 16, "anger_level");
        EntityDataNameMapper.registerDataName(clo.class, 16, "center_head_target");
        EntityDataNameMapper.registerDataName(clo.class, 17, "left_head_target");
        EntityDataNameMapper.registerDataName(clo.class, 18, "right_head_target");
        EntityDataNameMapper.registerDataName(clo.class, 19, "invulnerable_time");
        EntityDataNameMapper.registerDataName(cnp.class, 16, "is_baby");
        EntityDataNameMapper.registerDataName(cnq.class, 16, "is_baby");
        EntityDataNameMapper.registerDataName(cnq.class, 17, "type");
        EntityDataNameMapper.registerDataName(cnq.class, 18, "converting_in_water");
        EntityDataNameMapper.registerDataName(cnr.class, 19, "is_converting");
        EntityDataNameMapper.registerDataName(cnr.class, 20, "villager_data");
        EntityDataNameMapper.registerDataName(cmn.class, 16, "carried_block");
        EntityDataNameMapper.registerDataName(cmn.class, 17, "screaming");
        EntityDataNameMapper.registerDataName(cmn.class, 18, "staring");
        EntityDataNameMapper.registerDataName(cku.class, 16, "phase");
        EntityDataNameMapper.registerDataName(cmr.class, 16, "attacking");
        EntityDataNameMapper.registerDataName(cmz.class, 16, "size");
        EntityDataNameMapper.registerDataName(cng.class, 16, "size");
        EntityDataNameMapper.registerDataName(crw.class, 8, "shaking_ticks");
        EntityDataNameMapper.registerDataName(crw.class, 9, "shaking_direction");
        EntityDataNameMapper.registerDataName(crw.class, 10, "damage_taken");
        EntityDataNameMapper.registerDataName(crw.class, 11, "display_block_id");
        EntityDataNameMapper.registerDataName(crw.class, 12, "display_block_y");
        EntityDataNameMapper.registerDataName(crw.class, 13, "show_display_block");
        EntityDataNameMapper.registerDataName(csh.class, 14, "has_fuel");
        EntityDataNameMapper.registerDataName(csg.class, 14, "command");
        EntityDataNameMapper.registerDataName(csg.class, 15, "last_output");
        EntityDataNameMapper.registerDataName(cmc.class, 8, "fuse_ticks");
    }
}

