/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.nms.v1_21.helpers;

import com.denizenscript.denizencore.objects.ArgumentHelper;
import com.denizenscript.denizencore.objects.core.ElementTag;
import java.util.HashMap;
import java.util.Map;

public class EntityDataNameMapper {
    public static final Map<Class<? extends cdv>, Map<String, Integer>> entityDataNames = new HashMap<Class<? extends cdv>, Map<String, Integer>>();

    public static void registerDataName(Class<? extends cdv> entityClass, int id, String name) {
        entityDataNames.computeIfAbsent(entityClass, k2 -> new HashMap()).put(name, id);
    }

    public static int getIdForName(Class<? extends cdv> entityClass, String name) {
        Class<? extends cdv> currentClass = entityClass;
        int id = EntityDataNameMapper.getIdFromClass(currentClass, name);
        while (id == -1 && (currentClass = currentClass.getSuperclass()) != Object.class) {
            id = EntityDataNameMapper.getIdFromClass(currentClass, name);
        }
        return id;
    }

    private static int getIdFromClass(Class<?> entityClass, String name) {
        int id;
        Map<String, Integer> nameToId = entityDataNames.get(entityClass);
        int n = id = nameToId != null ? nameToId.getOrDefault(name, -1) : -1;
        if (id == -1 && ArgumentHelper.matchesInteger((String)name)) {
            id = new ElementTag(name).asInt();
        }
        return id;
    }

    static {
        EntityDataNameMapper.registerDataName(cdv.class, 0, "entity_flags");
        EntityDataNameMapper.registerDataName(cdv.class, 1, "air_ticks");
        EntityDataNameMapper.registerDataName(cdv.class, 2, "custom_name");
        EntityDataNameMapper.registerDataName(cdv.class, 3, "custom_name_visible");
        EntityDataNameMapper.registerDataName(cdv.class, 4, "silent");
        EntityDataNameMapper.registerDataName(cdv.class, 5, "no_gravity");
        EntityDataNameMapper.registerDataName(cdv.class, 6, "pose");
        EntityDataNameMapper.registerDataName(cdv.class, 7, "frozen_ticks");
        EntityDataNameMapper.registerDataName(cep.class, 8, "width");
        EntityDataNameMapper.registerDataName(cep.class, 9, "height");
        EntityDataNameMapper.registerDataName(cep.class, 10, "responsive");
        EntityDataNameMapper.registerDataName(cds.class, 8, "transform_interpolation_start");
        EntityDataNameMapper.registerDataName(cds.class, 9, "transform_interpolation_duration");
        EntityDataNameMapper.registerDataName(cds.class, 10, "movement_interpolation_duration");
        EntityDataNameMapper.registerDataName(cds.class, 11, "translation");
        EntityDataNameMapper.registerDataName(cds.class, 12, "scale");
        EntityDataNameMapper.registerDataName(cds.class, 13, "left_rotation");
        EntityDataNameMapper.registerDataName(cds.class, 14, "right_rotation");
        EntityDataNameMapper.registerDataName(cds.class, 15, "billboard");
        EntityDataNameMapper.registerDataName(cds.class, 16, "brightness");
        EntityDataNameMapper.registerDataName(cds.class, 17, "view_range");
        EntityDataNameMapper.registerDataName(cds.class, 18, "shadow_radius");
        EntityDataNameMapper.registerDataName(cds.class, 19, "shadow_strength");
        EntityDataNameMapper.registerDataName(cds.class, 20, "width");
        EntityDataNameMapper.registerDataName(cds.class, 21, "height");
        EntityDataNameMapper.registerDataName(cds.class, 22, "glow_color");
        EntityDataNameMapper.registerDataName(cds.b.class, 23, "material");
        EntityDataNameMapper.registerDataName(cds.g.class, 23, "item");
        EntityDataNameMapper.registerDataName(cds.g.class, 24, "model_transform");
        EntityDataNameMapper.registerDataName(cds.k.class, 23, "text");
        EntityDataNameMapper.registerDataName(cds.k.class, 24, "line_width");
        EntityDataNameMapper.registerDataName(cds.k.class, 25, "background_color");
        EntityDataNameMapper.registerDataName(cds.k.class, 26, "text_opacity");
        EntityDataNameMapper.registerDataName(cds.k.class, 27, "text_display_flags");
        EntityDataNameMapper.registerDataName(daq.class, 8, "item");
        EntityDataNameMapper.registerDataName(dab.class, 8, "item");
        EntityDataNameMapper.registerDataName(dad.class, 8, "spawn_position");
        EntityDataNameMapper.registerDataName(cdl.class, 8, "radius");
        EntityDataNameMapper.registerDataName(cdl.class, 9, "color");
        EntityDataNameMapper.registerDataName(cdl.class, 10, "waiting");
        EntityDataNameMapper.registerDataName(cdl.class, 11, "particle");
        EntityDataNameMapper.registerDataName(dae.class, 8, "hooked_entity_id");
        EntityDataNameMapper.registerDataName(dae.class, 9, "catchable");
        EntityDataNameMapper.registerDataName(czv.class, 8, "abstract_arrow_flags");
        EntityDataNameMapper.registerDataName(czv.class, 9, "piercing_level");
        EntityDataNameMapper.registerDataName(czy.class, 10, "color");
        EntityDataNameMapper.registerDataName(daw.class, 10, "loyalty_level");
        EntityDataNameMapper.registerDataName(daw.class, 11, "enchantment_glint");
        EntityDataNameMapper.registerDataName(dcc.class, 8, "shaking_ticks");
        EntityDataNameMapper.registerDataName(dcc.class, 9, "shaking_direction");
        EntityDataNameMapper.registerDataName(dcc.class, 10, "damage_taken");
        EntityDataNameMapper.registerDataName(dcc.class, 11, "type");
        EntityDataNameMapper.registerDataName(dcc.class, 12, "left_paddle_moving");
        EntityDataNameMapper.registerDataName(dcc.class, 13, "right_paddle_moving");
        EntityDataNameMapper.registerDataName(dcc.class, 14, "bubble_shaking_ticks");
        EntityDataNameMapper.registerDataName(cui.class, 8, "beam_target");
        EntityDataNameMapper.registerDataName(cui.class, 9, "showing_bottom");
        EntityDataNameMapper.registerDataName(dam.class, 8, "item");
        EntityDataNameMapper.registerDataName(dac.class, 8, "item");
        EntityDataNameMapper.registerDataName(dax.class, 8, "invulnerable");
        EntityDataNameMapper.registerDataName(dad.class, 8, "item");
        EntityDataNameMapper.registerDataName(dad.class, 9, "shooter_id");
        EntityDataNameMapper.registerDataName(dad.class, 10, "shot_at_angle");
        EntityDataNameMapper.registerDataName(cvj.class, 8, "item");
        EntityDataNameMapper.registerDataName(cvj.class, 9, "rotation");
        EntityDataNameMapper.registerDataName(cvm.class, 8, "painting_variant");
        EntityDataNameMapper.registerDataName(cew.class, 8, "living_entity_flags");
        EntityDataNameMapper.registerDataName(cew.class, 9, "health");
        EntityDataNameMapper.registerDataName(cew.class, 10, "potion_effect_color");
        EntityDataNameMapper.registerDataName(cew.class, 11, "is_potion_effect_ambient");
        EntityDataNameMapper.registerDataName(cew.class, 12, "arrows_in_body");
        EntityDataNameMapper.registerDataName(cew.class, 13, "bee_stingers_in_body");
        EntityDataNameMapper.registerDataName(cew.class, 14, "bed_location");
        EntityDataNameMapper.registerDataName(czl.class, 15, "additional_hearts");
        EntityDataNameMapper.registerDataName(czl.class, 16, "score");
        EntityDataNameMapper.registerDataName(czl.class, 17, "skin_parts");
        EntityDataNameMapper.registerDataName(czl.class, 18, "main_hand");
        EntityDataNameMapper.registerDataName(czl.class, 19, "left_shoulder_entity");
        EntityDataNameMapper.registerDataName(czl.class, 20, "right_shoulder_entity");
        EntityDataNameMapper.registerDataName(cvf.class, 15, "armor_stand_flags");
        EntityDataNameMapper.registerDataName(cvf.class, 16, "head_rotation");
        EntityDataNameMapper.registerDataName(cvf.class, 17, "body_rotation");
        EntityDataNameMapper.registerDataName(cvf.class, 18, "left_arm_rotation");
        EntityDataNameMapper.registerDataName(cvf.class, 19, "right_arm_rotation");
        EntityDataNameMapper.registerDataName(cvf.class, 20, "left_leg_rotation");
        EntityDataNameMapper.registerDataName(cvf.class, 21, "right_leg_rotation");
        EntityDataNameMapper.registerDataName(cey.class, 15, "mob_flags");
        EntityDataNameMapper.registerDataName(cqj.class, 16, "bat_flags");
        EntityDataNameMapper.registerDataName(crd.class, 16, "treasure_location");
        EntityDataNameMapper.registerDataName(crd.class, 17, "has_fish");
        EntityDataNameMapper.registerDataName(crd.class, 18, "moisture_level");
        EntityDataNameMapper.registerDataName(cqm.class, 16, "from_bucket");
        EntityDataNameMapper.registerDataName(crr.class, 17, "puff_state");
        EntityDataNameMapper.registerDataName(cry.class, 17, "variant");
        EntityDataNameMapper.registerDataName(cdj.class, 16, "is_baby");
        EntityDataNameMapper.registerDataName(ctx.class, 17, "sniffer_state");
        EntityDataNameMapper.registerDataName(ctx.class, 18, "finish_dig_time");
        EntityDataNameMapper.registerDataName(cth.class, 17, "horse_flags");
        EntityDataNameMapper.registerDataName(ctj.class, 18, "variant");
        EntityDataNameMapper.registerDataName(csm.class, 18, "is_dashing");
        EntityDataNameMapper.registerDataName(csm.class, 19, "last_pose_change");
        EntityDataNameMapper.registerDataName(ctg.class, 18, "has_chest");
        EntityDataNameMapper.registerDataName(ctk.class, 19, "strength");
        EntityDataNameMapper.registerDataName(ctk.class, 20, "carpet_color");
        EntityDataNameMapper.registerDataName(ctk.class, 21, "variant");
        EntityDataNameMapper.registerDataName(csh.class, 17, "variant");
        EntityDataNameMapper.registerDataName(csh.class, 18, "playing_dead");
        EntityDataNameMapper.registerDataName(csh.class, 19, "from_bucket");
        EntityDataNameMapper.registerDataName(cqr.class, 17, "bee_flags");
        EntityDataNameMapper.registerDataName(cqr.class, 18, "anger_time");
        EntityDataNameMapper.registerDataName(crf.class, 17, "type");
        EntityDataNameMapper.registerDataName(crf.class, 18, "fox_flags");
        EntityDataNameMapper.registerDataName(crf.class, 19, "first_trusted_uuid");
        EntityDataNameMapper.registerDataName(crf.class, 20, "second_trusted_uuid");
        EntityDataNameMapper.registerDataName(csv.class, 17, "variant");
        EntityDataNameMapper.registerDataName(csv.class, 18, "target_id");
        EntityDataNameMapper.registerDataName(crk.class, 17, "is_trusting");
        EntityDataNameMapper.registerDataName(crl.class, 17, "ask_for_bamboo_timer");
        EntityDataNameMapper.registerDataName(crl.class, 18, "sneeze_timer");
        EntityDataNameMapper.registerDataName(crl.class, 19, "eat_timer");
        EntityDataNameMapper.registerDataName(crl.class, 20, "main_gene");
        EntityDataNameMapper.registerDataName(crl.class, 21, "hidden_gene");
        EntityDataNameMapper.registerDataName(crl.class, 22, "panda_flags");
        EntityDataNameMapper.registerDataName(crn.class, 17, "has_saddle");
        EntityDataNameMapper.registerDataName(crn.class, 18, "boost_ticks");
        EntityDataNameMapper.registerDataName(crs.class, 17, "type");
        EntityDataNameMapper.registerDataName(crz.class, 17, "home_location");
        EntityDataNameMapper.registerDataName(crz.class, 18, "has_egg");
        EntityDataNameMapper.registerDataName(crz.class, 19, "laying_egg");
        EntityDataNameMapper.registerDataName(crz.class, 20, "travel_location");
        EntityDataNameMapper.registerDataName(crz.class, 21, "going_home");
        EntityDataNameMapper.registerDataName(crz.class, 20, "traveling");
        EntityDataNameMapper.registerDataName(crq.class, 17, "standing_up");
        EntityDataNameMapper.registerDataName(cxu.class, 17, "immune_to_zombification");
        EntityDataNameMapper.registerDataName(crj.class, 17, "variant");
        EntityDataNameMapper.registerDataName(ctu.class, 17, "sheep_wool_flags");
        EntityDataNameMapper.registerDataName(cxa.class, 17, "boost_ticks");
        EntityDataNameMapper.registerDataName(cxa.class, 18, "shaking");
        EntityDataNameMapper.registerDataName(cxa.class, 19, "has_saddle");
        EntityDataNameMapper.registerDataName(cfs.class, 17, "tamable_animal_flags");
        EntityDataNameMapper.registerDataName(cfs.class, 18, "owner");
        EntityDataNameMapper.registerDataName(cqt.class, 19, "variant");
        EntityDataNameMapper.registerDataName(cqt.class, 20, "lying");
        EntityDataNameMapper.registerDataName(cqt.class, 20, "relaxed");
        EntityDataNameMapper.registerDataName(cqt.class, 21, "collar_color");
        EntityDataNameMapper.registerDataName(cua.class, 19, "begging");
        EntityDataNameMapper.registerDataName(cua.class, 20, "collar_color");
        EntityDataNameMapper.registerDataName(cua.class, 21, "anger_time");
        EntityDataNameMapper.registerDataName(crm.class, 19, "variant");
        EntityDataNameMapper.registerDataName(cys.class, 17, "head_shake_ticks");
        EntityDataNameMapper.registerDataName(cyx.class, 18, "villager_data");
        EntityDataNameMapper.registerDataName(cri.class, 16, "iron_golem_flags");
        EntityDataNameMapper.registerDataName(crv.class, 16, "snow_golem_pumpkin_flags");
        EntityDataNameMapper.registerDataName(cwt.class, 16, "attach_face");
        EntityDataNameMapper.registerDataName(cwt.class, 17, "attachment_location");
        EntityDataNameMapper.registerDataName(cwt.class, 18, "peek");
        EntityDataNameMapper.registerDataName(cwt.class, 19, "color");
        EntityDataNameMapper.registerDataName(cxz.class, 16, "immune_to_zombification");
        EntityDataNameMapper.registerDataName(cya.class, 17, "is_baby");
        EntityDataNameMapper.registerDataName(cya.class, 18, "charging_crossbow");
        EntityDataNameMapper.registerDataName(cya.class, 19, "dancing");
        EntityDataNameMapper.registerDataName(cvw.class, 16, "blaze_flags");
        EntityDataNameMapper.registerDataName(cvz.class, 16, "state");
        EntityDataNameMapper.registerDataName(cvz.class, 17, "charged");
        EntityDataNameMapper.registerDataName(cvz.class, 18, "ignited");
        EntityDataNameMapper.registerDataName(ctd.class, 17, "screaming");
        EntityDataNameMapper.registerDataName(ctd.class, 18, "has_left_horn");
        EntityDataNameMapper.registerDataName(ctd.class, 19, "has_right_horn");
        EntityDataNameMapper.registerDataName(cwj.class, 16, "spikes_retracted");
        EntityDataNameMapper.registerDataName(cwj.class, 17, "target_id");
        EntityDataNameMapper.registerDataName(dbe.class, 16, "celebrating");
        EntityDataNameMapper.registerDataName(cwq.class, 17, "charging_crossbow");
        EntityDataNameMapper.registerDataName(cwx.class, 17, "spell");
        EntityDataNameMapper.registerDataName(cxd.class, 17, "drinking_potion");
        EntityDataNameMapper.registerDataName(cxb.class, 16, "vex_flags");
        EntityDataNameMapper.registerDataName(cwy.class, 16, "spider_flags");
        EntityDataNameMapper.registerDataName(cyo.class, 16, "anger_level");
        EntityDataNameMapper.registerDataName(cvd.class, 16, "center_head_target");
        EntityDataNameMapper.registerDataName(cvd.class, 17, "left_head_target");
        EntityDataNameMapper.registerDataName(cvd.class, 18, "right_head_target");
        EntityDataNameMapper.registerDataName(cvd.class, 19, "invulnerable_time");
        EntityDataNameMapper.registerDataName(cxf.class, 16, "is_baby");
        EntityDataNameMapper.registerDataName(cxg.class, 16, "is_baby");
        EntityDataNameMapper.registerDataName(cxg.class, 17, "type");
        EntityDataNameMapper.registerDataName(cxg.class, 18, "converting_in_water");
        EntityDataNameMapper.registerDataName(cxh.class, 19, "is_converting");
        EntityDataNameMapper.registerDataName(cxh.class, 20, "villager_data");
        EntityDataNameMapper.registerDataName(cwd.class, 16, "carried_block");
        EntityDataNameMapper.registerDataName(cwd.class, 17, "screaming");
        EntityDataNameMapper.registerDataName(cwd.class, 18, "staring");
        EntityDataNameMapper.registerDataName(cuj.class, 16, "phase");
        EntityDataNameMapper.registerDataName(cwh.class, 16, "attacking");
        EntityDataNameMapper.registerDataName(cwp.class, 16, "size");
        EntityDataNameMapper.registerDataName(cww.class, 16, "size");
        EntityDataNameMapper.registerDataName(dca.class, 8, "shaking_ticks");
        EntityDataNameMapper.registerDataName(dca.class, 9, "shaking_direction");
        EntityDataNameMapper.registerDataName(dca.class, 10, "damage_taken");
        EntityDataNameMapper.registerDataName(dca.class, 11, "display_block_id");
        EntityDataNameMapper.registerDataName(dca.class, 12, "display_block_y");
        EntityDataNameMapper.registerDataName(dca.class, 13, "show_display_block");
        EntityDataNameMapper.registerDataName(dcl.class, 14, "has_fuel");
        EntityDataNameMapper.registerDataName(dck.class, 14, "command");
        EntityDataNameMapper.registerDataName(dck.class, 15, "last_output");
        EntityDataNameMapper.registerDataName(cvs.class, 8, "fuse_ticks");
    }
}

