/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.triggers;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.scripts.containers.core.InteractScriptContainer;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizen.utilities.Settings;
import com.denizenscript.denizen.utilities.debugging.Debug;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.queues.ContextSource;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;
import com.denizenscript.denizencore.scripts.queues.core.InstantQueue;
import com.denizenscript.denizencore.scripts.queues.core.TimedQueue;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.SlowWarning;
import java.util.List;
import java.util.Map;

public abstract class AbstractTrigger {
    protected String name;
    public static SlowWarning missetWarning = new SlowWarning("Trigger '{NAME}' on NPC '{NPC}' activated and used but not properly set via the 'trigger' command in 'on assignment'.");

    public AbstractTrigger as(String triggerName) {
        this.name = triggerName.toUpperCase();
        Denizen.getInstance().triggerRegistry.register(triggerName, this);
        this.onEnable();
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void onDisable() {
    }

    public void onEnable() {
    }

    public AbstractTrigger activate() {
        return this;
    }

    public boolean parse(NPCTag npc, PlayerTag player, InteractScriptContainer script, String id) {
        return this.parse(npc, player, script, id, null);
    }

    public boolean parse(NPCTag npc, PlayerTag player, InteractScriptContainer script, String id, Map<String, ObjectTag> context) {
        if (npc == null || player == null || script == null) {
            return false;
        }
        List<ScriptEntry> entries = script.getEntriesFor(this.getClass(), player, npc, id, true);
        if (entries.isEmpty()) {
            return false;
        }
        Debug.echoDebug(script, Debug.DebugElement.Header, "Parsing " + this.name + " trigger: n@" + npc.getName() + "/p@" + player.getName());
        long speedTicks = script.contains("SPEED", String.class) ? DurationTag.valueOf(script.getString("SPEED", "0"), new BukkitTagContext(script)).getTicks() : DurationTag.valueOf(Settings.interactQueueSpeed(), new BukkitTagContext(script)).getTicks();
        ScriptQueue queue = speedTicks > 0L ? new TimedQueue(script.getName()).setSpeed(speedTicks) : new InstantQueue(script.getName());
        queue.addEntries(entries);
        if (context != null) {
            ContextSource.SimpleMap src = new ContextSource.SimpleMap();
            src.contexts = context;
            queue.setContextSource(src);
        }
        if (!npc.getTriggerTrait().properly_set.get(this.name).booleanValue() && missetWarning.testShouldWarn()) {
            Debug.echoError(AbstractTrigger.missetWarning.message.replace("{NAME}", this.name).replace("{NPC}", npc.getId() + "/" + npc.getName()));
        }
        queue.start();
        return true;
    }
}

