/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizencore.flags;

import com.denizenscript.denizencore.flags.AbstractFlagTracker;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.core.TimeTag;
import java.util.ArrayList;
import java.util.Collection;

public class RedirectionFlagTracker
extends AbstractFlagTracker {
    public AbstractFlagTracker original;
    public String prefix;

    public RedirectionFlagTracker(AbstractFlagTracker original, String prefix) {
        this.original = original;
        this.prefix = prefix;
    }

    @Override
    public ObjectTag getFlagValue(String key) {
        return this.original.getFlagValue(this.prefix + "." + key);
    }

    @Override
    public TimeTag getFlagExpirationTime(String key) {
        return this.original.getFlagExpirationTime(this.prefix + "." + key);
    }

    @Override
    public Collection<String> listAllFlags() {
        MapTag map = this.getFlagMap();
        if (map == null) {
            return new ArrayList<String>();
        }
        return map.keys();
    }

    @Override
    public void setFlag(String key, ObjectTag value, TimeTag expiration) {
        this.original.setFlag(this.prefix + "." + key, value, expiration);
    }

    @Override
    public MapTag getFlagMap() {
        ObjectTag obj = this.original.getFlagValue(this.prefix);
        if (!(obj instanceof MapTag)) {
            return null;
        }
        return (MapTag)obj;
    }
}

