/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.entity;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import java.util.Arrays;
import java.util.HashSet;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.spigotmc.event.entity.EntityMountEvent;

public class EntityEntersVehicleScriptEvent
extends BukkitScriptEvent
implements Listener {
    public static EntityEntersVehicleScriptEvent instance;
    public EntityTag vehicle;
    public EntityTag entity;
    public EntityMountEvent event;
    public static HashSet<String> notRelevantEnterables;

    public EntityEntersVehicleScriptEvent() {
        instance = this;
    }

    @Override
    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        if (!path.eventArgLowerAt(1).equals("enters")) {
            return false;
        }
        if (notRelevantEnterables.contains(path.eventArgLowerAt(2))) {
            return false;
        }
        if (!EntityEntersVehicleScriptEvent.couldMatchEntity(path.eventArgLowerAt(0))) {
            return false;
        }
        return EntityEntersVehicleScriptEvent.couldMatchEntity(path.eventArgLowerAt(2));
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!EntityEntersVehicleScriptEvent.tryEntity(this.entity, path.eventArgLowerAt(0)) || !EntityEntersVehicleScriptEvent.tryEntity(this.vehicle, path.eventArgLowerAt(2))) {
            return false;
        }
        if (!this.runInCheck(path, this.vehicle.getLocation())) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public String getName() {
        return "EntityEntersVehicle";
    }

    @Override
    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.entity);
    }

    @Override
    public ObjectTag getContext(String name) {
        if (name.equals("vehicle")) {
            return this.vehicle;
        }
        if (name.equals("entity")) {
            return this.entity;
        }
        return super.getContext(name);
    }

    @EventHandler
    public void onEntityEntersVehicle(EntityMountEvent event) {
        this.vehicle = new EntityTag(event.getMount());
        this.entity = new EntityTag(event.getEntity());
        this.event = event;
        this.fire((Event)event);
    }

    static {
        notRelevantEnterables = new HashSet<String>(Arrays.asList("notable", "cuboid", "biome", "bed", "portal"));
    }
}

